/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBaseStyle;
import net.sf.jasperreports.engine.util.JRCloneUtils;
import net.sf.jasperreports.engine.util.ObjectUtils;

public class JRBaseConditionalStyle
extends JRBaseStyle
implements JRConditionalStyle {
    private static final long serialVersionUID = 10200L;
    protected JRExpression conditionExpression;

    public JRBaseConditionalStyle() {
    }

    public JRBaseConditionalStyle(JRConditionalStyle style, JRStyle parentStyle, JRAbstractObjectFactory factory) {
        this.parentStyle = parentStyle;
        this.modeValue = style.getOwnModeValue();
        this.forecolor = style.getOwnForecolor();
        this.backcolor = style.getOwnBackcolor();
        this.linePen = style.getLinePen().clone(this);
        this.fillValue = style.getOwnFillValue();
        this.radius = style.getOwnRadius();
        this.scaleImageValue = style.getOwnScaleImageValue();
        this.horizontalAlignmentValue = style.getOwnHorizontalAlignmentValue();
        this.verticalAlignmentValue = style.getOwnVerticalAlignmentValue();
        this.lineBox = style.getLineBox().clone(this);
        this.paragraph = style.getParagraph().clone(this);
        this.rotationValue = style.getOwnRotationValue();
        this.markup = style.getOwnMarkup();
        this.pattern = style.getOwnPattern();
        this.fontName = style.getOwnFontName();
        this.isBold = style.isOwnBold();
        this.isItalic = style.isOwnItalic();
        this.isUnderline = style.isOwnUnderline();
        this.isStrikeThrough = style.isOwnStrikeThrough();
        this.fontSize = style.getOwnFontSize();
        this.pdfFontName = style.getOwnPdfFontName();
        this.pdfEncoding = style.getOwnPdfEncoding();
        this.isPdfEmbedded = style.isOwnPdfEmbedded();
        this.conditionExpression = factory.getExpression(style.getConditionExpression(), true);
    }

    @Override
    public JRExpression getConditionExpression() {
        return this.conditionExpression;
    }

    @Override
    public Object clone() {
        JRBaseConditionalStyle clone = (JRBaseConditionalStyle)super.clone();
        clone.conditionExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.conditionExpression);
        return clone;
    }

    @Override
    public int getHashCode() {
        ObjectUtils.HashCode hash = ObjectUtils.hash();
        this.addStyleHash(hash);
        hash.add(this.conditionExpression == null ? null : this.conditionExpression.getText());
        return hash.getHashCode();
    }

    @Override
    public boolean isIdentical(Object object) {
        Integer otherExpressionId;
        if (this == object) {
            return true;
        }
        if (!(object instanceof JRBaseConditionalStyle)) {
            return false;
        }
        JRBaseConditionalStyle style = (JRBaseConditionalStyle)object;
        if (!this.identicalStyle(style)) {
            return false;
        }
        Integer expressionId = this.conditionExpression == null ? null : Integer.valueOf(this.conditionExpression.getId());
        Integer n = otherExpressionId = style.conditionExpression == null ? null : Integer.valueOf(style.conditionExpression.getId());
        if (!ObjectUtils.equals(expressionId, otherExpressionId)) {
            return false;
        }
        String expressionText = this.conditionExpression == null ? null : this.conditionExpression.getText();
        String otherExpressionText = style.conditionExpression == null ? null : style.conditionExpression.getText();
        return ObjectUtils.equals(expressionText, otherExpressionText);
    }
}

