/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.StringReader;
import java.lang.ref.SoftReference;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBasePrintHyperlink;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import net.sf.jasperreports.engine.util.JRValueStringUtils;
import net.sf.jasperreports.extensions.ExtensionsEnvironment;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JRStyledTextParser
implements ErrorHandler {
    private static final Log log = LogFactory.getLog(JRStyledTextParser.class);
    private static final Set<String> AVAILABLE_FONT_FACE_NAMES = new HashSet<String>();
    private static final String ROOT_START = "<st>";
    private static final String ROOT_END = "</st>";
    private static final String NODE_style = "style";
    private static final String NODE_bold = "b";
    private static final String NODE_italic = "i";
    private static final String NODE_underline = "u";
    private static final String NODE_sup = "sup";
    private static final String NODE_sub = "sub";
    private static final String NODE_font = "font";
    private static final String NODE_br = "br";
    private static final String NODE_li = "li";
    private static final String NODE_a = "a";
    private static final String NODE_param = "param";
    private static final String ATTRIBUTE_fontName = "fontName";
    private static final String ATTRIBUTE_fontFace = "face";
    private static final String ATTRIBUTE_color = "color";
    private static final String ATTRIBUTE_size = "size";
    private static final String ATTRIBUTE_isBold = "isBold";
    private static final String ATTRIBUTE_isItalic = "isItalic";
    private static final String ATTRIBUTE_isUnderline = "isUnderline";
    private static final String ATTRIBUTE_isStrikeThrough = "isStrikeThrough";
    private static final String ATTRIBUTE_forecolor = "forecolor";
    private static final String ATTRIBUTE_backcolor = "backcolor";
    private static final String ATTRIBUTE_pdfFontName = "pdfFontName";
    private static final String ATTRIBUTE_pdfEncoding = "pdfEncoding";
    private static final String ATTRIBUTE_isPdfEmbedded = "isPdfEmbedded";
    private static final String ATTRIBUTE_type = "type";
    private static final String ATTRIBUTE_href = "href";
    private static final String ATTRIBUTE_target = "target";
    private static final String ATTRIBUTE_name = "name";
    private static final String ATTRIBUTE_valueClass = "valueClass";
    private static final String SPACE = " ";
    private static final String EQUAL_QUOTE = "=\"";
    private static final String QUOTE = "\"";
    private static final String SHARP = "#";
    private static final String LESS = "<";
    private static final String LESS_SLASH = "</";
    private static final String GREATER = ">";
    private static final ThreadLocal<SoftReference<JRStyledTextParser>> threadInstances;
    private static final ThreadLocal<Locale> threadLocale;
    private DocumentBuilder documentBuilder;
    private JRBasePrintHyperlink hyperlink;

    public static JRStyledTextParser getInstance() {
        JRStyledTextParser instance = null;
        SoftReference<JRStyledTextParser> instanceRef = threadInstances.get();
        if (instanceRef != null) {
            instance = instanceRef.get();
        }
        if (instance == null) {
            instance = new JRStyledTextParser();
            threadInstances.set(new SoftReference<JRStyledTextParser>(instance));
        }
        return instance;
    }

    public static void setLocale(Locale locale) {
        threadLocale.set(locale);
    }

    public static Locale getLocale() {
        return threadLocale.get();
    }

    private JRStyledTextParser() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            this.documentBuilder = factory.newDocumentBuilder();
            this.documentBuilder.setErrorHandler(this);
        }
        catch (ParserConfigurationException e) {
            throw new JRRuntimeException(e);
        }
    }

    public JRStyledText parse(Map<AttributedCharacterIterator.Attribute, Object> attributes, String text, Locale locale) throws SAXException {
        JRStyledText styledText = new JRStyledText(locale);
        Document document = null;
        try {
            document = this.documentBuilder.parse(new InputSource(new StringReader(ROOT_START + text + ROOT_END)));
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
        this.hyperlink = null;
        this.parseStyle(styledText, document.getDocumentElement());
        styledText.setGlobalAttributes(attributes);
        return styledText;
    }

    public JRStyledText getStyledText(Map<AttributedCharacterIterator.Attribute, Object> parentAttributes, String text, boolean isStyledText, Locale locale) {
        JRStyledText styledText = null;
        if (isStyledText) {
            try {
                styledText = this.parse(parentAttributes, text, locale);
            }
            catch (SAXException e) {
                // empty catch block
            }
        }
        if (styledText == null) {
            styledText = new JRStyledText(locale);
            styledText.append(text);
            styledText.setGlobalAttributes(parentAttributes);
        }
        return styledText;
    }

    public String write(JRStyledText styledText) {
        return this.write(styledText.getGlobalAttributes(), styledText.getAttributedString().getIterator(), styledText.getText());
    }

    public String write(Map<AttributedCharacterIterator.Attribute, Object> parentAttrs, AttributedCharacterIterator iterator, String text) {
        StringBuffer sbuffer = new StringBuffer();
        int runLimit = 0;
        while (runLimit < iterator.getEndIndex() && (runLimit = iterator.getRunLimit()) <= iterator.getEndIndex()) {
            String chunk = text.substring(iterator.getIndex(), runLimit);
            Map<AttributedCharacterIterator.Attribute, Object> attrs = iterator.getAttributes();
            StringBuffer styleBuffer = this.writeStyleAttributes(parentAttrs, attrs);
            if (styleBuffer.length() > 0) {
                sbuffer.append(LESS);
                sbuffer.append(NODE_style);
                sbuffer.append(styleBuffer.toString());
                sbuffer.append(GREATER);
                this.writeChunk(sbuffer, parentAttrs, attrs, chunk);
                sbuffer.append(LESS_SLASH);
                sbuffer.append(NODE_style);
                sbuffer.append(GREATER);
            } else {
                this.writeChunk(sbuffer, parentAttrs, attrs, chunk);
            }
            iterator.setIndex(runLimit);
        }
        return sbuffer.toString();
    }

    public String write(JRStyledText styledText, int startIndex, int endIndex) {
        AttributedCharacterIterator subIterator = new AttributedString(styledText.getAttributedString().getIterator(), startIndex, endIndex).getIterator();
        String subText = styledText.getText().substring(startIndex, endIndex);
        return this.write(styledText.getGlobalAttributes(), subIterator, subText);
    }

    public void writeChunk(StringBuffer sbuffer, Map<AttributedCharacterIterator.Attribute, Object> parentAttrs, Map<AttributedCharacterIterator.Attribute, Object> attrs, String chunk) {
        JRPrintHyperlink hlink;
        String scriptNode;
        Object value = attrs.get(TextAttribute.SUPERSCRIPT);
        Object oldValue = parentAttrs.get(TextAttribute.SUPERSCRIPT);
        boolean isSuper = false;
        boolean isSub = false;
        if (value != null && !value.equals(oldValue)) {
            isSuper = TextAttribute.SUPERSCRIPT_SUPER.equals(value);
            isSub = TextAttribute.SUPERSCRIPT_SUB.equals(value);
        }
        String string = scriptNode = isSuper ? NODE_sup : NODE_sub;
        if (isSuper || isSub) {
            sbuffer.append(LESS);
            sbuffer.append(scriptNode);
            sbuffer.append(GREATER);
        }
        if ((hlink = (JRPrintHyperlink)attrs.get(JRTextAttribute.HYPERLINK)) != null) {
            String target;
            String type;
            sbuffer.append(LESS);
            sbuffer.append(NODE_a);
            String href = hlink.getHyperlinkReference();
            if (href != null && href.trim().length() > 0) {
                sbuffer.append(SPACE);
                sbuffer.append(ATTRIBUTE_href);
                sbuffer.append(EQUAL_QUOTE);
                sbuffer.append(JRStringUtil.htmlEncode(href));
                sbuffer.append(QUOTE);
            }
            if ((type = hlink.getLinkType()) != null && type.trim().length() > 0) {
                sbuffer.append(SPACE);
                sbuffer.append(ATTRIBUTE_type);
                sbuffer.append(EQUAL_QUOTE);
                sbuffer.append(type);
                sbuffer.append(QUOTE);
            }
            if ((target = hlink.getLinkTarget()) != null && target.trim().length() > 0) {
                sbuffer.append(SPACE);
                sbuffer.append(ATTRIBUTE_target);
                sbuffer.append(EQUAL_QUOTE);
                sbuffer.append(target);
                sbuffer.append(QUOTE);
            }
            sbuffer.append(GREATER);
            JRPrintHyperlinkParameters parameters = hlink.getHyperlinkParameters();
            if (parameters != null && parameters.getParameters() != null) {
                for (JRPrintHyperlinkParameter parameter : parameters.getParameters()) {
                    sbuffer.append(LESS);
                    sbuffer.append(NODE_param);
                    sbuffer.append(SPACE);
                    sbuffer.append(ATTRIBUTE_name);
                    sbuffer.append(EQUAL_QUOTE);
                    sbuffer.append(parameter.getName());
                    sbuffer.append(QUOTE);
                    sbuffer.append(GREATER);
                    if (parameter.getValue() != null) {
                        String strValue = JRValueStringUtils.serialize((String)parameter.getValueClass(), (Object)parameter.getValue());
                        sbuffer.append(JRStringUtil.xmlEncode(strValue));
                    }
                    sbuffer.append(LESS_SLASH);
                    sbuffer.append(NODE_param);
                    sbuffer.append(GREATER);
                }
            }
        }
        sbuffer.append(JRStringUtil.xmlEncode(chunk));
        if (hlink != null) {
            sbuffer.append(LESS_SLASH);
            sbuffer.append(NODE_a);
            sbuffer.append(GREATER);
        }
        if (isSuper || isSub) {
            sbuffer.append(LESS_SLASH);
            sbuffer.append(scriptNode);
            sbuffer.append(GREATER);
        }
    }

    private void parseStyle(JRStyledText styledText, Node parentNode) throws SAXException {
        NodeList nodeList = parentNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                styledText.append(node.getNodeValue());
                continue;
            }
            if (node.getNodeType() == 1 && NODE_style.equals(node.getNodeName())) {
                Color color;
                NamedNodeMap nodeAttrs = node.getAttributes();
                HashMap<AttributedCharacterIterator.Attribute, Object> styleAttrs = new HashMap<AttributedCharacterIterator.Attribute, Object>();
                if (nodeAttrs.getNamedItem(ATTRIBUTE_fontName) != null) {
                    styleAttrs.put(TextAttribute.FAMILY, nodeAttrs.getNamedItem(ATTRIBUTE_fontName).getNodeValue());
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_isBold) != null) {
                    styleAttrs.put(TextAttribute.WEIGHT, Boolean.valueOf(nodeAttrs.getNamedItem(ATTRIBUTE_isBold).getNodeValue()) != false ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_isItalic) != null) {
                    styleAttrs.put(TextAttribute.POSTURE, Boolean.valueOf(nodeAttrs.getNamedItem(ATTRIBUTE_isItalic).getNodeValue()) != false ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_isUnderline) != null) {
                    styleAttrs.put(TextAttribute.UNDERLINE, Boolean.valueOf(nodeAttrs.getNamedItem(ATTRIBUTE_isUnderline).getNodeValue()) != false ? TextAttribute.UNDERLINE_ON : null);
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_isStrikeThrough) != null) {
                    styleAttrs.put(TextAttribute.STRIKETHROUGH, Boolean.valueOf(nodeAttrs.getNamedItem(ATTRIBUTE_isStrikeThrough).getNodeValue()) != false ? TextAttribute.STRIKETHROUGH_ON : null);
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_size) != null) {
                    styleAttrs.put(TextAttribute.SIZE, new Float(nodeAttrs.getNamedItem(ATTRIBUTE_size).getNodeValue()));
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_pdfFontName) != null) {
                    styleAttrs.put(JRTextAttribute.PDF_FONT_NAME, nodeAttrs.getNamedItem(ATTRIBUTE_pdfFontName).getNodeValue());
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_pdfEncoding) != null) {
                    styleAttrs.put(JRTextAttribute.PDF_ENCODING, nodeAttrs.getNamedItem(ATTRIBUTE_pdfEncoding).getNodeValue());
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_isPdfEmbedded) != null) {
                    styleAttrs.put(JRTextAttribute.IS_PDF_EMBEDDED, Boolean.valueOf(nodeAttrs.getNamedItem(ATTRIBUTE_isPdfEmbedded).getNodeValue()));
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_forecolor) != null) {
                    color = JRColorUtil.getColor((String)nodeAttrs.getNamedItem(ATTRIBUTE_forecolor).getNodeValue(), (Color)Color.black);
                    styleAttrs.put(TextAttribute.FOREGROUND, color);
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_backcolor) != null) {
                    color = JRColorUtil.getColor((String)nodeAttrs.getNamedItem(ATTRIBUTE_backcolor).getNodeValue(), (Color)Color.black);
                    styleAttrs.put(TextAttribute.BACKGROUND, color);
                }
                int startIndex = styledText.length();
                this.parseStyle(styledText, node);
                styledText.addRun(new JRStyledText.Run(styleAttrs, startIndex, styledText.length()));
                continue;
            }
            if (node.getNodeType() == 1 && NODE_bold.equalsIgnoreCase(node.getNodeName())) {
                HashMap<AttributedCharacterIterator.Attribute, Object> styleAttrs = new HashMap<AttributedCharacterIterator.Attribute, Object>();
                styleAttrs.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                int startIndex = styledText.length();
                this.parseStyle(styledText, node);
                styledText.addRun(new JRStyledText.Run(styleAttrs, startIndex, styledText.length()));
                continue;
            }
            if (node.getNodeType() == 1 && NODE_italic.equalsIgnoreCase(node.getNodeName())) {
                HashMap<AttributedCharacterIterator.Attribute, Object> styleAttrs = new HashMap<AttributedCharacterIterator.Attribute, Object>();
                styleAttrs.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
                int startIndex = styledText.length();
                this.parseStyle(styledText, node);
                styledText.addRun(new JRStyledText.Run(styleAttrs, startIndex, styledText.length()));
                continue;
            }
            if (node.getNodeType() == 1 && NODE_underline.equalsIgnoreCase(node.getNodeName())) {
                HashMap<AttributedCharacterIterator.Attribute, Object> styleAttrs = new HashMap<AttributedCharacterIterator.Attribute, Object>();
                styleAttrs.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                int startIndex = styledText.length();
                this.parseStyle(styledText, node);
                styledText.addRun(new JRStyledText.Run(styleAttrs, startIndex, styledText.length()));
                continue;
            }
            if (node.getNodeType() == 1 && NODE_sup.equalsIgnoreCase(node.getNodeName())) {
                HashMap<AttributedCharacterIterator.Attribute, Object> styleAttrs = new HashMap<AttributedCharacterIterator.Attribute, Object>();
                styleAttrs.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
                int startIndex = styledText.length();
                this.parseStyle(styledText, node);
                styledText.addRun(new JRStyledText.Run(styleAttrs, startIndex, styledText.length()));
                continue;
            }
            if (node.getNodeType() == 1 && NODE_sub.equalsIgnoreCase(node.getNodeName())) {
                HashMap<AttributedCharacterIterator.Attribute, Object> styleAttrs = new HashMap<AttributedCharacterIterator.Attribute, Object>();
                styleAttrs.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB);
                int startIndex = styledText.length();
                this.parseStyle(styledText, node);
                styledText.addRun(new JRStyledText.Run(styleAttrs, startIndex, styledText.length()));
                continue;
            }
            if (node.getNodeType() == 1 && NODE_font.equalsIgnoreCase(node.getNodeName())) {
                NamedNodeMap nodeAttrs = node.getAttributes();
                HashMap<AttributedCharacterIterator.Attribute, Object> styleAttrs = new HashMap<AttributedCharacterIterator.Attribute, Object>();
                if (nodeAttrs.getNamedItem(ATTRIBUTE_size) != null) {
                    styleAttrs.put(TextAttribute.SIZE, new Float(nodeAttrs.getNamedItem(ATTRIBUTE_size).getNodeValue()));
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_color) != null) {
                    Color color = JRColorUtil.getColor((String)nodeAttrs.getNamedItem(ATTRIBUTE_color).getNodeValue(), (Color)Color.black);
                    styleAttrs.put(TextAttribute.FOREGROUND, color);
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_fontFace) != null) {
                    String fontFaces = nodeAttrs.getNamedItem(ATTRIBUTE_fontFace).getNodeValue();
                    StringTokenizer t = new StringTokenizer(fontFaces, ",");
                    while (t.hasMoreTokens()) {
                        String face = t.nextToken().trim();
                        if (!AVAILABLE_FONT_FACE_NAMES.contains(face)) continue;
                        styleAttrs.put(TextAttribute.FAMILY, face);
                        break;
                    }
                }
                int startIndex = styledText.length();
                this.parseStyle(styledText, node);
                styledText.addRun(new JRStyledText.Run(styleAttrs, startIndex, styledText.length()));
                continue;
            }
            if (node.getNodeType() == 1 && NODE_br.equalsIgnoreCase(node.getNodeName())) {
                styledText.append("\n");
                int startIndex = styledText.length();
                this.resizeRuns(styledText.getRuns(), startIndex, 1);
                this.parseStyle(styledText, node);
                styledText.addRun(new JRStyledText.Run(new HashMap<AttributedCharacterIterator.Attribute, Object>(), startIndex, styledText.length()));
                if (startIndex >= styledText.length()) continue;
                styledText.append("\n");
                this.resizeRuns(styledText.getRuns(), startIndex, 1);
                continue;
            }
            if (node.getNodeType() == 1 && NODE_li.equalsIgnoreCase(node.getNodeName())) {
                String tmpText = styledText.getText();
                if (tmpText.length() > 0 && !tmpText.endsWith("\n")) {
                    styledText.append("\n");
                }
                styledText.append(" \u2022 ");
                int startIndex = styledText.length();
                this.resizeRuns(styledText.getRuns(), startIndex, 1);
                this.parseStyle(styledText, node);
                styledText.addRun(new JRStyledText.Run(new HashMap<AttributedCharacterIterator.Attribute, Object>(), startIndex, styledText.length()));
                Node nextNode = node.getNextSibling();
                String textContent = this.getFirstTextOccurence(nextNode);
                if (nextNode == null || nextNode.getNodeType() == 1 && NODE_li.equalsIgnoreCase(nextNode.getNodeName()) || textContent != null && textContent.startsWith("\n")) continue;
                styledText.append("\n");
                this.resizeRuns(styledText.getRuns(), startIndex, 1);
                continue;
            }
            if (node.getNodeType() == 1 && NODE_a.equalsIgnoreCase(node.getNodeName())) {
                if (this.hyperlink == null) {
                    NamedNodeMap nodeAttrs = node.getAttributes();
                    HashMap<AttributedCharacterIterator.Attribute, Object> styleAttrs = new HashMap<AttributedCharacterIterator.Attribute, Object>();
                    this.hyperlink = new JRBasePrintHyperlink();
                    this.hyperlink.setHyperlinkType(HyperlinkTypeEnum.REFERENCE);
                    styleAttrs.put(JRTextAttribute.HYPERLINK, this.hyperlink);
                    if (nodeAttrs.getNamedItem(ATTRIBUTE_href) != null) {
                        this.hyperlink.setHyperlinkReference(nodeAttrs.getNamedItem(ATTRIBUTE_href).getNodeValue());
                    }
                    if (nodeAttrs.getNamedItem(ATTRIBUTE_type) != null) {
                        this.hyperlink.setLinkType(nodeAttrs.getNamedItem(ATTRIBUTE_type).getNodeValue());
                    }
                    if (nodeAttrs.getNamedItem(ATTRIBUTE_target) != null) {
                        this.hyperlink.setLinkTarget(nodeAttrs.getNamedItem(ATTRIBUTE_target).getNodeValue());
                    }
                    int startIndex = styledText.length();
                    this.parseStyle(styledText, node);
                    styledText.addRun(new JRStyledText.Run(styleAttrs, startIndex, styledText.length()));
                    this.hyperlink = null;
                    continue;
                }
                throw new SAXException("Hyperlink <a> tags cannot be nested.");
            }
            if (node.getNodeType() == 1 && NODE_param.equalsIgnoreCase(node.getNodeName())) {
                String strValue;
                if (this.hyperlink == null) {
                    throw new SAXException("Hyperlink <param> tags must appear inside an <a> tag only.");
                }
                NamedNodeMap nodeAttrs = node.getAttributes();
                JRPrintHyperlinkParameter parameter = new JRPrintHyperlinkParameter();
                if (nodeAttrs.getNamedItem(ATTRIBUTE_name) != null) {
                    parameter.setName(nodeAttrs.getNamedItem(ATTRIBUTE_name).getNodeValue());
                }
                if (nodeAttrs.getNamedItem(ATTRIBUTE_valueClass) != null) {
                    parameter.setValueClass(nodeAttrs.getNamedItem(ATTRIBUTE_valueClass).getNodeValue());
                }
                if ((strValue = node.getTextContent()) != null) {
                    Object value = JRValueStringUtils.deserialize((String)parameter.getValueClass(), (String)strValue);
                    parameter.setValue(value);
                }
                this.hyperlink.addHyperlinkParameter(parameter);
                continue;
            }
            if (node.getNodeType() != 1) continue;
            String nodeName = LESS + node.getNodeName() + GREATER;
            throw new SAXException("Tag " + nodeName + " is not a valid styled text tag.");
        }
    }

    private void resizeRuns(List<JRStyledText.Run> runs, int startIndex, int count) {
        for (int j = 0; j < runs.size(); ++j) {
            JRStyledText.Run run = runs.get(j);
            if (run.startIndex > startIndex || run.endIndex <= startIndex - count) continue;
            run.endIndex += count;
        }
    }

    private StringBuffer writeStyleAttributes(Map<AttributedCharacterIterator.Attribute, Object> parentAttrs, Map<AttributedCharacterIterator.Attribute, Object> attrs) {
        StringBuffer sbuffer = new StringBuffer();
        Object value = attrs.get(TextAttribute.FAMILY);
        Object oldValue = parentAttrs.get(TextAttribute.FAMILY);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_fontName);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value);
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.WEIGHT);
        oldValue = parentAttrs.get(TextAttribute.WEIGHT);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_isBold);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value.equals(TextAttribute.WEIGHT_BOLD));
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.POSTURE);
        oldValue = parentAttrs.get(TextAttribute.POSTURE);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_isItalic);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value.equals(TextAttribute.POSTURE_OBLIQUE));
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.UNDERLINE);
        oldValue = parentAttrs.get(TextAttribute.UNDERLINE);
        if (value == null && oldValue != null || value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_isUnderline);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value != null);
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.STRIKETHROUGH);
        oldValue = parentAttrs.get(TextAttribute.STRIKETHROUGH);
        if (value == null && oldValue != null || value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_isStrikeThrough);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value != null);
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.SIZE);
        oldValue = parentAttrs.get(TextAttribute.SIZE);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_size);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(((Float)value).intValue());
            sbuffer.append(QUOTE);
        }
        value = attrs.get(JRTextAttribute.PDF_FONT_NAME);
        oldValue = parentAttrs.get(JRTextAttribute.PDF_FONT_NAME);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_pdfFontName);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value);
            sbuffer.append(QUOTE);
        }
        value = attrs.get(JRTextAttribute.PDF_ENCODING);
        oldValue = parentAttrs.get(JRTextAttribute.PDF_ENCODING);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_pdfEncoding);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value);
            sbuffer.append(QUOTE);
        }
        value = attrs.get(JRTextAttribute.IS_PDF_EMBEDDED);
        oldValue = parentAttrs.get(JRTextAttribute.IS_PDF_EMBEDDED);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_isPdfEmbedded);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(value);
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.FOREGROUND);
        oldValue = parentAttrs.get(TextAttribute.FOREGROUND);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_forecolor);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(SHARP);
            sbuffer.append(JRColorUtil.getColorHexa((Color)((Color)value)));
            sbuffer.append(QUOTE);
        }
        value = attrs.get(TextAttribute.BACKGROUND);
        oldValue = parentAttrs.get(TextAttribute.BACKGROUND);
        if (value != null && !value.equals(oldValue)) {
            sbuffer.append(SPACE);
            sbuffer.append(ATTRIBUTE_backcolor);
            sbuffer.append(EQUAL_QUOTE);
            sbuffer.append(SHARP);
            sbuffer.append(JRColorUtil.getColorHexa((Color)((Color)value)));
            sbuffer.append(QUOTE);
        }
        return sbuffer;
    }

    private String getFirstTextOccurence(Node node) {
        if (node != null) {
            if (node.getNodeValue() != null) {
                return node.getNodeValue();
            }
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String firstOccurence = this.getFirstTextOccurence(nodeList.item(i));
                if (firstOccurence == null) continue;
                return firstOccurence;
            }
        }
        return null;
    }

    @Override
    public void error(SAXParseException e) {
        if (log.isErrorEnabled()) {
            log.error((Object)"Error parsing styled text.", (Throwable)e);
        }
    }

    @Override
    public void fatalError(SAXParseException e) {
        if (log.isFatalEnabled()) {
            log.fatal((Object)"Error parsing styled text.", (Throwable)e);
        }
    }

    @Override
    public void warning(SAXParseException e) {
        if (log.isWarnEnabled()) {
            log.warn((Object)"Error parsing styled text.", (Throwable)e);
        }
    }

    static {
        List<FontFamily> families = ExtensionsEnvironment.getExtensionsRegistry().getExtensions(FontFamily.class);
        for (FontFamily family : families) {
            AVAILABLE_FONT_FACE_NAMES.add(family.getName());
        }
        AVAILABLE_FONT_FACE_NAMES.addAll(Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()));
        threadInstances = new ThreadLocal();
        threadLocale = new ThreadLocal();
    }
}

