/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.view.JRSaveContributor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SaveContributorUtils {
    private static final Log log = LogFactory.getLog(SaveContributorUtils.class);
    private static final String[] DEFAULT_CONTRIBUTORS = new String[]{"net.sf.jasperreports.view.save.JRPrintSaveContributor", "net.sf.jasperreports.view.save.JRPdfSaveContributor", "net.sf.jasperreports.view.save.JRRtfSaveContributor", "net.sf.jasperreports.view.save.JROdtSaveContributor", "net.sf.jasperreports.view.save.JRDocxSaveContributor", "net.sf.jasperreports.view.save.JRHtmlSaveContributor", "net.sf.jasperreports.view.save.JRSingleSheetXlsSaveContributor", "net.sf.jasperreports.view.save.JRMultipleSheetsXlsSaveContributor", "net.sf.jasperreports.view.save.JRCsvSaveContributor", "net.sf.jasperreports.view.save.JRXmlSaveContributor", "net.sf.jasperreports.view.save.JREmbeddedImagesXmlSaveContributor"};
    private static final Class<?>[] CONSTRUCTOR_SIGNATURE = new Class[]{JasperReportsContext.class, Locale.class, ResourceBundle.class};

    public static List<JRSaveContributor> createBuiltinContributors(JasperReportsContext context, Locale locale, ResourceBundle resourceBundle) {
        ArrayList<JRSaveContributor> contributors = new ArrayList<JRSaveContributor>(DEFAULT_CONTRIBUTORS.length);
        for (String contributorClassName : DEFAULT_CONTRIBUTORS) {
            try {
                Class<?> saveContribClass = JRClassLoader.loadClassForName(contributorClassName);
                Constructor<?> constructor = saveContribClass.getConstructor(CONSTRUCTOR_SIGNATURE);
                JRSaveContributor saveContrib = (JRSaveContributor)constructor.newInstance(context, locale, resourceBundle);
                contributors.add(saveContrib);
            }
            catch (Exception e) {
                log.warn((Object)("Error creating save contributor of type " + contributorClassName), (Throwable)e);
            }
        }
        return contributors;
    }
}

