/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.BaseResultSet;
import org.postgresql.core.BaseStatement;
import org.postgresql.core.Field;
import org.postgresql.jdbc2.AbstractJdbc2ResultSet;
import org.postgresql.jdbc2.TimestampUtils;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class AbstractJdbc2Array {
    private BaseConnection conn = null;
    private Field field = null;
    private BaseResultSet rs;
    private int idx = 0;
    private String rawString = null;

    public AbstractJdbc2Array(BaseConnection conn, int idx, Field field, BaseResultSet rs) throws SQLException {
        this.conn = conn;
        this.field = field;
        this.rs = rs;
        this.idx = idx;
        this.rawString = rs.getFixedString(idx);
    }

    private void fillIntegerResultSet(long index, int[] intArray, Vector rows) throws SQLException {
        int i = 0;
        while (i < intArray.length) {
            byte[][] tuple = new byte[2][0];
            tuple[0] = this.conn.encodeString(Integer.toString((int)index + i));
            tuple[1] = this.conn.encodeString(Integer.toString(intArray[i]));
            rows.addElement(tuple);
            ++i;
        }
    }

    private void fillStringResultSet(long index, String[] strArray, Vector rows) throws SQLException {
        int i = 0;
        while (i < strArray.length) {
            byte[][] tuple = new byte[2][0];
            tuple[0] = this.conn.encodeString(Integer.toString((int)index + i));
            tuple[1] = this.conn.encodeString(strArray[i]);
            rows.addElement(tuple);
            ++i;
        }
    }

    public Object getArray() throws SQLException {
        return this.getArrayImpl(1L, 0, null);
    }

    public Object getArray(long index, int count) throws SQLException {
        return this.getArrayImpl(index, count, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Object getArrayImpl(long index, int count, Map map) throws SQLException {
        block37: {
            if (map != null) {
                throw Driver.notImplemented();
            }
            if (index < 1L) {
                throw new PSQLException(GT.tr("The array index is out of range: {0}", new Long(index)), PSQLState.DATA_ERROR);
            }
            retVal /* !! */  = null;
            array = new ArrayList<String>();
            if (this.rawString == null || this.rawString.equals("{}")) break block37;
            chars = this.rawString.toCharArray();
            sbuf = new StringBuffer();
            foundOpen = false;
            insideString = false;
            startOffset = 0;
            if (chars[0] == '[') {
                while (chars[startOffset] != '=') {
                    ++startOffset;
                }
                ++startOffset;
            }
            i = startOffset;
            while (i < chars.length) {
                block38: {
                    if (chars[i] != '\\') break block38;
                    ++i;
                    ** GOTO lbl-1000
                }
                if (!insideString && chars[i] == '{') {
                    if (foundOpen) {
                        throw new PSQLException(GT.tr("Multi-dimensional arrays are currently not supported."), PSQLState.NOT_IMPLEMENTED);
                    }
                    foundOpen = true;
                } else if (chars[i] == '\"') {
                    insideString ^= true;
                } else if (!insideString && (chars[i] == ',' || chars[i] == '}') || i == chars.length - 1) {
                    if (chars[i] != '\"' && chars[i] != '}' && chars[i] != ',') {
                        sbuf.append(chars[i]);
                    }
                    array.add(sbuf.toString());
                    sbuf = new StringBuffer();
                } else lbl-1000:
                // 2 sources

                {
                    sbuf.append(chars[i]);
                }
                ++i;
            }
        }
        arrayContents = array.toArray(new String[array.size()]);
        if (count == 0) {
            count = arrayContents.length;
        }
        if (--index + (long)count > (long)arrayContents.length) {
            throw new PSQLException(GT.tr("The array index is out of range: {0}, number of elements: {1}.", new Object[]{new Long(index + (long)count), new Long(arrayContents.length)}), PSQLState.DATA_ERROR);
        }
        i = 0;
        cal = null;
        switch (this.getBaseType()) {
            case -7: {
                retVal /* !! */  = new boolean[count];
                while (count > 0) {
                    retVal /* !! */ [i++] = AbstractJdbc2ResultSet.toBoolean(arrayContents[(int)index++]);
                    --count;
                }
                break;
            }
            case 4: 
            case 5: {
                retVal /* !! */  = (boolean[])new int[count];
                while (count > 0) {
                    ((int[])retVal /* !! */ )[i++] = AbstractJdbc2ResultSet.toInt(arrayContents[(int)index++]);
                    --count;
                }
                break;
            }
            case -5: {
                retVal /* !! */  = (boolean[])new long[count];
                while (count > 0) {
                    ((long[])retVal /* !! */ )[i++] = AbstractJdbc2ResultSet.toLong(arrayContents[(int)index++]);
                    --count;
                }
                break;
            }
            case 2: {
                retVal /* !! */  = (boolean[])new BigDecimal[count];
                while (count > 0) {
                    ((BigDecimal[])retVal /* !! */ )[i++] = AbstractJdbc2ResultSet.toBigDecimal(arrayContents[(int)index++], -1);
                    --count;
                }
                break;
            }
            case 7: {
                retVal /* !! */  = (boolean[])new float[count];
                while (count > 0) {
                    ((float[])retVal /* !! */ )[i++] = AbstractJdbc2ResultSet.toFloat(arrayContents[(int)index++]);
                    --count;
                }
                break;
            }
            case 8: {
                retVal /* !! */  = (boolean[])new double[count];
                while (count > 0) {
                    ((double[])retVal /* !! */ )[i++] = AbstractJdbc2ResultSet.toDouble(arrayContents[(int)index++]);
                    --count;
                }
                break;
            }
            case 1: 
            case 12: {
                retVal /* !! */  = (boolean[])new String[count];
                while (count > 0) {
                    ((String[])retVal /* !! */ )[i++] = arrayContents[(int)index++];
                    --count;
                }
                break;
            }
            case 91: {
                retVal /* !! */  = (boolean[])new Date[count];
                cal = new GregorianCalendar();
                while (count > 0) {
                    ((Date[])retVal /* !! */ )[i++] = TimestampUtils.toDate(cal, arrayContents[(int)index++]);
                    --count;
                }
                break;
            }
            case 92: {
                retVal /* !! */  = (boolean[])new Time[count];
                cal = new GregorianCalendar();
                while (count > 0) {
                    ((Time[])retVal /* !! */ )[i++] = TimestampUtils.toTime(cal, arrayContents[(int)index++]);
                    --count;
                }
                break;
            }
            case 93: {
                retVal /* !! */  = (boolean[])new Timestamp[count];
                cal = new GregorianCalendar();
                while (count > 0) {
                    ((Timestamp[])retVal /* !! */ )[i++] = TimestampUtils.toTimestamp(cal, arrayContents[(int)index++]);
                    --count;
                }
                break;
            }
            default: {
                throw Driver.notImplemented();
            }
        }
        return retVal /* !! */ ;
    }

    public Object getArrayImpl(Map map) throws SQLException {
        return this.getArrayImpl(1L, 0, map);
    }

    public int getBaseType() throws SQLException {
        return this.conn.getSQLType(this.getBaseTypeName());
    }

    public String getBaseTypeName() throws SQLException {
        String fType = this.conn.getPGType(this.field.getOID());
        if (fType.charAt(0) == '_') {
            fType = fType.substring(1);
        }
        return fType;
    }

    public ResultSet getResultSet() throws SQLException {
        return this.getResultSetImpl(1L, 0, null);
    }

    public ResultSet getResultSet(long index, int count) throws SQLException {
        return this.getResultSetImpl(index, count, null);
    }

    public ResultSet getResultSetImpl(long index, int count, Map map) throws SQLException {
        StringBuffer sbuf = null;
        GregorianCalendar cal = null;
        Object array = this.getArrayImpl(index, count, map);
        Vector<byte[][]> rows = new Vector<byte[][]>();
        Field[] fields = new Field[2];
        fields[0] = new Field("INDEX", 21, 2);
        switch (this.getBaseType()) {
            case -7: {
                boolean[] booleanArray = (boolean[])array;
                fields[1] = new Field("VALUE", 16, 1);
                int i = 0;
                while (i < booleanArray.length) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.encodeString(Integer.toString((int)index + i));
                    tuple[1] = this.conn.encodeString(booleanArray[i] ? "YES" : "NO");
                    rows.addElement(tuple);
                    ++i;
                }
                break;
            }
            case 5: {
                fields[1] = new Field("VALUE", 21, 2);
                this.fillIntegerResultSet(index, (int[])array, rows);
                break;
            }
            case 4: {
                fields[1] = new Field("VALUE", 23, 4);
                this.fillIntegerResultSet(index, (int[])array, rows);
                break;
            }
            case -5: {
                long[] longArray = (long[])array;
                fields[1] = new Field("VALUE", 20, 8);
                int i = 0;
                while (i < longArray.length) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.encodeString(Integer.toString((int)index + i));
                    tuple[1] = this.conn.encodeString(Long.toString(longArray[i]));
                    rows.addElement(tuple);
                    ++i;
                }
                break;
            }
            case 2: {
                BigDecimal[] bdArray = (BigDecimal[])array;
                fields[1] = new Field("VALUE", 1700, -1);
                int i = 0;
                while (i < bdArray.length) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.encodeString(Integer.toString((int)index + i));
                    tuple[1] = this.conn.encodeString(bdArray[i].toString());
                    rows.addElement(tuple);
                    ++i;
                }
                break;
            }
            case 7: {
                float[] floatArray = (float[])array;
                fields[1] = new Field("VALUE", 700, 4);
                int i = 0;
                while (i < floatArray.length) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.encodeString(Integer.toString((int)index + i));
                    tuple[1] = this.conn.encodeString(Float.toString(floatArray[i]));
                    rows.addElement(tuple);
                    ++i;
                }
                break;
            }
            case 8: {
                double[] doubleArray = (double[])array;
                fields[1] = new Field("VALUE", 701, 8);
                int i = 0;
                while (i < doubleArray.length) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.encodeString(Integer.toString((int)index + i));
                    tuple[1] = this.conn.encodeString(Double.toString(doubleArray[i]));
                    rows.addElement(tuple);
                    ++i;
                }
                break;
            }
            case 1: {
                fields[1] = new Field("VALUE", 1042, 1);
                this.fillStringResultSet(index, (String[])array, rows);
                break;
            }
            case 12: {
                fields[1] = new Field("VALUE", 1043, -1);
                this.fillStringResultSet(index, (String[])array, rows);
                break;
            }
            case 91: {
                Date[] dateArray = (Date[])array;
                sbuf = new StringBuffer(35);
                cal = new GregorianCalendar();
                fields[1] = new Field("VALUE", 1082, 4);
                int i = 0;
                while (i < dateArray.length) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.encodeString(Integer.toString((int)index + i));
                    tuple[1] = this.conn.encodeString(TimestampUtils.toString(sbuf, cal, dateArray[i]));
                    rows.addElement(tuple);
                    ++i;
                }
                break;
            }
            case 92: {
                sbuf = new StringBuffer(35);
                cal = new GregorianCalendar();
                Time[] timeArray = (Time[])array;
                fields[1] = new Field("VALUE", 1083, 8);
                int i = 0;
                while (i < timeArray.length) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.encodeString(Integer.toString((int)index + i));
                    tuple[1] = this.conn.encodeString(TimestampUtils.toString(sbuf, cal, timeArray[i]));
                    rows.addElement(tuple);
                    ++i;
                }
                break;
            }
            case 93: {
                sbuf = new StringBuffer(35);
                cal = new GregorianCalendar();
                Timestamp[] timestampArray = (Timestamp[])array;
                fields[1] = new Field("VALUE", 1184, 8);
                int i = 0;
                while (i < timestampArray.length) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.encodeString(Integer.toString((int)index + i));
                    tuple[1] = this.conn.encodeString(TimestampUtils.toString(sbuf, cal, timestampArray[i]));
                    rows.addElement(tuple);
                    ++i;
                }
                break;
            }
            default: {
                throw Driver.notImplemented();
            }
        }
        BaseStatement stat = (BaseStatement)this.conn.createStatement(1004, 1007);
        return stat.createDriverResultSet(fields, rows);
    }

    public ResultSet getResultSetImpl(Map map) throws SQLException {
        return this.getResultSetImpl(1L, 0, map);
    }

    public String toString() {
        return this.rawString;
    }
}

