/*
 * Decompiled with CFR 0.152.
 */
package cz.dhl.ftp;

import cz.dhl.ftp.FtpConnect;
import cz.dhl.ftp.FtpContext;
import cz.dhl.ftp.FtpControlSocket;
import cz.dhl.ftp.FtpInterpret;
import cz.dhl.io.CoSource;
import java.io.IOException;

public final class Ftp
implements CoSource {
    public static final int PORT = 21;
    private FtpContext a = new FtpContext();
    FtpControlSocket control = new FtpControlSocket(this.a);

    public boolean connect(FtpConnect ftpConnect) throws IOException {
        if (this.connect(ftpConnect.getHostName(), ftpConnect.getPortNum())) {
            if (this.login(ftpConnect.getUserName(), ftpConnect.getPassWord())) {
                String string = ftpConnect.getPathName();
                if (ftpConnect.getPathName().length() > 0) {
                    this.cd(ftpConnect.getPathName());
                }
            } else {
                this.disconnect();
            }
        }
        return this.isConnected();
    }

    public boolean connect(String string, int n2) throws IOException {
        if (!this.isConnected() && string != null) {
            if (this.control.connect(string, n2)) {
                if (!this.control.completeCommand(FtpInterpret.getReplies("login-done"))) {
                    this.printlog("< Can't obtain welcome message from host! >");
                    this.control.disconnect();
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void disconnect() {
        this.control.disconnect();
    }

    public void abort() {
        this.disconnect();
    }

    public boolean login(String string, String string2) throws IOException {
        if (this.control.executeCommand("USER " + string)) {
            if (this.control.executeCommand("PASS " + string2)) {
                this.syst();
                return true;
            }
            this.printlog("< Can't login to host. >");
            return false;
        }
        this.printlog("< Can't login to host. >");
        return false;
    }

    public String host() throws IOException {
        if (this.isConnected()) {
            return this.control.server;
        }
        throw new IOException("Ctrl: No Connection!");
    }

    public boolean command(String string) {
        return this.control.manualCommand(string);
    }

    public boolean rmdir(String string) {
        return this.control.executeCommand("RMD " + string);
    }

    public boolean mkdir(String string) {
        return this.control.executeCommand("MKD " + string);
    }

    public String pwd() throws IOException {
        if (this.isConnected()) {
            String string = null;
            this.control.executeCommand("PWD");
            String string2 = this.control.replyOfCommand();
            try {
                string = string2.substring(string2.indexOf(34) + 1, string2.lastIndexOf(34));
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                throw new IOException("Ctrl: PWD, Invalid Format!");
            }
            return string;
        }
        throw new IOException("Ctrl: PWD, No Connection!");
    }

    public String syst() throws IOException {
        if (this.isConnected()) {
            this.control.executeCommand("SYST");
            String string = this.control.replyOfCommand();
            this.getContext().setServerSystemMode(1);
            if (string != null && string.toUpperCase().indexOf("WINDOWS") >= 0) {
                this.getContext().setServerSystemMode(2);
                this.printlog("< File: Setting 'WIN' Server Mode >");
            }
            return string;
        }
        throw new IOException("Ctrl: PWD, No Connection!");
    }

    public boolean cd(String string) {
        return this.control.executeCommand("CWD " + string);
    }

    public boolean cdup() {
        return this.control.executeCommand("CDUP");
    }

    public boolean rm(String string) {
        return this.control.executeCommand("DELE " + string);
    }

    public boolean mv(String string, String string2) {
        if (this.control.executeCommand("RNFR " + string)) {
            return this.control.executeCommand("RNTO " + string2);
        }
        return false;
    }

    public boolean chmod(String string, String string2) {
        return this.control.executeCommand("SITE CHMOD " + string2 + " " + string);
    }

    public boolean isConnected() {
        return this.control.isConnected();
    }

    public FtpContext getContext() {
        return this.a;
    }

    void printlog(String string) {
        this.a.printlog(string);
    }

    void printerr(Exception exception) {
        this.a.printerr(exception);
    }
}

