/*
 * Decompiled with CFR 0.152.
 */
package cz.dhl.ftp;

import cz.dhl.ftp.Ftp;
import cz.dhl.ftp.FtpContext;
import cz.dhl.ftp.FtpControlSocket;
import cz.dhl.ftp.FtpInterpret;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
final class FtpDataSocket {
    private ServerSocket a = null;
    private Socket if = null;
    FtpContext context = null;
    private FtpControlSocket do = null;

    FtpDataSocket(Ftp ftp) throws IOException {
        if (!ftp.isConnected()) {
            throw new IOException("Data: CreateSocket, No Connection!");
        }
        this.do = ftp.control;
        this.context = ftp.getContext();
    }

    String getConnect(String string) throws NumberFormatException {
        if (string == null) {
            throw new NumberFormatException("Null Reply!\n");
        }
        int n2 = string.indexOf(40);
        int n3 = string.indexOf(41);
        if (n2 != -1 && n3 != -1 && n2 < n3) {
            return string.substring(n2 + 1, n3);
        }
        throw new NumberFormatException("Invalid Reply!\n" + string);
    }

    String getConnectAddress(String string) throws NumberFormatException {
        int n2 = -1;
        for (int i2 = 0; i2 < 4; ++i2) {
            if ((n2 = string.indexOf(44, n2 + 1)) != -1) continue;
            throw new NumberFormatException("Misformated Reply! " + i2 + ":" + n2 + " " + string);
        }
        return string.substring(0, n2).replace(',', '.');
    }

    int getConnectPort(String string) throws NumberFormatException, NoSuchElementException {
        int n2 = -1;
        for (int i2 = 0; i2 < 4; ++i2) {
            if ((n2 = string.indexOf(44, n2 + 1)) != -1) continue;
            throw new NumberFormatException("Misformated Reply! " + i2 + ":" + n2 + " " + string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n2 + 1), ",");
        return Integer.parseInt(stringTokenizer.nextToken()) * 256 + Integer.parseInt(stringTokenizer.nextToken());
    }

    void openPassiveDataSocket(String string, char c2) throws IOException {
        block8: {
            if (this.do.isConnected()) {
                try {
                    this.do.executeCommand("TYPE " + c2);
                    this.do.executeCommand("PASV");
                    String string2 = this.getConnect(this.do.replyOfCommand());
                    String string3 = this.getConnectAddress(string2);
                    int n2 = this.getConnectPort(string2);
                    this.if = new Socket(string3, n2);
                    this.if.setSoTimeout(60000);
                    if (!this.do.executeCommand(string)) {
                        throw new IOException(this.do.replyOfCommand());
                    }
                    break block8;
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw new IOException("Data: OpenSocket, Invalid Format!\n" + noSuchElementException);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IOException("Data: OpenSocket, Invalid Format!\n" + numberFormatException);
                }
                catch (SocketException socketException) {
                    throw new IOException("Data: OpenSocket, Socket Error!\n" + socketException);
                }
                catch (IOException iOException) {
                    throw new IOException("Data: OpenSocket, IO Error!\n" + iOException);
                }
                catch (Exception exception) {
                    throw new IOException("Data: OpenSocket, Permission Denied?\n" + exception);
                }
            }
            throw new IOException("Data: OpenSocket, No Connection!");
        }
    }

    String getConnect() throws UnknownHostException {
        short s = (short)this.a.getLocalPort();
        return InetAddress.getLocalHost().getHostAddress().replace('.', ',') + "," + s / 256 + "," + s % 256;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void openActiveDataSocket(String string, char c2) throws IOException {
        block9: {
            if (this.do.isConnected()) {
                try {
                    this.do.executeCommand("TYPE " + c2);
                    this.a = new ServerSocket(0);
                    this.a.setSoTimeout(20000);
                    this.do.executeCommand("PORT " + this.getConnect());
                    FtpControlSocket ftpControlSocket = this.do;
                    synchronized (ftpControlSocket) {
                        this.do.writeCommand(string);
                        this.if = this.a.accept();
                        this.if.setSoTimeout(60000);
                        if (!this.do.completeCommand(FtpInterpret.getReplies(string))) {
                            throw new IOException(this.do.replyOfCommand());
                        }
                        break block9;
                    }
                }
                catch (SocketException socketException) {
                    throw new IOException("Data: OpenSocket, Socket Error!\n" + socketException);
                }
                catch (IOException iOException) {
                    throw new IOException("Data: OpenSocket, IO Error!\n" + iOException);
                }
                catch (Exception exception) {
                    throw new IOException("Data: OpenSocket, Permission Denied!\n" + exception);
                }
            }
            throw new IOException("Data: OpenSocket, No Connection!");
        }
    }

    void openDataSocket(String string, char c2) throws IOException {
        if (this.context.getActiveSocketMode()) {
            this.openActiveDataSocket(string, c2);
        } else {
            this.openPassiveDataSocket(string, c2);
        }
    }

    InputStream getInputStream(String string, char c2) throws IOException {
        if (this.if == null) {
            this.openDataSocket(string, c2);
        }
        return this.if.getInputStream();
    }

    OutputStream getOutputStream(String string, char c2) throws IOException {
        if (this.if == null) {
            this.openDataSocket(string, c2);
        }
        return this.if.getOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void close() throws IOException {
        block9: {
            try {
                if (this.if != null) {
                    this.if.close();
                }
                Object var2_1 = null;
                this.if = null;
                if (!this.do.isConnected()) throw new IOException("Data: CloseSocket, No Connection!");
                if (this.do.completeCommand(FtpInterpret.getReplies("data-done"))) break block9;
                this.do.executeCommand("ABOR");
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.if = null;
                if (!this.do.isConnected()) throw new IOException("Data: CloseSocket, No Connection!");
                if (!this.do.completeCommand(FtpInterpret.getReplies("data-done"))) {
                    this.do.executeCommand("ABOR");
                    throw new IOException("Data: CloseSocket, Transfer Aborted!");
                }
                try {
                    if (this.a == null) throw throwable;
                    this.a.close();
                    throw throwable;
                }
                finally {
                    this.a = null;
                }
            }
            throw new IOException("Data: CloseSocket, Transfer Aborted!");
        }
        try {
            if (this.a == null) return;
            this.a.close();
            return;
        }
        finally {
            this.a = null;
        }
    }
}

