/*
 * Decompiled with CFR 0.152.
 */
package cz.dhl.ftp;

import cz.dhl.ftp.Ftp;
import cz.dhl.ftp.FtpConnect;
import cz.dhl.ftp.FtpDataSocket;
import cz.dhl.ftp.FtpFile;
import cz.dhl.ui.CoConsole;
import java.io.IOException;
import java.io.InputStream;

public class FtpInputStream
extends InputStream {
    Ftp client;
    FtpDataSocket data;
    InputStream stream;

    FtpInputStream() {
    }

    public FtpInputStream(FtpFile ftpFile) throws IOException {
        this.client = null;
        this.data = new FtpDataSocket(ftpFile.client);
        this.stream = this.data.getInputStream("RETR " + ftpFile, ftpFile.getDataType());
    }

    public FtpInputStream(FtpFile ftpFile, FtpConnect ftpConnect, CoConsole coConsole) throws IOException {
        this.client = new Ftp();
        if (this.client.connect(ftpConnect)) {
            if (coConsole != null) {
                this.client.getContext().setConsole(coConsole);
            }
        } else {
            throw new IOException("Connect failed.");
        }
        ftpFile = new FtpFile(ftpFile.toString(), this.client);
        this.data = new FtpDataSocket(ftpFile.client);
        this.stream = this.data.getInputStream("RETR " + ftpFile, ftpFile.getDataType());
    }

    public void close() throws IOException {
        IOException iOException = null;
        while (this.stream != null || this.data != null || this.client != null) {
            try {
                if (this.stream != null) {
                    InputStream inputStream = this.stream;
                    this.stream = null;
                    inputStream.close();
                }
                if (this.data != null) {
                    FtpDataSocket ftpDataSocket = this.data;
                    this.data = null;
                    ftpDataSocket.close();
                }
                if (this.client == null) continue;
                Ftp ftp = this.client;
                this.client = null;
                ftp.disconnect();
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    public int read() throws IOException {
        return this.stream.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.stream.read(byArray);
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        return this.stream.read(byArray, n2, n3);
    }

    public long skip(long l2) throws IOException {
        return this.stream.skip(l2);
    }

    public int available() throws IOException {
        return this.stream.available();
    }

    public synchronized void mark(int n2) {
        this.stream.mark(n2);
    }

    public synchronized void reset() throws IOException {
        this.stream.reset();
    }

    public boolean markSupported() {
        return this.stream.markSupported();
    }
}

