/*
 * Decompiled with CFR 0.152.
 */
package cz.dhl.ftp;

import cz.dhl.ftp.FtpDataSocket;
import cz.dhl.ftp.FtpFile;
import cz.dhl.ftp.FtpInputStream;
import java.io.IOException;

public final class FtpListInputStream
extends FtpInputStream {
    public FtpListInputStream(FtpFile ftpFile) throws IOException {
        String string = null;
        if (!ftpFile.client.cd(ftpFile.toString())) {
            throw new IOException("File: cd command failed!\ncd " + ftpFile);
        }
        ftpFile.path = ftpFile.client.pwd();
        this.data = new FtpDataSocket(ftpFile.client);
        switch (this.data.context.getListCommandMode()) {
            case 1: {
                string = "LIST";
                break;
            }
            case 2: {
                string = "NLST";
                break;
            }
            case 4: {
                string = "NLST -F";
                break;
            }
            case 3: {
                string = "NLST -p";
                break;
            }
            case 5: {
                string = "NLST -la";
                break;
            }
            default: {
                throw new IOException("File: Invalid List Command Mode!");
            }
        }
        this.stream = this.data.getInputStream(string, 'A');
    }
}

