/*
 * Decompiled with CFR 0.152.
 */
package jcifs;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import jcifs.util.LogStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Config {
    public static int socketCount;
    private static Properties if;
    private static LogStream a;
    public static String DEFAULT_OEM_ENCODING;

    public static void registerSmbURLHandler() {
        String string = System.getProperty("java.version");
        if (string.startsWith("1.1.") || string.startsWith("1.2.")) {
            throw new RuntimeException("jcifs-0.7.0b4+ requires Java 1.3 or above. You are running " + string);
        }
        String string2 = System.getProperty("java.protocol.handler.pkgs");
        if (string2 == null) {
            System.setProperty("java.protocol.handler.pkgs", "jcifs");
        } else if (string2.indexOf("jcifs") == -1) {
            string2 = string2 + "|jcifs";
            System.setProperty("java.protocol.handler.pkgs", string2);
        }
    }

    Config() {
    }

    public static void setProperties(Properties properties) {
        block2: {
            if = new Properties(properties);
            try {
                if.putAll((Map<?, ?>)System.getProperties());
            }
            catch (SecurityException securityException) {
                if (LogStream.level <= 1) break block2;
                a.println("SecurityException: jcifs will ignore System properties");
            }
        }
    }

    public static void load(InputStream inputStream) throws IOException {
        block3: {
            if (inputStream != null) {
                if.load(inputStream);
            }
            try {
                if.putAll((Map<?, ?>)System.getProperties());
            }
            catch (SecurityException securityException) {
                if (LogStream.level <= 1) break block3;
                a.println("SecurityException: jcifs will ignore System properties");
            }
        }
    }

    public static void store(OutputStream outputStream, String string) throws IOException {
        if.store(outputStream, string);
    }

    public static void list(PrintStream printStream) throws IOException {
        if.list(printStream);
    }

    public static Object setProperty(String string, String string2) {
        return if.setProperty(string, string2);
    }

    public static Object get(String string) {
        return if.get(string);
    }

    public static String getProperty(String string, String string2) {
        return if.getProperty(string, string2);
    }

    public static String getProperty(String string) {
        return if.getProperty(string);
    }

    public static int getInt(String string, int n2) {
        block3: {
            String string2 = if.getProperty(string);
            if (string2 != null) {
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    if (LogStream.level <= 0) break block3;
                    numberFormatException.printStackTrace(a);
                }
            }
        }
        return n2;
    }

    public static int getInt(String string) {
        int n2;
        block3: {
            String string2 = if.getProperty(string);
            n2 = -1;
            if (string2 != null) {
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    if (LogStream.level <= 0) break block3;
                    numberFormatException.printStackTrace(a);
                }
            }
        }
        return n2;
    }

    public static long getLong(String string, long l2) {
        block3: {
            String string2 = if.getProperty(string);
            if (string2 != null) {
                try {
                    l2 = Long.parseLong(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    if (LogStream.level <= 0) break block3;
                    numberFormatException.printStackTrace(a);
                }
            }
        }
        return l2;
    }

    public static InetAddress getInetAddress(String string, InetAddress inetAddress) {
        block3: {
            String string2 = if.getProperty(string);
            if (string2 != null) {
                try {
                    inetAddress = InetAddress.getByName(string2);
                }
                catch (UnknownHostException unknownHostException) {
                    if (LogStream.level <= 0) break block3;
                    a.println(string2);
                    unknownHostException.printStackTrace(a);
                }
            }
        }
        return inetAddress;
    }

    public static InetAddress getLocalHost() {
        block3: {
            String string = if.getProperty("jcifs.smb.client.laddr");
            if (string != null) {
                try {
                    return InetAddress.getByName(string);
                }
                catch (UnknownHostException unknownHostException) {
                    if (LogStream.level <= 0) break block3;
                    a.println("Ignoring jcifs.smb.client.laddr address: " + string);
                    unknownHostException.printStackTrace(a);
                }
            }
        }
        return null;
    }

    public static boolean getBoolean(String string, boolean bl) {
        String string2 = Config.getProperty(string);
        if (string2 != null) {
            bl = string2.toLowerCase().equals("true");
        }
        return bl;
    }

    public static InetAddress[] getInetAddressArray(String string, String string2, InetAddress[] inetAddressArray) {
        String string3 = Config.getProperty(string);
        if (string3 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, string2);
            int n2 = stringTokenizer.countTokens();
            InetAddress[] inetAddressArray2 = new InetAddress[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                String string4 = stringTokenizer.nextToken();
                try {
                    inetAddressArray2[i2] = InetAddress.getByName(string4);
                    continue;
                }
                catch (UnknownHostException unknownHostException) {
                    if (LogStream.level > 0) {
                        a.println(string4);
                        unknownHostException.printStackTrace(a);
                    }
                    return inetAddressArray;
                }
            }
            return inetAddressArray2;
        }
        return inetAddressArray;
    }

    static {
        block11: {
            socketCount = 0;
            if = new Properties();
            DEFAULT_OEM_ENCODING = "Cp850";
            FileInputStream fileInputStream = null;
            a = LogStream.getInstance();
            try {
                String string = System.getProperty("jcifs.properties");
                if (string != null && string.length() > 1) {
                    fileInputStream = new FileInputStream(string);
                }
                Config.load(fileInputStream);
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                if (LogStream.level <= 0) break block11;
                iOException.printStackTrace(a);
            }
        }
        int n2 = Config.getInt("jcifs.util.loglevel", -1);
        if (n2 != -1) {
            LogStream.setLevel(n2);
        }
        try {
            "".getBytes(DEFAULT_OEM_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (LogStream.level >= 2) {
                a.println("WARNING: The default OEM encoding " + DEFAULT_OEM_ENCODING + " does not appear to be supported by this JRE. The default encoding will be US-ASCII.");
            }
            DEFAULT_OEM_ENCODING = "US-ASCII";
        }
        if (LogStream.level >= 4) {
            try {
                if.store(a, "JCIFS PROPERTIES");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

