/*
 * Decompiled with CFR 0.152.
 */
package jcifs;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import jcifs.Config;
import jcifs.netbios.Lmhosts;
import jcifs.netbios.NbtAddress;
import jcifs.util.LogStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class UniAddress {
    private static final int do = 0;
    private static final int for = 1;
    private static final int a = 2;
    private static final int try = 3;
    private static int[] new;
    private static InetAddress if;
    private static LogStream int;
    Object addr;
    String calledName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static NbtAddress lookupServerOrWorkgroup(String string, InetAddress inetAddress) throws UnknownHostException {
        Sem sem = new Sem(2);
        int n2 = NbtAddress.isWINS(inetAddress) ? 27 : 29;
        QueryThread queryThread = new QueryThread(sem, string, n2, null, inetAddress);
        QueryThread queryThread2 = new QueryThread(sem, string, 32, null, inetAddress);
        queryThread.setDaemon(true);
        queryThread2.setDaemon(true);
        try {
            Sem sem2 = sem;
            synchronized (sem2) {
                queryThread.start();
                queryThread2.start();
                while (sem.count > 0 && queryThread.ans == null && queryThread2.ans == null) {
                    sem.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            throw new UnknownHostException(string);
        }
        if (queryThread.ans != null) {
            return queryThread.ans;
        }
        if (queryThread2.ans != null) {
            return queryThread2.ans;
        }
        throw queryThread.uhe;
    }

    public static UniAddress getByName(String string) throws UnknownHostException {
        return UniAddress.getByName(string, false);
    }

    static boolean isDotQuadIP(String string) {
        if (Character.isDigit(string.charAt(0))) {
            int n2 = 0;
            int n3 = 0;
            int n4 = string.length();
            char[] cArray = string.toCharArray();
            while (n3 < n4 && Character.isDigit(cArray[n3++])) {
                if (n3 == n4 && n2 == 3) {
                    return true;
                }
                if (n3 >= n4 || cArray[n3] != '.') continue;
                ++n2;
                ++n3;
            }
        }
        return false;
    }

    static boolean isAllDigits(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (Character.isDigit(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static UniAddress getByName(String string, boolean bl) throws UnknownHostException {
        UniAddress[] uniAddressArray = UniAddress.getAllByName(string, bl);
        return uniAddressArray[0];
    }

    public static UniAddress[] getAllByName(String string, boolean bl) throws UnknownHostException {
        if (string == null || string.length() == 0) {
            throw new UnknownHostException();
        }
        if (UniAddress.isDotQuadIP(string)) {
            UniAddress[] uniAddressArray = new UniAddress[]{new UniAddress(NbtAddress.getByName(string))};
            return uniAddressArray;
        }
        block8: for (int i2 = 0; i2 < new.length; ++i2) {
            try {
                NbtAddress nbtAddress;
                switch (new[i2]) {
                    case 3: {
                        nbtAddress = Lmhosts.getByName(string);
                        if (nbtAddress != null) break;
                        continue block8;
                    }
                    case 0: {
                        if (string == "\u0001\u0002__MSBROWSE__\u0002" || string.length() > 15) continue block8;
                        if (bl) {
                            nbtAddress = UniAddress.lookupServerOrWorkgroup(string, NbtAddress.getWINSAddress());
                            break;
                        }
                        nbtAddress = NbtAddress.getByName(string, 32, null, NbtAddress.getWINSAddress());
                        break;
                    }
                    case 1: {
                        if (string.length() > 15) continue block8;
                        if (bl) {
                            nbtAddress = UniAddress.lookupServerOrWorkgroup(string, if);
                            break;
                        }
                        nbtAddress = NbtAddress.getByName(string, 32, null, if);
                        break;
                    }
                    case 2: {
                        if (UniAddress.isAllDigits(string)) {
                            throw new UnknownHostException(string);
                        }
                        InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
                        UniAddress[] uniAddressArray = new UniAddress[inetAddressArray.length];
                        for (int i3 = 0; i3 < inetAddressArray.length; ++i3) {
                            uniAddressArray[i3] = new UniAddress(inetAddressArray[i3]);
                        }
                        return uniAddressArray;
                    }
                    default: {
                        throw new UnknownHostException(string);
                    }
                }
                UniAddress[] uniAddressArray = new UniAddress[]{new UniAddress(nbtAddress)};
                return uniAddressArray;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new UnknownHostException(string);
    }

    public UniAddress(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        this.addr = object;
    }

    public int hashCode() {
        return this.addr.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof UniAddress && this.addr.equals(((UniAddress)object).addr);
    }

    public String firstCalledName() {
        int n2;
        if (this.addr instanceof NbtAddress) {
            return ((NbtAddress)this.addr).firstCalledName();
        }
        this.calledName = ((InetAddress)this.addr).getHostName();
        this.calledName = UniAddress.isDotQuadIP(this.calledName) ? "*SMBSERVER     " : ((n2 = this.calledName.indexOf(46)) > 1 && n2 < 15 ? this.calledName.substring(0, n2).toUpperCase() : (this.calledName.length() > 15 ? "*SMBSERVER     " : this.calledName.toUpperCase()));
        return this.calledName;
    }

    public String nextCalledName() {
        if (this.addr instanceof NbtAddress) {
            return ((NbtAddress)this.addr).nextCalledName();
        }
        if (this.calledName != "*SMBSERVER     ") {
            this.calledName = "*SMBSERVER     ";
            return this.calledName;
        }
        return null;
    }

    public Object getAddress() {
        return this.addr;
    }

    public String getHostName() {
        if (this.addr instanceof NbtAddress) {
            return ((NbtAddress)this.addr).getHostName();
        }
        return ((InetAddress)this.addr).getHostName();
    }

    public String getHostAddress() {
        if (this.addr instanceof NbtAddress) {
            return ((NbtAddress)this.addr).getHostAddress();
        }
        return ((InetAddress)this.addr).getHostAddress();
    }

    public String toString() {
        return this.addr.toString();
    }

    static {
        int = LogStream.getInstance();
        String string = Config.getProperty("jcifs.resolveOrder");
        InetAddress inetAddress = NbtAddress.getWINSAddress();
        try {
            if = Config.getInetAddress("jcifs.netbios.baddr", InetAddress.getByName("255.255.255.255"));
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (string == null || string.length() == 0) {
            if (inetAddress == null) {
                new = new int[3];
                UniAddress.new[0] = 3;
                UniAddress.new[1] = 2;
                UniAddress.new[2] = 1;
            } else {
                new = new int[4];
                UniAddress.new[0] = 3;
                UniAddress.new[1] = 0;
                UniAddress.new[2] = 2;
                UniAddress.new[3] = 1;
            }
        } else {
            int[] nArray = new int[4];
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.equalsIgnoreCase("LMHOSTS")) {
                    nArray[n2++] = 3;
                    continue;
                }
                if (string2.equalsIgnoreCase("WINS")) {
                    if (inetAddress == null) {
                        if (LogStream.level <= 1) continue;
                        int.println("UniAddress resolveOrder specifies WINS however the jcifs.netbios.wins property has not been set");
                        continue;
                    }
                    nArray[n2++] = 0;
                    continue;
                }
                if (string2.equalsIgnoreCase("BCAST")) {
                    nArray[n2++] = 1;
                    continue;
                }
                if (string2.equalsIgnoreCase("DNS")) {
                    nArray[n2++] = 2;
                    continue;
                }
                if (LogStream.level <= 1) continue;
                int.println("unknown resolver method: " + string2);
            }
            new = new int[n2];
            System.arraycopy(nArray, 0, new, 0, n2);
        }
    }

    static class QueryThread
    extends Thread {
        Sem sem;
        String host;
        String scope;
        int type;
        NbtAddress ans = null;
        InetAddress svr;
        UnknownHostException uhe;

        QueryThread(Sem sem, String string, int n2, String string2, InetAddress inetAddress) {
            super("JCIFS-QueryThread: " + string);
            this.sem = sem;
            this.host = string;
            this.type = n2;
            this.scope = string2;
            this.svr = inetAddress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Sem sem;
            try {
                try {
                    this.ans = NbtAddress.getByName(this.host, this.type, this.scope, this.svr);
                }
                catch (UnknownHostException unknownHostException) {
                    this.uhe = unknownHostException;
                    Object var3_2 = null;
                    Sem sem3 = this.sem;
                    synchronized (sem3) {
                        --this.sem.count;
                        this.sem.notify();
                        return;
                    }
                }
                catch (Exception exception) {
                    this.uhe = new UnknownHostException(exception.getMessage());
                    Object var3_3 = null;
                    Sem sem4 = this.sem;
                    synchronized (sem4) {
                        --this.sem.count;
                        this.sem.notify();
                        return;
                    }
                }
                Object var3_1 = null;
                sem = this.sem;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                Sem sem2 = this.sem;
                synchronized (sem2) {
                    --this.sem.count;
                    this.sem.notify();
                    throw throwable;
                }
            }
            synchronized (sem) {
                --this.sem.count;
                this.sem.notify();
                return;
            }
        }
    }

    static class Sem {
        int count;

        Sem(int n2) {
            this.count = n2;
        }
    }
}

