/*
 * Decompiled with CFR 0.152.
 */
package jcifs.dcerpc;

import jcifs.dcerpc.DcerpcBinding;
import jcifs.dcerpc.DcerpcConstants;
import jcifs.dcerpc.DcerpcException;
import jcifs.dcerpc.DcerpcHandle;
import jcifs.dcerpc.DcerpcMessage;
import jcifs.dcerpc.ndr.NdrBuffer;
import jcifs.dcerpc.ndr.NdrException;
import jcifs.util.Hexdump;

public class DcerpcBind
extends DcerpcMessage {
    static final String[] result_message = new String[]{"0", "DCERPC_BIND_ERR_ABSTRACT_SYNTAX_NOT_SUPPORTED", "DCERPC_BIND_ERR_PROPOSED_TRANSFER_SYNTAXES_NOT_SUPPORTED", "DCERPC_BIND_ERR_LOCAL_LIMIT_EXCEEDED"};
    DcerpcBinding binding;
    int max_xmit;
    int max_recv;

    static String getResultMessage(int n2) {
        return n2 < 4 ? result_message[n2] : "0x" + Hexdump.toHexString(n2, 4);
    }

    public DcerpcException getResult() {
        if (this.result != 0) {
            return new DcerpcException(DcerpcBind.getResultMessage(this.result));
        }
        return null;
    }

    public DcerpcBind() {
    }

    DcerpcBind(DcerpcBinding dcerpcBinding, DcerpcHandle dcerpcHandle) {
        this.binding = dcerpcBinding;
        this.max_xmit = dcerpcHandle.max_xmit;
        this.max_recv = dcerpcHandle.max_recv;
        this.ptype = 11;
        this.flags = 3;
    }

    public int getOpnum() {
        return 0;
    }

    public void encode_in(NdrBuffer ndrBuffer) throws NdrException {
        ndrBuffer.enc_ndr_short(this.max_xmit);
        ndrBuffer.enc_ndr_short(this.max_recv);
        ndrBuffer.enc_ndr_long(0);
        ndrBuffer.enc_ndr_small(1);
        ndrBuffer.enc_ndr_small(0);
        ndrBuffer.enc_ndr_short(0);
        ndrBuffer.enc_ndr_short(0);
        ndrBuffer.enc_ndr_small(1);
        ndrBuffer.enc_ndr_small(0);
        this.binding.uuid.encode(ndrBuffer);
        ndrBuffer.enc_ndr_short(this.binding.major);
        ndrBuffer.enc_ndr_short(this.binding.minor);
        DcerpcConstants.DCERPC_UUID_SYNTAX_NDR.encode(ndrBuffer);
        ndrBuffer.enc_ndr_long(2);
    }

    public void decode_out(NdrBuffer ndrBuffer) throws NdrException {
        ndrBuffer.dec_ndr_short();
        ndrBuffer.dec_ndr_short();
        ndrBuffer.dec_ndr_long();
        int n2 = ndrBuffer.dec_ndr_short();
        ndrBuffer.advance(n2);
        ndrBuffer.align(4);
        ndrBuffer.dec_ndr_small();
        ndrBuffer.align(4);
        this.result = ndrBuffer.dec_ndr_short();
        ndrBuffer.dec_ndr_short();
        ndrBuffer.advance(20);
    }
}

