/*
 * Decompiled with CFR 0.152.
 */
package jcifs.dcerpc;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.security.Principal;
import jcifs.dcerpc.DcerpcBind;
import jcifs.dcerpc.DcerpcBinding;
import jcifs.dcerpc.DcerpcConstants;
import jcifs.dcerpc.DcerpcException;
import jcifs.dcerpc.DcerpcMessage;
import jcifs.dcerpc.DcerpcPipeHandle;
import jcifs.dcerpc.DcerpcSecurityProvider;
import jcifs.dcerpc.ndr.NdrBuffer;
import jcifs.smb.BufferCache;
import jcifs.smb.NtlmPasswordAuthentication;

public abstract class DcerpcHandle
implements DcerpcConstants {
    protected DcerpcBinding binding;
    protected int max_xmit;
    protected int max_recv;
    protected int state;
    protected DcerpcSecurityProvider securityProvider;
    private static int a = 1;

    public DcerpcHandle() {
        this.max_recv = this.max_xmit = 4280;
        this.state = 0;
        this.securityProvider = null;
    }

    protected static DcerpcBinding parseBinding(String string) throws DcerpcException {
        char[] cArray = string.toCharArray();
        String string2 = null;
        String string3 = null;
        DcerpcBinding dcerpcBinding = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        block6: do {
            char c2 = cArray[n2];
            switch (n4) {
                case 0: {
                    if (c2 != ':') continue block6;
                    string2 = string.substring(n3, n2);
                    n3 = n2 + 1;
                    n4 = 1;
                    break;
                }
                case 1: {
                    if (c2 == '\\') {
                        n3 = n2 + 1;
                        break;
                    }
                    n4 = 2;
                }
                case 2: {
                    if (c2 != '[') continue block6;
                    String string4 = string.substring(n3, n2).trim();
                    if (string4.length() == 0) {
                        string4 = "127.0.0.1";
                    }
                    dcerpcBinding = new DcerpcBinding(string2, string.substring(n3, n2));
                    n3 = n2 + 1;
                    n4 = 5;
                    break;
                }
                case 5: {
                    if (c2 == '=') {
                        string3 = string.substring(n3, n2).trim();
                        n3 = n2 + 1;
                        break;
                    }
                    if (c2 != ',' && c2 != ']') continue block6;
                    String string4 = string.substring(n3, n2).trim();
                    if (string3 == null) {
                        string3 = "endpoint";
                    }
                    dcerpcBinding.setOption(string3, string4);
                    string3 = null;
                    break;
                }
                default: {
                    n2 = cArray.length;
                }
            }
        } while (++n2 < cArray.length);
        if (dcerpcBinding == null || dcerpcBinding.endpoint == null) {
            throw new DcerpcException("Invalid binding URL: " + string);
        }
        return dcerpcBinding;
    }

    public static DcerpcHandle getHandle(String string, NtlmPasswordAuthentication ntlmPasswordAuthentication) throws UnknownHostException, MalformedURLException, DcerpcException {
        if (string.startsWith("ncacn_np:")) {
            return new DcerpcPipeHandle(string, ntlmPasswordAuthentication);
        }
        throw new DcerpcException("DCERPC transport not supported: " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind() throws DcerpcException, IOException {
        DcerpcHandle dcerpcHandle = this;
        synchronized (dcerpcHandle) {
            try {
                this.state = 1;
                DcerpcBind dcerpcBind = new DcerpcBind(this.binding, this);
                this.sendrecv(dcerpcBind);
            }
            catch (IOException iOException) {
                this.state = 0;
                throw iOException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendrecv(DcerpcMessage dcerpcMessage) throws DcerpcException, IOException {
        if (this.state == 0) {
            this.bind();
        }
        boolean bl = dcerpcMessage instanceof DcerpcBind;
        byte[] byArray = BufferCache.getBuffer();
        try {
            int n2;
            int n3;
            NdrBuffer ndrBuffer = new NdrBuffer(byArray, 0);
            dcerpcMessage.flags = 3;
            dcerpcMessage.call_id = a;
            dcerpcMessage.encode(ndrBuffer);
            if (this.securityProvider != null) {
                ndrBuffer.setIndex(0);
                this.securityProvider.wrap(ndrBuffer);
            }
            int n4 = ndrBuffer.getLength();
            for (n2 = 0; n2 < n4; n2 += n3) {
                ++a;
                dcerpcMessage.call_id = dcerpcMessage.call_id;
                if (n4 - n2 > this.max_xmit) {
                    throw new DcerpcException("Fragmented request PDUs currently not supported");
                }
                n3 = n4 - n2;
                this.doSendFragment(byArray, n2, n3, bl);
            }
            this.doReceiveFragment(byArray, bl);
            ndrBuffer.reset();
            ndrBuffer.setIndex(8);
            ndrBuffer.setLength(ndrBuffer.dec_ndr_short());
            if (this.securityProvider != null) {
                this.securityProvider.unwrap(ndrBuffer);
            }
            ndrBuffer.setIndex(0);
            dcerpcMessage.decode_header(ndrBuffer);
            n2 = 24;
            if (dcerpcMessage.ptype == 2 && !dcerpcMessage.isFlagSet(2)) {
                n2 = dcerpcMessage.length;
            }
            byte[] byArray2 = null;
            NdrBuffer ndrBuffer2 = null;
            while (!dcerpcMessage.isFlagSet(2)) {
                if (byArray2 == null) {
                    byArray2 = new byte[this.max_recv];
                    ndrBuffer2 = new NdrBuffer(byArray2, 0);
                }
                this.doReceiveFragment(byArray2, bl);
                ndrBuffer2.reset();
                ndrBuffer2.setIndex(8);
                ndrBuffer2.setLength(ndrBuffer2.dec_ndr_short());
                if (this.securityProvider != null) {
                    this.securityProvider.unwrap(ndrBuffer2);
                }
                ndrBuffer2.reset();
                dcerpcMessage.decode_header(ndrBuffer2);
                int n5 = dcerpcMessage.length - 24;
                if (n2 + n5 > byArray.length) {
                    byte[] byArray3 = new byte[n2 + n5];
                    System.arraycopy(byArray, 0, byArray3, 0, n2);
                    byArray = byArray3;
                }
                System.arraycopy(byArray2, 24, byArray, n2, n5);
                n2 += n5;
            }
            ndrBuffer = new NdrBuffer(byArray, 0);
            dcerpcMessage.decode(ndrBuffer);
        }
        finally {
            BufferCache.releaseBuffer(byArray);
        }
        DcerpcException dcerpcException = dcerpcMessage.getResult();
        if (dcerpcException != null) {
            throw dcerpcException;
        }
    }

    public void setDcerpcSecurityProvider(DcerpcSecurityProvider dcerpcSecurityProvider) {
        this.securityProvider = dcerpcSecurityProvider;
    }

    public String getServer() {
        if (this instanceof DcerpcPipeHandle) {
            return ((DcerpcPipeHandle)this).pipe.getServer();
        }
        return null;
    }

    public Principal getPrincipal() {
        if (this instanceof DcerpcPipeHandle) {
            return ((DcerpcPipeHandle)this).pipe.getPrincipal();
        }
        return null;
    }

    public String toString() {
        return this.binding.toString();
    }

    protected abstract void doSendFragment(byte[] var1, int var2, int var3, boolean var4) throws IOException;

    protected abstract void doReceiveFragment(byte[] var1, boolean var2) throws IOException;

    public abstract void close() throws IOException;
}

