/*
 * Decompiled with CFR 0.152.
 */
package jcifs.dcerpc;

import jcifs.dcerpc.DcerpcConstants;
import jcifs.dcerpc.DcerpcException;
import jcifs.dcerpc.ndr.NdrBuffer;
import jcifs.dcerpc.ndr.NdrException;
import jcifs.dcerpc.ndr.NdrObject;

public abstract class DcerpcMessage
extends NdrObject
implements DcerpcConstants {
    protected int ptype = -1;
    protected int flags = 0;
    protected int length = 0;
    protected int call_id = 0;
    protected int alloc_hint = 0;
    protected int result = 0;

    public boolean isFlagSet(int n2) {
        return (this.flags & n2) == n2;
    }

    public void unsetFlag(int n2) {
        this.flags |= n2;
    }

    public void setFlag(int n2) {
        this.flags |= n2;
    }

    public DcerpcException getResult() {
        if (this.result != 0) {
            return new DcerpcException(this.result);
        }
        return null;
    }

    void encode_header(NdrBuffer ndrBuffer) {
        ndrBuffer.enc_ndr_small(5);
        ndrBuffer.enc_ndr_small(0);
        ndrBuffer.enc_ndr_small(this.ptype);
        ndrBuffer.enc_ndr_small(this.flags);
        ndrBuffer.enc_ndr_long(16);
        ndrBuffer.enc_ndr_short(this.length);
        ndrBuffer.enc_ndr_short(0);
        ndrBuffer.enc_ndr_long(this.call_id);
    }

    void decode_header(NdrBuffer ndrBuffer) throws NdrException {
        if (ndrBuffer.dec_ndr_small() != 5 || ndrBuffer.dec_ndr_small() != 0) {
            throw new NdrException("DCERPC version not supported");
        }
        this.ptype = ndrBuffer.dec_ndr_small();
        this.flags = ndrBuffer.dec_ndr_small();
        if (ndrBuffer.dec_ndr_long() != 16) {
            throw new NdrException("Data representation not supported");
        }
        this.length = ndrBuffer.dec_ndr_short();
        if (ndrBuffer.dec_ndr_short() != 0) {
            throw new NdrException("DCERPC authentication not supported");
        }
        this.call_id = ndrBuffer.dec_ndr_long();
    }

    public void encode(NdrBuffer ndrBuffer) throws NdrException {
        int n2 = ndrBuffer.getIndex();
        int n3 = 0;
        ndrBuffer.advance(16);
        if (this.ptype == 0) {
            n3 = ndrBuffer.getIndex();
            ndrBuffer.enc_ndr_long(0);
            ndrBuffer.enc_ndr_short(0);
            ndrBuffer.enc_ndr_short(this.getOpnum());
        }
        this.encode_in(ndrBuffer);
        this.length = ndrBuffer.getIndex() - n2;
        if (this.ptype == 0) {
            ndrBuffer.setIndex(n3);
            this.alloc_hint = this.length - n3;
            ndrBuffer.enc_ndr_long(this.alloc_hint);
        }
        ndrBuffer.setIndex(n2);
        this.encode_header(ndrBuffer);
        ndrBuffer.setIndex(n2 + this.length);
    }

    public void decode(NdrBuffer ndrBuffer) throws NdrException {
        this.decode_header(ndrBuffer);
        if (this.ptype != 12 && this.ptype != 2 && this.ptype != 3 && this.ptype != 13) {
            throw new NdrException("Unexpected ptype: " + this.ptype);
        }
        if (this.ptype == 2 || this.ptype == 3) {
            this.alloc_hint = ndrBuffer.dec_ndr_long();
            ndrBuffer.dec_ndr_short();
            ndrBuffer.dec_ndr_short();
        }
        if (this.ptype == 3 || this.ptype == 13) {
            this.result = ndrBuffer.dec_ndr_long();
        } else {
            this.decode_out(ndrBuffer);
        }
    }

    public abstract int getOpnum();

    public abstract void encode_in(NdrBuffer var1) throws NdrException;

    public abstract void decode_out(NdrBuffer var1) throws NdrException;
}

