/*
 * Decompiled with CFR 0.152.
 */
package jcifs.dcerpc;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import jcifs.dcerpc.DcerpcException;
import jcifs.dcerpc.DcerpcHandle;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;
import jcifs.smb.SmbNamedPipe;
import jcifs.util.Encdec;

public class DcerpcPipeHandle
extends DcerpcHandle {
    SmbNamedPipe pipe;
    SmbFileInputStream in = null;
    SmbFileOutputStream out = null;
    boolean isStart = true;

    public DcerpcPipeHandle(String string, NtlmPasswordAuthentication ntlmPasswordAuthentication) throws UnknownHostException, MalformedURLException, DcerpcException {
        this.binding = DcerpcHandle.parseBinding(string);
        string = "smb://" + this.binding.server + "/IPC$/" + this.binding.endpoint.substring(6);
        String string2 = "";
        String string3 = (String)this.binding.getOption("server");
        if (string3 != null) {
            string2 = string2 + "&server=" + string3;
        }
        String string4 = (String)this.binding.getOption("address");
        if (string3 != null) {
            string2 = string2 + "&address=" + string4;
        }
        if (string2.length() > 0) {
            string = string + "?" + string2.substring(1);
        }
        this.pipe = new SmbNamedPipe(string, 27198979, ntlmPasswordAuthentication);
    }

    protected void doSendFragment(byte[] byArray, int n2, int n3, boolean bl) throws IOException {
        if (this.out != null && !this.out.isOpen()) {
            throw new IOException("DCERPC pipe is no longer open");
        }
        if (this.in == null) {
            this.in = (SmbFileInputStream)this.pipe.getNamedPipeInputStream();
        }
        if (this.out == null) {
            this.out = (SmbFileOutputStream)this.pipe.getNamedPipeOutputStream();
        }
        if (bl) {
            this.out.writeDirect(byArray, n2, n3, 1);
            return;
        }
        this.out.write(byArray, n2, n3);
    }

    protected void doReceiveFragment(byte[] byArray, boolean bl) throws IOException {
        if (byArray.length < this.max_recv) {
            throw new IllegalArgumentException("buffer too small");
        }
        if (byArray[0] != 5 && byArray[1] != 0) {
            throw new IOException("Unexpected DCERPC PDU header");
        }
        int n2 = byArray[3] & 0xFF;
        this.isStart = (n2 & 2) == 2;
        short s = Encdec.dec_uint16le(byArray, 8);
        if (s > this.max_recv) {
            throw new IOException("Unexpected fragment length: " + s);
        }
        for (int i2 = this.isStart && !bl ? this.in.read(byArray, 0, 1024) : this.in.readDirect(byArray, 0, byArray.length); i2 < s; i2 += this.in.readDirect(byArray, i2, s - i2)) {
        }
    }

    public void close() throws IOException {
        this.state = 0;
        if (this.out != null) {
            this.out.close();
        }
    }
}

