/*
 * Decompiled with CFR 0.152.
 */
package jcifs.dcerpc.msrpc;

import jcifs.dcerpc.DcerpcMessage;
import jcifs.dcerpc.ndr.NdrBuffer;
import jcifs.dcerpc.ndr.NdrException;
import jcifs.dcerpc.ndr.NdrObject;
import jcifs.dcerpc.ndr.NdrSmall;
import jcifs.dcerpc.rpc;

public class lsarpc {
    public static final int POLICY_INFO_AUDIT_EVENTS = 2;
    public static final int POLICY_INFO_PRIMARY_DOMAIN = 3;
    public static final int POLICY_INFO_ACCOUNT_DOMAIN = 5;
    public static final int POLICY_INFO_SERVER_ROLE = 6;
    public static final int POLICY_INFO_MODIFICATION = 9;
    public static final int POLICY_INFO_DNS_DOMAIN = 12;
    public static final int SID_NAME_USE_NONE = 0;
    public static final int SID_NAME_USER = 1;
    public static final int SID_NAME_DOM_GRP = 2;
    public static final int SID_NAME_DOMAIN = 3;
    public static final int SID_NAME_ALIAS = 4;
    public static final int SID_NAME_WKN_GRP = 5;
    public static final int SID_NAME_DELETED = 6;
    public static final int SID_NAME_INVALID = 7;
    public static final int SID_NAME_UNKNOWN = 8;

    public static String getSyntax() {
        return "12345778-1234-abcd-ef00-0123456789ab:0.0";
    }

    public static class LsarQueryInformationPolicy2
    extends DcerpcMessage {
        public int retval;
        public rpc.policy_handle handle;
        public short level;
        public NdrObject info;

        public int getOpnum() {
            return 46;
        }

        public LsarQueryInformationPolicy2(rpc.policy_handle policy_handle2, short s, NdrObject ndrObject) {
            this.handle = policy_handle2;
            this.level = s;
            this.info = ndrObject;
        }

        public void encode_in(NdrBuffer ndrBuffer) throws NdrException {
            this.handle.encode(ndrBuffer);
            ndrBuffer.enc_ndr_short(this.level);
        }

        public void decode_out(NdrBuffer ndrBuffer) throws NdrException {
            int n2 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                ndrBuffer.dec_ndr_short();
                this.info.decode(ndrBuffer);
            }
            this.retval = ndrBuffer.dec_ndr_long();
        }
    }

    public static class LsarOpenPolicy2
    extends DcerpcMessage {
        public int retval;
        public String system_name;
        public LsarObjectAttributes object_attributes;
        public int desired_access;
        public rpc.policy_handle policy_handle;

        public int getOpnum() {
            return 44;
        }

        public LsarOpenPolicy2(String string, LsarObjectAttributes lsarObjectAttributes, int n2, rpc.policy_handle policy_handle2) {
            this.system_name = string;
            this.object_attributes = lsarObjectAttributes;
            this.desired_access = n2;
            this.policy_handle = policy_handle2;
        }

        public void encode_in(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.enc_ndr_referent(this.system_name, 1);
            if (this.system_name != null) {
                ndrBuffer.enc_ndr_string(this.system_name);
            }
            this.object_attributes.encode(ndrBuffer);
            ndrBuffer.enc_ndr_long(this.desired_access);
        }

        public void decode_out(NdrBuffer ndrBuffer) throws NdrException {
            this.policy_handle.decode(ndrBuffer);
            this.retval = ndrBuffer.dec_ndr_long();
        }
    }

    public static class LsarLookupSids
    extends DcerpcMessage {
        public int retval;
        public rpc.policy_handle handle;
        public LsarSidArray sids;
        public LsarRefDomainList domains;
        public LsarTransNameArray names;
        public short level;
        public int count;

        public int getOpnum() {
            return 15;
        }

        public LsarLookupSids(rpc.policy_handle policy_handle2, LsarSidArray lsarSidArray, LsarRefDomainList lsarRefDomainList, LsarTransNameArray lsarTransNameArray, short s, int n2) {
            this.handle = policy_handle2;
            this.sids = lsarSidArray;
            this.domains = lsarRefDomainList;
            this.names = lsarTransNameArray;
            this.level = s;
            this.count = n2;
        }

        public void encode_in(NdrBuffer ndrBuffer) throws NdrException {
            this.handle.encode(ndrBuffer);
            this.sids.encode(ndrBuffer);
            this.names.encode(ndrBuffer);
            ndrBuffer.enc_ndr_short(this.level);
            ndrBuffer.enc_ndr_long(this.count);
        }

        public void decode_out(NdrBuffer ndrBuffer) throws NdrException {
            int n2 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                if (this.domains == null) {
                    this.domains = new LsarRefDomainList();
                }
                this.domains.decode(ndrBuffer);
            }
            this.names.decode(ndrBuffer);
            this.count = ndrBuffer.dec_ndr_long();
            this.retval = ndrBuffer.dec_ndr_long();
        }
    }

    public static class LsarQueryInformationPolicy
    extends DcerpcMessage {
        public int retval;
        public rpc.policy_handle handle;
        public short level;
        public NdrObject info;

        public int getOpnum() {
            return 7;
        }

        public LsarQueryInformationPolicy(rpc.policy_handle policy_handle2, short s, NdrObject ndrObject) {
            this.handle = policy_handle2;
            this.level = s;
            this.info = ndrObject;
        }

        public void encode_in(NdrBuffer ndrBuffer) throws NdrException {
            this.handle.encode(ndrBuffer);
            ndrBuffer.enc_ndr_short(this.level);
        }

        public void decode_out(NdrBuffer ndrBuffer) throws NdrException {
            int n2 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                ndrBuffer.dec_ndr_short();
                this.info.decode(ndrBuffer);
            }
            this.retval = ndrBuffer.dec_ndr_long();
        }
    }

    public static class LsarClose
    extends DcerpcMessage {
        public int retval;
        public rpc.policy_handle handle;

        public int getOpnum() {
            return 0;
        }

        public LsarClose(rpc.policy_handle policy_handle2) {
            this.handle = policy_handle2;
        }

        public void encode_in(NdrBuffer ndrBuffer) throws NdrException {
            this.handle.encode(ndrBuffer);
        }

        public void decode_out(NdrBuffer ndrBuffer) throws NdrException {
            this.handle.decode(ndrBuffer);
            this.retval = ndrBuffer.dec_ndr_long();
        }
    }

    public static class LsarTransNameArray
    extends NdrObject {
        public int count;
        public LsarTranslatedName[] names;

        public void encode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.enc_ndr_long(this.count);
            ndrBuffer.enc_ndr_referent(this.names, 1);
            if (this.names != null) {
                ndrBuffer = ndrBuffer.deferred;
                int n2 = this.count;
                ndrBuffer.enc_ndr_long(n2);
                int n3 = ndrBuffer.index;
                ndrBuffer.advance(16 * n2);
                ndrBuffer = ndrBuffer.derive(n3);
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.names[i2].encode(ndrBuffer);
                }
            }
        }

        public void decode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            this.count = ndrBuffer.dec_ndr_long();
            int n2 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                int n3 = ndrBuffer.dec_ndr_long();
                int n4 = ndrBuffer.index;
                ndrBuffer.advance(16 * n3);
                if (this.names == null) {
                    if (n3 < 0 || n3 > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.names = new LsarTranslatedName[n3];
                }
                ndrBuffer = ndrBuffer.derive(n4);
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (this.names[i2] == null) {
                        this.names[i2] = new LsarTranslatedName();
                    }
                    this.names[i2].decode(ndrBuffer);
                }
            }
        }
    }

    public static class LsarTranslatedName
    extends NdrObject {
        public short sid_type;
        public rpc.unicode_string name;
        public int sid_index;

        public void encode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.enc_ndr_short(this.sid_type);
            ndrBuffer.enc_ndr_short(this.name.length);
            ndrBuffer.enc_ndr_short(this.name.maximum_length);
            ndrBuffer.enc_ndr_referent(this.name.buffer, 1);
            ndrBuffer.enc_ndr_long(this.sid_index);
            if (this.name.buffer != null) {
                ndrBuffer = ndrBuffer.deferred;
                int n2 = this.name.length / 2;
                int n3 = this.name.maximum_length / 2;
                ndrBuffer.enc_ndr_long(n3);
                ndrBuffer.enc_ndr_long(0);
                ndrBuffer.enc_ndr_long(n2);
                int n4 = ndrBuffer.index;
                ndrBuffer.advance(2 * n2);
                ndrBuffer = ndrBuffer.derive(n4);
                for (int i2 = 0; i2 < n2; ++i2) {
                    ndrBuffer.enc_ndr_short(this.name.buffer[i2]);
                }
            }
        }

        public void decode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            this.sid_type = (short)ndrBuffer.dec_ndr_short();
            ndrBuffer.align(4);
            if (this.name == null) {
                this.name = new rpc.unicode_string();
            }
            this.name.length = (short)ndrBuffer.dec_ndr_short();
            this.name.maximum_length = (short)ndrBuffer.dec_ndr_short();
            int n2 = ndrBuffer.dec_ndr_long();
            this.sid_index = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                int n3 = ndrBuffer.dec_ndr_long();
                ndrBuffer.dec_ndr_long();
                int n4 = ndrBuffer.dec_ndr_long();
                int n5 = ndrBuffer.index;
                ndrBuffer.advance(2 * n4);
                if (this.name.buffer == null) {
                    if (n3 < 0 || n3 > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.name.buffer = new short[n3];
                }
                ndrBuffer = ndrBuffer.derive(n5);
                for (int i2 = 0; i2 < n4; ++i2) {
                    this.name.buffer[i2] = (short)ndrBuffer.dec_ndr_short();
                }
            }
        }
    }

    public static class LsarRefDomainList
    extends NdrObject {
        public int count;
        public LsarTrustInformation[] domains;
        public int max_count;

        public void encode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.enc_ndr_long(this.count);
            ndrBuffer.enc_ndr_referent(this.domains, 1);
            ndrBuffer.enc_ndr_long(this.max_count);
            if (this.domains != null) {
                ndrBuffer = ndrBuffer.deferred;
                int n2 = this.count;
                ndrBuffer.enc_ndr_long(n2);
                int n3 = ndrBuffer.index;
                ndrBuffer.advance(12 * n2);
                ndrBuffer = ndrBuffer.derive(n3);
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.domains[i2].encode(ndrBuffer);
                }
            }
        }

        public void decode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            this.count = ndrBuffer.dec_ndr_long();
            int n2 = ndrBuffer.dec_ndr_long();
            this.max_count = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                int n3 = ndrBuffer.dec_ndr_long();
                int n4 = ndrBuffer.index;
                ndrBuffer.advance(12 * n3);
                if (this.domains == null) {
                    if (n3 < 0 || n3 > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.domains = new LsarTrustInformation[n3];
                }
                ndrBuffer = ndrBuffer.derive(n4);
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (this.domains[i2] == null) {
                        this.domains[i2] = new LsarTrustInformation();
                    }
                    this.domains[i2].decode(ndrBuffer);
                }
            }
        }
    }

    public static class LsarTrustInformation
    extends NdrObject {
        public rpc.unicode_string name;
        public rpc.sid_t sid;

        public void encode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.enc_ndr_short(this.name.length);
            ndrBuffer.enc_ndr_short(this.name.maximum_length);
            ndrBuffer.enc_ndr_referent(this.name.buffer, 1);
            ndrBuffer.enc_ndr_referent(this.sid, 1);
            if (this.name.buffer != null) {
                ndrBuffer = ndrBuffer.deferred;
                int n2 = this.name.length / 2;
                int n3 = this.name.maximum_length / 2;
                ndrBuffer.enc_ndr_long(n3);
                ndrBuffer.enc_ndr_long(0);
                ndrBuffer.enc_ndr_long(n2);
                int n4 = ndrBuffer.index;
                ndrBuffer.advance(2 * n2);
                ndrBuffer = ndrBuffer.derive(n4);
                for (int i2 = 0; i2 < n2; ++i2) {
                    ndrBuffer.enc_ndr_short(this.name.buffer[i2]);
                }
            }
            if (this.sid != null) {
                ndrBuffer = ndrBuffer.deferred;
                this.sid.encode(ndrBuffer);
            }
        }

        public void decode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.align(4);
            if (this.name == null) {
                this.name = new rpc.unicode_string();
            }
            this.name.length = (short)ndrBuffer.dec_ndr_short();
            this.name.maximum_length = (short)ndrBuffer.dec_ndr_short();
            int n2 = ndrBuffer.dec_ndr_long();
            int n3 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                int n4 = ndrBuffer.dec_ndr_long();
                ndrBuffer.dec_ndr_long();
                int n5 = ndrBuffer.dec_ndr_long();
                int n6 = ndrBuffer.index;
                ndrBuffer.advance(2 * n5);
                if (this.name.buffer == null) {
                    if (n4 < 0 || n4 > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.name.buffer = new short[n4];
                }
                ndrBuffer = ndrBuffer.derive(n6);
                for (int i2 = 0; i2 < n5; ++i2) {
                    this.name.buffer[i2] = (short)ndrBuffer.dec_ndr_short();
                }
            }
            if (n3 != 0) {
                if (this.sid == null) {
                    this.sid = new rpc.sid_t();
                }
                ndrBuffer = ndrBuffer.deferred;
                this.sid.decode(ndrBuffer);
            }
        }
    }

    public static class LsarTransSidArray
    extends NdrObject {
        public int count;
        public LsarTranslatedSid[] sids;

        public void encode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.enc_ndr_long(this.count);
            ndrBuffer.enc_ndr_referent(this.sids, 1);
            if (this.sids != null) {
                ndrBuffer = ndrBuffer.deferred;
                int n2 = this.count;
                ndrBuffer.enc_ndr_long(n2);
                int n3 = ndrBuffer.index;
                ndrBuffer.advance(12 * n2);
                ndrBuffer = ndrBuffer.derive(n3);
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.sids[i2].encode(ndrBuffer);
                }
            }
        }

        public void decode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            this.count = ndrBuffer.dec_ndr_long();
            int n2 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                int n3 = ndrBuffer.dec_ndr_long();
                int n4 = ndrBuffer.index;
                ndrBuffer.advance(12 * n3);
                if (this.sids == null) {
                    if (n3 < 0 || n3 > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.sids = new LsarTranslatedSid[n3];
                }
                ndrBuffer = ndrBuffer.derive(n4);
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (this.sids[i2] == null) {
                        this.sids[i2] = new LsarTranslatedSid();
                    }
                    this.sids[i2].decode(ndrBuffer);
                }
            }
        }
    }

    public static class LsarTranslatedSid
    extends NdrObject {
        public int sid_type;
        public int rid;
        public int sid_index;

        public void encode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.enc_ndr_short(this.sid_type);
            ndrBuffer.enc_ndr_long(this.rid);
            ndrBuffer.enc_ndr_long(this.sid_index);
        }

        public void decode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            this.sid_type = ndrBuffer.dec_ndr_short();
            this.rid = ndrBuffer.dec_ndr_long();
            this.sid_index = ndrBuffer.dec_ndr_long();
        }
    }

    public static class LsarSidArray
    extends NdrObject {
        public int num_sids;
        public LsarSidPtr[] sids;

        public void encode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.enc_ndr_long(this.num_sids);
            ndrBuffer.enc_ndr_referent(this.sids, 1);
            if (this.sids != null) {
                ndrBuffer = ndrBuffer.deferred;
                int n2 = this.num_sids;
                ndrBuffer.enc_ndr_long(n2);
                int n3 = ndrBuffer.index;
                ndrBuffer.advance(4 * n2);
                ndrBuffer = ndrBuffer.derive(n3);
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.sids[i2].encode(ndrBuffer);
                }
            }
        }

        public void decode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            this.num_sids = ndrBuffer.dec_ndr_long();
            int n2 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                int n3 = ndrBuffer.dec_ndr_long();
                int n4 = ndrBuffer.index;
                ndrBuffer.advance(4 * n3);
                if (this.sids == null) {
                    if (n3 < 0 || n3 > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.sids = new LsarSidPtr[n3];
                }
                ndrBuffer = ndrBuffer.derive(n4);
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (this.sids[i2] == null) {
                        this.sids[i2] = new LsarSidPtr();
                    }
                    this.sids[i2].decode(ndrBuffer);
                }
            }
        }
    }

    public static class LsarSidPtr
    extends NdrObject {
        public rpc.sid_t sid;

        public void encode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.enc_ndr_referent(this.sid, 1);
            if (this.sid != null) {
                ndrBuffer = ndrBuffer.deferred;
                this.sid.encode(ndrBuffer);
            }
        }

        public void decode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            int n2 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                if (this.sid == null) {
                    this.sid = new rpc.sid_t();
                }
                ndrBuffer = ndrBuffer.deferred;
                this.sid.decode(ndrBuffer);
            }
        }
    }

    public static class LsarDnsDomainInfo
    extends NdrObject {
        public rpc.unicode_string name;
        public rpc.unicode_string dns_domain;
        public rpc.unicode_string dns_forest;
        public rpc.uuid_t domain_guid;
        public rpc.sid_t sid;

        public void encode(NdrBuffer ndrBuffer) throws NdrException {
            int n2;
            int n3;
            int n4;
            int n5;
            ndrBuffer.align(4);
            ndrBuffer.enc_ndr_short(this.name.length);
            ndrBuffer.enc_ndr_short(this.name.maximum_length);
            ndrBuffer.enc_ndr_referent(this.name.buffer, 1);
            ndrBuffer.enc_ndr_short(this.dns_domain.length);
            ndrBuffer.enc_ndr_short(this.dns_domain.maximum_length);
            ndrBuffer.enc_ndr_referent(this.dns_domain.buffer, 1);
            ndrBuffer.enc_ndr_short(this.dns_forest.length);
            ndrBuffer.enc_ndr_short(this.dns_forest.maximum_length);
            ndrBuffer.enc_ndr_referent(this.dns_forest.buffer, 1);
            ndrBuffer.enc_ndr_long(this.domain_guid.time_low);
            ndrBuffer.enc_ndr_short(this.domain_guid.time_mid);
            ndrBuffer.enc_ndr_short(this.domain_guid.time_hi_and_version);
            ndrBuffer.enc_ndr_small(this.domain_guid.clock_seq_hi_and_reserved);
            ndrBuffer.enc_ndr_small(this.domain_guid.clock_seq_low);
            int n6 = 6;
            int n7 = ndrBuffer.index;
            ndrBuffer.advance(1 * n6);
            ndrBuffer.enc_ndr_referent(this.sid, 1);
            if (this.name.buffer != null) {
                ndrBuffer = ndrBuffer.deferred;
                n5 = this.name.length / 2;
                n4 = this.name.maximum_length / 2;
                ndrBuffer.enc_ndr_long(n4);
                ndrBuffer.enc_ndr_long(0);
                ndrBuffer.enc_ndr_long(n5);
                n3 = ndrBuffer.index;
                ndrBuffer.advance(2 * n5);
                ndrBuffer = ndrBuffer.derive(n3);
                for (n2 = 0; n2 < n5; ++n2) {
                    ndrBuffer.enc_ndr_short(this.name.buffer[n2]);
                }
            }
            if (this.dns_domain.buffer != null) {
                ndrBuffer = ndrBuffer.deferred;
                n5 = this.dns_domain.length / 2;
                n4 = this.dns_domain.maximum_length / 2;
                ndrBuffer.enc_ndr_long(n4);
                ndrBuffer.enc_ndr_long(0);
                ndrBuffer.enc_ndr_long(n5);
                n3 = ndrBuffer.index;
                ndrBuffer.advance(2 * n5);
                ndrBuffer = ndrBuffer.derive(n3);
                for (n2 = 0; n2 < n5; ++n2) {
                    ndrBuffer.enc_ndr_short(this.dns_domain.buffer[n2]);
                }
            }
            if (this.dns_forest.buffer != null) {
                ndrBuffer = ndrBuffer.deferred;
                n5 = this.dns_forest.length / 2;
                n4 = this.dns_forest.maximum_length / 2;
                ndrBuffer.enc_ndr_long(n4);
                ndrBuffer.enc_ndr_long(0);
                ndrBuffer.enc_ndr_long(n5);
                n3 = ndrBuffer.index;
                ndrBuffer.advance(2 * n5);
                ndrBuffer = ndrBuffer.derive(n3);
                for (n2 = 0; n2 < n5; ++n2) {
                    ndrBuffer.enc_ndr_short(this.dns_forest.buffer[n2]);
                }
            }
            ndrBuffer = ndrBuffer.derive(n7);
            for (n5 = 0; n5 < n6; ++n5) {
                ndrBuffer.enc_ndr_small(this.domain_guid.node[n5]);
            }
            if (this.sid != null) {
                ndrBuffer = ndrBuffer.deferred;
                this.sid.encode(ndrBuffer);
            }
        }

        public void decode(NdrBuffer ndrBuffer) throws NdrException {
            int n2;
            int n3;
            int n4;
            int n5;
            ndrBuffer.align(4);
            ndrBuffer.align(4);
            if (this.name == null) {
                this.name = new rpc.unicode_string();
            }
            this.name.length = (short)ndrBuffer.dec_ndr_short();
            this.name.maximum_length = (short)ndrBuffer.dec_ndr_short();
            int n6 = ndrBuffer.dec_ndr_long();
            ndrBuffer.align(4);
            if (this.dns_domain == null) {
                this.dns_domain = new rpc.unicode_string();
            }
            this.dns_domain.length = (short)ndrBuffer.dec_ndr_short();
            this.dns_domain.maximum_length = (short)ndrBuffer.dec_ndr_short();
            int n7 = ndrBuffer.dec_ndr_long();
            ndrBuffer.align(4);
            if (this.dns_forest == null) {
                this.dns_forest = new rpc.unicode_string();
            }
            this.dns_forest.length = (short)ndrBuffer.dec_ndr_short();
            this.dns_forest.maximum_length = (short)ndrBuffer.dec_ndr_short();
            int n8 = ndrBuffer.dec_ndr_long();
            ndrBuffer.align(4);
            if (this.domain_guid == null) {
                this.domain_guid = new rpc.uuid_t();
            }
            this.domain_guid.time_low = ndrBuffer.dec_ndr_long();
            this.domain_guid.time_mid = (short)ndrBuffer.dec_ndr_short();
            this.domain_guid.time_hi_and_version = (short)ndrBuffer.dec_ndr_short();
            this.domain_guid.clock_seq_hi_and_reserved = (byte)ndrBuffer.dec_ndr_small();
            this.domain_guid.clock_seq_low = (byte)ndrBuffer.dec_ndr_small();
            int n9 = 6;
            int n10 = ndrBuffer.index;
            ndrBuffer.advance(1 * n9);
            int n11 = ndrBuffer.dec_ndr_long();
            if (n6 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                n5 = ndrBuffer.dec_ndr_long();
                ndrBuffer.dec_ndr_long();
                n4 = ndrBuffer.dec_ndr_long();
                n3 = ndrBuffer.index;
                ndrBuffer.advance(2 * n4);
                if (this.name.buffer == null) {
                    if (n5 < 0 || n5 > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.name.buffer = new short[n5];
                }
                ndrBuffer = ndrBuffer.derive(n3);
                for (n2 = 0; n2 < n4; ++n2) {
                    this.name.buffer[n2] = (short)ndrBuffer.dec_ndr_short();
                }
            }
            if (n7 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                n5 = ndrBuffer.dec_ndr_long();
                ndrBuffer.dec_ndr_long();
                n4 = ndrBuffer.dec_ndr_long();
                n3 = ndrBuffer.index;
                ndrBuffer.advance(2 * n4);
                if (this.dns_domain.buffer == null) {
                    if (n5 < 0 || n5 > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.dns_domain.buffer = new short[n5];
                }
                ndrBuffer = ndrBuffer.derive(n3);
                for (n2 = 0; n2 < n4; ++n2) {
                    this.dns_domain.buffer[n2] = (short)ndrBuffer.dec_ndr_short();
                }
            }
            if (n8 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                n5 = ndrBuffer.dec_ndr_long();
                ndrBuffer.dec_ndr_long();
                n4 = ndrBuffer.dec_ndr_long();
                n3 = ndrBuffer.index;
                ndrBuffer.advance(2 * n4);
                if (this.dns_forest.buffer == null) {
                    if (n5 < 0 || n5 > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.dns_forest.buffer = new short[n5];
                }
                ndrBuffer = ndrBuffer.derive(n3);
                for (n2 = 0; n2 < n4; ++n2) {
                    this.dns_forest.buffer[n2] = (short)ndrBuffer.dec_ndr_short();
                }
            }
            if (this.domain_guid.node == null) {
                if (n9 < 0 || n9 > 65535) {
                    throw new NdrException("invalid array conformance");
                }
                this.domain_guid.node = new byte[n9];
            }
            ndrBuffer = ndrBuffer.derive(n10);
            for (n5 = 0; n5 < n9; ++n5) {
                this.domain_guid.node[n5] = (byte)ndrBuffer.dec_ndr_small();
            }
            if (n11 != 0) {
                if (this.sid == null) {
                    this.sid = new rpc.sid_t();
                }
                ndrBuffer = ndrBuffer.deferred;
                this.sid.decode(ndrBuffer);
            }
        }
    }

    public static class LsarDomainInfo
    extends NdrObject {
        public rpc.unicode_string name;
        public rpc.sid_t sid;

        public void encode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.enc_ndr_short(this.name.length);
            ndrBuffer.enc_ndr_short(this.name.maximum_length);
            ndrBuffer.enc_ndr_referent(this.name.buffer, 1);
            ndrBuffer.enc_ndr_referent(this.sid, 1);
            if (this.name.buffer != null) {
                ndrBuffer = ndrBuffer.deferred;
                int n2 = this.name.length / 2;
                int n3 = this.name.maximum_length / 2;
                ndrBuffer.enc_ndr_long(n3);
                ndrBuffer.enc_ndr_long(0);
                ndrBuffer.enc_ndr_long(n2);
                int n4 = ndrBuffer.index;
                ndrBuffer.advance(2 * n2);
                ndrBuffer = ndrBuffer.derive(n4);
                for (int i2 = 0; i2 < n2; ++i2) {
                    ndrBuffer.enc_ndr_short(this.name.buffer[i2]);
                }
            }
            if (this.sid != null) {
                ndrBuffer = ndrBuffer.deferred;
                this.sid.encode(ndrBuffer);
            }
        }

        public void decode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.align(4);
            if (this.name == null) {
                this.name = new rpc.unicode_string();
            }
            this.name.length = (short)ndrBuffer.dec_ndr_short();
            this.name.maximum_length = (short)ndrBuffer.dec_ndr_short();
            int n2 = ndrBuffer.dec_ndr_long();
            int n3 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                int n4 = ndrBuffer.dec_ndr_long();
                ndrBuffer.dec_ndr_long();
                int n5 = ndrBuffer.dec_ndr_long();
                int n6 = ndrBuffer.index;
                ndrBuffer.advance(2 * n5);
                if (this.name.buffer == null) {
                    if (n4 < 0 || n4 > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.name.buffer = new short[n4];
                }
                ndrBuffer = ndrBuffer.derive(n6);
                for (int i2 = 0; i2 < n5; ++i2) {
                    this.name.buffer[i2] = (short)ndrBuffer.dec_ndr_short();
                }
            }
            if (n3 != 0) {
                if (this.sid == null) {
                    this.sid = new rpc.sid_t();
                }
                ndrBuffer = ndrBuffer.deferred;
                this.sid.decode(ndrBuffer);
            }
        }
    }

    public static class LsarObjectAttributes
    extends NdrObject {
        public int length;
        public NdrSmall root_directory;
        public rpc.unicode_string object_name;
        public int attributes;
        public int security_descriptor;
        public LsarQosInfo security_quality_of_service;

        public void encode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.enc_ndr_long(this.length);
            ndrBuffer.enc_ndr_referent(this.root_directory, 1);
            ndrBuffer.enc_ndr_referent(this.object_name, 1);
            ndrBuffer.enc_ndr_long(this.attributes);
            ndrBuffer.enc_ndr_long(this.security_descriptor);
            ndrBuffer.enc_ndr_referent(this.security_quality_of_service, 1);
            if (this.root_directory != null) {
                ndrBuffer = ndrBuffer.deferred;
                this.root_directory.encode(ndrBuffer);
            }
            if (this.object_name != null) {
                ndrBuffer = ndrBuffer.deferred;
                this.object_name.encode(ndrBuffer);
            }
            if (this.security_quality_of_service != null) {
                ndrBuffer = ndrBuffer.deferred;
                this.security_quality_of_service.encode(ndrBuffer);
            }
        }

        public void decode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            this.length = ndrBuffer.dec_ndr_long();
            int n2 = ndrBuffer.dec_ndr_long();
            int n3 = ndrBuffer.dec_ndr_long();
            this.attributes = ndrBuffer.dec_ndr_long();
            this.security_descriptor = ndrBuffer.dec_ndr_long();
            int n4 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                this.root_directory.decode(ndrBuffer);
            }
            if (n3 != 0) {
                if (this.object_name == null) {
                    this.object_name = new rpc.unicode_string();
                }
                ndrBuffer = ndrBuffer.deferred;
                this.object_name.decode(ndrBuffer);
            }
            if (n4 != 0) {
                if (this.security_quality_of_service == null) {
                    this.security_quality_of_service = new LsarQosInfo();
                }
                ndrBuffer = ndrBuffer.deferred;
                this.security_quality_of_service.decode(ndrBuffer);
            }
        }
    }

    public static class LsarQosInfo
    extends NdrObject {
        public int length;
        public short impersonation_level;
        public byte context_mode;
        public byte effective_only;

        public void encode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.enc_ndr_long(this.length);
            ndrBuffer.enc_ndr_short(this.impersonation_level);
            ndrBuffer.enc_ndr_small(this.context_mode);
            ndrBuffer.enc_ndr_small(this.effective_only);
        }

        public void decode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            this.length = ndrBuffer.dec_ndr_long();
            this.impersonation_level = (short)ndrBuffer.dec_ndr_short();
            this.context_mode = (byte)ndrBuffer.dec_ndr_small();
            this.effective_only = (byte)ndrBuffer.dec_ndr_small();
        }
    }
}

