/*
 * Decompiled with CFR 0.152.
 */
package jcifs.dcerpc.msrpc;

import jcifs.dcerpc.DcerpcMessage;
import jcifs.dcerpc.ndr.NdrBuffer;
import jcifs.dcerpc.ndr.NdrException;
import jcifs.dcerpc.ndr.NdrLong;
import jcifs.dcerpc.ndr.NdrObject;

public class netdfs {
    public static final int DFS_VOLUME_FLAVOR_STANDALONE = 256;
    public static final int DFS_VOLUME_FLAVOR_AD_BLOB = 512;
    public static final int DFS_STORAGE_STATE_OFFLINE = 1;
    public static final int DFS_STORAGE_STATE_ONLINE = 2;
    public static final int DFS_STORAGE_STATE_ACTIVE = 4;

    public static String getSyntax() {
        return "4fc742e0-4a10-11cf-8273-00aa004ae673:3.0";
    }

    public static class NetrDfsEnumEx
    extends DcerpcMessage {
        public int retval;
        public String dfs_name;
        public int level;
        public int prefmaxlen;
        public DfsEnumStruct info;
        public NdrLong totalentries;

        public int getOpnum() {
            return 21;
        }

        public NetrDfsEnumEx(String string, int n2, int n3, DfsEnumStruct dfsEnumStruct, NdrLong ndrLong) {
            this.dfs_name = string;
            this.level = n2;
            this.prefmaxlen = n3;
            this.info = dfsEnumStruct;
            this.totalentries = ndrLong;
        }

        public void encode_in(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.enc_ndr_string(this.dfs_name);
            ndrBuffer.enc_ndr_long(this.level);
            ndrBuffer.enc_ndr_long(this.prefmaxlen);
            ndrBuffer.enc_ndr_referent(this.info, 1);
            if (this.info != null) {
                this.info.encode(ndrBuffer);
            }
            ndrBuffer.enc_ndr_referent(this.totalentries, 1);
            if (this.totalentries != null) {
                this.totalentries.encode(ndrBuffer);
            }
        }

        public void decode_out(NdrBuffer ndrBuffer) throws NdrException {
            int n2;
            int n3 = ndrBuffer.dec_ndr_long();
            if (n3 != 0) {
                if (this.info == null) {
                    this.info = new DfsEnumStruct();
                }
                this.info.decode(ndrBuffer);
            }
            if ((n2 = ndrBuffer.dec_ndr_long()) != 0) {
                this.totalentries.decode(ndrBuffer);
            }
            this.retval = ndrBuffer.dec_ndr_long();
        }
    }

    public static class DfsEnumStruct
    extends NdrObject {
        public int level;
        public NdrObject e;

        public void encode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.enc_ndr_long(this.level);
            int n2 = this.level;
            ndrBuffer.enc_ndr_long(n2);
            ndrBuffer.enc_ndr_referent(this.e, 1);
            if (this.e != null) {
                ndrBuffer = ndrBuffer.deferred;
                this.e.encode(ndrBuffer);
            }
        }

        public void decode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            this.level = ndrBuffer.dec_ndr_long();
            ndrBuffer.dec_ndr_long();
            int n2 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                if (this.e == null) {
                    this.e = new DfsEnumArray1();
                }
                ndrBuffer = ndrBuffer.deferred;
                this.e.decode(ndrBuffer);
            }
        }
    }

    public static class DfsEnumArray300
    extends NdrObject {
        public int count;
        public DfsInfo300[] s;

        public void encode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.enc_ndr_long(this.count);
            ndrBuffer.enc_ndr_referent(this.s, 1);
            if (this.s != null) {
                ndrBuffer = ndrBuffer.deferred;
                int n2 = this.count;
                ndrBuffer.enc_ndr_long(n2);
                int n3 = ndrBuffer.index;
                ndrBuffer.advance(8 * n2);
                ndrBuffer = ndrBuffer.derive(n3);
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.s[i2].encode(ndrBuffer);
                }
            }
        }

        public void decode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            this.count = ndrBuffer.dec_ndr_long();
            int n2 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                int n3 = ndrBuffer.dec_ndr_long();
                int n4 = ndrBuffer.index;
                ndrBuffer.advance(8 * n3);
                if (this.s == null) {
                    if (n3 < 0 || n3 > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.s = new DfsInfo300[n3];
                }
                ndrBuffer = ndrBuffer.derive(n4);
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (this.s[i2] == null) {
                        this.s[i2] = new DfsInfo300();
                    }
                    this.s[i2].decode(ndrBuffer);
                }
            }
        }
    }

    public static class DfsInfo300
    extends NdrObject {
        public int flags;
        public String dfs_name;

        public void encode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.enc_ndr_long(this.flags);
            ndrBuffer.enc_ndr_referent(this.dfs_name, 1);
            if (this.dfs_name != null) {
                ndrBuffer = ndrBuffer.deferred;
                ndrBuffer.enc_ndr_string(this.dfs_name);
            }
        }

        public void decode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            this.flags = ndrBuffer.dec_ndr_long();
            int n2 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                this.dfs_name = ndrBuffer.dec_ndr_string();
            }
        }
    }

    public static class DfsEnumArray200
    extends NdrObject {
        public int count;
        public DfsInfo200[] s;

        public void encode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.enc_ndr_long(this.count);
            ndrBuffer.enc_ndr_referent(this.s, 1);
            if (this.s != null) {
                ndrBuffer = ndrBuffer.deferred;
                int n2 = this.count;
                ndrBuffer.enc_ndr_long(n2);
                int n3 = ndrBuffer.index;
                ndrBuffer.advance(4 * n2);
                ndrBuffer = ndrBuffer.derive(n3);
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.s[i2].encode(ndrBuffer);
                }
            }
        }

        public void decode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            this.count = ndrBuffer.dec_ndr_long();
            int n2 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                int n3 = ndrBuffer.dec_ndr_long();
                int n4 = ndrBuffer.index;
                ndrBuffer.advance(4 * n3);
                if (this.s == null) {
                    if (n3 < 0 || n3 > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.s = new DfsInfo200[n3];
                }
                ndrBuffer = ndrBuffer.derive(n4);
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (this.s[i2] == null) {
                        this.s[i2] = new DfsInfo200();
                    }
                    this.s[i2].decode(ndrBuffer);
                }
            }
        }
    }

    public static class DfsInfo200
    extends NdrObject {
        public String dfs_name;

        public void encode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.enc_ndr_referent(this.dfs_name, 1);
            if (this.dfs_name != null) {
                ndrBuffer = ndrBuffer.deferred;
                ndrBuffer.enc_ndr_string(this.dfs_name);
            }
        }

        public void decode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            int n2 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                this.dfs_name = ndrBuffer.dec_ndr_string();
            }
        }
    }

    public static class DfsEnumArray3
    extends NdrObject {
        public int count;
        public DfsInfo3[] s;

        public void encode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.enc_ndr_long(this.count);
            ndrBuffer.enc_ndr_referent(this.s, 1);
            if (this.s != null) {
                ndrBuffer = ndrBuffer.deferred;
                int n2 = this.count;
                ndrBuffer.enc_ndr_long(n2);
                int n3 = ndrBuffer.index;
                ndrBuffer.advance(20 * n2);
                ndrBuffer = ndrBuffer.derive(n3);
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.s[i2].encode(ndrBuffer);
                }
            }
        }

        public void decode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            this.count = ndrBuffer.dec_ndr_long();
            int n2 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                int n3 = ndrBuffer.dec_ndr_long();
                int n4 = ndrBuffer.index;
                ndrBuffer.advance(20 * n3);
                if (this.s == null) {
                    if (n3 < 0 || n3 > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.s = new DfsInfo3[n3];
                }
                ndrBuffer = ndrBuffer.derive(n4);
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (this.s[i2] == null) {
                        this.s[i2] = new DfsInfo3();
                    }
                    this.s[i2].decode(ndrBuffer);
                }
            }
        }
    }

    public static class DfsInfo3
    extends NdrObject {
        public String path;
        public String comment;
        public int state;
        public int num_stores;
        public DfsStorageInfo[] stores;

        public void encode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.enc_ndr_referent(this.path, 1);
            ndrBuffer.enc_ndr_referent(this.comment, 1);
            ndrBuffer.enc_ndr_long(this.state);
            ndrBuffer.enc_ndr_long(this.num_stores);
            ndrBuffer.enc_ndr_referent(this.stores, 1);
            if (this.path != null) {
                ndrBuffer = ndrBuffer.deferred;
                ndrBuffer.enc_ndr_string(this.path);
            }
            if (this.comment != null) {
                ndrBuffer = ndrBuffer.deferred;
                ndrBuffer.enc_ndr_string(this.comment);
            }
            if (this.stores != null) {
                ndrBuffer = ndrBuffer.deferred;
                int n2 = this.num_stores;
                ndrBuffer.enc_ndr_long(n2);
                int n3 = ndrBuffer.index;
                ndrBuffer.advance(12 * n2);
                ndrBuffer = ndrBuffer.derive(n3);
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.stores[i2].encode(ndrBuffer);
                }
            }
        }

        public void decode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            int n2 = ndrBuffer.dec_ndr_long();
            int n3 = ndrBuffer.dec_ndr_long();
            this.state = ndrBuffer.dec_ndr_long();
            this.num_stores = ndrBuffer.dec_ndr_long();
            int n4 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                this.path = ndrBuffer.dec_ndr_string();
            }
            if (n3 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                this.comment = ndrBuffer.dec_ndr_string();
            }
            if (n4 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                int n5 = ndrBuffer.dec_ndr_long();
                int n6 = ndrBuffer.index;
                ndrBuffer.advance(12 * n5);
                if (this.stores == null) {
                    if (n5 < 0 || n5 > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.stores = new DfsStorageInfo[n5];
                }
                ndrBuffer = ndrBuffer.derive(n6);
                for (int i2 = 0; i2 < n5; ++i2) {
                    if (this.stores[i2] == null) {
                        this.stores[i2] = new DfsStorageInfo();
                    }
                    this.stores[i2].decode(ndrBuffer);
                }
            }
        }
    }

    public static class DfsStorageInfo
    extends NdrObject {
        public int state;
        public String server_name;
        public String share_name;

        public void encode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.enc_ndr_long(this.state);
            ndrBuffer.enc_ndr_referent(this.server_name, 1);
            ndrBuffer.enc_ndr_referent(this.share_name, 1);
            if (this.server_name != null) {
                ndrBuffer = ndrBuffer.deferred;
                ndrBuffer.enc_ndr_string(this.server_name);
            }
            if (this.share_name != null) {
                ndrBuffer = ndrBuffer.deferred;
                ndrBuffer.enc_ndr_string(this.share_name);
            }
        }

        public void decode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            this.state = ndrBuffer.dec_ndr_long();
            int n2 = ndrBuffer.dec_ndr_long();
            int n3 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                this.server_name = ndrBuffer.dec_ndr_string();
            }
            if (n3 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                this.share_name = ndrBuffer.dec_ndr_string();
            }
        }
    }

    public static class DfsEnumArray1
    extends NdrObject {
        public int count;
        public DfsInfo1[] s;

        public void encode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.enc_ndr_long(this.count);
            ndrBuffer.enc_ndr_referent(this.s, 1);
            if (this.s != null) {
                ndrBuffer = ndrBuffer.deferred;
                int n2 = this.count;
                ndrBuffer.enc_ndr_long(n2);
                int n3 = ndrBuffer.index;
                ndrBuffer.advance(4 * n2);
                ndrBuffer = ndrBuffer.derive(n3);
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.s[i2].encode(ndrBuffer);
                }
            }
        }

        public void decode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            this.count = ndrBuffer.dec_ndr_long();
            int n2 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                int n3 = ndrBuffer.dec_ndr_long();
                int n4 = ndrBuffer.index;
                ndrBuffer.advance(4 * n3);
                if (this.s == null) {
                    if (n3 < 0 || n3 > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.s = new DfsInfo1[n3];
                }
                ndrBuffer = ndrBuffer.derive(n4);
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (this.s[i2] == null) {
                        this.s[i2] = new DfsInfo1();
                    }
                    this.s[i2].decode(ndrBuffer);
                }
            }
        }
    }

    public static class DfsInfo1
    extends NdrObject {
        public String entry_path;

        public void encode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.enc_ndr_referent(this.entry_path, 1);
            if (this.entry_path != null) {
                ndrBuffer = ndrBuffer.deferred;
                ndrBuffer.enc_ndr_string(this.entry_path);
            }
        }

        public void decode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            int n2 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                this.entry_path = ndrBuffer.dec_ndr_string();
            }
        }
    }
}

