/*
 * Decompiled with CFR 0.152.
 */
package jcifs.dcerpc.msrpc;

import jcifs.dcerpc.DcerpcMessage;
import jcifs.dcerpc.msrpc.lsarpc;
import jcifs.dcerpc.ndr.NdrBuffer;
import jcifs.dcerpc.ndr.NdrException;
import jcifs.dcerpc.ndr.NdrObject;
import jcifs.dcerpc.rpc;

public class samr {
    public static final int ACB_DISABLED = 1;
    public static final int ACB_HOMDIRREQ = 2;
    public static final int ACB_PWNOTREQ = 4;
    public static final int ACB_TEMPDUP = 8;
    public static final int ACB_NORMAL = 16;
    public static final int ACB_MNS = 32;
    public static final int ACB_DOMTRUST = 64;
    public static final int ACB_WSTRUST = 128;
    public static final int ACB_SVRTRUST = 256;
    public static final int ACB_PWNOEXP = 512;
    public static final int ACB_AUTOLOCK = 1024;
    public static final int ACB_ENC_TXT_PWD_ALLOWED = 2048;
    public static final int ACB_SMARTCARD_REQUIRED = 4096;
    public static final int ACB_TRUSTED_FOR_DELEGATION = 8192;
    public static final int ACB_NOT_DELEGATED = 16384;
    public static final int ACB_USE_DES_KEY_ONLY = 32768;
    public static final int ACB_DONT_REQUIRE_PREAUTH = 65536;
    public static final int SE_GROUP_MANDATORY = 1;
    public static final int SE_GROUP_ENABLED_BY_DEFAULT = 2;
    public static final int SE_GROUP_ENABLED = 4;
    public static final int SE_GROUP_OWNER = 8;
    public static final int SE_GROUP_USE_FOR_DENY_ONLY = 16;
    public static final int SE_GROUP_RESOURCE = 0x20000000;
    public static final int SE_GROUP_LOGON_ID = -1073741824;

    public static String getSyntax() {
        return "12345778-1234-abcd-ef00-0123456789ac:1.0";
    }

    public static class SamrRidWithAttributeArray
    extends NdrObject {
        public int count;
        public SamrRidWithAttribute[] rids;

        public void encode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.enc_ndr_long(this.count);
            ndrBuffer.enc_ndr_referent(this.rids, 1);
            if (this.rids != null) {
                ndrBuffer = ndrBuffer.deferred;
                int n2 = this.count;
                ndrBuffer.enc_ndr_long(n2);
                int n3 = ndrBuffer.index;
                ndrBuffer.advance(8 * n2);
                ndrBuffer = ndrBuffer.derive(n3);
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.rids[i2].encode(ndrBuffer);
                }
            }
        }

        public void decode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            this.count = ndrBuffer.dec_ndr_long();
            int n2 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                int n3 = ndrBuffer.dec_ndr_long();
                int n4 = ndrBuffer.index;
                ndrBuffer.advance(8 * n3);
                if (this.rids == null) {
                    if (n3 < 0 || n3 > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.rids = new SamrRidWithAttribute[n3];
                }
                ndrBuffer = ndrBuffer.derive(n4);
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (this.rids[i2] == null) {
                        this.rids[i2] = new SamrRidWithAttribute();
                    }
                    this.rids[i2].decode(ndrBuffer);
                }
            }
        }
    }

    public static class SamrRidWithAttribute
    extends NdrObject {
        public int rid;
        public int attributes;

        public void encode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.enc_ndr_long(this.rid);
            ndrBuffer.enc_ndr_long(this.attributes);
        }

        public void decode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            this.rid = ndrBuffer.dec_ndr_long();
            this.attributes = ndrBuffer.dec_ndr_long();
        }
    }

    public static class SamrGetMembersInAlias
    extends DcerpcMessage {
        public int retval;
        public rpc.policy_handle alias_handle;
        public lsarpc.LsarSidArray sids;

        public int getOpnum() {
            return 33;
        }

        public SamrGetMembersInAlias(rpc.policy_handle policy_handle2, lsarpc.LsarSidArray lsarSidArray) {
            this.alias_handle = policy_handle2;
            this.sids = lsarSidArray;
        }

        public void encode_in(NdrBuffer ndrBuffer) throws NdrException {
            this.alias_handle.encode(ndrBuffer);
        }

        public void decode_out(NdrBuffer ndrBuffer) throws NdrException {
            this.sids.decode(ndrBuffer);
            this.retval = ndrBuffer.dec_ndr_long();
        }
    }

    public static class SamrOpenAlias
    extends DcerpcMessage {
        public int retval;
        public rpc.policy_handle domain_handle;
        public int access_mask;
        public int rid;
        public rpc.policy_handle alias_handle;

        public int getOpnum() {
            return 27;
        }

        public SamrOpenAlias(rpc.policy_handle policy_handle2, int n2, int n3, rpc.policy_handle policy_handle3) {
            this.domain_handle = policy_handle2;
            this.access_mask = n2;
            this.rid = n3;
            this.alias_handle = policy_handle3;
        }

        public void encode_in(NdrBuffer ndrBuffer) throws NdrException {
            this.domain_handle.encode(ndrBuffer);
            ndrBuffer.enc_ndr_long(this.access_mask);
            ndrBuffer.enc_ndr_long(this.rid);
        }

        public void decode_out(NdrBuffer ndrBuffer) throws NdrException {
            this.alias_handle.decode(ndrBuffer);
            this.retval = ndrBuffer.dec_ndr_long();
        }
    }

    public static class SamrEnumerateAliasesInDomain
    extends DcerpcMessage {
        public int retval;
        public rpc.policy_handle domain_handle;
        public int resume_handle;
        public int acct_flags;
        public SamrSamArray sam;
        public int num_entries;

        public int getOpnum() {
            return 15;
        }

        public SamrEnumerateAliasesInDomain(rpc.policy_handle policy_handle2, int n2, int n3, SamrSamArray samrSamArray, int n4) {
            this.domain_handle = policy_handle2;
            this.resume_handle = n2;
            this.acct_flags = n3;
            this.sam = samrSamArray;
            this.num_entries = n4;
        }

        public void encode_in(NdrBuffer ndrBuffer) throws NdrException {
            this.domain_handle.encode(ndrBuffer);
            ndrBuffer.enc_ndr_long(this.resume_handle);
            ndrBuffer.enc_ndr_long(this.acct_flags);
        }

        public void decode_out(NdrBuffer ndrBuffer) throws NdrException {
            this.resume_handle = ndrBuffer.dec_ndr_long();
            int n2 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                if (this.sam == null) {
                    this.sam = new SamrSamArray();
                }
                this.sam.decode(ndrBuffer);
            }
            this.num_entries = ndrBuffer.dec_ndr_long();
            this.retval = ndrBuffer.dec_ndr_long();
        }
    }

    public static class SamrSamArray
    extends NdrObject {
        public int count;
        public SamrSamEntry[] entries;

        public void encode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.enc_ndr_long(this.count);
            ndrBuffer.enc_ndr_referent(this.entries, 1);
            if (this.entries != null) {
                ndrBuffer = ndrBuffer.deferred;
                int n2 = this.count;
                ndrBuffer.enc_ndr_long(n2);
                int n3 = ndrBuffer.index;
                ndrBuffer.advance(12 * n2);
                ndrBuffer = ndrBuffer.derive(n3);
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.entries[i2].encode(ndrBuffer);
                }
            }
        }

        public void decode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            this.count = ndrBuffer.dec_ndr_long();
            int n2 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                int n3 = ndrBuffer.dec_ndr_long();
                int n4 = ndrBuffer.index;
                ndrBuffer.advance(12 * n3);
                if (this.entries == null) {
                    if (n3 < 0 || n3 > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.entries = new SamrSamEntry[n3];
                }
                ndrBuffer = ndrBuffer.derive(n4);
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (this.entries[i2] == null) {
                        this.entries[i2] = new SamrSamEntry();
                    }
                    this.entries[i2].decode(ndrBuffer);
                }
            }
        }
    }

    public static class SamrSamEntry
    extends NdrObject {
        public int idx;
        public rpc.unicode_string name;

        public void encode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.enc_ndr_long(this.idx);
            ndrBuffer.enc_ndr_short(this.name.length);
            ndrBuffer.enc_ndr_short(this.name.maximum_length);
            ndrBuffer.enc_ndr_referent(this.name.buffer, 1);
            if (this.name.buffer != null) {
                ndrBuffer = ndrBuffer.deferred;
                int n2 = this.name.length / 2;
                int n3 = this.name.maximum_length / 2;
                ndrBuffer.enc_ndr_long(n3);
                ndrBuffer.enc_ndr_long(0);
                ndrBuffer.enc_ndr_long(n2);
                int n4 = ndrBuffer.index;
                ndrBuffer.advance(2 * n2);
                ndrBuffer = ndrBuffer.derive(n4);
                for (int i2 = 0; i2 < n2; ++i2) {
                    ndrBuffer.enc_ndr_short(this.name.buffer[i2]);
                }
            }
        }

        public void decode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            this.idx = ndrBuffer.dec_ndr_long();
            ndrBuffer.align(4);
            if (this.name == null) {
                this.name = new rpc.unicode_string();
            }
            this.name.length = (short)ndrBuffer.dec_ndr_short();
            this.name.maximum_length = (short)ndrBuffer.dec_ndr_short();
            int n2 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                int n3 = ndrBuffer.dec_ndr_long();
                ndrBuffer.dec_ndr_long();
                int n4 = ndrBuffer.dec_ndr_long();
                int n5 = ndrBuffer.index;
                ndrBuffer.advance(2 * n4);
                if (this.name.buffer == null) {
                    if (n3 < 0 || n3 > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.name.buffer = new short[n3];
                }
                ndrBuffer = ndrBuffer.derive(n5);
                for (int i2 = 0; i2 < n4; ++i2) {
                    this.name.buffer[i2] = (short)ndrBuffer.dec_ndr_short();
                }
            }
        }
    }

    public static class SamrOpenDomain
    extends DcerpcMessage {
        public int retval;
        public rpc.policy_handle handle;
        public int access_mask;
        public rpc.sid_t sid;
        public rpc.policy_handle domain_handle;

        public int getOpnum() {
            return 7;
        }

        public SamrOpenDomain(rpc.policy_handle policy_handle2, int n2, rpc.sid_t sid_t2, rpc.policy_handle policy_handle3) {
            this.handle = policy_handle2;
            this.access_mask = n2;
            this.sid = sid_t2;
            this.domain_handle = policy_handle3;
        }

        public void encode_in(NdrBuffer ndrBuffer) throws NdrException {
            this.handle.encode(ndrBuffer);
            ndrBuffer.enc_ndr_long(this.access_mask);
            this.sid.encode(ndrBuffer);
        }

        public void decode_out(NdrBuffer ndrBuffer) throws NdrException {
            this.domain_handle.decode(ndrBuffer);
            this.retval = ndrBuffer.dec_ndr_long();
        }
    }

    public static class SamrConnect4
    extends DcerpcMessage {
        public int retval;
        public String system_name;
        public int unknown;
        public int access_mask;
        public rpc.policy_handle handle;

        public int getOpnum() {
            return 62;
        }

        public SamrConnect4(String string, int n2, int n3, rpc.policy_handle policy_handle2) {
            this.system_name = string;
            this.unknown = n2;
            this.access_mask = n3;
            this.handle = policy_handle2;
        }

        public void encode_in(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.enc_ndr_referent(this.system_name, 1);
            if (this.system_name != null) {
                ndrBuffer.enc_ndr_string(this.system_name);
            }
            ndrBuffer.enc_ndr_long(this.unknown);
            ndrBuffer.enc_ndr_long(this.access_mask);
        }

        public void decode_out(NdrBuffer ndrBuffer) throws NdrException {
            this.handle.decode(ndrBuffer);
            this.retval = ndrBuffer.dec_ndr_long();
        }
    }

    public static class SamrConnect2
    extends DcerpcMessage {
        public int retval;
        public String system_name;
        public int access_mask;
        public rpc.policy_handle handle;

        public int getOpnum() {
            return 57;
        }

        public SamrConnect2(String string, int n2, rpc.policy_handle policy_handle2) {
            this.system_name = string;
            this.access_mask = n2;
            this.handle = policy_handle2;
        }

        public void encode_in(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.enc_ndr_referent(this.system_name, 1);
            if (this.system_name != null) {
                ndrBuffer.enc_ndr_string(this.system_name);
            }
            ndrBuffer.enc_ndr_long(this.access_mask);
        }

        public void decode_out(NdrBuffer ndrBuffer) throws NdrException {
            this.handle.decode(ndrBuffer);
            this.retval = ndrBuffer.dec_ndr_long();
        }
    }

    public static class SamrCloseHandle
    extends DcerpcMessage {
        public int retval;
        public rpc.policy_handle handle;

        public int getOpnum() {
            return 1;
        }

        public SamrCloseHandle(rpc.policy_handle policy_handle2) {
            this.handle = policy_handle2;
        }

        public void encode_in(NdrBuffer ndrBuffer) throws NdrException {
            this.handle.encode(ndrBuffer);
        }

        public void decode_out(NdrBuffer ndrBuffer) throws NdrException {
            this.retval = ndrBuffer.dec_ndr_long();
        }
    }
}

