/*
 * Decompiled with CFR 0.152.
 */
package jcifs.dcerpc.msrpc;

import jcifs.dcerpc.DcerpcMessage;
import jcifs.dcerpc.ndr.NdrBuffer;
import jcifs.dcerpc.ndr.NdrException;
import jcifs.dcerpc.ndr.NdrObject;

public class srvsvc {
    public static String getSyntax() {
        return "4b324fc8-1670-01d3-1278-5a47bf6ee188:3.0";
    }

    public static class RemoteTOD
    extends DcerpcMessage {
        public int retval;
        public String servername;
        public TimeOfDayInfo info;

        public int getOpnum() {
            return 28;
        }

        public RemoteTOD(String string, TimeOfDayInfo timeOfDayInfo) {
            this.servername = string;
            this.info = timeOfDayInfo;
        }

        public void encode_in(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.enc_ndr_referent(this.servername, 1);
            if (this.servername != null) {
                ndrBuffer.enc_ndr_string(this.servername);
            }
        }

        public void decode_out(NdrBuffer ndrBuffer) throws NdrException {
            int n2 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                if (this.info == null) {
                    this.info = new TimeOfDayInfo();
                }
                this.info.decode(ndrBuffer);
            }
            this.retval = ndrBuffer.dec_ndr_long();
        }
    }

    public static class TimeOfDayInfo
    extends NdrObject {
        public int elapsedt;
        public int msecs;
        public int hours;
        public int mins;
        public int secs;
        public int hunds;
        public int timezone;
        public int tinterval;
        public int day;
        public int month;
        public int year;
        public int weekday;

        public void encode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.enc_ndr_long(this.elapsedt);
            ndrBuffer.enc_ndr_long(this.msecs);
            ndrBuffer.enc_ndr_long(this.hours);
            ndrBuffer.enc_ndr_long(this.mins);
            ndrBuffer.enc_ndr_long(this.secs);
            ndrBuffer.enc_ndr_long(this.hunds);
            ndrBuffer.enc_ndr_long(this.timezone);
            ndrBuffer.enc_ndr_long(this.tinterval);
            ndrBuffer.enc_ndr_long(this.day);
            ndrBuffer.enc_ndr_long(this.month);
            ndrBuffer.enc_ndr_long(this.year);
            ndrBuffer.enc_ndr_long(this.weekday);
        }

        public void decode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            this.elapsedt = ndrBuffer.dec_ndr_long();
            this.msecs = ndrBuffer.dec_ndr_long();
            this.hours = ndrBuffer.dec_ndr_long();
            this.mins = ndrBuffer.dec_ndr_long();
            this.secs = ndrBuffer.dec_ndr_long();
            this.hunds = ndrBuffer.dec_ndr_long();
            this.timezone = ndrBuffer.dec_ndr_long();
            this.tinterval = ndrBuffer.dec_ndr_long();
            this.day = ndrBuffer.dec_ndr_long();
            this.month = ndrBuffer.dec_ndr_long();
            this.year = ndrBuffer.dec_ndr_long();
            this.weekday = ndrBuffer.dec_ndr_long();
        }
    }

    public static class ServerGetInfo
    extends DcerpcMessage {
        public int retval;
        public String servername;
        public int level;
        public NdrObject info;

        public int getOpnum() {
            return 21;
        }

        public ServerGetInfo(String string, int n2, NdrObject ndrObject) {
            this.servername = string;
            this.level = n2;
            this.info = ndrObject;
        }

        public void encode_in(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.enc_ndr_referent(this.servername, 1);
            if (this.servername != null) {
                ndrBuffer.enc_ndr_string(this.servername);
            }
            ndrBuffer.enc_ndr_long(this.level);
        }

        public void decode_out(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.dec_ndr_long();
            int n2 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                if (this.info == null) {
                    this.info = new ServerInfo100();
                }
                ndrBuffer = ndrBuffer.deferred;
                this.info.decode(ndrBuffer);
            }
            this.retval = ndrBuffer.dec_ndr_long();
        }
    }

    public static class ServerInfo100
    extends NdrObject {
        public int platform_id;
        public String name;

        public void encode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.enc_ndr_long(this.platform_id);
            ndrBuffer.enc_ndr_referent(this.name, 1);
            if (this.name != null) {
                ndrBuffer = ndrBuffer.deferred;
                ndrBuffer.enc_ndr_string(this.name);
            }
        }

        public void decode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            this.platform_id = ndrBuffer.dec_ndr_long();
            int n2 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                this.name = ndrBuffer.dec_ndr_string();
            }
        }
    }

    public static class ShareGetInfo
    extends DcerpcMessage {
        public int retval;
        public String servername;
        public String sharename;
        public int level;
        public NdrObject info;

        public int getOpnum() {
            return 16;
        }

        public ShareGetInfo(String string, String string2, int n2, NdrObject ndrObject) {
            this.servername = string;
            this.sharename = string2;
            this.level = n2;
            this.info = ndrObject;
        }

        public void encode_in(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.enc_ndr_referent(this.servername, 1);
            if (this.servername != null) {
                ndrBuffer.enc_ndr_string(this.servername);
            }
            ndrBuffer.enc_ndr_string(this.sharename);
            ndrBuffer.enc_ndr_long(this.level);
        }

        public void decode_out(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.dec_ndr_long();
            int n2 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                if (this.info == null) {
                    this.info = new ShareInfo0();
                }
                ndrBuffer = ndrBuffer.deferred;
                this.info.decode(ndrBuffer);
            }
            this.retval = ndrBuffer.dec_ndr_long();
        }
    }

    public static class ShareEnumAll
    extends DcerpcMessage {
        public int retval;
        public String servername;
        public int level;
        public NdrObject info;
        public int prefmaxlen;
        public int totalentries;
        public int resume_handle;

        public int getOpnum() {
            return 15;
        }

        public ShareEnumAll(String string, int n2, NdrObject ndrObject, int n3, int n4, int n5) {
            this.servername = string;
            this.level = n2;
            this.info = ndrObject;
            this.prefmaxlen = n3;
            this.totalentries = n4;
            this.resume_handle = n5;
        }

        public void encode_in(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.enc_ndr_referent(this.servername, 1);
            if (this.servername != null) {
                ndrBuffer.enc_ndr_string(this.servername);
            }
            ndrBuffer.enc_ndr_long(this.level);
            int n2 = this.level;
            ndrBuffer.enc_ndr_long(n2);
            ndrBuffer.enc_ndr_referent(this.info, 1);
            if (this.info != null) {
                ndrBuffer = ndrBuffer.deferred;
                this.info.encode(ndrBuffer);
            }
            ndrBuffer.enc_ndr_long(this.prefmaxlen);
            ndrBuffer.enc_ndr_long(this.resume_handle);
        }

        public void decode_out(NdrBuffer ndrBuffer) throws NdrException {
            this.level = ndrBuffer.dec_ndr_long();
            ndrBuffer.dec_ndr_long();
            int n2 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                if (this.info == null) {
                    this.info = new ShareInfoCtr0();
                }
                ndrBuffer = ndrBuffer.deferred;
                this.info.decode(ndrBuffer);
            }
            this.totalentries = ndrBuffer.dec_ndr_long();
            this.resume_handle = ndrBuffer.dec_ndr_long();
            this.retval = ndrBuffer.dec_ndr_long();
        }
    }

    public static class ShareInfoCtr502
    extends NdrObject {
        public int count;
        public ShareInfo502[] array;

        public void encode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.enc_ndr_long(this.count);
            ndrBuffer.enc_ndr_referent(this.array, 1);
            if (this.array != null) {
                ndrBuffer = ndrBuffer.deferred;
                int n2 = this.count;
                ndrBuffer.enc_ndr_long(n2);
                int n3 = ndrBuffer.index;
                ndrBuffer.advance(40 * n2);
                ndrBuffer = ndrBuffer.derive(n3);
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.array[i2].encode(ndrBuffer);
                }
            }
        }

        public void decode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            this.count = ndrBuffer.dec_ndr_long();
            int n2 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                int n3 = ndrBuffer.dec_ndr_long();
                int n4 = ndrBuffer.index;
                ndrBuffer.advance(40 * n3);
                if (this.array == null) {
                    if (n3 < 0 || n3 > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.array = new ShareInfo502[n3];
                }
                ndrBuffer = ndrBuffer.derive(n4);
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (this.array[i2] == null) {
                        this.array[i2] = new ShareInfo502();
                    }
                    this.array[i2].decode(ndrBuffer);
                }
            }
        }
    }

    public static class ShareInfo502
    extends NdrObject {
        public String netname;
        public int type;
        public String remark;
        public int permissions;
        public int max_uses;
        public int current_uses;
        public String path;
        public String password;
        public int sd_size;
        public byte[] security_descriptor;

        public void encode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.enc_ndr_referent(this.netname, 1);
            ndrBuffer.enc_ndr_long(this.type);
            ndrBuffer.enc_ndr_referent(this.remark, 1);
            ndrBuffer.enc_ndr_long(this.permissions);
            ndrBuffer.enc_ndr_long(this.max_uses);
            ndrBuffer.enc_ndr_long(this.current_uses);
            ndrBuffer.enc_ndr_referent(this.path, 1);
            ndrBuffer.enc_ndr_referent(this.password, 1);
            ndrBuffer.enc_ndr_long(this.sd_size);
            ndrBuffer.enc_ndr_referent(this.security_descriptor, 1);
            if (this.netname != null) {
                ndrBuffer = ndrBuffer.deferred;
                ndrBuffer.enc_ndr_string(this.netname);
            }
            if (this.remark != null) {
                ndrBuffer = ndrBuffer.deferred;
                ndrBuffer.enc_ndr_string(this.remark);
            }
            if (this.path != null) {
                ndrBuffer = ndrBuffer.deferred;
                ndrBuffer.enc_ndr_string(this.path);
            }
            if (this.password != null) {
                ndrBuffer = ndrBuffer.deferred;
                ndrBuffer.enc_ndr_string(this.password);
            }
            if (this.security_descriptor != null) {
                ndrBuffer = ndrBuffer.deferred;
                int n2 = this.sd_size;
                ndrBuffer.enc_ndr_long(n2);
                int n3 = ndrBuffer.index;
                ndrBuffer.advance(1 * n2);
                ndrBuffer = ndrBuffer.derive(n3);
                for (int i2 = 0; i2 < n2; ++i2) {
                    ndrBuffer.enc_ndr_small(this.security_descriptor[i2]);
                }
            }
        }

        public void decode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            int n2 = ndrBuffer.dec_ndr_long();
            this.type = ndrBuffer.dec_ndr_long();
            int n3 = ndrBuffer.dec_ndr_long();
            this.permissions = ndrBuffer.dec_ndr_long();
            this.max_uses = ndrBuffer.dec_ndr_long();
            this.current_uses = ndrBuffer.dec_ndr_long();
            int n4 = ndrBuffer.dec_ndr_long();
            int n5 = ndrBuffer.dec_ndr_long();
            this.sd_size = ndrBuffer.dec_ndr_long();
            int n6 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                this.netname = ndrBuffer.dec_ndr_string();
            }
            if (n3 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                this.remark = ndrBuffer.dec_ndr_string();
            }
            if (n4 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                this.path = ndrBuffer.dec_ndr_string();
            }
            if (n5 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                this.password = ndrBuffer.dec_ndr_string();
            }
            if (n6 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                int n7 = ndrBuffer.dec_ndr_long();
                int n8 = ndrBuffer.index;
                ndrBuffer.advance(1 * n7);
                if (this.security_descriptor == null) {
                    if (n7 < 0 || n7 > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.security_descriptor = new byte[n7];
                }
                ndrBuffer = ndrBuffer.derive(n8);
                for (int i2 = 0; i2 < n7; ++i2) {
                    this.security_descriptor[i2] = (byte)ndrBuffer.dec_ndr_small();
                }
            }
        }
    }

    public static class ShareInfoCtr1
    extends NdrObject {
        public int count;
        public ShareInfo1[] array;

        public void encode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.enc_ndr_long(this.count);
            ndrBuffer.enc_ndr_referent(this.array, 1);
            if (this.array != null) {
                ndrBuffer = ndrBuffer.deferred;
                int n2 = this.count;
                ndrBuffer.enc_ndr_long(n2);
                int n3 = ndrBuffer.index;
                ndrBuffer.advance(12 * n2);
                ndrBuffer = ndrBuffer.derive(n3);
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.array[i2].encode(ndrBuffer);
                }
            }
        }

        public void decode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            this.count = ndrBuffer.dec_ndr_long();
            int n2 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                int n3 = ndrBuffer.dec_ndr_long();
                int n4 = ndrBuffer.index;
                ndrBuffer.advance(12 * n3);
                if (this.array == null) {
                    if (n3 < 0 || n3 > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.array = new ShareInfo1[n3];
                }
                ndrBuffer = ndrBuffer.derive(n4);
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (this.array[i2] == null) {
                        this.array[i2] = new ShareInfo1();
                    }
                    this.array[i2].decode(ndrBuffer);
                }
            }
        }
    }

    public static class ShareInfo1
    extends NdrObject {
        public String netname;
        public int type;
        public String remark;

        public void encode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.enc_ndr_referent(this.netname, 1);
            ndrBuffer.enc_ndr_long(this.type);
            ndrBuffer.enc_ndr_referent(this.remark, 1);
            if (this.netname != null) {
                ndrBuffer = ndrBuffer.deferred;
                ndrBuffer.enc_ndr_string(this.netname);
            }
            if (this.remark != null) {
                ndrBuffer = ndrBuffer.deferred;
                ndrBuffer.enc_ndr_string(this.remark);
            }
        }

        public void decode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            int n2 = ndrBuffer.dec_ndr_long();
            this.type = ndrBuffer.dec_ndr_long();
            int n3 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                this.netname = ndrBuffer.dec_ndr_string();
            }
            if (n3 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                this.remark = ndrBuffer.dec_ndr_string();
            }
        }
    }

    public static class ShareInfoCtr0
    extends NdrObject {
        public int count;
        public ShareInfo0[] array;

        public void encode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.enc_ndr_long(this.count);
            ndrBuffer.enc_ndr_referent(this.array, 1);
            if (this.array != null) {
                ndrBuffer = ndrBuffer.deferred;
                int n2 = this.count;
                ndrBuffer.enc_ndr_long(n2);
                int n3 = ndrBuffer.index;
                ndrBuffer.advance(4 * n2);
                ndrBuffer = ndrBuffer.derive(n3);
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.array[i2].encode(ndrBuffer);
                }
            }
        }

        public void decode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            this.count = ndrBuffer.dec_ndr_long();
            int n2 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                int n3 = ndrBuffer.dec_ndr_long();
                int n4 = ndrBuffer.index;
                ndrBuffer.advance(4 * n3);
                if (this.array == null) {
                    if (n3 < 0 || n3 > 65535) {
                        throw new NdrException("invalid array conformance");
                    }
                    this.array = new ShareInfo0[n3];
                }
                ndrBuffer = ndrBuffer.derive(n4);
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (this.array[i2] == null) {
                        this.array[i2] = new ShareInfo0();
                    }
                    this.array[i2].decode(ndrBuffer);
                }
            }
        }
    }

    public static class ShareInfo0
    extends NdrObject {
        public String netname;

        public void encode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            ndrBuffer.enc_ndr_referent(this.netname, 1);
            if (this.netname != null) {
                ndrBuffer = ndrBuffer.deferred;
                ndrBuffer.enc_ndr_string(this.netname);
            }
        }

        public void decode(NdrBuffer ndrBuffer) throws NdrException {
            ndrBuffer.align(4);
            int n2 = ndrBuffer.dec_ndr_long();
            if (n2 != 0) {
                ndrBuffer = ndrBuffer.deferred;
                this.netname = ndrBuffer.dec_ndr_string();
            }
        }
    }
}

