/*
 * Decompiled with CFR 0.152.
 */
package jcifs.dcerpc.ndr;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import jcifs.dcerpc.ndr.NdrException;
import jcifs.util.Encdec;

public class NdrBuffer {
    int referent;
    HashMap referents;
    public byte[] buf;
    public int start;
    public int index;
    public int length;
    public NdrBuffer deferred;

    public NdrBuffer(byte[] byArray, int n2) {
        this.buf = byArray;
        this.start = this.index = n2;
        this.length = 0;
        this.deferred = this;
    }

    public NdrBuffer derive(int n2) {
        NdrBuffer ndrBuffer = new NdrBuffer(this.buf, this.start);
        ndrBuffer.index = n2;
        ndrBuffer.deferred = this.deferred;
        return ndrBuffer;
    }

    public void reset() {
        this.index = this.start;
        this.length = 0;
        this.deferred = this;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n2) {
        this.index = n2;
    }

    public int getCapacity() {
        return this.buf.length - this.start;
    }

    public int getTailSpace() {
        return this.buf.length - this.index;
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public int align(int n2, byte by) {
        int n3;
        for (int i2 = n3 = this.align(n2); i2 > 0; --i2) {
            this.buf[this.index - i2] = by;
        }
        return n3;
    }

    public void writeOctetArray(byte[] byArray, int n2, int n3) {
        System.arraycopy(byArray, n2, this.buf, this.index, n3);
        this.advance(n3);
    }

    public void readOctetArray(byte[] byArray, int n2, int n3) {
        System.arraycopy(this.buf, this.index, byArray, n2, n3);
        this.advance(n3);
    }

    public int getLength() {
        return this.deferred.length;
    }

    public void setLength(int n2) {
        this.deferred.length = n2;
    }

    public void advance(int n2) {
        this.index += n2;
        if (this.index - this.start > this.deferred.length) {
            this.deferred.length = this.index - this.start;
        }
    }

    public int align(int n2) {
        int n3 = n2 - 1;
        int n4 = this.index - this.start;
        int n5 = (n4 + n3 & ~n3) - n4;
        this.advance(n5);
        return n5;
    }

    public void enc_ndr_small(int n2) {
        this.buf[this.index] = (byte)(n2 & 0xFF);
        this.advance(1);
    }

    public int dec_ndr_small() {
        int n2 = this.buf[this.index] & 0xFF;
        this.advance(1);
        return n2;
    }

    public void enc_ndr_short(int n2) {
        this.align(2);
        Encdec.enc_uint16le((short)n2, this.buf, this.index);
        this.advance(2);
    }

    public int dec_ndr_short() {
        this.align(2);
        short s = Encdec.dec_uint16le(this.buf, this.index);
        this.advance(2);
        return s;
    }

    public void enc_ndr_long(int n2) {
        this.align(4);
        Encdec.enc_uint32le(n2, this.buf, this.index);
        this.advance(4);
    }

    public int dec_ndr_long() {
        this.align(4);
        int n2 = Encdec.dec_uint32le(this.buf, this.index);
        this.advance(4);
        return n2;
    }

    public void enc_ndr_hyper(long l2) {
        this.align(8);
        Encdec.enc_uint64le(l2, this.buf, this.index);
        this.advance(8);
    }

    public long dec_ndr_hyper() {
        this.align(8);
        long l2 = Encdec.dec_uint64le(this.buf, this.index);
        this.advance(8);
        return l2;
    }

    public void enc_ndr_string(String string) {
        this.align(4);
        int n2 = this.index;
        int n3 = string.length();
        Encdec.enc_uint32le(n3 + 1, this.buf, n2);
        Encdec.enc_uint32le(0, this.buf, n2 += 4);
        Encdec.enc_uint32le(n3 + 1, this.buf, n2 += 4);
        n2 += 4;
        try {
            System.arraycopy(string.getBytes("UTF-16LE"), 0, this.buf, n2, n3 * 2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        n2 += n3 * 2;
        this.buf[n2++] = 0;
        this.buf[n2++] = 0;
        this.advance(n2 - this.index);
    }

    public String dec_ndr_string() throws NdrException {
        this.align(4);
        int n2 = this.index;
        String string = null;
        int n3 = Encdec.dec_uint32le(this.buf, n2);
        n2 += 12;
        if (n3 != 0) {
            int n4 = --n3 * 2;
            try {
                if (n4 < 0 || n4 > 65535) {
                    throw new NdrException("invalid array conformance");
                }
                string = new String(this.buf, n2, n4, "UTF-16LE");
                n2 += n4 + 2;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        this.advance(n2 - this.index);
        return string;
    }

    private int a(Object object) {
        Entry entry;
        if (this.referents == null) {
            this.referents = new HashMap();
            this.referent = 1;
        }
        if ((entry = (Entry)this.referents.get(object)) == null) {
            entry = new Entry();
            entry.referent = this.referent++;
            entry.obj = object;
            this.referents.put(object, entry);
        }
        return entry.referent;
    }

    public void enc_ndr_referent(Object object, int n2) {
        if (object == null) {
            this.enc_ndr_long(0);
            return;
        }
        switch (n2) {
            case 1: 
            case 3: {
                this.enc_ndr_long(System.identityHashCode(object));
                return;
            }
            case 2: {
                this.enc_ndr_long(this.a(object));
                return;
            }
        }
    }

    public String toString() {
        return "start=" + this.start + ",index=" + this.index + ",length=" + this.getLength();
    }

    static class Entry {
        int referent;
        Object obj;

        Entry() {
        }
    }
}

