/*
 * Decompiled with CFR 0.152.
 */
package jcifs.netbios;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.StringTokenizer;
import jcifs.Config;
import jcifs.netbios.Lmhosts;
import jcifs.netbios.Name;
import jcifs.netbios.NameQueryRequest;
import jcifs.netbios.NameQueryResponse;
import jcifs.netbios.NameServicePacket;
import jcifs.netbios.NbtAddress;
import jcifs.netbios.NodeStatusRequest;
import jcifs.netbios.NodeStatusResponse;
import jcifs.util.Hexdump;
import jcifs.util.LogStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class NameServiceClient
implements Runnable {
    static final int DEFAULT_SO_TIMEOUT = 5000;
    static final int DEFAULT_RCV_BUF_SIZE = 576;
    static final int DEFAULT_SND_BUF_SIZE = 576;
    static final int NAME_SERVICE_UDP_PORT = 137;
    static final int DEFAULT_RETRY_COUNT = 2;
    static final int DEFAULT_RETRY_TIMEOUT = 3000;
    static final int RESOLVER_LMHOSTS = 1;
    static final int RESOLVER_BCAST = 2;
    static final int RESOLVER_WINS = 3;
    private static final int goto = Config.getInt("jcifs.netbios.snd_buf_size", 576);
    private static final int b = Config.getInt("jcifs.netbios.rcv_buf_size", 576);
    private static final int g = Config.getInt("jcifs.netbios.soTimeout", 5000);
    private static final int f = Config.getInt("jcifs.netbios.retryCount", 2);
    private static final int int = Config.getInt("jcifs.netbios.retryTimeout", 3000);
    private static final int void = Config.getInt("jcifs.netbios.lport", 0);
    private static final InetAddress long = Config.getInetAddress("jcifs.netbios.laddr", null);
    private static final String try = Config.getProperty("jcifs.resolveOrder");
    private static LogStream byte = LogStream.getInstance();
    private final Object new = new Object();
    private int if;
    private int char;
    private byte[] d;
    private byte[] a;
    private DatagramSocket else;
    private DatagramPacket case;
    private DatagramPacket c;
    private HashMap e = new HashMap();
    private Thread for;
    private int h = 0;
    private int[] do;
    InetAddress laddr;
    InetAddress baddr;

    NameServiceClient() {
        this(void, long);
    }

    NameServiceClient(int n2, InetAddress inetAddress) {
        this.if = n2;
        this.laddr = inetAddress;
        try {
            this.baddr = Config.getInetAddress("jcifs.netbios.baddr", InetAddress.getByName("255.255.255.255"));
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.d = new byte[goto];
        this.a = new byte[b];
        this.c = new DatagramPacket(this.d, goto, this.baddr, 137);
        this.case = new DatagramPacket(this.a, b);
        if (try == null || try.length() == 0) {
            if (NbtAddress.getWINSAddress() == null) {
                this.do = new int[2];
                this.do[0] = 1;
                this.do[1] = 2;
            } else {
                this.do = new int[3];
                this.do[0] = 1;
                this.do[1] = 3;
                this.do[2] = 2;
            }
        } else {
            int[] nArray = new int[3];
            StringTokenizer stringTokenizer = new StringTokenizer(try, ",");
            int n3 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken().trim();
                if (string.equalsIgnoreCase("LMHOSTS")) {
                    nArray[n3++] = 1;
                    continue;
                }
                if (string.equalsIgnoreCase("WINS")) {
                    if (NbtAddress.getWINSAddress() == null) {
                        if (LogStream.level <= 1) continue;
                        byte.println("NetBIOS resolveOrder specifies WINS however the jcifs.netbios.wins property has not been set");
                        continue;
                    }
                    nArray[n3++] = 3;
                    continue;
                }
                if (string.equalsIgnoreCase("BCAST")) {
                    nArray[n3++] = 2;
                    continue;
                }
                if (string.equalsIgnoreCase("DNS")) continue;
                if (LogStream.level <= 1) continue;
                byte.println("unknown resolver method: " + string);
            }
            this.do = new int[n3];
            System.arraycopy(nArray, 0, this.do, 0, n3);
        }
    }

    int getNextNameTrnId() {
        if ((++this.h & 0xFFFF) == 0) {
            this.h = 1;
        }
        return this.h;
    }

    void ensureOpen(int n2) throws IOException {
        this.char = 0;
        if (g != 0) {
            this.char = Math.max(g, n2);
        }
        if (this.else == null) {
            this.else = new DatagramSocket(this.if, this.laddr);
            this.for = new Thread((Runnable)this, "JCIFS-NameServiceClient");
            this.for.setDaemon(true);
            this.for.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryClose() {
        Object object = this.new;
        synchronized (object) {
            if (this.else != null) {
                this.else.close();
                this.else = null;
            }
            this.for = null;
            this.e.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (this.for == Thread.currentThread()) {
                int n2;
                NameServicePacket nameServicePacket;
                this.case.setLength(b);
                this.else.setSoTimeout(this.char);
                this.else.receive(this.case);
                if (LogStream.level > 3) {
                    byte.println("NetBIOS: new data read from socket");
                }
                if ((nameServicePacket = (NameServicePacket)this.e.get(new Integer(n2 = NameServicePacket.readNameTrnId(this.a, 0)))) == null || nameServicePacket.received) continue;
                NameServicePacket nameServicePacket2 = nameServicePacket;
                synchronized (nameServicePacket2) {
                    nameServicePacket.readWireFormat(this.a, 0);
                    nameServicePacket.received = true;
                    if (LogStream.level > 3) {
                        byte.println(nameServicePacket);
                        Hexdump.hexdump(byte, this.a, 0, this.case.getLength());
                    }
                    nameServicePacket.notify();
                }
            }
            return;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return;
        }
        catch (Exception exception) {
            if (LogStream.level <= 2) return;
            exception.printStackTrace(byte);
            return;
        }
        finally {
            this.tryClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void send(NameServicePacket var1_1, NameServicePacket var2_2, int var3_3) throws IOException {
        var4_4 = null;
        var5_5 = NbtAddress.NBNS.length;
        if (var5_5 == 0) {
            var5_5 = 1;
        }
        var6_6 = var2_2;
        synchronized (var6_6) {
            while (var5_5-- > 0) {
                block19: {
                    block18: {
                        try {
                            var7_7 = this.new;
                            synchronized (var7_7) {
                                var1_1.nameTrnId = this.getNextNameTrnId();
                                var4_4 = new Integer(var1_1.nameTrnId);
                                this.c.setAddress(var1_1.addr);
                                this.c.setLength(var1_1.writeWireFormat(this.d, 0));
                                var2_2.received = false;
                                this.e.put(var4_4, var2_2);
                                this.ensureOpen(var3_3 + 1000);
                                this.else.send(this.c);
                                if (LogStream.level > 3) {
                                    NameServiceClient.byte.println(var1_1);
                                    Hexdump.hexdump(NameServiceClient.byte, this.d, 0, this.c.getLength());
                                }
                            }
                            var7_8 = System.currentTimeMillis();
lbl25:
                            // 2 sources

                            while (var3_3 > 0) {
                                var2_2.wait(var3_3);
                                if (var2_2.received && var1_1.questionType == var2_2.recordType) {
                                    this.e.remove(var4_4);
                                    break block18;
                                }
                                ** GOTO lbl-1000
                            }
                            break block19;
                        }
                        catch (InterruptedException var7_9) {
                            try {
                                throw new IOException(var7_9.getMessage());
                            }
                            catch (Throwable var9_11) {
                                this.e.remove(var4_4);
                                throw var9_11;
                            }
                        }
                    }
                    return;
lbl-1000:
                    // 1 sources

                    {
                        var2_2.received = false;
                        var3_3 = (int)((long)var3_3 - (System.currentTimeMillis() - var7_8));
                        ** GOTO lbl25
                    }
                }
                this.e.remove(var4_4);
                var7_7 = this.new;
                synchronized (var7_7) {
                    if (!NbtAddress.isWINS(var1_1.addr)) {
                        return;
                    }
                    if (var1_1.addr == NbtAddress.getWINSAddress()) {
                        NbtAddress.switchWINS();
                    }
                    var1_1.addr = NbtAddress.getWINSAddress();
                }
            }
            return;
        }
    }

    NbtAddress[] getAllByName(Name name, InetAddress inetAddress) throws UnknownHostException {
        int n2;
        NameQueryRequest nameQueryRequest = new NameQueryRequest(name);
        NameQueryResponse nameQueryResponse = new NameQueryResponse();
        nameQueryRequest.addr = inetAddress != null ? inetAddress : NbtAddress.getWINSAddress();
        boolean bl = nameQueryRequest.isBroadcast = nameQueryRequest.addr == null;
        if (nameQueryRequest.isBroadcast) {
            nameQueryRequest.addr = this.baddr;
            n2 = f;
        } else {
            nameQueryRequest.isBroadcast = false;
            n2 = 1;
        }
        do {
            try {
                this.send(nameQueryRequest, nameQueryResponse, int);
            }
            catch (IOException iOException) {
                if (LogStream.level > 1) {
                    iOException.printStackTrace(byte);
                }
                throw new UnknownHostException(name.name);
            }
            if (!nameQueryResponse.received || nameQueryResponse.resultCode != 0) continue;
            return nameQueryResponse.addrEntry;
        } while (--n2 > 0 && nameQueryRequest.isBroadcast);
        throw new UnknownHostException(name.name);
    }

    NbtAddress getByName(Name name, InetAddress inetAddress) throws UnknownHostException {
        NameQueryRequest nameQueryRequest = new NameQueryRequest(name);
        NameQueryResponse nameQueryResponse = new NameQueryResponse();
        if (inetAddress != null) {
            nameQueryRequest.addr = inetAddress;
            nameQueryRequest.isBroadcast = inetAddress.getAddress()[3] == -1;
            int n2 = f;
            do {
                try {
                    this.send(nameQueryRequest, nameQueryResponse, int);
                }
                catch (IOException iOException) {
                    if (LogStream.level > 1) {
                        iOException.printStackTrace(byte);
                    }
                    throw new UnknownHostException(name.name);
                }
                if (!nameQueryResponse.received || nameQueryResponse.resultCode != 0) continue;
                int n3 = nameQueryResponse.addrEntry.length - 1;
                nameQueryResponse.addrEntry[n3].hostName.srcHashCode = inetAddress.hashCode();
                return nameQueryResponse.addrEntry[n3];
            } while (--n2 > 0 && nameQueryRequest.isBroadcast);
            throw new UnknownHostException(name.name);
        }
        for (int i2 = 0; i2 < this.do.length; ++i2) {
            try {
                block3 : switch (this.do[i2]) {
                    case 1: {
                        NbtAddress nbtAddress = Lmhosts.getByName(name);
                        if (nbtAddress == null) break;
                        nbtAddress.hostName.srcHashCode = 0;
                        return nbtAddress;
                    }
                    case 2: 
                    case 3: {
                        if (this.do[i2] == 3 && name.name != "\u0001\u0002__MSBROWSE__\u0002" && name.hexCode != 29) {
                            nameQueryRequest.addr = NbtAddress.getWINSAddress();
                            nameQueryRequest.isBroadcast = false;
                        } else {
                            nameQueryRequest.addr = this.baddr;
                            nameQueryRequest.isBroadcast = true;
                        }
                        int n4 = f;
                        while (n4-- > 0) {
                            try {
                                this.send(nameQueryRequest, nameQueryResponse, int);
                            }
                            catch (IOException iOException) {
                                if (LogStream.level > 1) {
                                    iOException.printStackTrace(byte);
                                }
                                throw new UnknownHostException(name.name);
                            }
                            if (nameQueryResponse.received && nameQueryResponse.resultCode == 0) {
                                nameQueryResponse.addrEntry[0].hostName.srcHashCode = nameQueryRequest.addr.hashCode();
                                return nameQueryResponse.addrEntry[0];
                            }
                            if (this.do[i2] != 3) continue;
                            break block3;
                        }
                        break;
                    }
                }
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new UnknownHostException(name.name);
    }

    NbtAddress[] getNodeStatus(NbtAddress nbtAddress) throws UnknownHostException {
        NodeStatusResponse nodeStatusResponse = new NodeStatusResponse(nbtAddress);
        NodeStatusRequest nodeStatusRequest = new NodeStatusRequest(new Name("*\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000", 0, null));
        nodeStatusRequest.addr = nbtAddress.getInetAddress();
        int n2 = f;
        while (n2-- > 0) {
            try {
                this.send(nodeStatusRequest, nodeStatusResponse, int);
            }
            catch (IOException iOException) {
                if (LogStream.level > 1) {
                    iOException.printStackTrace(byte);
                }
                throw new UnknownHostException(nbtAddress.toString());
            }
            if (!nodeStatusResponse.received || nodeStatusResponse.resultCode != 0) continue;
            int n3 = nodeStatusRequest.addr.hashCode();
            for (int i2 = 0; i2 < nodeStatusResponse.addressArray.length; ++i2) {
                nodeStatusResponse.addressArray[i2].hostName.srcHashCode = n3;
            }
            return nodeStatusResponse.addressArray;
        }
        throw new UnknownHostException(nbtAddress.hostName.name);
    }
}

