/*
 * Decompiled with CFR 0.152.
 */
package jcifs.netbios;

import java.net.InetAddress;
import jcifs.netbios.Name;
import jcifs.netbios.NbtAddress;
import jcifs.util.Hexdump;

abstract class NameServicePacket {
    static final int QUERY = 0;
    static final int WACK = 7;
    static final int FMT_ERR = 1;
    static final int SRV_ERR = 2;
    static final int IMP_ERR = 4;
    static final int RFS_ERR = 5;
    static final int ACT_ERR = 6;
    static final int CFT_ERR = 7;
    static final int NB_IN = 0x200001;
    static final int NBSTAT_IN = 0x210001;
    static final int NB = 32;
    static final int NBSTAT = 33;
    static final int IN = 1;
    static final int A = 1;
    static final int NS = 2;
    static final int NULL = 10;
    static final int HEADER_LENGTH = 12;
    static final int OPCODE_OFFSET = 2;
    static final int QUESTION_OFFSET = 4;
    static final int ANSWER_OFFSET = 6;
    static final int AUTHORITY_OFFSET = 8;
    static final int ADDITIONAL_OFFSET = 10;
    int addrIndex;
    NbtAddress[] addrEntry;
    int nameTrnId;
    int opCode;
    int resultCode;
    int questionCount = 1;
    int answerCount;
    int authorityCount;
    int additionalCount;
    boolean received;
    boolean isResponse;
    boolean isAuthAnswer;
    boolean isTruncated;
    boolean isRecurDesired = true;
    boolean isRecurAvailable;
    boolean isBroadcast = true;
    Name questionName;
    Name recordName;
    int questionType;
    int questionClass = 1;
    int recordType;
    int recordClass;
    int ttl;
    int rDataLength;
    InetAddress addr;

    static void writeInt2(int n2, byte[] byArray, int n3) {
        byArray[n3++] = (byte)(n2 >> 8 & 0xFF);
        byArray[n3] = (byte)(n2 & 0xFF);
    }

    static void writeInt4(int n2, byte[] byArray, int n3) {
        byArray[n3++] = (byte)(n2 >> 24 & 0xFF);
        byArray[n3++] = (byte)(n2 >> 16 & 0xFF);
        byArray[n3++] = (byte)(n2 >> 8 & 0xFF);
        byArray[n3] = (byte)(n2 & 0xFF);
    }

    static int readInt2(byte[] byArray, int n2) {
        return ((byArray[n2] & 0xFF) << 8) + (byArray[n2 + 1] & 0xFF);
    }

    static int readInt4(byte[] byArray, int n2) {
        return ((byArray[n2] & 0xFF) << 24) + ((byArray[n2 + 1] & 0xFF) << 16) + ((byArray[n2 + 2] & 0xFF) << 8) + (byArray[n2 + 3] & 0xFF);
    }

    static int readNameTrnId(byte[] byArray, int n2) {
        return NameServicePacket.readInt2(byArray, n2);
    }

    NameServicePacket() {
    }

    int writeWireFormat(byte[] byArray, int n2) {
        int n3 = n2;
        n2 += this.writeHeaderWireFormat(byArray, n2);
        n2 += this.writeBodyWireFormat(byArray, n2);
        return n2 - n3;
    }

    int readWireFormat(byte[] byArray, int n2) {
        int n3 = n2;
        n2 += this.readHeaderWireFormat(byArray, n2);
        n2 += this.readBodyWireFormat(byArray, n2);
        return n2 - n3;
    }

    int writeHeaderWireFormat(byte[] byArray, int n2) {
        int n3 = n2;
        NameServicePacket.writeInt2(this.nameTrnId, byArray, n2);
        byArray[n2 + 2] = (byte)((this.isResponse ? 128 : 0) + (this.opCode << 3 & 0x78) + (this.isAuthAnswer ? 4 : 0) + (this.isTruncated ? 2 : 0) + (this.isRecurDesired ? 1 : 0));
        byArray[n2 + 2 + 1] = (byte)((this.isRecurAvailable ? 128 : 0) + (this.isBroadcast ? 16 : 0) + (this.resultCode & 0xF));
        NameServicePacket.writeInt2(this.questionCount, byArray, n3 + 4);
        NameServicePacket.writeInt2(this.answerCount, byArray, n3 + 6);
        NameServicePacket.writeInt2(this.authorityCount, byArray, n3 + 8);
        NameServicePacket.writeInt2(this.additionalCount, byArray, n3 + 10);
        return 12;
    }

    int readHeaderWireFormat(byte[] byArray, int n2) {
        this.nameTrnId = NameServicePacket.readInt2(byArray, n2);
        this.isResponse = (byArray[n2 + 2] & 0x80) != 0;
        this.opCode = (byArray[n2 + 2] & 0x78) >> 3;
        this.isAuthAnswer = (byArray[n2 + 2] & 4) != 0;
        this.isTruncated = (byArray[n2 + 2] & 2) != 0;
        this.isRecurDesired = (byArray[n2 + 2] & 1) != 0;
        this.isRecurAvailable = (byArray[n2 + 2 + 1] & 0x80) != 0;
        this.isBroadcast = (byArray[n2 + 2 + 1] & 0x10) != 0;
        this.resultCode = byArray[n2 + 2 + 1] & 0xF;
        this.questionCount = NameServicePacket.readInt2(byArray, n2 + 4);
        this.answerCount = NameServicePacket.readInt2(byArray, n2 + 6);
        this.authorityCount = NameServicePacket.readInt2(byArray, n2 + 8);
        this.additionalCount = NameServicePacket.readInt2(byArray, n2 + 10);
        return 12;
    }

    int writeQuestionSectionWireFormat(byte[] byArray, int n2) {
        int n3 = n2;
        n2 += this.questionName.writeWireFormat(byArray, n2);
        NameServicePacket.writeInt2(this.questionType, byArray, n2);
        NameServicePacket.writeInt2(this.questionClass, byArray, n2 += 2);
        return (n2 += 2) - n3;
    }

    int readQuestionSectionWireFormat(byte[] byArray, int n2) {
        int n3 = n2;
        n2 += this.questionName.readWireFormat(byArray, n2);
        this.questionType = NameServicePacket.readInt2(byArray, n2);
        this.questionClass = NameServicePacket.readInt2(byArray, n2 += 2);
        return (n2 += 2) - n3;
    }

    int writeResourceRecordWireFormat(byte[] byArray, int n2) {
        int n3 = n2;
        if (this.recordName == this.questionName) {
            byArray[n2++] = -64;
            byArray[n2++] = 12;
        } else {
            n2 += this.recordName.writeWireFormat(byArray, n2);
        }
        NameServicePacket.writeInt2(this.recordType, byArray, n2);
        NameServicePacket.writeInt2(this.recordClass, byArray, n2 += 2);
        NameServicePacket.writeInt4(this.ttl, byArray, n2 += 2);
        this.rDataLength = this.writeRDataWireFormat(byArray, (n2 += 4) + 2);
        NameServicePacket.writeInt2(this.rDataLength, byArray, n2);
        return (n2 += 2 + this.rDataLength) - n3;
    }

    int readResourceRecordWireFormat(byte[] byArray, int n2) {
        int n3 = n2;
        if ((byArray[n2] & 0xC0) == 192) {
            this.recordName = this.questionName;
            n2 += 2;
        } else {
            n2 += this.recordName.readWireFormat(byArray, n2);
        }
        this.recordType = NameServicePacket.readInt2(byArray, n2);
        this.recordClass = NameServicePacket.readInt2(byArray, n2 += 2);
        this.ttl = NameServicePacket.readInt4(byArray, n2 += 2);
        this.rDataLength = NameServicePacket.readInt2(byArray, n2 += 4);
        this.addrEntry = new NbtAddress[this.rDataLength / 6];
        int n4 = (n2 += 2) + this.rDataLength;
        this.addrIndex = 0;
        while (n2 < n4) {
            n2 += this.readRDataWireFormat(byArray, n2);
            ++this.addrIndex;
        }
        return n2 - n3;
    }

    abstract int writeBodyWireFormat(byte[] var1, int var2);

    abstract int readBodyWireFormat(byte[] var1, int var2);

    abstract int writeRDataWireFormat(byte[] var1, int var2);

    abstract int readRDataWireFormat(byte[] var1, int var2);

    public String toString() {
        String string;
        String string2;
        String string3;
        switch (this.opCode) {
            case 0: {
                string3 = "QUERY";
                break;
            }
            case 7: {
                string3 = "WACK";
                break;
            }
            default: {
                string3 = Integer.toString(this.opCode);
            }
        }
        switch (this.resultCode) {
            case 1: {
                String string4 = "FMT_ERR";
                break;
            }
            case 2: {
                String string5 = "SRV_ERR";
                break;
            }
            case 4: {
                String string6 = "IMP_ERR";
                break;
            }
            case 5: {
                String string7 = "RFS_ERR";
                break;
            }
            case 6: {
                String string8 = "ACT_ERR";
                break;
            }
            case 7: {
                String string9 = "CFT_ERR";
                break;
            }
            default: {
                String string10 = "0x" + Hexdump.toHexString(this.resultCode, 1);
            }
        }
        switch (this.questionType) {
            case 32: {
                string2 = "NB";
                break;
            }
            case 33: {
                string2 = "NBSTAT";
                break;
            }
            default: {
                string2 = "0x" + Hexdump.toHexString(this.questionType, 4);
            }
        }
        switch (this.recordType) {
            case 1: {
                string = "A";
                break;
            }
            case 2: {
                string = "NS";
                break;
            }
            case 10: {
                string = "NULL";
                break;
            }
            case 32: {
                string = "NB";
                break;
            }
            case 33: {
                string = "NBSTAT";
                break;
            }
            default: {
                string = "0x" + Hexdump.toHexString(this.recordType, 4);
            }
        }
        return new String("nameTrnId=" + this.nameTrnId + ",isResponse=" + this.isResponse + ",opCode=" + string3 + ",isAuthAnswer=" + this.isAuthAnswer + ",isTruncated=" + this.isTruncated + ",isRecurAvailable=" + this.isRecurAvailable + ",isRecurDesired=" + this.isRecurDesired + ",isBroadcast=" + this.isBroadcast + ",resultCode=" + this.resultCode + ",questionCount=" + this.questionCount + ",answerCount=" + this.answerCount + ",authorityCount=" + this.authorityCount + ",additionalCount=" + this.additionalCount + ",questionName=" + this.questionName + ",questionType=" + string2 + ",questionClass=" + (this.questionClass == 1 ? "IN" : "0x" + Hexdump.toHexString(this.questionClass, 4)) + ",recordName=" + this.recordName + ",recordType=" + string + ",recordClass=" + (this.recordClass == 1 ? "IN" : "0x" + Hexdump.toHexString(this.recordClass, 4)) + ",ttl=" + this.ttl + ",rDataLength=" + this.rDataLength);
    }
}

