/*
 * Decompiled with CFR 0.152.
 */
package jcifs.netbios;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import jcifs.Config;
import jcifs.netbios.Name;
import jcifs.netbios.NameServiceClient;
import jcifs.util.Hexdump;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class NbtAddress {
    static final String ANY_HOSTS_NAME = "*\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000";
    public static final String MASTER_BROWSER_NAME = "\u0001\u0002__MSBROWSE__\u0002";
    public static final String SMBSERVER_NAME = "*SMBSERVER     ";
    public static final int B_NODE = 0;
    public static final int P_NODE = 1;
    public static final int M_NODE = 2;
    public static final int H_NODE = 3;
    static final InetAddress[] NBNS;
    private static final NameServiceClient a;
    private static final int new = 30;
    private static final int do;
    private static final int int = -1;
    private static int for;
    private static final HashMap try;
    private static final HashMap if;
    static final Name UNKNOWN_NAME;
    static final NbtAddress UNKNOWN_ADDRESS;
    static final byte[] UNKNOWN_MAC_ADDRESS;
    static NbtAddress localhost;
    Name hostName;
    int address;
    int nodeType;
    boolean groupName;
    boolean isBeingDeleted;
    boolean isInConflict;
    boolean isActive;
    boolean isPermanent;
    boolean isDataFromNodeStatus;
    byte[] macAddress;
    String calledName;

    static void cacheAddress(Name name, NbtAddress nbtAddress) {
        if (do == 0) {
            return;
        }
        long l2 = -1L;
        if (do != -1) {
            l2 = System.currentTimeMillis() + (long)(do * 1000);
        }
        NbtAddress.cacheAddress(name, nbtAddress, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cacheAddress(Name name, NbtAddress nbtAddress, long l2) {
        if (do == 0) {
            return;
        }
        HashMap hashMap = try;
        synchronized (hashMap) {
            CacheEntry cacheEntry = (CacheEntry)try.get(name);
            if (cacheEntry == null) {
                cacheEntry = new CacheEntry(name, nbtAddress, l2);
                try.put(name, cacheEntry);
            } else {
                cacheEntry.address = nbtAddress;
                cacheEntry.expiration = l2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cacheAddressArray(NbtAddress[] nbtAddressArray) {
        if (do == 0) {
            return;
        }
        long l2 = -1L;
        if (do != -1) {
            l2 = System.currentTimeMillis() + (long)(do * 1000);
        }
        HashMap hashMap = try;
        synchronized (hashMap) {
            for (int i2 = 0; i2 < nbtAddressArray.length; ++i2) {
                CacheEntry cacheEntry = (CacheEntry)try.get(nbtAddressArray[i2].hostName);
                if (cacheEntry == null) {
                    cacheEntry = new CacheEntry(nbtAddressArray[i2].hostName, nbtAddressArray[i2], l2);
                    try.put(nbtAddressArray[i2].hostName, cacheEntry);
                    continue;
                }
                cacheEntry.address = nbtAddressArray[i2];
                cacheEntry.expiration = l2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static NbtAddress getCachedAddress(Name name) {
        if (do == 0) {
            return null;
        }
        HashMap hashMap = try;
        synchronized (hashMap) {
            CacheEntry cacheEntry = (CacheEntry)try.get(name);
            if (cacheEntry != null && cacheEntry.expiration < System.currentTimeMillis() && cacheEntry.expiration >= 0L) {
                cacheEntry = null;
            }
            return cacheEntry != null ? cacheEntry.address : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static NbtAddress doNameQuery(Name name, InetAddress inetAddress) throws UnknownHostException {
        if (name.hexCode == 29 && inetAddress == null) {
            inetAddress = NbtAddress.a.baddr;
        }
        name.srcHashCode = inetAddress != null ? inetAddress.hashCode() : 0;
        NbtAddress nbtAddress = NbtAddress.getCachedAddress(name);
        if (nbtAddress == null && (nbtAddress = (NbtAddress)NbtAddress.if(name)) == null) {
            try {
                nbtAddress = a.getByName(name, inetAddress);
            }
            catch (UnknownHostException unknownHostException) {
                nbtAddress = UNKNOWN_ADDRESS;
            }
            finally {
                NbtAddress.cacheAddress(name, nbtAddress);
                NbtAddress.a(name);
            }
        }
        if (nbtAddress == UNKNOWN_ADDRESS) {
            throw new UnknownHostException(name.toString());
        }
        return nbtAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object if(Name name) {
        HashMap hashMap = if;
        synchronized (hashMap) {
            if (!if.containsKey(name)) {
                if.put(name, name);
                return null;
            }
            while (if.containsKey(name)) {
                try {
                    if.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        NbtAddress nbtAddress = NbtAddress.getCachedAddress(name);
        if (nbtAddress == null) {
            hashMap = if;
            synchronized (hashMap) {
                if.put(name, name);
            }
        }
        return nbtAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(Name name) {
        HashMap hashMap = if;
        synchronized (hashMap) {
            if.remove(name);
            if.notifyAll();
        }
    }

    public static NbtAddress getLocalHost() throws UnknownHostException {
        return localhost;
    }

    public static Name getLocalName() {
        return NbtAddress.localhost.hostName;
    }

    public static NbtAddress getByName(String string) throws UnknownHostException {
        return NbtAddress.getByName(string, 0, null);
    }

    public static NbtAddress getByName(String string, int n2, String string2) throws UnknownHostException {
        return NbtAddress.getByName(string, n2, string2, null);
    }

    public static NbtAddress getByName(String string, int n2, String string2, InetAddress inetAddress) throws UnknownHostException {
        if (string == null || string.length() == 0) {
            return NbtAddress.getLocalHost();
        }
        if (!Character.isDigit(string.charAt(0))) {
            return NbtAddress.doNameQuery(new Name(string, n2, string2), inetAddress);
        }
        int n3 = 0;
        int n4 = 0;
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            char c2 = cArray[i2];
            if (c2 < '0' || c2 > '9') {
                return NbtAddress.doNameQuery(new Name(string, n2, string2), inetAddress);
            }
            int n5 = 0;
            while (c2 != '.') {
                if (c2 < '0' || c2 > '9') {
                    return NbtAddress.doNameQuery(new Name(string, n2, string2), inetAddress);
                }
                n5 = n5 * 10 + c2 - 48;
                if (++i2 >= cArray.length) break;
                c2 = cArray[i2];
            }
            if (n5 > 255) {
                return NbtAddress.doNameQuery(new Name(string, n2, string2), inetAddress);
            }
            n3 = (n3 << 8) + n5;
            ++n4;
        }
        if (n4 != 4 || string.endsWith(".")) {
            return NbtAddress.doNameQuery(new Name(string, n2, string2), inetAddress);
        }
        return new NbtAddress(UNKNOWN_NAME, n3, false, 0);
    }

    public static NbtAddress[] getAllByName(String string, int n2, String string2, InetAddress inetAddress) throws UnknownHostException {
        return a.getAllByName(new Name(string, n2, string2), inetAddress);
    }

    public static NbtAddress[] getAllByAddress(String string) throws UnknownHostException {
        return NbtAddress.getAllByAddress(NbtAddress.getByName(string, 0, null));
    }

    public static NbtAddress[] getAllByAddress(String string, int n2, String string2) throws UnknownHostException {
        return NbtAddress.getAllByAddress(NbtAddress.getByName(string, n2, string2));
    }

    public static NbtAddress[] getAllByAddress(NbtAddress nbtAddress) throws UnknownHostException {
        try {
            NbtAddress[] nbtAddressArray = a.getNodeStatus(nbtAddress);
            NbtAddress.cacheAddressArray(nbtAddressArray);
            return nbtAddressArray;
        }
        catch (UnknownHostException unknownHostException) {
            throw new UnknownHostException("no name with type 0x" + Hexdump.toHexString(nbtAddress.hostName.hexCode, 2) + (nbtAddress.hostName.scope == null || nbtAddress.hostName.scope.length() == 0 ? " with no scope" : " with scope " + nbtAddress.hostName.scope) + " for host " + nbtAddress.getHostAddress());
        }
    }

    public static InetAddress getWINSAddress() {
        return NBNS.length == 0 ? null : NBNS[for];
    }

    public static boolean isWINS(InetAddress inetAddress) {
        for (int i2 = 0; inetAddress != null && i2 < NBNS.length; ++i2) {
            if (inetAddress.hashCode() != NBNS[i2].hashCode()) continue;
            return true;
        }
        return false;
    }

    static InetAddress switchWINS() {
        for = for + 1 < NBNS.length ? for + 1 : 0;
        return NBNS.length == 0 ? null : NBNS[for];
    }

    NbtAddress(Name name, int n2, boolean bl, int n3) {
        this.hostName = name;
        this.address = n2;
        this.groupName = bl;
        this.nodeType = n3;
    }

    NbtAddress(Name name, int n2, boolean bl, int n3, boolean bl2, boolean bl3, boolean bl4, boolean bl5, byte[] byArray) {
        this.hostName = name;
        this.address = n2;
        this.groupName = bl;
        this.nodeType = n3;
        this.isBeingDeleted = bl2;
        this.isInConflict = bl3;
        this.isActive = bl4;
        this.isPermanent = bl5;
        this.macAddress = byArray;
        this.isDataFromNodeStatus = true;
    }

    public String firstCalledName() {
        this.calledName = this.hostName.name;
        if (Character.isDigit(this.calledName.charAt(0))) {
            int n2 = 0;
            int n3 = 0;
            int n4 = this.calledName.length();
            char[] cArray = this.calledName.toCharArray();
            while (n3 < n4 && Character.isDigit(cArray[n3++])) {
                if (n3 == n4 && n2 == 3) {
                    this.calledName = SMBSERVER_NAME;
                    break;
                }
                if (n3 >= n4 || cArray[n3] != '.') continue;
                ++n2;
                ++n3;
            }
        } else {
            switch (this.hostName.hexCode) {
                case 27: 
                case 28: 
                case 29: {
                    this.calledName = SMBSERVER_NAME;
                }
            }
        }
        return this.calledName;
    }

    public String nextCalledName() {
        if (this.calledName == this.hostName.name) {
            this.calledName = SMBSERVER_NAME;
        } else if (this.calledName == SMBSERVER_NAME) {
            try {
                NbtAddress[] nbtAddressArray = a.getNodeStatus(this);
                if (this.hostName.hexCode == 29) {
                    for (int i2 = 0; i2 < nbtAddressArray.length; ++i2) {
                        if (nbtAddressArray[i2].hostName.hexCode != 32) continue;
                        return nbtAddressArray[i2].hostName.name;
                    }
                    return null;
                }
                if (this.isDataFromNodeStatus) {
                    this.calledName = null;
                    return this.hostName.name;
                }
            }
            catch (UnknownHostException unknownHostException) {
                this.calledName = null;
            }
        } else {
            this.calledName = null;
        }
        return this.calledName;
    }

    void checkData() throws UnknownHostException {
        if (this.hostName == UNKNOWN_NAME) {
            NbtAddress.getAllByAddress(this);
        }
    }

    void checkNodeStatusData() throws UnknownHostException {
        if (!this.isDataFromNodeStatus) {
            NbtAddress.getAllByAddress(this);
        }
    }

    public boolean isGroupAddress() throws UnknownHostException {
        this.checkData();
        return this.groupName;
    }

    public int getNodeType() throws UnknownHostException {
        this.checkData();
        return this.nodeType;
    }

    public boolean isBeingDeleted() throws UnknownHostException {
        this.checkNodeStatusData();
        return this.isBeingDeleted;
    }

    public boolean isInConflict() throws UnknownHostException {
        this.checkNodeStatusData();
        return this.isInConflict;
    }

    public boolean isActive() throws UnknownHostException {
        this.checkNodeStatusData();
        return this.isActive;
    }

    public boolean isPermanent() throws UnknownHostException {
        this.checkNodeStatusData();
        return this.isPermanent;
    }

    public byte[] getMacAddress() throws UnknownHostException {
        this.checkNodeStatusData();
        return this.macAddress;
    }

    public String getHostName() {
        if (this.hostName == UNKNOWN_NAME) {
            return this.getHostAddress();
        }
        return this.hostName.name;
    }

    public byte[] getAddress() {
        byte[] byArray = new byte[]{(byte)(this.address >>> 24 & 0xFF), (byte)(this.address >>> 16 & 0xFF), (byte)(this.address >>> 8 & 0xFF), (byte)(this.address & 0xFF)};
        return byArray;
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        return InetAddress.getByName(this.getHostAddress());
    }

    public String getHostAddress() {
        return (this.address >>> 24 & 0xFF) + "." + (this.address >>> 16 & 0xFF) + "." + (this.address >>> 8 & 0xFF) + "." + (this.address >>> 0 & 0xFF);
    }

    public int getNameType() {
        return this.hostName.hexCode;
    }

    public int hashCode() {
        return this.address;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof NbtAddress && ((NbtAddress)object).address == this.address;
    }

    public String toString() {
        return this.hostName.toString() + "/" + this.getHostAddress();
    }

    static {
        String string;
        NBNS = Config.getInetAddressArray("jcifs.netbios.wins", ",", new InetAddress[0]);
        a = new NameServiceClient();
        do = Config.getInt("jcifs.netbios.cachePolicy", 30);
        for = 0;
        try = new HashMap();
        if = new HashMap();
        UNKNOWN_NAME = new Name("0.0.0.0", 0, null);
        UNKNOWN_ADDRESS = new NbtAddress(UNKNOWN_NAME, 0, false, 0);
        UNKNOWN_MAC_ADDRESS = new byte[]{0, 0, 0, 0, 0, 0};
        try.put(UNKNOWN_NAME, new CacheEntry(UNKNOWN_NAME, UNKNOWN_ADDRESS, -1L));
        InetAddress inetAddress = NbtAddress.a.laddr;
        if (inetAddress == null) {
            try {
                inetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                try {
                    inetAddress = InetAddress.getByName("127.0.0.1");
                }
                catch (UnknownHostException unknownHostException2) {
                    // empty catch block
                }
            }
        }
        if ((string = Config.getProperty("jcifs.netbios.hostname", null)) == null || string.length() == 0) {
            byte[] byArray = inetAddress.getAddress();
            string = "JCIFS" + (byArray[2] & 0xFF) + "_" + (byArray[3] & 0xFF) + "_" + Hexdump.toHexString((int)(Math.random() * 255.0), 2);
        }
        Name name = new Name(string, 0, Config.getProperty("jcifs.netbios.scope", null));
        localhost = new NbtAddress(name, inetAddress.hashCode(), false, 0, false, false, true, false, UNKNOWN_MAC_ADDRESS);
        NbtAddress.cacheAddress(name, localhost, -1L);
    }

    static final class CacheEntry {
        Name hostName;
        NbtAddress address;
        long expiration;

        CacheEntry(Name name, NbtAddress nbtAddress, long l2) {
            this.hostName = name;
            this.address = nbtAddress;
            this.expiration = l2;
        }
    }
}

