/*
 * Decompiled with CFR 0.152.
 */
package jcifs.netbios;

import java.io.IOException;

public class NbtException
extends IOException {
    public static final int SUCCESS = 0;
    public static final int ERR_NAM_SRVC = 1;
    public static final int ERR_SSN_SRVC = 2;
    public static final int FMT_ERR = 1;
    public static final int SRV_ERR = 2;
    public static final int IMP_ERR = 4;
    public static final int RFS_ERR = 5;
    public static final int ACT_ERR = 6;
    public static final int CFT_ERR = 7;
    public static final int CONNECTION_REFUSED = -1;
    public static final int NOT_LISTENING_CALLED = 128;
    public static final int NOT_LISTENING_CALLING = 129;
    public static final int CALLED_NOT_PRESENT = 130;
    public static final int NO_RESOURCES = 131;
    public static final int UNSPECIFIED = 143;
    public int errorClass;
    public int errorCode;

    public static String getErrorString(int n2, int n3) {
        String string = "";
        block0 : switch (n2) {
            case 0: {
                string = string + "SUCCESS";
                break;
            }
            case 1: {
                string = string + "ERR_NAM_SRVC/";
                switch (n3) {
                    case 1: {
                        string = string + "FMT_ERR: Format Error";
                    }
                }
                string = string + "Unknown error code: " + n3;
                break;
            }
            case 2: {
                string = string + "ERR_SSN_SRVC/";
                switch (n3) {
                    case -1: {
                        string = string + "Connection refused";
                        break block0;
                    }
                    case 128: {
                        string = string + "Not listening on called name";
                        break block0;
                    }
                    case 129: {
                        string = string + "Not listening for calling name";
                        break block0;
                    }
                    case 130: {
                        string = string + "Called name not present";
                        break block0;
                    }
                    case 131: {
                        string = string + "Called name present, but insufficient resources";
                        break block0;
                    }
                    case 143: {
                        string = string + "Unspecified error";
                        break block0;
                    }
                }
                string = string + "Unknown error code: " + n3;
                break;
            }
            default: {
                string = string + "unknown error class: " + n2;
            }
        }
        return string;
    }

    public NbtException(int n2, int n3) {
        super(NbtException.getErrorString(n2, n3));
        this.errorClass = n2;
        this.errorCode = n3;
    }

    public String toString() {
        return new String("errorClass=" + this.errorClass + ",errorCode=" + this.errorCode + ",errorString=" + NbtException.getErrorString(this.errorClass, this.errorCode));
    }
}

