/*
 * Decompiled with CFR 0.152.
 */
package jcifs.netbios;

import java.io.IOException;
import java.io.InputStream;

public abstract class SessionServicePacket {
    static final int SESSION_MESSAGE = 0;
    static final int SESSION_REQUEST = 129;
    public static final int POSITIVE_SESSION_RESPONSE = 130;
    public static final int NEGATIVE_SESSION_RESPONSE = 131;
    static final int SESSION_RETARGET_RESPONSE = 132;
    static final int SESSION_KEEP_ALIVE = 133;
    static final int MAX_MESSAGE_SIZE = 131071;
    static final int HEADER_LENGTH = 4;
    int type;
    int length;

    static void writeInt2(int n2, byte[] byArray, int n3) {
        byArray[n3++] = (byte)(n2 >> 8 & 0xFF);
        byArray[n3] = (byte)(n2 & 0xFF);
    }

    static void writeInt4(int n2, byte[] byArray, int n3) {
        byArray[n3++] = (byte)(n2 >> 24 & 0xFF);
        byArray[n3++] = (byte)(n2 >> 16 & 0xFF);
        byArray[n3++] = (byte)(n2 >> 8 & 0xFF);
        byArray[n3] = (byte)(n2 & 0xFF);
    }

    static int readInt2(byte[] byArray, int n2) {
        return ((byArray[n2] & 0xFF) << 8) + (byArray[n2 + 1] & 0xFF);
    }

    static int readInt4(byte[] byArray, int n2) {
        return ((byArray[n2] & 0xFF) << 24) + ((byArray[n2 + 1] & 0xFF) << 16) + ((byArray[n2 + 2] & 0xFF) << 8) + (byArray[n2 + 3] & 0xFF);
    }

    static int readLength(byte[] byArray, int n2) {
        int n3 = ++n2;
        int n4 = ++n2;
        int n5 = ++n2;
        ++n2;
        return ((byArray[n3] & 1) << 16) + ((byArray[n4] & 0xFF) << 8) + (byArray[n5] & 0xFF);
    }

    static int readn(InputStream inputStream, byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5;
        for (n4 = 0; n4 < n3 && (n5 = inputStream.read(byArray, n2 + n4, n3 - n4)) > 0; n4 += n5) {
        }
        return n4;
    }

    static int readPacketType(InputStream inputStream, byte[] byArray, int n2) throws IOException {
        int n3 = SessionServicePacket.readn(inputStream, byArray, n2, 4);
        if (n3 != 4) {
            if (n3 == -1) {
                return -1;
            }
            throw new IOException("unexpected EOF reading netbios session header");
        }
        int n4 = byArray[n2] & 0xFF;
        return n4;
    }

    public int writeWireFormat(byte[] byArray, int n2) {
        this.length = this.writeTrailerWireFormat(byArray, n2 + 4);
        this.writeHeaderWireFormat(byArray, n2);
        return 4 + this.length;
    }

    int readWireFormat(InputStream inputStream, byte[] byArray, int n2) throws IOException {
        this.readHeaderWireFormat(inputStream, byArray, n2);
        return 4 + this.readTrailerWireFormat(inputStream, byArray, n2);
    }

    int writeHeaderWireFormat(byte[] byArray, int n2) {
        byArray[n2++] = (byte)this.type;
        if (this.length > 65535) {
            byArray[n2] = 1;
        }
        SessionServicePacket.writeInt2(this.length, byArray, ++n2);
        return 4;
    }

    int readHeaderWireFormat(InputStream inputStream, byte[] byArray, int n2) throws IOException {
        this.type = byArray[n2++] & 0xFF;
        this.length = ((byArray[n2] & 1) << 16) + SessionServicePacket.readInt2(byArray, n2 + 1);
        return 4;
    }

    abstract int writeTrailerWireFormat(byte[] var1, int var2);

    abstract int readTrailerWireFormat(InputStream var1, byte[] var2, int var3) throws IOException;
}

