/*
 * Decompiled with CFR 0.152.
 */
package jcifs.ntlmssp;

import java.io.IOException;
import java.net.UnknownHostException;
import jcifs.Config;
import jcifs.netbios.NbtAddress;
import jcifs.ntlmssp.NtlmMessage;
import jcifs.util.Hexdump;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Type1Message
extends NtlmMessage {
    private static final int n = 0x200 | (Config.getBoolean("jcifs.smb.client.useUnicode", true) ? 1 : 2);
    private static final String o = Config.getProperty("jcifs.smb.client.domain", null);
    private static final String m;
    private String l;
    private String k;

    public Type1Message() {
        this(Type1Message.getDefaultFlags(), Type1Message.getDefaultDomain(), Type1Message.getDefaultWorkstation());
    }

    public Type1Message(int n2, String string, String string2) {
        this.setFlags(Type1Message.getDefaultFlags() | n2);
        this.setSuppliedDomain(string);
        if (string2 == null) {
            string2 = Type1Message.getDefaultWorkstation();
        }
        this.setSuppliedWorkstation(string2);
    }

    public Type1Message(byte[] byArray) throws IOException {
        this.do(byArray);
    }

    public String getSuppliedDomain() {
        return this.l;
    }

    public void setSuppliedDomain(String string) {
        this.l = string;
    }

    public String getSuppliedWorkstation() {
        return this.k;
    }

    public void setSuppliedWorkstation(String string) {
        this.k = string;
    }

    public byte[] toByteArray() {
        try {
            String string = this.getSuppliedDomain();
            String string2 = this.getSuppliedWorkstation();
            int n2 = this.getFlags();
            boolean bl = false;
            byte[] byArray = new byte[]{};
            if (string != null && string.length() != 0) {
                bl = true;
                n2 |= 0x1000;
                byArray = string.toUpperCase().getBytes(Type1Message.getOEMEncoding());
            } else {
                n2 &= 0xFFFFEFFF;
            }
            byte[] byArray2 = new byte[]{};
            if (string2 != null && string2.length() != 0) {
                bl = true;
                n2 |= 0x2000;
                byArray2 = string2.toUpperCase().getBytes(Type1Message.getOEMEncoding());
            } else {
                n2 &= 0xFFFFDFFF;
            }
            byte[] byArray3 = new byte[bl ? 32 + byArray.length + byArray2.length : 16];
            System.arraycopy(NTLMSSP_SIGNATURE, 0, byArray3, 0, 8);
            Type1Message.writeULong(byArray3, 8, 1);
            Type1Message.writeULong(byArray3, 12, n2);
            if (bl) {
                Type1Message.writeSecurityBuffer(byArray3, 16, 32, byArray);
                Type1Message.writeSecurityBuffer(byArray3, 24, 32 + byArray.length, byArray2);
            }
            return byArray3;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.getMessage());
        }
    }

    public String toString() {
        String string = this.getSuppliedDomain();
        String string2 = this.getSuppliedWorkstation();
        return "Type1Message[suppliedDomain=" + (string == null ? "null" : string) + ",suppliedWorkstation=" + (string2 == null ? "null" : string2) + ",flags=0x" + Hexdump.toHexString(this.getFlags(), 8) + "]";
    }

    public static int getDefaultFlags() {
        return n;
    }

    public static String getDefaultDomain() {
        return o;
    }

    public static String getDefaultWorkstation() {
        return m;
    }

    private void do(byte[] byArray) throws IOException {
        Object object;
        int n2;
        for (n2 = 0; n2 < 8; ++n2) {
            if (byArray[n2] == NTLMSSP_SIGNATURE[n2]) continue;
            throw new IOException("Not an NTLMSSP message.");
        }
        if (Type1Message.readULong(byArray, 8) != 1) {
            throw new IOException("Not a Type 1 message.");
        }
        n2 = Type1Message.readULong(byArray, 12);
        String string = null;
        if ((n2 & 0x1000) != 0) {
            object = Type1Message.readSecurityBuffer(byArray, 16);
            string = new String((byte[])object, Type1Message.getOEMEncoding());
        }
        object = null;
        if ((n2 & 0x2000) != 0) {
            byte[] byArray2 = Type1Message.readSecurityBuffer(byArray, 24);
            object = new String(byArray2, Type1Message.getOEMEncoding());
        }
        this.setFlags(n2);
        this.setSuppliedDomain(string);
        this.setSuppliedWorkstation((String)object);
    }

    static {
        String string = null;
        try {
            string = NbtAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        m = string;
    }
}

