/*
 * Decompiled with CFR 0.152.
 */
package jcifs.ntlmssp;

import java.io.IOException;
import java.net.UnknownHostException;
import jcifs.Config;
import jcifs.netbios.NbtAddress;
import jcifs.ntlmssp.NtlmMessage;
import jcifs.ntlmssp.Type1Message;
import jcifs.util.Hexdump;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Type2Message
extends NtlmMessage {
    private static final int h = 0x200 | (Config.getBoolean("jcifs.smb.client.useUnicode", true) ? 1 : 2);
    private static final String i = Config.getProperty("jcifs.smb.client.domain", null);
    private static final byte[] j;
    private byte[] f;
    private String g;
    private byte[] e;
    private byte[] d;

    public Type2Message() {
        this(Type2Message.getDefaultFlags(), null, null);
    }

    public Type2Message(Type1Message type1Message) {
        this(type1Message, null, null);
    }

    public Type2Message(Type1Message type1Message, byte[] byArray, String string) {
        this(Type2Message.getDefaultFlags(type1Message), byArray, type1Message != null && string == null && type1Message.getFlag(4) ? Type2Message.getDefaultDomain() : string);
    }

    public Type2Message(int n2, byte[] byArray, String string) {
        this.setFlags(n2);
        this.setChallenge(byArray);
        this.setTarget(string);
        if (string != null) {
            this.setTargetInformation(Type2Message.getDefaultTargetInformation());
        }
    }

    public Type2Message(byte[] byArray) throws IOException {
        this.if(byArray);
    }

    public byte[] getChallenge() {
        return this.f;
    }

    public void setChallenge(byte[] byArray) {
        this.f = byArray;
    }

    public String getTarget() {
        return this.g;
    }

    public void setTarget(String string) {
        this.g = string;
    }

    public byte[] getTargetInformation() {
        return this.d;
    }

    public void setTargetInformation(byte[] byArray) {
        this.d = byArray;
    }

    public byte[] getContext() {
        return this.e;
    }

    public void setContext(byte[] byArray) {
        this.e = byArray;
    }

    public byte[] toByteArray() {
        try {
            String string = this.getTarget();
            byte[] byArray = this.getChallenge();
            byte[] byArray2 = this.getContext();
            byte[] byArray3 = this.getTargetInformation();
            int n2 = this.getFlags();
            byte[] byArray4 = new byte[]{};
            if ((n2 & 0x70000) != 0) {
                if (string != null && string.length() != 0) {
                    byArray4 = (n2 & 1) != 0 ? string.getBytes("UTF-16LE") : string.toUpperCase().getBytes(Type2Message.getOEMEncoding());
                } else {
                    n2 &= 0xFFF8FFFF;
                }
            }
            if (byArray3 != null) {
                n2 |= 0x800000;
                if (byArray2 == null) {
                    byArray2 = new byte[8];
                }
            }
            int n3 = 32;
            if (byArray2 != null) {
                n3 += 8;
            }
            if (byArray3 != null) {
                n3 += 8;
            }
            byte[] byArray5 = new byte[n3 + byArray4.length + (byArray3 != null ? byArray3.length : 0)];
            System.arraycopy(NTLMSSP_SIGNATURE, 0, byArray5, 0, 8);
            Type2Message.writeULong(byArray5, 8, 2);
            Type2Message.writeSecurityBuffer(byArray5, 12, n3, byArray4);
            Type2Message.writeULong(byArray5, 20, n2);
            System.arraycopy(byArray != null ? byArray : new byte[8], 0, byArray5, 24, 8);
            if (byArray2 != null) {
                System.arraycopy(byArray2, 0, byArray5, 32, 8);
            }
            if (byArray3 != null) {
                Type2Message.writeSecurityBuffer(byArray5, 40, n3 + byArray4.length, byArray3);
            }
            return byArray5;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.getMessage());
        }
    }

    public String toString() {
        String string = this.getTarget();
        byte[] byArray = this.getChallenge();
        byte[] byArray2 = this.getContext();
        byte[] byArray3 = this.getTargetInformation();
        return "Type2Message[target=" + string + ",challenge=" + (byArray == null ? "null" : "<" + byArray.length + " bytes>") + ",context=" + (byArray2 == null ? "null" : "<" + byArray2.length + " bytes>") + ",targetInformation=" + (byArray3 == null ? "null" : "<" + byArray3.length + " bytes>") + ",flags=0x" + Hexdump.toHexString(this.getFlags(), 8) + "]";
    }

    public static int getDefaultFlags() {
        return h;
    }

    public static int getDefaultFlags(Type1Message type1Message) {
        String string;
        if (type1Message == null) {
            return h;
        }
        int n2 = 512;
        int n3 = type1Message.getFlags();
        n2 |= (n3 & 1) != 0 ? 1 : 2;
        if ((n3 & 4) != 0 && (string = Type2Message.getDefaultDomain()) != null) {
            n2 |= 0x10004;
        }
        return n2;
    }

    public static String getDefaultDomain() {
        return i;
    }

    public static byte[] getDefaultTargetInformation() {
        return j;
    }

    private void if(byte[] byArray) throws IOException {
        int n2;
        int n3;
        for (n3 = 0; n3 < 8; ++n3) {
            if (byArray[n3] == NTLMSSP_SIGNATURE[n3]) continue;
            throw new IOException("Not an NTLMSSP message.");
        }
        if (Type2Message.readULong(byArray, 8) != 2) {
            throw new IOException("Not a Type 2 message.");
        }
        n3 = Type2Message.readULong(byArray, 20);
        this.setFlags(n3);
        String string = null;
        byte[] byArray2 = Type2Message.readSecurityBuffer(byArray, 12);
        if (byArray2.length != 0) {
            string = new String(byArray2, (n3 & 1) != 0 ? "UTF-16LE" : Type2Message.getOEMEncoding());
        }
        this.setTarget(string);
        for (n2 = 24; n2 < 32; ++n2) {
            if (byArray[n2] == 0) continue;
            byte[] byArray3 = new byte[8];
            System.arraycopy(byArray, 24, byArray3, 0, 8);
            this.setChallenge(byArray3);
            break;
        }
        if ((n2 = Type2Message.readULong(byArray, 16)) == 32 || byArray.length == 32) {
            return;
        }
        for (int i2 = 32; i2 < 40; ++i2) {
            if (byArray[i2] == 0) continue;
            byte[] byArray4 = new byte[8];
            System.arraycopy(byArray, 32, byArray4, 0, 8);
            this.setContext(byArray4);
            break;
        }
        if (n2 == 40 || byArray.length == 40) {
            return;
        }
        byArray2 = Type2Message.readSecurityBuffer(byArray, 40);
        if (byArray2.length != 0) {
            this.setTargetInformation(byArray2);
        }
    }

    static {
        byte[] byArray = new byte[]{};
        if (i != null) {
            try {
                byArray = i.getBytes("UTF-16LE");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        int n2 = byArray.length;
        byte[] byArray2 = new byte[]{};
        try {
            String string = NbtAddress.getLocalHost().getHostName();
            if (string != null) {
                try {
                    byArray2 = string.getBytes("UTF-16LE");
                }
                catch (IOException iOException) {}
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        int n3 = byArray2.length;
        byte[] byArray3 = new byte[(n2 > 0 ? n2 + 4 : 0) + (n3 > 0 ? n3 + 4 : 0) + 4];
        int n4 = 0;
        if (n2 > 0) {
            Type2Message.writeUShort(byArray3, n4, 2);
            Type2Message.writeUShort(byArray3, n4 += 2, n2);
            System.arraycopy(byArray, 0, byArray3, n4 += 2, n2);
            n4 += n2;
        }
        if (n3 > 0) {
            Type2Message.writeUShort(byArray3, n4, 1);
            Type2Message.writeUShort(byArray3, n4 += 2, n3);
            System.arraycopy(byArray2, 0, byArray3, n4 += 2, n3);
        }
        j = byArray3;
    }
}

