/*
 * Decompiled with CFR 0.152.
 */
package jcifs.ntlmssp;

import java.io.IOException;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.Arrays;
import jcifs.Config;
import jcifs.netbios.NbtAddress;
import jcifs.ntlmssp.NtlmMessage;
import jcifs.ntlmssp.Type2Message;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.util.HMACT64;
import jcifs.util.Hexdump;
import jcifs.util.MD4;
import jcifs.util.RC4;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Type3Message
extends NtlmMessage {
    static final long MILLISECONDS_BETWEEN_1970_AND_1601 = 11644473600000L;
    private static final int try;
    private static final String for;
    private static final String b;
    private static final String goto;
    private static final String void;
    private static final int do;
    private static final SecureRandom int;
    private byte[] c;
    private byte[] long;
    private String else;
    private String char;
    private String byte;
    private byte[] new = null;
    private byte[] case = null;

    public Type3Message() {
        this.setFlags(Type3Message.getDefaultFlags());
        this.setDomain(Type3Message.getDefaultDomain());
        this.setUser(Type3Message.getDefaultUser());
        this.setWorkstation(Type3Message.getDefaultWorkstation());
    }

    public Type3Message(Type2Message type2Message) {
        this.setFlags(Type3Message.getDefaultFlags(type2Message));
        this.setWorkstation(Type3Message.getDefaultWorkstation());
        String string = Type3Message.getDefaultDomain();
        this.setDomain(string);
        String string2 = Type3Message.getDefaultUser();
        this.setUser(string2);
        String string3 = Type3Message.getDefaultPassword();
        switch (do) {
            case 0: 
            case 1: {
                this.setLMResponse(Type3Message.getLMResponse(type2Message, string3));
                this.setNTResponse(Type3Message.getNTResponse(type2Message, string3));
                break;
            }
            case 2: {
                byte[] byArray = Type3Message.getNTResponse(type2Message, string3);
                this.setLMResponse(byArray);
                this.setNTResponse(byArray);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                byte[] byArray = new byte[8];
                int.nextBytes(byArray);
                this.setLMResponse(Type3Message.getLMv2Response(type2Message, string, string2, string3, byArray));
                break;
            }
            default: {
                this.setLMResponse(Type3Message.getLMResponse(type2Message, string3));
                this.setNTResponse(Type3Message.getNTResponse(type2Message, string3));
            }
        }
    }

    public Type3Message(Type2Message type2Message, String string, String string2, String string3, String string4, int n2) {
        this.setFlags(n2 | Type3Message.getDefaultFlags(type2Message));
        if (string4 == null) {
            string4 = Type3Message.getDefaultWorkstation();
        }
        this.setWorkstation(string4);
        this.setDomain(string2);
        this.setUser(string3);
        switch (do) {
            case 0: 
            case 1: {
                if ((this.getFlags() & 0x80000) == 0) {
                    this.setLMResponse(Type3Message.getLMResponse(type2Message, string));
                    this.setNTResponse(Type3Message.getNTResponse(type2Message, string));
                    break;
                }
                byte[] byArray = new byte[24];
                int.nextBytes(byArray);
                Arrays.fill(byArray, 8, 24, (byte)0);
                byte[] byArray2 = NtlmPasswordAuthentication.nTOWFv1(string);
                byte[] byArray3 = NtlmPasswordAuthentication.getNTLM2Response(byArray2, type2Message.getChallenge(), byArray);
                this.setLMResponse(byArray);
                this.setNTResponse(byArray3);
                if ((this.getFlags() & 0x10) != 16) break;
                byte[] byArray4 = new byte[16];
                System.arraycopy(type2Message.getChallenge(), 0, byArray4, 0, 8);
                System.arraycopy(byArray, 0, byArray4, 8, 8);
                MD4 mD4 = new MD4();
                mD4.update(byArray2);
                byte[] byArray5 = mD4.digest();
                HMACT64 hMACT64 = new HMACT64(byArray5);
                hMACT64.update(byArray4);
                byte[] byArray6 = hMACT64.digest();
                if ((this.getFlags() & 0x40000000) != 0) {
                    this.new = new byte[16];
                    int.nextBytes(this.new);
                    byte[] byArray7 = new byte[16];
                    RC4 rC4 = new RC4(byArray6);
                    rC4.update(this.new, 0, 16, byArray7, 0);
                    this.setSessionKey(byArray7);
                    break;
                }
                this.new = byArray6;
                this.setSessionKey(this.new);
                break;
            }
            case 2: {
                byte[] byArray = Type3Message.getNTResponse(type2Message, string);
                this.setLMResponse(byArray);
                this.setNTResponse(byArray);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                byte[] byArray = NtlmPasswordAuthentication.nTOWFv2(string2, string3, string);
                byte[] byArray8 = new byte[8];
                int.nextBytes(byArray8);
                this.setLMResponse(Type3Message.getLMv2Response(type2Message, string2, string3, string, byArray8));
                byte[] byArray9 = new byte[8];
                int.nextBytes(byArray9);
                this.setNTResponse(Type3Message.getNTLMv2Response(type2Message, byArray, byArray9));
                if ((this.getFlags() & 0x10) != 16) break;
                HMACT64 hMACT64 = new HMACT64(byArray);
                hMACT64.update(this.long, 0, 16);
                byte[] byArray10 = hMACT64.digest();
                if ((this.getFlags() & 0x40000000) != 0) {
                    this.new = new byte[16];
                    int.nextBytes(this.new);
                    byte[] byArray11 = new byte[16];
                    RC4 rC4 = new RC4(byArray10);
                    rC4.update(this.new, 0, 16, byArray11, 0);
                    this.setSessionKey(byArray11);
                    break;
                }
                this.new = byArray10;
                this.setSessionKey(this.new);
                break;
            }
            default: {
                this.setLMResponse(Type3Message.getLMResponse(type2Message, string));
                this.setNTResponse(Type3Message.getNTResponse(type2Message, string));
            }
        }
    }

    public Type3Message(int n2, byte[] byArray, byte[] byArray2, String string, String string2, String string3) {
        this.setFlags(n2);
        this.setLMResponse(byArray);
        this.setNTResponse(byArray2);
        this.setDomain(string);
        this.setUser(string2);
        this.setWorkstation(string3);
    }

    public Type3Message(byte[] byArray) throws IOException {
        this.a(byArray);
    }

    public byte[] getLMResponse() {
        return this.c;
    }

    public void setLMResponse(byte[] byArray) {
        this.c = byArray;
    }

    public byte[] getNTResponse() {
        return this.long;
    }

    public void setNTResponse(byte[] byArray) {
        this.long = byArray;
    }

    public String getDomain() {
        return this.else;
    }

    public void setDomain(String string) {
        this.else = string;
    }

    public String getUser() {
        return this.char;
    }

    public void setUser(String string) {
        this.char = string;
    }

    public String getWorkstation() {
        return this.byte;
    }

    public void setWorkstation(String string) {
        this.byte = string;
    }

    public byte[] getMasterKey() {
        return this.new;
    }

    public byte[] getSessionKey() {
        return this.case;
    }

    public void setSessionKey(byte[] byArray) {
        this.case = byArray;
    }

    public byte[] toByteArray() {
        try {
            int n2 = this.getFlags();
            boolean bl = (n2 & 1) != 0;
            String string = bl ? null : Type3Message.getOEMEncoding();
            String string2 = this.getDomain();
            byte[] byArray = null;
            if (string2 != null && string2.length() != 0) {
                byArray = bl ? string2.getBytes("UTF-16LE") : string2.getBytes(string);
            }
            int n3 = byArray != null ? byArray.length : 0;
            String string3 = this.getUser();
            byte[] byArray2 = null;
            if (string3 != null && string3.length() != 0) {
                byArray2 = bl ? string3.getBytes("UTF-16LE") : string3.toUpperCase().getBytes(string);
            }
            int n4 = byArray2 != null ? byArray2.length : 0;
            String string4 = this.getWorkstation();
            byte[] byArray3 = null;
            if (string4 != null && string4.length() != 0) {
                byArray3 = bl ? string4.getBytes("UTF-16LE") : string4.toUpperCase().getBytes(string);
            }
            int n5 = byArray3 != null ? byArray3.length : 0;
            byte[] byArray4 = this.getLMResponse();
            int n6 = byArray4 != null ? byArray4.length : 0;
            byte[] byArray5 = this.getNTResponse();
            int n7 = byArray5 != null ? byArray5.length : 0;
            byte[] byArray6 = this.getSessionKey();
            int n8 = byArray6 != null ? byArray6.length : 0;
            byte[] byArray7 = new byte[64 + n3 + n4 + n5 + n6 + n7 + n8];
            System.arraycopy(NTLMSSP_SIGNATURE, 0, byArray7, 0, 8);
            Type3Message.writeULong(byArray7, 8, 3);
            int n9 = 64;
            Type3Message.writeSecurityBuffer(byArray7, 12, n9, byArray4);
            Type3Message.writeSecurityBuffer(byArray7, 20, n9 += n6, byArray5);
            Type3Message.writeSecurityBuffer(byArray7, 28, n9 += n7, byArray);
            Type3Message.writeSecurityBuffer(byArray7, 36, n9 += n3, byArray2);
            Type3Message.writeSecurityBuffer(byArray7, 44, n9 += n4, byArray3);
            Type3Message.writeSecurityBuffer(byArray7, 52, n9 += n5, byArray6);
            Type3Message.writeULong(byArray7, 60, n2);
            return byArray7;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.getMessage());
        }
    }

    public String toString() {
        String string = this.getUser();
        String string2 = this.getDomain();
        String string3 = this.getWorkstation();
        byte[] byArray = this.getLMResponse();
        byte[] byArray2 = this.getNTResponse();
        byte[] byArray3 = this.getSessionKey();
        return "Type3Message[domain=" + string2 + ",user=" + string + ",workstation=" + string3 + ",lmResponse=" + (byArray == null ? "null" : "<" + byArray.length + " bytes>") + ",ntResponse=" + (byArray2 == null ? "null" : "<" + byArray2.length + " bytes>") + ",sessionKey=" + (byArray3 == null ? "null" : "<" + byArray3.length + " bytes>") + ",flags=0x" + Hexdump.toHexString(this.getFlags(), 8) + "]";
    }

    public static int getDefaultFlags() {
        return try;
    }

    public static int getDefaultFlags(Type2Message type2Message) {
        if (type2Message == null) {
            return try;
        }
        int n2 = 512;
        return n2 |= (type2Message.getFlags() & 1) != 0 ? 1 : 2;
    }

    public static byte[] getLMResponse(Type2Message type2Message, String string) {
        if (type2Message == null || string == null) {
            return null;
        }
        return NtlmPasswordAuthentication.getPreNTLMResponse(string, type2Message.getChallenge());
    }

    public static byte[] getLMv2Response(Type2Message type2Message, String string, String string2, String string3, byte[] byArray) {
        if (type2Message == null || string == null || string2 == null || string3 == null || byArray == null) {
            return null;
        }
        return NtlmPasswordAuthentication.getLMv2Response(string, string2, string3, type2Message.getChallenge(), byArray);
    }

    public static byte[] getNTLMv2Response(Type2Message type2Message, byte[] byArray, byte[] byArray2) {
        if (type2Message == null || byArray == null || byArray2 == null) {
            return null;
        }
        long l2 = (System.currentTimeMillis() + 11644473600000L) * 10000L;
        return NtlmPasswordAuthentication.getNTLMv2Response(byArray, type2Message.getChallenge(), byArray2, l2, type2Message.getTargetInformation());
    }

    public static byte[] getNTResponse(Type2Message type2Message, String string) {
        if (type2Message == null || string == null) {
            return null;
        }
        return NtlmPasswordAuthentication.getNTLMResponse(string, type2Message.getChallenge());
    }

    public static String getDefaultDomain() {
        return for;
    }

    public static String getDefaultUser() {
        return b;
    }

    public static String getDefaultPassword() {
        return goto;
    }

    public static String getDefaultWorkstation() {
        return void;
    }

    private void a(byte[] byArray) throws IOException {
        String string;
        int n2;
        for (int i2 = 0; i2 < 8; ++i2) {
            if (byArray[i2] == NTLMSSP_SIGNATURE[i2]) continue;
            throw new IOException("Not an NTLMSSP message.");
        }
        if (Type3Message.readULong(byArray, 8) != 3) {
            throw new IOException("Not a Type 3 message.");
        }
        byte[] byArray2 = Type3Message.readSecurityBuffer(byArray, 12);
        int n3 = Type3Message.readULong(byArray, 16);
        byte[] byArray3 = Type3Message.readSecurityBuffer(byArray, 20);
        int n4 = Type3Message.readULong(byArray, 24);
        byte[] byArray4 = Type3Message.readSecurityBuffer(byArray, 28);
        int n5 = Type3Message.readULong(byArray, 32);
        byte[] byArray5 = Type3Message.readSecurityBuffer(byArray, 36);
        int n6 = Type3Message.readULong(byArray, 40);
        byte[] byArray6 = Type3Message.readSecurityBuffer(byArray, 44);
        int n7 = Type3Message.readULong(byArray, 48);
        byte[] byArray7 = null;
        if (n3 == 52 || n4 == 52 || n5 == 52 || n6 == 52 || n7 == 52) {
            n2 = 514;
            string = Type3Message.getOEMEncoding();
        } else {
            byArray7 = Type3Message.readSecurityBuffer(byArray, 52);
            n2 = Type3Message.readULong(byArray, 60);
            string = (n2 & 1) != 0 ? "UTF-16LE" : Type3Message.getOEMEncoding();
        }
        this.setSessionKey(byArray7);
        this.setFlags(n2);
        this.setLMResponse(byArray2);
        this.setNTResponse(byArray3);
        this.setDomain(new String(byArray4, string));
        this.setUser(new String(byArray5, string));
        this.setWorkstation(new String(byArray6, string));
    }

    static {
        int = new SecureRandom();
        try = 0x200 | (Config.getBoolean("jcifs.smb.client.useUnicode", true) ? 1 : 2);
        for = Config.getProperty("jcifs.smb.client.domain", null);
        b = Config.getProperty("jcifs.smb.client.username", null);
        goto = Config.getProperty("jcifs.smb.client.password", null);
        String string = null;
        try {
            string = NbtAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        void = string;
        do = Config.getInt("jcifs.smb.lmCompatibility", 3);
    }
}

