/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SmbComNTCreateAndXResponse;
import jcifs.smb.SmbConstants;
import jcifs.util.Hexdump;

abstract class AndXServerMessageBlock
extends ServerMessageBlock {
    private static final int aJ = 1;
    private static final int aH = 2;
    private static final int aK = 3;
    private byte aL = (byte)-1;
    private int aI = 0;
    ServerMessageBlock andx = null;

    AndXServerMessageBlock() {
    }

    AndXServerMessageBlock(ServerMessageBlock serverMessageBlock) {
        if (serverMessageBlock != null) {
            this.andx = serverMessageBlock;
            this.aL = serverMessageBlock.command;
        }
    }

    int getBatchLimit(byte by) {
        return 0;
    }

    int encode(byte[] byArray, int n2) {
        int n3 = this.headerStart = n2;
        n2 += this.writeHeaderWireFormat(byArray, n2);
        n2 += this.writeAndXWireFormat(byArray, n2);
        this.length = n2 - n3;
        if (this.digest != null) {
            this.digest.sign(byArray, this.headerStart, this.length, this, this.response);
        }
        return this.length;
    }

    int decode(byte[] byArray, int n2) {
        int n3 = this.headerStart = n2;
        n2 += this.readHeaderWireFormat(byArray, n2);
        n2 += this.readAndXWireFormat(byArray, n2);
        this.length = n2 - n3;
        return this.length;
    }

    int writeAndXWireFormat(byte[] byArray, int n2) {
        int n3 = n2;
        this.wordCount = this.writeParameterWordsWireFormat(byArray, n3 + 3 + 2);
        this.wordCount += 4;
        this.wordCount /= 2;
        byArray[n3] = (byte)(this.wordCount & 0xFF);
        this.byteCount = this.writeBytesWireFormat(byArray, (n2 += this.wordCount + 1) + 2);
        byArray[n2++] = (byte)(this.byteCount & 0xFF);
        byArray[n2++] = (byte)(this.byteCount >> 8 & 0xFF);
        n2 += this.byteCount;
        if (this.andx == null || !SmbConstants.USE_BATCHING || this.batchLevel >= this.getBatchLimit(this.andx.command)) {
            this.aL = (byte)-1;
            this.andx = null;
            byArray[n3 + 1] = -1;
            byArray[n3 + 2] = 0;
            byArray[n3 + 3] = -34;
            byArray[n3 + 3 + 1] = -34;
            return n2 - n3;
        }
        this.andx.batchLevel = this.batchLevel + 1;
        byArray[n3 + 1] = this.aL;
        byArray[n3 + 2] = 0;
        this.aI = n2 - this.headerStart;
        AndXServerMessageBlock.writeInt2(this.aI, byArray, n3 + 3);
        this.andx.useUnicode = this.useUnicode;
        if (this.andx instanceof AndXServerMessageBlock) {
            this.andx.uid = this.uid;
            n2 += ((AndXServerMessageBlock)this.andx).writeAndXWireFormat(byArray, n2);
        } else {
            int n4 = n2;
            this.andx.wordCount = this.andx.writeParameterWordsWireFormat(byArray, n2);
            this.andx.wordCount /= 2;
            byArray[n4] = (byte)(this.andx.wordCount & 0xFF);
            this.andx.byteCount = this.andx.writeBytesWireFormat(byArray, (n2 += this.andx.wordCount + 1) + 2);
            byArray[n2++] = (byte)(this.andx.byteCount & 0xFF);
            byArray[n2++] = (byte)(this.andx.byteCount >> 8 & 0xFF);
            n2 += this.andx.byteCount;
        }
        return n2 - n3;
    }

    int readAndXWireFormat(byte[] byArray, int n2) {
        int n3 = n2;
        this.wordCount = byArray[n2++];
        if (this.wordCount != 0) {
            this.aL = byArray[n2];
            this.aI = AndXServerMessageBlock.readInt2(byArray, n2 + 2);
            if (this.aI == 0) {
                this.aL = (byte)-1;
            }
            if (this.wordCount > 2) {
                this.readParameterWordsWireFormat(byArray, n2 + 4);
                if (this.command == -94 && ((SmbComNTCreateAndXResponse)this).isExtended) {
                    this.wordCount += 8;
                }
            }
            n2 = n3 + 1 + this.wordCount * 2;
        }
        this.byteCount = AndXServerMessageBlock.readInt2(byArray, n2);
        n2 += 2;
        if (this.byteCount != 0) {
            int n4 = this.readBytesWireFormat(byArray, n2);
            n2 += this.byteCount;
        }
        if (this.errorCode != 0 || this.aL == -1) {
            this.aL = (byte)-1;
            this.andx = null;
        } else {
            if (this.andx == null) {
                this.aL = (byte)-1;
                throw new RuntimeException("no andx command supplied with response");
            }
            n2 = this.headerStart + this.aI;
            this.andx.headerStart = this.headerStart;
            this.andx.command = this.aL;
            this.andx.errorCode = this.errorCode;
            this.andx.flags = this.flags;
            this.andx.flags2 = this.flags2;
            this.andx.tid = this.tid;
            this.andx.pid = this.pid;
            this.andx.uid = this.uid;
            this.andx.mid = this.mid;
            this.andx.useUnicode = this.useUnicode;
            if (this.andx instanceof AndXServerMessageBlock) {
                n2 += ((AndXServerMessageBlock)this.andx).readAndXWireFormat(byArray, n2);
            } else {
                byArray[n2++] = (byte)(this.andx.wordCount & 0xFF);
                if (this.andx.wordCount != 0 && this.andx.wordCount > 2) {
                    n2 += this.andx.readParameterWordsWireFormat(byArray, n2);
                }
                this.andx.byteCount = AndXServerMessageBlock.readInt2(byArray, n2);
                n2 += 2;
                if (this.andx.byteCount != 0) {
                    this.andx.readBytesWireFormat(byArray, n2);
                    n2 += this.andx.byteCount;
                }
            }
            this.andx.received = true;
        }
        return n2 - n3;
    }

    public String toString() {
        return new String(super.toString() + ",andxCommand=0x" + Hexdump.toHexString(this.aL, 2) + ",andxOffset=" + this.aI);
    }
}

