/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.util.HashMap;
import jcifs.Config;
import jcifs.UniAddress;
import jcifs.smb.DfsReferral;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbTransport;
import jcifs.util.LogStream;

public class Dfs {
    static LogStream log = LogStream.getInstance();
    static final boolean strictView = Config.getBoolean("jcifs.smb.client.dfs.strictView", false);
    static final long TTL = Config.getLong("jcifs.smb.client.dfs.ttl", 300L);
    static final boolean DISABLED = Config.getBoolean("jcifs.smb.client.dfs.disabled", false);
    protected static CacheEntry FALSE_ENTRY = new CacheEntry(0L);
    protected CacheEntry _domains = null;
    protected CacheEntry referrals = null;

    public HashMap getTrustedDomains(NtlmPasswordAuthentication ntlmPasswordAuthentication) throws SmbAuthException {
        block8: {
            if (DISABLED || ntlmPasswordAuthentication.domain == "?") {
                return null;
            }
            if (this._domains != null && System.currentTimeMillis() > this._domains.expiration) {
                this._domains = null;
            }
            if (this._domains != null) {
                return this._domains.map;
            }
            try {
                UniAddress uniAddress = UniAddress.getByName(ntlmPasswordAuthentication.domain, true);
                SmbTransport smbTransport = SmbTransport.getSmbTransport(uniAddress, 0);
                CacheEntry cacheEntry = new CacheEntry(TTL * 10L);
                DfsReferral dfsReferral = smbTransport.getDfsReferrals(ntlmPasswordAuthentication, "", 0);
                if (dfsReferral != null) {
                    DfsReferral dfsReferral2 = dfsReferral;
                    do {
                        String string = dfsReferral.server.toLowerCase();
                        cacheEntry.map.put(string, new HashMap());
                    } while ((dfsReferral = dfsReferral.next) != dfsReferral2);
                    this._domains = cacheEntry;
                    return this._domains.map;
                }
            }
            catch (IOException iOException) {
                if (LogStream.level >= 3) {
                    iOException.printStackTrace(log);
                }
                if (!strictView || !(iOException instanceof SmbAuthException)) break block8;
                throw (SmbAuthException)iOException;
            }
        }
        return null;
    }

    public boolean isTrustedDomain(String string, NtlmPasswordAuthentication ntlmPasswordAuthentication) throws SmbAuthException {
        HashMap hashMap = this.getTrustedDomains(ntlmPasswordAuthentication);
        if (hashMap == null) {
            return false;
        }
        return hashMap.get(string = string.toLowerCase()) != null;
    }

    public SmbTransport getDc(String string, NtlmPasswordAuthentication ntlmPasswordAuthentication) throws SmbAuthException {
        block8: {
            if (DISABLED) {
                return null;
            }
            try {
                UniAddress uniAddress = UniAddress.getByName(string, true);
                SmbTransport smbTransport = SmbTransport.getSmbTransport(uniAddress, 0);
                DfsReferral dfsReferral = smbTransport.getDfsReferrals(ntlmPasswordAuthentication, "\\" + string, 1);
                if (dfsReferral != null) {
                    DfsReferral dfsReferral2 = dfsReferral;
                    IOException iOException = null;
                    while (true) {
                        try {
                            uniAddress = UniAddress.getByName(dfsReferral.server);
                            return SmbTransport.getSmbTransport(uniAddress, 0);
                        }
                        catch (IOException iOException2) {
                            iOException = iOException2;
                            if ((dfsReferral = dfsReferral.next) != dfsReferral2) continue;
                            throw iOException;
                        }
                        break;
                    }
                }
            }
            catch (IOException iOException) {
                if (LogStream.level >= 3) {
                    iOException.printStackTrace(log);
                }
                if (!strictView || !(iOException instanceof SmbAuthException)) break block8;
                throw (SmbAuthException)iOException;
            }
        }
        return null;
    }

    public DfsReferral getReferral(SmbTransport smbTransport, String string, String string2, String string3, NtlmPasswordAuthentication ntlmPasswordAuthentication) throws SmbAuthException {
        block6: {
            if (DISABLED) {
                return null;
            }
            try {
                DfsReferral dfsReferral;
                String string4 = "\\" + string + "\\" + string2;
                if (string3 != null) {
                    string4 = string4 + string3;
                }
                if ((dfsReferral = smbTransport.getDfsReferrals(ntlmPasswordAuthentication, string4, 0)) != null) {
                    return dfsReferral;
                }
            }
            catch (IOException iOException) {
                if (LogStream.level >= 4) {
                    iOException.printStackTrace(log);
                }
                if (!strictView || !(iOException instanceof SmbAuthException)) break block6;
                throw (SmbAuthException)iOException;
            }
        }
        return null;
    }

    public synchronized DfsReferral resolve(String string, String string2, String string3, NtlmPasswordAuthentication ntlmPasswordAuthentication) throws SmbAuthException {
        int n2;
        Object object;
        Object object2;
        Object object3;
        DfsReferral dfsReferral = null;
        long l2 = System.currentTimeMillis();
        if (DISABLED || string2.equals("IPC$")) {
            return null;
        }
        HashMap hashMap = this.getTrustedDomains(ntlmPasswordAuthentication);
        if (hashMap != null && (object3 = (HashMap)hashMap.get(string = string.toLowerCase())) != null) {
            object2 = null;
            object = (CacheEntry)((HashMap)object3).get(string2 = string2.toLowerCase());
            if (object != null && l2 > ((CacheEntry)object).expiration) {
                ((HashMap)object3).remove(string2);
                object = null;
            }
            if (object == null) {
                object2 = this.getDc(string, ntlmPasswordAuthentication);
                if (object2 == null) {
                    return null;
                }
                dfsReferral = this.getReferral((SmbTransport)object2, string, string2, string3, ntlmPasswordAuthentication);
                if (dfsReferral != null) {
                    n2 = 1 + string.length() + 1 + string2.length();
                    object = new CacheEntry(0L);
                    DfsReferral dfsReferral2 = dfsReferral;
                    do {
                        if (string3 == null) {
                            dfsReferral2.map = ((CacheEntry)object).map;
                            dfsReferral2.key = "\\";
                        }
                        dfsReferral2.pathConsumed -= n2;
                    } while ((dfsReferral2 = dfsReferral2.next) != dfsReferral);
                    if (dfsReferral.key != null) {
                        ((CacheEntry)object).map.put(dfsReferral.key, dfsReferral);
                    }
                    ((HashMap)object3).put(string2, object);
                } else if (string3 == null) {
                    ((HashMap)object3).put(string2, FALSE_ENTRY);
                }
            } else if (object == FALSE_ENTRY) {
                object = null;
            }
            if (object != null) {
                String string4 = "\\";
                dfsReferral = (DfsReferral)((CacheEntry)object).map.get(string4);
                if (dfsReferral != null && l2 > dfsReferral.expiration) {
                    ((CacheEntry)object).map.remove(string4);
                    dfsReferral = null;
                }
                if (dfsReferral == null) {
                    if (object2 == null && (object2 = this.getDc(string, ntlmPasswordAuthentication)) == null) {
                        return null;
                    }
                    dfsReferral = this.getReferral((SmbTransport)object2, string, string2, string3, ntlmPasswordAuthentication);
                    if (dfsReferral != null) {
                        dfsReferral.pathConsumed -= 1 + string.length() + 1 + string2.length();
                        dfsReferral.link = string4;
                        ((CacheEntry)object).map.put(string4, dfsReferral);
                    }
                }
            }
        }
        if (dfsReferral == null && string3 != null) {
            if (this.referrals != null && l2 > this.referrals.expiration) {
                this.referrals = null;
            }
            if (this.referrals == null) {
                this.referrals = new CacheEntry(0L);
            }
            object3 = "\\" + string + "\\" + string2;
            if (!string3.equals("\\")) {
                object3 = (String)object3 + string3;
            }
            object3 = ((String)object3).toLowerCase();
            object2 = this.referrals.map.keySet().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                n2 = ((String)object).length();
                boolean bl = false;
                if (n2 == ((String)object3).length()) {
                    bl = ((String)object).equals(object3);
                } else if (n2 < ((String)object3).length()) {
                    boolean bl2 = bl = ((String)object).regionMatches(0, (String)object3, 0, n2) && ((String)object3).charAt(n2) == '\\';
                }
                if (!bl) continue;
                dfsReferral = (DfsReferral)this.referrals.map.get(object);
            }
        }
        return dfsReferral;
    }

    synchronized void insert(String string, DfsReferral dfsReferral) {
        int n2;
        if (DISABLED) {
            return;
        }
        int n3 = string.indexOf(92, 1);
        int n4 = string.indexOf(92, n3 + 1);
        String string2 = string.substring(1, n3);
        String string3 = string.substring(n3 + 1, n4);
        String string4 = string.substring(0, dfsReferral.pathConsumed).toLowerCase();
        for (n2 = string4.length(); n2 > 1 && string4.charAt(n2 - 1) == '\\'; --n2) {
        }
        if (n2 < string4.length()) {
            string4 = string4.substring(0, n2);
        }
        dfsReferral.pathConsumed -= 1 + string2.length() + 1 + string3.length();
        if (this.referrals != null && System.currentTimeMillis() + 10000L > this.referrals.expiration) {
            this.referrals = null;
        }
        if (this.referrals == null) {
            this.referrals = new CacheEntry(0L);
        }
        this.referrals.map.put(string4, dfsReferral);
    }

    static class CacheEntry {
        long expiration;
        HashMap map;

        CacheEntry(long l2) {
            if (l2 == 0L) {
                l2 = TTL;
            }
            this.expiration = System.currentTimeMillis() + l2 * 1000L;
            this.map = new HashMap();
        }
    }
}

