/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import jcifs.smb.FileEntry;
import jcifs.smb.SmbComTransactionResponse;
import jcifs.util.Hexdump;
import jcifs.util.LogStream;

class NetServerEnum2Response
extends SmbComTransactionResponse {
    private int ao;
    private int ap;
    String lastName;

    NetServerEnum2Response() {
    }

    int writeSetupWireFormat(byte[] byArray, int n2) {
        return 0;
    }

    int writeParametersWireFormat(byte[] byArray, int n2) {
        return 0;
    }

    int writeDataWireFormat(byte[] byArray, int n2) {
        return 0;
    }

    int readSetupWireFormat(byte[] byArray, int n2, int n3) {
        return 0;
    }

    int readParametersWireFormat(byte[] byArray, int n2, int n3) {
        int n4 = n2;
        this.status = NetServerEnum2Response.readInt2(byArray, n2);
        this.ao = NetServerEnum2Response.readInt2(byArray, n2 += 2);
        this.numEntries = NetServerEnum2Response.readInt2(byArray, n2 += 2);
        this.ap = NetServerEnum2Response.readInt2(byArray, n2 += 2);
        return (n2 += 2) - n4;
    }

    int readDataWireFormat(byte[] byArray, int n2, int n3) {
        int n4 = n2;
        ServerInfo1 serverInfo1 = null;
        this.results = new ServerInfo1[this.numEntries];
        for (int i2 = 0; i2 < this.numEntries; ++i2) {
            serverInfo1 = new ServerInfo1();
            this.results[i2] = serverInfo1;
            serverInfo1.name = this.readString(byArray, n2, 16, false);
            n2 += 16;
            serverInfo1.versionMajor = byArray[n2++] & 0xFF;
            serverInfo1.versionMinor = byArray[n2++] & 0xFF;
            serverInfo1.type = NetServerEnum2Response.readInt4(byArray, n2);
            int n5 = NetServerEnum2Response.readInt4(byArray, n2 += 4);
            n2 += 4;
            n5 = (n5 & 0xFFFF) - this.ao;
            n5 = n4 + n5;
            serverInfo1.commentOrMasterBrowser = this.readString(byArray, n5, 48, false);
            if (LogStream.level < 4) continue;
            log.println(serverInfo1);
        }
        this.lastName = this.numEntries == 0 ? null : serverInfo1.name;
        return n2 - n4;
    }

    public String toString() {
        return new String("NetServerEnum2Response[" + super.toString() + ",status=" + this.status + ",converter=" + this.ao + ",entriesReturned=" + this.numEntries + ",totalAvailableEntries=" + this.ap + ",lastName=" + this.lastName + "]");
    }

    class ServerInfo1
    implements FileEntry {
        String name;
        int versionMajor;
        int versionMinor;
        int type;
        String commentOrMasterBrowser;

        ServerInfo1() {
        }

        public String getName() {
            return this.name;
        }

        public int getType() {
            return (this.type & Integer.MIN_VALUE) != 0 ? 2 : 4;
        }

        public int getAttributes() {
            return 17;
        }

        public long createTime() {
            return 0L;
        }

        public long lastModified() {
            return 0L;
        }

        public long length() {
            return 0L;
        }

        public String toString() {
            return new String("ServerInfo1[name=" + this.name + ",versionMajor=" + this.versionMajor + ",versionMinor=" + this.versionMinor + ",type=0x" + Hexdump.toHexString(this.type, 8) + ",commentOrMasterBrowser=" + this.commentOrMasterBrowser + "]");
        }
    }
}

