/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.UnsupportedEncodingException;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.ntlmssp.Type3Message;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbException;
import jcifs.util.Encdec;
import jcifs.util.Hexdump;
import jcifs.util.LogStream;

public class NtlmContext {
    NtlmPasswordAuthentication auth;
    int ntlmsspFlags;
    String workstation;
    boolean isEstablished = false;
    byte[] serverChallenge = null;
    byte[] signingKey = null;
    String netbiosName = null;
    int state = 1;
    LogStream log;

    public NtlmContext(NtlmPasswordAuthentication ntlmPasswordAuthentication, boolean bl) {
        this.auth = ntlmPasswordAuthentication;
        this.ntlmsspFlags = this.ntlmsspFlags | 4 | 0x80000 | 0x20000000;
        if (bl) {
            this.ntlmsspFlags |= 0x40008010;
        }
        this.workstation = Type1Message.getDefaultWorkstation();
        this.log = LogStream.getInstance();
    }

    public String toString() {
        String string = "NtlmContext[auth=" + this.auth + ",ntlmsspFlags=0x" + Hexdump.toHexString(this.ntlmsspFlags, 8) + ",workstation=" + this.workstation + ",isEstablished=" + this.isEstablished + ",state=" + this.state + ",serverChallenge=";
        string = this.serverChallenge == null ? string + "null" : string + Hexdump.toHexString(this.serverChallenge, 0, this.serverChallenge.length * 2);
        string = string + ",signingKey=";
        string = this.signingKey == null ? string + "null" : string + Hexdump.toHexString(this.signingKey, 0, this.signingKey.length * 2);
        string = string + "]";
        return string;
    }

    public boolean isEstablished() {
        return this.isEstablished;
    }

    public byte[] getServerChallenge() {
        return this.serverChallenge;
    }

    public byte[] getSigningKey() {
        return this.signingKey;
    }

    public String getNetbiosName() {
        return this.netbiosName;
    }

    private String a(byte[] byArray, int n2) {
        int n3 = 58;
        while (true) {
            short s = Encdec.dec_uint16le(byArray, n3);
            short s2 = Encdec.dec_uint16le(byArray, n3 + 2);
            if (s == 0 || (n3 += 4) + s2 > byArray.length) break;
            if (s == n2) {
                try {
                    return new String(byArray, n3, (int)s2, "UTF-16LE");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    break;
                }
            }
            n3 += s2;
        }
        return null;
    }

    public byte[] initSecContext(byte[] byArray, int n2, int n3) throws SmbException {
        switch (this.state) {
            case 1: {
                Type1Message type1Message = new Type1Message(this.ntlmsspFlags, this.auth.getDomain(), this.workstation);
                byArray = type1Message.toByteArray();
                if (LogStream.level >= 4) {
                    this.log.println(type1Message);
                    if (LogStream.level >= 6) {
                        Hexdump.hexdump(this.log, byArray, 0, byArray.length);
                    }
                }
                ++this.state;
                break;
            }
            case 2: {
                try {
                    Type2Message type2Message = new Type2Message(byArray);
                    if (LogStream.level >= 4) {
                        this.log.println(type2Message);
                        if (LogStream.level >= 6) {
                            Hexdump.hexdump(this.log, byArray, 0, byArray.length);
                        }
                    }
                    this.serverChallenge = type2Message.getChallenge();
                    this.ntlmsspFlags &= type2Message.getFlags();
                    Type3Message type3Message = new Type3Message(type2Message, this.auth.getPassword(), this.auth.getDomain(), this.auth.getUsername(), this.workstation, this.ntlmsspFlags);
                    byArray = type3Message.toByteArray();
                    if (LogStream.level >= 4) {
                        this.log.println(type3Message);
                        if (LogStream.level >= 6) {
                            Hexdump.hexdump(this.log, byArray, 0, byArray.length);
                        }
                    }
                    if ((this.ntlmsspFlags & 0x10) != 0) {
                        this.signingKey = type3Message.getMasterKey();
                    }
                    this.isEstablished = true;
                    ++this.state;
                    break;
                }
                catch (Exception exception) {
                    throw new SmbException(exception.getMessage(), (Throwable)exception);
                }
            }
            default: {
                throw new SmbException("Invalid state");
            }
        }
        return byArray;
    }
}

