/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Principal;
import java.util.Arrays;
import java.util.Random;
import jcifs.Config;
import jcifs.smb.SmbConstants;
import jcifs.smb.SmbException;
import jcifs.util.DES;
import jcifs.util.Encdec;
import jcifs.util.HMACT64;
import jcifs.util.LogStream;
import jcifs.util.MD4;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class NtlmPasswordAuthentication
implements Principal,
Serializable {
    private static final int do = Config.getInt("jcifs.smb.lmCompatibility", 3);
    private static final Random for = new Random();
    private static LogStream if = LogStream.getInstance();
    private static final byte[] a = new byte[]{75, 71, 83, 33, 64, 35, 36, 37};
    static String DEFAULT_DOMAIN;
    static String DEFAULT_USERNAME;
    static String DEFAULT_PASSWORD;
    static final String BLANK = "";
    public static final NtlmPasswordAuthentication ANONYMOUS;
    static final NtlmPasswordAuthentication NULL;
    static final NtlmPasswordAuthentication GUEST;
    static final NtlmPasswordAuthentication DEFAULT;
    String domain;
    String username;
    String password;
    byte[] ansiHash;
    byte[] unicodeHash;
    boolean hashesExternal = false;
    byte[] clientChallenge = null;
    byte[] challenge = null;

    private static void a(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[7];
        byte[] byArray5 = new byte[8];
        for (int i2 = 0; i2 < byArray.length / 7; ++i2) {
            System.arraycopy(byArray, i2 * 7, byArray4, 0, 7);
            DES dES = new DES(byArray4);
            dES.encrypt(byArray2, byArray5);
            System.arraycopy(byArray5, 0, byArray3, i2 * 8, 8);
        }
    }

    static void initDefaults() {
        if (DEFAULT_DOMAIN != null) {
            return;
        }
        DEFAULT_DOMAIN = Config.getProperty("jcifs.smb.client.domain", "?");
        DEFAULT_USERNAME = Config.getProperty("jcifs.smb.client.username", "GUEST");
        DEFAULT_PASSWORD = Config.getProperty("jcifs.smb.client.password", BLANK);
    }

    public static byte[] getPreNTLMResponse(String string, byte[] byArray) {
        byte[] byArray2;
        byte[] byArray3 = new byte[14];
        byte[] byArray4 = new byte[21];
        byte[] byArray5 = new byte[24];
        try {
            byArray2 = string.toUpperCase().getBytes(SmbConstants.OEM_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Try setting jcifs.encoding=US-ASCII", unsupportedEncodingException);
        }
        int n2 = byArray2.length;
        if (n2 > 14) {
            n2 = 14;
        }
        System.arraycopy(byArray2, 0, byArray3, 0, n2);
        NtlmPasswordAuthentication.a(byArray3, a, byArray4);
        NtlmPasswordAuthentication.a(byArray4, byArray, byArray5);
        return byArray5;
    }

    public static byte[] getNTLMResponse(String string, byte[] byArray) {
        byte[] byArray2;
        byte[] byArray3;
        block5: {
            byte[] byArray4;
            block4: {
                byArray4 = null;
                byArray3 = new byte[21];
                byArray2 = new byte[24];
                try {
                    byArray4 = string.getBytes("UTF-16LE");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (LogStream.level <= 0) break block4;
                    unsupportedEncodingException.printStackTrace(if);
                }
            }
            MD4 mD4 = new MD4();
            mD4.update(byArray4);
            try {
                mD4.digest(byArray3, 0, 16);
            }
            catch (Exception exception) {
                if (LogStream.level <= 0) break block5;
                exception.printStackTrace(if);
            }
        }
        NtlmPasswordAuthentication.a(byArray3, byArray, byArray2);
        return byArray2;
    }

    public static byte[] getLMv2Response(String string, String string2, String string3, byte[] byArray, byte[] byArray2) {
        try {
            byte[] byArray3 = new byte[16];
            byte[] byArray4 = new byte[24];
            MD4 mD4 = new MD4();
            mD4.update(string3.getBytes("UTF-16LE"));
            HMACT64 hMACT64 = new HMACT64(mD4.digest());
            hMACT64.update(string2.toUpperCase().getBytes("UTF-16LE"));
            hMACT64.update(string.toUpperCase().getBytes("UTF-16LE"));
            hMACT64 = new HMACT64(hMACT64.digest());
            hMACT64.update(byArray);
            hMACT64.update(byArray2);
            hMACT64.digest(byArray4, 0, 16);
            System.arraycopy(byArray2, 0, byArray4, 16, 8);
            return byArray4;
        }
        catch (Exception exception) {
            if (LogStream.level > 0) {
                exception.printStackTrace(if);
            }
            return null;
        }
    }

    public static byte[] getNTLM2Response(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        Object object;
        byte[] byArray4 = new byte[8];
        try {
            object = MessageDigest.getInstance("MD5");
            ((MessageDigest)object).update(byArray2);
            ((MessageDigest)object).update(byArray3, 0, 8);
            System.arraycopy(((MessageDigest)object).digest(), 0, byArray4, 0, 8);
        }
        catch (GeneralSecurityException generalSecurityException) {
            if (LogStream.level > 0) {
                generalSecurityException.printStackTrace(if);
            }
            throw new RuntimeException("MD5", generalSecurityException);
        }
        object = new byte[21];
        System.arraycopy(byArray, 0, object, 0, 16);
        byte[] byArray5 = new byte[24];
        NtlmPasswordAuthentication.a((byte[])object, byArray4, byArray5);
        return byArray5;
    }

    public static byte[] nTOWFv1(String string) {
        try {
            MD4 mD4 = new MD4();
            mD4.update(string.getBytes("UTF-16LE"));
            return mD4.digest();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.getMessage());
        }
    }

    public static byte[] nTOWFv2(String string, String string2, String string3) {
        try {
            MD4 mD4 = new MD4();
            mD4.update(string3.getBytes("UTF-16LE"));
            HMACT64 hMACT64 = new HMACT64(mD4.digest());
            hMACT64.update(string2.toUpperCase().getBytes("UTF-16LE"));
            hMACT64.update(string.getBytes("UTF-16LE"));
            return hMACT64.digest();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.getMessage());
        }
    }

    static byte[] computeResponse(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) {
        HMACT64 hMACT64 = new HMACT64(byArray);
        hMACT64.update(byArray2);
        hMACT64.update(byArray3, n2, n3);
        byte[] byArray4 = hMACT64.digest();
        byte[] byArray5 = new byte[byArray4.length + byArray3.length];
        System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
        System.arraycopy(byArray3, 0, byArray5, byArray4.length, byArray3.length);
        return byArray5;
    }

    public static byte[] getLMv2Response(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return NtlmPasswordAuthentication.computeResponse(byArray, byArray2, byArray3, 0, byArray3.length);
    }

    public static byte[] getNTLMv2Response(byte[] byArray, byte[] byArray2, byte[] byArray3, long l2, byte[] byArray4) {
        int n2 = byArray4 != null ? byArray4.length : 0;
        byte[] byArray5 = new byte[28 + n2 + 4];
        Encdec.enc_uint32le(257, byArray5, 0);
        Encdec.enc_uint32le(0, byArray5, 4);
        Encdec.enc_uint64le(l2, byArray5, 8);
        System.arraycopy(byArray3, 0, byArray5, 16, 8);
        Encdec.enc_uint32le(0, byArray5, 24);
        if (byArray4 != null) {
            System.arraycopy(byArray4, 0, byArray5, 28, n2);
        }
        Encdec.enc_uint32le(0, byArray5, 28 + n2);
        return NtlmPasswordAuthentication.computeResponse(byArray, byArray2, byArray5, 0, byArray5.length);
    }

    public NtlmPasswordAuthentication(String string) {
        this.password = null;
        this.username = null;
        this.domain = null;
        if (string != null) {
            int n2;
            try {
                string = NtlmPasswordAuthentication.unescape(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            int n3 = string.length();
            int n4 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                char c2 = string.charAt(n2);
                if (c2 == ';') {
                    this.domain = string.substring(0, n2);
                    n4 = n2 + 1;
                    continue;
                }
                if (c2 != ':') continue;
                this.password = string.substring(n2 + 1);
                break;
            }
            this.username = string.substring(n4, n2);
        }
        NtlmPasswordAuthentication.initDefaults();
        if (this.domain == null) {
            this.domain = DEFAULT_DOMAIN;
        }
        if (this.username == null) {
            this.username = DEFAULT_USERNAME;
        }
        if (this.password == null) {
            this.password = DEFAULT_PASSWORD;
        }
    }

    public NtlmPasswordAuthentication(String string, String string2, String string3) {
        int n2 = string2.indexOf(64);
        if (n2 > 0) {
            string = string2.substring(n2 + 1);
            string2 = string2.substring(0, n2);
        } else {
            n2 = string2.indexOf(92);
            if (n2 > 0) {
                string = string2.substring(0, n2);
                string2 = string2.substring(n2 + 1);
            }
        }
        this.domain = string;
        this.username = string2;
        this.password = string3;
        NtlmPasswordAuthentication.initDefaults();
        if (string == null) {
            this.domain = DEFAULT_DOMAIN;
        }
        if (string2 == null) {
            this.username = DEFAULT_USERNAME;
        }
        if (string3 == null) {
            this.password = DEFAULT_PASSWORD;
        }
    }

    public NtlmPasswordAuthentication(String string, String string2, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (string == null || string2 == null || byArray2 == null || byArray3 == null) {
            throw new IllegalArgumentException("External credentials cannot be null");
        }
        this.domain = string;
        this.username = string2;
        this.password = null;
        this.challenge = byArray;
        this.ansiHash = byArray2;
        this.unicodeHash = byArray3;
        this.hashesExternal = true;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getName() {
        boolean bl = this.domain.length() > 0 && !this.domain.equals("?");
        return bl ? this.domain + "\\" + this.username : this.username;
    }

    public byte[] getAnsiHash(byte[] byArray) {
        if (this.hashesExternal) {
            return this.ansiHash;
        }
        switch (do) {
            case 0: 
            case 1: {
                return NtlmPasswordAuthentication.getPreNTLMResponse(this.password, byArray);
            }
            case 2: {
                return NtlmPasswordAuthentication.getNTLMResponse(this.password, byArray);
            }
            case 3: 
            case 4: 
            case 5: {
                if (this.clientChallenge == null) {
                    this.clientChallenge = new byte[8];
                    for.nextBytes(this.clientChallenge);
                }
                return NtlmPasswordAuthentication.getLMv2Response(this.domain, this.username, this.password, byArray, this.clientChallenge);
            }
        }
        return NtlmPasswordAuthentication.getPreNTLMResponse(this.password, byArray);
    }

    public byte[] getUnicodeHash(byte[] byArray) {
        if (this.hashesExternal) {
            return this.unicodeHash;
        }
        switch (do) {
            case 0: 
            case 1: 
            case 2: {
                return NtlmPasswordAuthentication.getNTLMResponse(this.password, byArray);
            }
            case 3: 
            case 4: 
            case 5: {
                return new byte[0];
            }
        }
        return NtlmPasswordAuthentication.getNTLMResponse(this.password, byArray);
    }

    public byte[] getSigningKey(byte[] byArray) throws SmbException {
        switch (do) {
            case 0: 
            case 1: 
            case 2: {
                byte[] byArray2 = new byte[40];
                this.getUserSessionKey(byArray, byArray2, 0);
                System.arraycopy(this.getUnicodeHash(byArray), 0, byArray2, 16, 24);
                return byArray2;
            }
            case 3: 
            case 4: 
            case 5: {
                throw new SmbException("NTLMv2 requires extended security (jcifs.smb.client.useExtendedSecurity must be true if jcifs.smb.lmCompatibility >= 3)");
            }
        }
        return null;
    }

    public byte[] getUserSessionKey(byte[] byArray) {
        byte[] byArray2;
        block3: {
            if (this.hashesExternal) {
                return null;
            }
            byArray2 = new byte[16];
            try {
                this.getUserSessionKey(byArray, byArray2, 0);
            }
            catch (Exception exception) {
                if (LogStream.level <= 0) break block3;
                exception.printStackTrace(if);
            }
        }
        return byArray2;
    }

    void getUserSessionKey(byte[] byArray, byte[] byArray2, int n2) throws SmbException {
        if (this.hashesExternal) {
            return;
        }
        try {
            MD4 mD4 = new MD4();
            mD4.update(this.password.getBytes("UTF-16LE"));
            switch (do) {
                case 0: 
                case 1: 
                case 2: {
                    mD4.update(mD4.digest());
                    mD4.digest(byArray2, n2, 16);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    if (this.clientChallenge == null) {
                        this.clientChallenge = new byte[8];
                        for.nextBytes(this.clientChallenge);
                    }
                    HMACT64 hMACT64 = new HMACT64(mD4.digest());
                    hMACT64.update(this.username.toUpperCase().getBytes("UTF-16LE"));
                    hMACT64.update(this.domain.toUpperCase().getBytes("UTF-16LE"));
                    byte[] byArray3 = hMACT64.digest();
                    hMACT64 = new HMACT64(byArray3);
                    hMACT64.update(byArray);
                    hMACT64.update(this.clientChallenge);
                    HMACT64 hMACT642 = new HMACT64(byArray3);
                    hMACT642.update(hMACT64.digest());
                    hMACT642.digest(byArray2, n2, 16);
                    break;
                }
                default: {
                    mD4.update(mD4.digest());
                    mD4.digest(byArray2, n2, 16);
                    break;
                }
            }
        }
        catch (Exception exception) {
            throw new SmbException(BLANK, (Throwable)exception);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof NtlmPasswordAuthentication) {
            NtlmPasswordAuthentication ntlmPasswordAuthentication = (NtlmPasswordAuthentication)object;
            if (ntlmPasswordAuthentication.domain.toUpperCase().equals(this.domain.toUpperCase()) && ntlmPasswordAuthentication.username.toUpperCase().equals(this.username.toUpperCase())) {
                if (this.hashesExternal && ntlmPasswordAuthentication.hashesExternal) {
                    return Arrays.equals(this.ansiHash, ntlmPasswordAuthentication.ansiHash) && Arrays.equals(this.unicodeHash, ntlmPasswordAuthentication.unicodeHash);
                }
                if (!this.hashesExternal && this.password.equals(ntlmPasswordAuthentication.password)) {
                    return true;
                }
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getName().toUpperCase().hashCode();
    }

    public String toString() {
        return this.getName();
    }

    static String unescape(String string) throws NumberFormatException, UnsupportedEncodingException {
        byte[] byArray = new byte[1];
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        char[] cArray = new char[n2];
        int n3 = 0;
        int n4 = 0;
        block4: for (int i2 = 0; i2 < n2; ++i2) {
            switch (n3) {
                case 0: {
                    char c2 = string.charAt(i2);
                    if (c2 == '%') {
                        n3 = 1;
                        continue block4;
                    }
                    cArray[n4++] = c2;
                    continue block4;
                }
                case 1: {
                    byArray[0] = (byte)(Integer.parseInt(string.substring(i2, i2 + 2), 16) & 0xFF);
                    cArray[n4++] = new String(byArray, 0, 1, "ASCII").charAt(0);
                    ++i2;
                    n3 = 0;
                }
            }
        }
        return new String(cArray, 0, n4);
    }

    static {
        ANONYMOUS = new NtlmPasswordAuthentication(BLANK, BLANK, BLANK);
        NULL = new NtlmPasswordAuthentication(BLANK, BLANK, BLANK);
        GUEST = new NtlmPasswordAuthentication("?", "GUEST", BLANK);
        DEFAULT = new NtlmPasswordAuthentication(null);
    }
}

