/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import jcifs.dcerpc.DcerpcHandle;
import jcifs.dcerpc.UnicodeString;
import jcifs.dcerpc.msrpc.LsaPolicyHandle;
import jcifs.dcerpc.msrpc.MsrpcEnumerateAliasesInDomain;
import jcifs.dcerpc.msrpc.MsrpcGetMembersInAlias;
import jcifs.dcerpc.msrpc.MsrpcLookupSids;
import jcifs.dcerpc.msrpc.MsrpcQueryInformationPolicy;
import jcifs.dcerpc.msrpc.SamrAliasHandle;
import jcifs.dcerpc.msrpc.SamrDomainHandle;
import jcifs.dcerpc.msrpc.SamrPolicyHandle;
import jcifs.dcerpc.msrpc.lsarpc;
import jcifs.dcerpc.msrpc.samr;
import jcifs.dcerpc.ndr.NdrObject;
import jcifs.dcerpc.rpc;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SmbException;
import jcifs.util.Encdec;
import jcifs.util.Hexdump;

public class SID
extends rpc.sid_t {
    public static final int SID_TYPE_USE_NONE = 0;
    public static final int SID_TYPE_USER = 1;
    public static final int SID_TYPE_DOM_GRP = 2;
    public static final int SID_TYPE_DOMAIN = 3;
    public static final int SID_TYPE_ALIAS = 4;
    public static final int SID_TYPE_WKN_GRP = 5;
    public static final int SID_TYPE_DELETED = 6;
    public static final int SID_TYPE_INVALID = 7;
    public static final int SID_TYPE_UNKNOWN = 8;
    static final String[] SID_TYPE_NAMES = new String[]{"0", "User", "Domain group", "Domain", "Local group", "Builtin group", "Deleted", "Invalid", "Unknown"};
    public static final int SID_FLAG_RESOLVE_SIDS = 1;
    public static SID EVERYONE = null;
    public static SID CREATOR_OWNER = null;
    public static SID SYSTEM = null;
    static Map sid_cache;
    int type;
    String domainName = null;
    String acctName = null;
    String origin_server = null;
    NtlmPasswordAuthentication origin_auth = null;

    static void resolveSids(DcerpcHandle dcerpcHandle, LsaPolicyHandle lsaPolicyHandle, SID[] sIDArray) throws IOException {
        MsrpcLookupSids msrpcLookupSids = new MsrpcLookupSids(lsaPolicyHandle, sIDArray);
        dcerpcHandle.sendrecv(msrpcLookupSids);
        switch (msrpcLookupSids.retval) {
            case -1073741709: 
            case 0: 
            case 263: {
                break;
            }
            default: {
                throw new SmbException(msrpcLookupSids.retval, false);
            }
        }
        for (int i2 = 0; i2 < sIDArray.length; ++i2) {
            sIDArray[i2].type = msrpcLookupSids.names.names[i2].sid_type;
            sIDArray[i2].domainName = null;
            switch (sIDArray[i2].type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    int n2 = msrpcLookupSids.names.names[i2].sid_index;
                    rpc.unicode_string unicode_string2 = msrpcLookupSids.domains.domains[n2].name;
                    sIDArray[i2].domainName = new UnicodeString(unicode_string2, false).toString();
                }
            }
            sIDArray[i2].acctName = new UnicodeString(msrpcLookupSids.names.names[i2].name, false).toString();
            sIDArray[i2].origin_server = null;
            sIDArray[i2].origin_auth = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resolveSids0(String string, NtlmPasswordAuthentication ntlmPasswordAuthentication, SID[] sIDArray) throws IOException {
        block5: {
            DcerpcHandle dcerpcHandle;
            block6: {
                dcerpcHandle = null;
                LsaPolicyHandle lsaPolicyHandle = null;
                try {
                    dcerpcHandle = DcerpcHandle.getHandle("ncacn_np:" + string + "[\\PIPE\\lsarpc]", ntlmPasswordAuthentication);
                    String string2 = string;
                    int n2 = string2.indexOf(46);
                    if (n2 > 0 && !Character.isDigit(string2.charAt(0))) {
                        string2 = string2.substring(0, n2);
                    }
                    lsaPolicyHandle = new LsaPolicyHandle(dcerpcHandle, "\\\\" + string2, 2048);
                    SID.resolveSids(dcerpcHandle, lsaPolicyHandle, sIDArray);
                    Object var8_7 = null;
                    if (dcerpcHandle == null) break block5;
                    if (lsaPolicyHandle == null) break block6;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (dcerpcHandle != null) {
                        if (lsaPolicyHandle != null) {
                            lsaPolicyHandle.close();
                        }
                        dcerpcHandle.close();
                    }
                    throw throwable;
                }
                lsaPolicyHandle.close();
            }
            dcerpcHandle.close();
            {
            }
        }
    }

    public static void resolveSids(String string, NtlmPasswordAuthentication ntlmPasswordAuthentication, SID[] sIDArray, int n2, int n3) throws IOException {
        int n4;
        ArrayList<SID> arrayList = new ArrayList<SID>(sIDArray.length);
        for (n4 = 0; n4 < n3; ++n4) {
            SID sID = (SID)sid_cache.get(sIDArray[n2 + n4]);
            if (sID != null) {
                sIDArray[n2 + n4].type = sID.type;
                sIDArray[n2 + n4].domainName = sID.domainName;
                sIDArray[n2 + n4].acctName = sID.acctName;
                continue;
            }
            arrayList.add(sIDArray[n2 + n4]);
        }
        if (arrayList.size() > 0) {
            sIDArray = arrayList.toArray(new SID[0]);
            SID.resolveSids0(string, ntlmPasswordAuthentication, sIDArray);
            for (n4 = 0; n4 < sIDArray.length; ++n4) {
                sid_cache.put(sIDArray[n4], sIDArray[n4]);
            }
        }
    }

    public static void resolveSids(String string, NtlmPasswordAuthentication ntlmPasswordAuthentication, SID[] sIDArray) throws IOException {
        int n2;
        ArrayList<SID> arrayList = new ArrayList<SID>(sIDArray.length);
        for (n2 = 0; n2 < sIDArray.length; ++n2) {
            SID sID = (SID)sid_cache.get(sIDArray[n2]);
            if (sID != null) {
                sIDArray[n2].type = sID.type;
                sIDArray[n2].domainName = sID.domainName;
                sIDArray[n2].acctName = sID.acctName;
                continue;
            }
            arrayList.add(sIDArray[n2]);
        }
        if (arrayList.size() > 0) {
            sIDArray = arrayList.toArray(new SID[0]);
            SID.resolveSids0(string, ntlmPasswordAuthentication, sIDArray);
            for (n2 = 0; n2 < sIDArray.length; ++n2) {
                sid_cache.put(sIDArray[n2], sIDArray[n2]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SID getServerSid(String string, NtlmPasswordAuthentication ntlmPasswordAuthentication) throws IOException {
        SID sID;
        block4: {
            DcerpcHandle dcerpcHandle;
            block5: {
                dcerpcHandle = null;
                LsaPolicyHandle lsaPolicyHandle = null;
                lsarpc.LsarDomainInfo lsarDomainInfo = new lsarpc.LsarDomainInfo();
                try {
                    dcerpcHandle = DcerpcHandle.getHandle("ncacn_np:" + string + "[\\PIPE\\lsarpc]", ntlmPasswordAuthentication);
                    lsaPolicyHandle = new LsaPolicyHandle(dcerpcHandle, null, 1);
                    MsrpcQueryInformationPolicy msrpcQueryInformationPolicy = new MsrpcQueryInformationPolicy(lsaPolicyHandle, 5, (NdrObject)lsarDomainInfo);
                    dcerpcHandle.sendrecv(msrpcQueryInformationPolicy);
                    if (msrpcQueryInformationPolicy.retval != 0) {
                        throw new SmbException(msrpcQueryInformationPolicy.retval, false);
                    }
                    sID = new SID(lsarDomainInfo.sid, 3, new UnicodeString(lsarDomainInfo.name, false).toString(), null, false);
                    Object var8_7 = null;
                    if (dcerpcHandle == null) break block4;
                    if (lsaPolicyHandle == null) break block5;
                }
                catch (Throwable throwable) {
                    block6: {
                        Object var8_8 = null;
                        if (dcerpcHandle == null) break block6;
                        if (lsaPolicyHandle != null) {
                            lsaPolicyHandle.close();
                        }
                        dcerpcHandle.close();
                    }
                    throw throwable;
                }
                lsaPolicyHandle.close();
            }
            dcerpcHandle.close();
        }
        return sID;
    }

    public static byte[] toByteArray(rpc.sid_t sid_t2) {
        byte[] byArray = new byte[8 + sid_t2.sub_authority_count * 4];
        int n2 = 0;
        byArray[n2++] = sid_t2.revision;
        byArray[n2++] = sid_t2.sub_authority_count;
        System.arraycopy(sid_t2.identifier_authority, 0, byArray, n2, 6);
        n2 += 6;
        for (int i2 = 0; i2 < sid_t2.sub_authority_count; ++i2) {
            Encdec.enc_uint32le(sid_t2.sub_authority[i2], byArray, n2);
            n2 += 4;
        }
        return byArray;
    }

    public SID(byte[] byArray, int n2) {
        this.revision = byArray[n2++];
        this.sub_authority_count = byArray[n2++];
        this.identifier_authority = new byte[6];
        System.arraycopy(byArray, n2, this.identifier_authority, 0, 6);
        n2 += 6;
        if (this.sub_authority_count > 100) {
            throw new RuntimeException("Invalid SID sub_authority_count");
        }
        this.sub_authority = new int[this.sub_authority_count];
        for (int i2 = 0; i2 < this.sub_authority_count; ++i2) {
            this.sub_authority[i2] = ServerMessageBlock.readInt4(byArray, n2);
            n2 += 4;
        }
    }

    public SID(String string) throws SmbException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
        if (stringTokenizer.countTokens() < 3 || !stringTokenizer.nextToken().equals("S")) {
            throw new SmbException("Bad textual SID format: " + string);
        }
        this.revision = Byte.parseByte(stringTokenizer.nextToken());
        String string2 = stringTokenizer.nextToken();
        long l2 = 0L;
        l2 = string2.startsWith("0x") ? Long.parseLong(string2.substring(2), 16) : Long.parseLong(string2);
        this.identifier_authority = new byte[6];
        int n2 = 5;
        while (l2 > 0L) {
            this.identifier_authority[n2] = (byte)(l2 % 256L);
            l2 >>= 8;
            --n2;
        }
        this.sub_authority_count = (byte)stringTokenizer.countTokens();
        if (this.sub_authority_count > 0) {
            this.sub_authority = new int[this.sub_authority_count];
            for (n2 = 0; n2 < this.sub_authority_count; ++n2) {
                this.sub_authority[n2] = (int)(Long.parseLong(stringTokenizer.nextToken()) & 0xFFFFFFFFL);
            }
        }
    }

    public SID(SID sID, int n2) {
        this.revision = sID.revision;
        this.identifier_authority = sID.identifier_authority;
        this.sub_authority_count = (byte)(sID.sub_authority_count + 1);
        this.sub_authority = new int[this.sub_authority_count];
        for (int i2 = 0; i2 < sID.sub_authority_count; ++i2) {
            this.sub_authority[i2] = sID.sub_authority[i2];
        }
        this.sub_authority[i2] = n2;
    }

    public SID(rpc.sid_t sid_t2, int n2, String string, String string2, boolean bl) {
        this.revision = sid_t2.revision;
        this.sub_authority_count = sid_t2.sub_authority_count;
        this.identifier_authority = sid_t2.identifier_authority;
        this.sub_authority = sid_t2.sub_authority;
        this.type = n2;
        this.domainName = string;
        this.acctName = string2;
        if (bl) {
            this.sub_authority_count = (byte)(this.sub_authority_count - 1);
            this.sub_authority = new int[this.sub_authority_count];
            for (int i2 = 0; i2 < this.sub_authority_count; ++i2) {
                this.sub_authority[i2] = sid_t2.sub_authority[i2];
            }
        }
    }

    public SID getDomainSid() {
        return new SID(this, 3, this.domainName, null, this.getType() != 3);
    }

    public int getRid() {
        if (this.getType() == 3) {
            throw new IllegalArgumentException("This SID is a domain sid");
        }
        return this.sub_authority[this.sub_authority_count - 1];
    }

    public int getType() {
        if (this.origin_server != null) {
            this.resolveWeak();
        }
        return this.type;
    }

    public String getTypeText() {
        if (this.origin_server != null) {
            this.resolveWeak();
        }
        return SID_TYPE_NAMES[this.type];
    }

    public String getDomainName() {
        if (this.origin_server != null) {
            this.resolveWeak();
        }
        if (this.type == 8) {
            String string = this.toString();
            return string.substring(0, string.length() - this.getAccountName().length() - 1);
        }
        return this.domainName;
    }

    public String getAccountName() {
        if (this.origin_server != null) {
            this.resolveWeak();
        }
        if (this.type == 8) {
            return "" + this.sub_authority[this.sub_authority_count - 1];
        }
        if (this.type == 3) {
            return "";
        }
        return this.acctName;
    }

    public int hashCode() {
        int n2 = this.identifier_authority[5];
        for (int i2 = 0; i2 < this.sub_authority_count; ++i2) {
            n2 += 65599 * this.sub_authority[i2];
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object instanceof SID) {
            SID sID = (SID)object;
            if (sID == this) {
                return true;
            }
            if (sID.sub_authority_count == this.sub_authority_count) {
                int n2 = this.sub_authority_count;
                while (n2-- > 0) {
                    if (sID.sub_authority[n2] == this.sub_authority[n2]) continue;
                    return false;
                }
                for (n2 = 0; n2 < 6; ++n2) {
                    if (sID.identifier_authority[n2] == this.identifier_authority[n2]) continue;
                    return false;
                }
                return sID.revision == this.revision;
            }
        }
        return false;
    }

    public String toString() {
        String string = "S-" + (this.revision & 0xFF) + "-";
        if (this.identifier_authority[0] != 0 || this.identifier_authority[1] != 0) {
            string = string + "0x";
            string = string + Hexdump.toHexString(this.identifier_authority, 0, 6);
        } else {
            long l2 = 0L;
            long l3 = 0L;
            for (int i2 = 5; i2 > 1; --i2) {
                l3 += ((long)this.identifier_authority[i2] & 0xFFL) << (int)l2;
                l2 += 8L;
            }
            string = string + l3;
        }
        for (int i3 = 0; i3 < this.sub_authority_count; ++i3) {
            string = string + "-" + ((long)this.sub_authority[i3] & 0xFFFFFFFFL);
        }
        return string;
    }

    public String toDisplayString() {
        if (this.origin_server != null) {
            this.resolveWeak();
        }
        if (this.domainName != null) {
            String string = this.type == 3 ? this.domainName : (this.type == 5 || this.domainName.equals("BUILTIN") ? (this.type == 8 ? this.toString() : this.acctName) : this.domainName + "\\" + this.acctName);
            return string;
        }
        return this.toString();
    }

    public void resolve(String string, NtlmPasswordAuthentication ntlmPasswordAuthentication) throws IOException {
        SID[] sIDArray = new SID[]{this};
        SID.resolveSids(string, ntlmPasswordAuthentication, sIDArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resolveWeak() {
        if (this.origin_server != null) {
            try {
                this.resolve(this.origin_server, this.origin_auth);
            }
            catch (IOException iOException) {
            }
            finally {
                this.origin_server = null;
                this.origin_auth = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SID[] getGroupMemberSids0(DcerpcHandle dcerpcHandle, SamrDomainHandle samrDomainHandle, SID sID, int n2, int n3) throws IOException {
        SamrAliasHandle samrAliasHandle = null;
        lsarpc.LsarSidArray lsarSidArray = new lsarpc.LsarSidArray();
        MsrpcGetMembersInAlias msrpcGetMembersInAlias = null;
        try {
            samrAliasHandle = new SamrAliasHandle(dcerpcHandle, samrDomainHandle, 131084, n2);
            msrpcGetMembersInAlias = new MsrpcGetMembersInAlias(samrAliasHandle, lsarSidArray);
            dcerpcHandle.sendrecv(msrpcGetMembersInAlias);
            if (msrpcGetMembersInAlias.retval != 0) {
                throw new SmbException(msrpcGetMembersInAlias.retval, false);
            }
            SID[] sIDArray = new SID[msrpcGetMembersInAlias.sids.num_sids];
            String string = dcerpcHandle.getServer();
            NtlmPasswordAuthentication ntlmPasswordAuthentication = (NtlmPasswordAuthentication)dcerpcHandle.getPrincipal();
            for (int i2 = 0; i2 < sIDArray.length; ++i2) {
                sIDArray[i2] = new SID(msrpcGetMembersInAlias.sids.sids[i2].sid, 0, null, null, false);
                sIDArray[i2].origin_server = string;
                sIDArray[i2].origin_auth = ntlmPasswordAuthentication;
            }
            if (sIDArray.length > 0 && (n3 & 1) != 0) {
                SID.resolveSids(string, ntlmPasswordAuthentication, sIDArray);
            }
            SID[] sIDArray2 = sIDArray;
            return sIDArray2;
        }
        finally {
            if (samrAliasHandle != null) {
                samrAliasHandle.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SID[] getGroupMemberSids(String string, NtlmPasswordAuthentication ntlmPasswordAuthentication, int n2) throws IOException {
        SID[] sIDArray;
        block5: {
            DcerpcHandle dcerpcHandle;
            block6: {
                SamrPolicyHandle samrPolicyHandle;
                block7: {
                    if (this.type != 2 && this.type != 4) {
                        return new SID[0];
                    }
                    dcerpcHandle = null;
                    samrPolicyHandle = null;
                    SamrDomainHandle samrDomainHandle = null;
                    SID sID = this.getDomainSid();
                    try {
                        dcerpcHandle = DcerpcHandle.getHandle("ncacn_np:" + string + "[\\PIPE\\samr]", ntlmPasswordAuthentication);
                        samrPolicyHandle = new SamrPolicyHandle(dcerpcHandle, string, 48);
                        samrDomainHandle = new SamrDomainHandle(dcerpcHandle, samrPolicyHandle, 512, sID);
                        sIDArray = SID.getGroupMemberSids0(dcerpcHandle, samrDomainHandle, sID, this.getRid(), n2);
                        Object var10_9 = null;
                        if (dcerpcHandle == null) break block5;
                        if (samrPolicyHandle == null) break block6;
                        if (samrDomainHandle == null) break block7;
                    }
                    catch (Throwable throwable) {
                        block8: {
                            Object var10_10 = null;
                            if (dcerpcHandle == null) break block8;
                            if (samrPolicyHandle != null) {
                                if (samrDomainHandle != null) {
                                    samrDomainHandle.close();
                                }
                                samrPolicyHandle.close();
                            }
                            dcerpcHandle.close();
                        }
                        throw throwable;
                    }
                    samrDomainHandle.close();
                }
                samrPolicyHandle.close();
            }
            dcerpcHandle.close();
        }
        return sIDArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map getLocalGroupsMap(String string, NtlmPasswordAuthentication ntlmPasswordAuthentication, int n2) throws IOException {
        HashMap hashMap;
        block8: {
            DcerpcHandle dcerpcHandle;
            block9: {
                SamrPolicyHandle samrPolicyHandle;
                block10: {
                    SID sID = SID.getServerSid(string, ntlmPasswordAuthentication);
                    dcerpcHandle = null;
                    samrPolicyHandle = null;
                    SamrDomainHandle samrDomainHandle = null;
                    samr.SamrSamArray samrSamArray = new samr.SamrSamArray();
                    try {
                        dcerpcHandle = DcerpcHandle.getHandle("ncacn_np:" + string + "[\\PIPE\\samr]", ntlmPasswordAuthentication);
                        samrPolicyHandle = new SamrPolicyHandle(dcerpcHandle, string, 0x2000000);
                        samrDomainHandle = new SamrDomainHandle(dcerpcHandle, samrPolicyHandle, 0x2000000, sID);
                        MsrpcEnumerateAliasesInDomain msrpcEnumerateAliasesInDomain = new MsrpcEnumerateAliasesInDomain(samrDomainHandle, 65535, samrSamArray);
                        dcerpcHandle.sendrecv(msrpcEnumerateAliasesInDomain);
                        if (msrpcEnumerateAliasesInDomain.retval != 0) {
                            throw new SmbException(msrpcEnumerateAliasesInDomain.retval, false);
                        }
                        HashMap hashMap2 = new HashMap();
                        for (int i2 = 0; i2 < msrpcEnumerateAliasesInDomain.sam.count; ++i2) {
                            samr.SamrSamEntry samrSamEntry = msrpcEnumerateAliasesInDomain.sam.entries[i2];
                            SID[] sIDArray = SID.getGroupMemberSids0(dcerpcHandle, samrDomainHandle, sID, samrSamEntry.idx, n2);
                            SID sID2 = new SID(sID, samrSamEntry.idx);
                            sID2.type = 4;
                            sID2.domainName = sID.getDomainName();
                            sID2.acctName = new UnicodeString(samrSamEntry.name, false).toString();
                            for (int i3 = 0; i3 < sIDArray.length; ++i3) {
                                ArrayList<SID> arrayList = (ArrayList<SID>)hashMap2.get(sIDArray[i3]);
                                if (arrayList == null) {
                                    arrayList = new ArrayList<SID>();
                                    hashMap2.put(sIDArray[i3], arrayList);
                                }
                                if (arrayList.contains(sID2)) continue;
                                arrayList.add(sID2);
                            }
                        }
                        hashMap = hashMap2;
                        Object var17_17 = null;
                        if (dcerpcHandle == null) break block8;
                        if (samrPolicyHandle == null) break block9;
                        if (samrDomainHandle == null) break block10;
                    }
                    catch (Throwable throwable) {
                        block11: {
                            Object var17_18 = null;
                            if (dcerpcHandle == null) break block11;
                            if (samrPolicyHandle != null) {
                                if (samrDomainHandle != null) {
                                    samrDomainHandle.close();
                                }
                                samrPolicyHandle.close();
                            }
                            dcerpcHandle.close();
                        }
                        throw throwable;
                    }
                    samrDomainHandle.close();
                }
                samrPolicyHandle.close();
            }
            dcerpcHandle.close();
        }
        return hashMap;
    }

    static {
        try {
            EVERYONE = new SID("S-1-1-0");
            CREATOR_OWNER = new SID("S-1-3-0");
            SYSTEM = new SID("S-1-5-18");
        }
        catch (SmbException smbException) {
            // empty catch block
        }
        sid_cache = Collections.synchronizedMap(new HashMap());
    }
}

