/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.TimeZone;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SigningDigest;
import jcifs.smb.SmbConstants;
import jcifs.smb.SmbException;
import jcifs.util.Hexdump;
import jcifs.util.LogStream;
import jcifs.util.transport.Request;
import jcifs.util.transport.Response;

abstract class ServerMessageBlock
extends Response
implements Request,
SmbConstants {
    static LogStream log = LogStream.getInstance();
    static final byte[] header = new byte[]{-1, 83, 77, 66, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static final byte SMB_COM_CREATE_DIRECTORY = 0;
    static final byte SMB_COM_DELETE_DIRECTORY = 1;
    static final byte SMB_COM_CLOSE = 4;
    static final byte SMB_COM_DELETE = 6;
    static final byte SMB_COM_RENAME = 7;
    static final byte SMB_COM_QUERY_INFORMATION = 8;
    static final byte SMB_COM_WRITE = 11;
    static final byte SMB_COM_CHECK_DIRECTORY = 16;
    static final byte SMB_COM_TRANSACTION = 37;
    static final byte SMB_COM_TRANSACTION_SECONDARY = 38;
    static final byte SMB_COM_MOVE = 42;
    static final byte SMB_COM_ECHO = 43;
    static final byte SMB_COM_OPEN_ANDX = 45;
    static final byte SMB_COM_READ_ANDX = 46;
    static final byte SMB_COM_WRITE_ANDX = 47;
    static final byte SMB_COM_TRANSACTION2 = 50;
    static final byte SMB_COM_FIND_CLOSE2 = 52;
    static final byte SMB_COM_TREE_DISCONNECT = 113;
    static final byte SMB_COM_NEGOTIATE = 114;
    static final byte SMB_COM_SESSION_SETUP_ANDX = 115;
    static final byte SMB_COM_LOGOFF_ANDX = 116;
    static final byte SMB_COM_TREE_CONNECT_ANDX = 117;
    static final byte SMB_COM_NT_TRANSACT = -96;
    static final byte SMB_COM_NT_TRANSACT_SECONDARY = -95;
    static final byte SMB_COM_NT_CREATE_ANDX = -94;
    byte command;
    byte flags = (byte)24;
    int headerStart;
    int length;
    int batchLevel = 0;
    int errorCode;
    int flags2;
    int tid;
    int pid = SmbConstants.PID;
    int uid;
    int mid;
    int wordCount;
    int byteCount;
    boolean useUnicode;
    boolean received;
    boolean extendedSecurity;
    long responseTimeout = 1L;
    int signSeq;
    boolean verifyFailed;
    NtlmPasswordAuthentication auth = null;
    String path;
    SigningDigest digest = null;
    ServerMessageBlock response;

    static void writeInt2(long l2, byte[] byArray, int n2) {
        byArray[n2] = (byte)l2;
        byArray[++n2] = (byte)(l2 >> 8);
    }

    static void writeInt4(long l2, byte[] byArray, int n2) {
        byArray[n2] = (byte)l2;
        byArray[++n2] = (byte)(l2 >>= 8);
        byArray[++n2] = (byte)(l2 >>= 8);
        byArray[++n2] = (byte)(l2 >> 8);
    }

    static int readInt2(byte[] byArray, int n2) {
        return (byArray[n2] & 0xFF) + ((byArray[n2 + 1] & 0xFF) << 8);
    }

    static int readInt4(byte[] byArray, int n2) {
        return (byArray[n2] & 0xFF) + ((byArray[n2 + 1] & 0xFF) << 8) + ((byArray[n2 + 2] & 0xFF) << 16) + ((byArray[n2 + 3] & 0xFF) << 24);
    }

    static long readInt8(byte[] byArray, int n2) {
        return ((long)ServerMessageBlock.readInt4(byArray, n2) & 0xFFFFFFFFL) + ((long)ServerMessageBlock.readInt4(byArray, n2 + 4) << 32);
    }

    static void writeInt8(long l2, byte[] byArray, int n2) {
        byArray[n2] = (byte)l2;
        byArray[++n2] = (byte)(l2 >>= 8);
        byArray[++n2] = (byte)(l2 >>= 8);
        byArray[++n2] = (byte)(l2 >>= 8);
        byArray[++n2] = (byte)(l2 >>= 8);
        byArray[++n2] = (byte)(l2 >>= 8);
        byArray[++n2] = (byte)(l2 >>= 8);
        byArray[++n2] = (byte)(l2 >> 8);
    }

    static long readTime(byte[] byArray, int n2) {
        int n3 = ServerMessageBlock.readInt4(byArray, n2);
        int n4 = ServerMessageBlock.readInt4(byArray, n2 + 4);
        long l2 = (long)n4 << 32 | (long)n3 & 0xFFFFFFFFL;
        l2 = l2 / 10000L - 11644473600000L;
        return l2;
    }

    static void writeTime(long l2, byte[] byArray, int n2) {
        if (l2 != 0L) {
            l2 = (l2 + 11644473600000L) * 10000L;
        }
        ServerMessageBlock.writeInt8(l2, byArray, n2);
    }

    static long readUTime(byte[] byArray, int n2) {
        return (long)ServerMessageBlock.readInt4(byArray, n2) * 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeUTime(long l2, byte[] byArray, int n2) {
        if (l2 == 0L || l2 == -1L) {
            ServerMessageBlock.writeInt4(-1L, byArray, n2);
            return;
        }
        TimeZone timeZone = SmbConstants.TZ;
        synchronized (timeZone) {
            if (SmbConstants.TZ.inDaylightTime(new Date())) {
                if (!SmbConstants.TZ.inDaylightTime(new Date(l2))) {
                    l2 -= 3600000L;
                }
            } else if (SmbConstants.TZ.inDaylightTime(new Date(l2))) {
                l2 += 3600000L;
            }
        }
        ServerMessageBlock.writeInt4((int)(l2 / 1000L), byArray, n2);
    }

    ServerMessageBlock() {
    }

    void reset() {
        this.flags = (byte)24;
        this.flags2 = 0;
        this.errorCode = 0;
        this.received = false;
        this.digest = null;
    }

    int writeString(String string, byte[] byArray, int n2) {
        return this.writeString(string, byArray, n2, this.useUnicode);
    }

    int writeString(String string, byte[] byArray, int n2, boolean bl) {
        int n3;
        block5: {
            n3 = n2;
            try {
                if (bl) {
                    if ((n2 - this.headerStart) % 2 != 0) {
                        byArray[n2++] = 0;
                    }
                    System.arraycopy(string.getBytes("UTF-16LE"), 0, byArray, n2, string.length() * 2);
                    n2 += string.length() * 2;
                    byArray[n2++] = 0;
                    byArray[n2++] = 0;
                } else {
                    byte[] byArray2 = string.getBytes(SmbConstants.OEM_ENCODING);
                    System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
                    n2 += byArray2.length;
                    byArray[n2++] = 0;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (LogStream.level <= 1) break block5;
                unsupportedEncodingException.printStackTrace(log);
            }
        }
        return n2 - n3;
    }

    String readString(byte[] byArray, int n2) {
        return this.readString(byArray, n2, 256, this.useUnicode);
    }

    String readString(byte[] byArray, int n2, int n3, boolean bl) {
        String string;
        block9: {
            int n4 = 0;
            string = null;
            try {
                if (bl) {
                    if ((n2 - this.headerStart) % 2 != 0) {
                        ++n2;
                    }
                    while (byArray[n2 + n4] != 0 || byArray[n2 + n4 + 1] != 0) {
                        if ((n4 += 2) <= n3) continue;
                        if (LogStream.level > 0) {
                            Hexdump.hexdump(System.err, byArray, n2, n3 < 128 ? n3 + 8 : 128);
                        }
                        throw new RuntimeException("zero termination not found");
                    }
                    string = new String(byArray, n2, n4, "UTF-16LE");
                } else {
                    while (byArray[n2 + n4] != 0) {
                        if (++n4 <= n3) continue;
                        if (LogStream.level > 0) {
                            Hexdump.hexdump(System.err, byArray, n2, n3 < 128 ? n3 + 8 : 128);
                        }
                        throw new RuntimeException("zero termination not found");
                    }
                    string = new String(byArray, n2, n4, SmbConstants.OEM_ENCODING);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (LogStream.level <= 1) break block9;
                unsupportedEncodingException.printStackTrace(log);
            }
        }
        return string;
    }

    String readString(byte[] byArray, int n2, int n3, int n4, boolean bl) {
        String string;
        block11: {
            int n5 = 0;
            string = null;
            try {
                if (bl) {
                    if ((n2 - this.headerStart) % 2 != 0) {
                        ++n2;
                    }
                    n5 = 0;
                    while (n2 + n5 + 1 < n3 && (byArray[n2 + n5] != 0 || byArray[n2 + n5 + 1] != 0)) {
                        if (n5 > n4) {
                            if (LogStream.level > 0) {
                                Hexdump.hexdump(System.err, byArray, n2, n4 < 128 ? n4 + 8 : 128);
                            }
                            throw new RuntimeException("zero termination not found");
                        }
                        n5 += 2;
                    }
                    string = new String(byArray, n2, n5, "UTF-16LE");
                } else {
                    n5 = 0;
                    while (n2 < n3 && byArray[n2 + n5] != 0) {
                        if (n5 > n4) {
                            if (LogStream.level > 0) {
                                Hexdump.hexdump(System.err, byArray, n2, n4 < 128 ? n4 + 8 : 128);
                            }
                            throw new RuntimeException("zero termination not found");
                        }
                        ++n5;
                    }
                    string = new String(byArray, n2, n5, SmbConstants.OEM_ENCODING);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (LogStream.level <= 1) break block11;
                unsupportedEncodingException.printStackTrace(log);
            }
        }
        return string;
    }

    int stringWireLength(String string, int n2) {
        int n3 = string.length() + 1;
        if (this.useUnicode) {
            n3 = string.length() * 2 + 2;
            n3 = n2 % 2 != 0 ? n3 + 1 : n3;
        }
        return n3;
    }

    int readStringLength(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        while (byArray[n2 + n4] != 0) {
            if (n4++ <= n3) continue;
            throw new RuntimeException("zero termination not found: " + this);
        }
        return n4;
    }

    int encode(byte[] byArray, int n2) {
        int n3 = this.headerStart = n2;
        n2 += this.writeHeaderWireFormat(byArray, n2);
        this.wordCount = this.writeParameterWordsWireFormat(byArray, n2 + 1);
        byArray[n2++] = (byte)(this.wordCount / 2 & 0xFF);
        this.wordCount /= 2;
        this.byteCount = this.writeBytesWireFormat(byArray, (n2 += this.wordCount) + 2);
        byArray[n2++] = (byte)(this.byteCount & 0xFF);
        byArray[n2++] = (byte)(this.byteCount >> 8 & 0xFF);
        this.length = (n2 += this.byteCount) - n3;
        if (this.digest != null) {
            this.digest.sign(byArray, this.headerStart, this.length, this, this.response);
        }
        return this.length;
    }

    int decode(byte[] byArray, int n2) {
        int n3;
        int n4 = this.headerStart = n2;
        n2 += this.readHeaderWireFormat(byArray, n2);
        this.wordCount = byArray[n2++];
        if (this.wordCount != 0) {
            n3 = this.readParameterWordsWireFormat(byArray, n2);
            if (n3 != this.wordCount * 2) {
                if (LogStream.level >= 5) {
                    log.println("wordCount * 2=" + this.wordCount * 2 + " but readParameterWordsWireFormat returned " + n3);
                }
            }
            n2 += this.wordCount * 2;
        }
        this.byteCount = ServerMessageBlock.readInt2(byArray, n2);
        n2 += 2;
        if (this.byteCount != 0) {
            n3 = this.readBytesWireFormat(byArray, n2);
            if (n3 != this.byteCount) {
                if (LogStream.level >= 5) {
                    log.println("byteCount=" + this.byteCount + " but readBytesWireFormat returned " + n3);
                }
            }
            n2 += this.byteCount;
        }
        this.length = n2 - n4;
        return this.length;
    }

    int writeHeaderWireFormat(byte[] byArray, int n2) {
        System.arraycopy(header, 0, byArray, n2, header.length);
        byArray[n2 + 4] = this.command;
        byArray[n2 + 9] = this.flags;
        ServerMessageBlock.writeInt2(this.flags2, byArray, n2 + 9 + 1);
        ServerMessageBlock.writeInt2(this.tid, byArray, n2 += 24);
        ServerMessageBlock.writeInt2(this.pid, byArray, n2 + 2);
        ServerMessageBlock.writeInt2(this.uid, byArray, n2 + 4);
        ServerMessageBlock.writeInt2(this.mid, byArray, n2 + 6);
        return 32;
    }

    int readHeaderWireFormat(byte[] byArray, int n2) {
        this.command = byArray[n2 + 4];
        this.errorCode = ServerMessageBlock.readInt4(byArray, n2 + 5);
        this.flags = byArray[n2 + 9];
        this.flags2 = ServerMessageBlock.readInt2(byArray, n2 + 9 + 1);
        this.tid = ServerMessageBlock.readInt2(byArray, n2 + 24);
        this.pid = ServerMessageBlock.readInt2(byArray, n2 + 24 + 2);
        this.uid = ServerMessageBlock.readInt2(byArray, n2 + 24 + 4);
        this.mid = ServerMessageBlock.readInt2(byArray, n2 + 24 + 6);
        return 32;
    }

    boolean isResponse() {
        return (this.flags & 0x80) == 128;
    }

    abstract int writeParameterWordsWireFormat(byte[] var1, int var2);

    abstract int writeBytesWireFormat(byte[] var1, int var2);

    abstract int readParameterWordsWireFormat(byte[] var1, int var2);

    abstract int readBytesWireFormat(byte[] var1, int var2);

    public int hashCode() {
        return this.mid;
    }

    public boolean equals(Object object) {
        return object instanceof ServerMessageBlock && ((ServerMessageBlock)object).mid == this.mid;
    }

    public String toString() {
        String string;
        switch (this.command) {
            case 114: {
                string = "SMB_COM_NEGOTIATE";
                break;
            }
            case 115: {
                string = "SMB_COM_SESSION_SETUP_ANDX";
                break;
            }
            case 117: {
                string = "SMB_COM_TREE_CONNECT_ANDX";
                break;
            }
            case 8: {
                string = "SMB_COM_QUERY_INFORMATION";
                break;
            }
            case 16: {
                string = "SMB_COM_CHECK_DIRECTORY";
                break;
            }
            case 37: {
                string = "SMB_COM_TRANSACTION";
                break;
            }
            case 50: {
                string = "SMB_COM_TRANSACTION2";
                break;
            }
            case 38: {
                string = "SMB_COM_TRANSACTION_SECONDARY";
                break;
            }
            case 52: {
                string = "SMB_COM_FIND_CLOSE2";
                break;
            }
            case 113: {
                string = "SMB_COM_TREE_DISCONNECT";
                break;
            }
            case 116: {
                string = "SMB_COM_LOGOFF_ANDX";
                break;
            }
            case 43: {
                string = "SMB_COM_ECHO";
                break;
            }
            case 42: {
                string = "SMB_COM_MOVE";
                break;
            }
            case 7: {
                string = "SMB_COM_RENAME";
                break;
            }
            case 6: {
                string = "SMB_COM_DELETE";
                break;
            }
            case 1: {
                string = "SMB_COM_DELETE_DIRECTORY";
                break;
            }
            case -94: {
                string = "SMB_COM_NT_CREATE_ANDX";
                break;
            }
            case 45: {
                string = "SMB_COM_OPEN_ANDX";
                break;
            }
            case 46: {
                string = "SMB_COM_READ_ANDX";
                break;
            }
            case 4: {
                string = "SMB_COM_CLOSE";
                break;
            }
            case 47: {
                string = "SMB_COM_WRITE_ANDX";
                break;
            }
            case 0: {
                string = "SMB_COM_CREATE_DIRECTORY";
                break;
            }
            case -96: {
                string = "SMB_COM_NT_TRANSACT";
                break;
            }
            case -95: {
                string = "SMB_COM_NT_TRANSACT_SECONDARY";
                break;
            }
            default: {
                string = "UNKNOWN";
            }
        }
        String string2 = this.errorCode == 0 ? "0" : SmbException.getMessageByCode(this.errorCode);
        return new String("command=" + string + ",received=" + this.received + ",errorCode=" + string2 + ",flags=0x" + Hexdump.toHexString(this.flags & 0xFF, 4) + ",flags2=0x" + Hexdump.toHexString(this.flags2, 4) + ",signSeq=" + this.signSeq + ",tid=" + this.tid + ",pid=" + this.pid + ",uid=" + this.uid + ",mid=" + this.mid + ",wordCount=" + this.wordCount + ",byteCount=" + this.byteCount);
    }
}

