/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SmbComReadAndXResponse;
import jcifs.smb.SmbConstants;
import jcifs.smb.SmbException;
import jcifs.smb.SmbTransport;
import jcifs.util.Hexdump;
import jcifs.util.LogStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SigningDigest
implements SmbConstants {
    static LogStream log = LogStream.getInstance();
    private MessageDigest e;
    private byte[] d;
    private boolean c = false;
    private int void;
    private int long;

    public SigningDigest(byte[] byArray, boolean bl) throws SmbException {
        try {
            this.e = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (LogStream.level > 0) {
                noSuchAlgorithmException.printStackTrace(log);
            }
            throw new SmbException("MD5", (Throwable)noSuchAlgorithmException);
        }
        this.d = byArray;
        this.c = bl;
        this.void = 0;
        this.long = 0;
        if (LogStream.level >= 5) {
            log.println("macSigningKey:");
            Hexdump.hexdump(log, byArray, 0, byArray.length);
        }
    }

    public SigningDigest(SmbTransport smbTransport, NtlmPasswordAuthentication ntlmPasswordAuthentication) throws SmbException {
        try {
            this.e = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (LogStream.level > 0) {
                noSuchAlgorithmException.printStackTrace(log);
            }
            throw new SmbException("MD5", (Throwable)noSuchAlgorithmException);
        }
        try {
            switch (SmbConstants.LM_COMPATIBILITY) {
                case 0: 
                case 1: 
                case 2: {
                    this.d = new byte[40];
                    ntlmPasswordAuthentication.getUserSessionKey(smbTransport.server.encryptionKey, this.d, 0);
                    System.arraycopy(ntlmPasswordAuthentication.getUnicodeHash(smbTransport.server.encryptionKey), 0, this.d, 16, 24);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    this.d = new byte[16];
                    ntlmPasswordAuthentication.getUserSessionKey(smbTransport.server.encryptionKey, this.d, 0);
                    break;
                }
                default: {
                    this.d = new byte[40];
                    ntlmPasswordAuthentication.getUserSessionKey(smbTransport.server.encryptionKey, this.d, 0);
                    System.arraycopy(ntlmPasswordAuthentication.getUnicodeHash(smbTransport.server.encryptionKey), 0, this.d, 16, 24);
                    break;
                }
            }
        }
        catch (Exception exception) {
            throw new SmbException("", (Throwable)exception);
        }
        if (LogStream.level >= 5) {
            log.println("LM_COMPATIBILITY=" + SmbConstants.LM_COMPATIBILITY);
            Hexdump.hexdump(log, this.d, 0, this.d.length);
        }
    }

    public void update(byte[] byArray, int n2, int n3) {
        if (LogStream.level >= 5) {
            log.println("update: " + this.void + " " + n2 + ":" + n3);
            Hexdump.hexdump(log, byArray, n2, Math.min(n3, 256));
            log.flush();
        }
        if (n3 == 0) {
            return;
        }
        this.e.update(byArray, n2, n3);
        ++this.void;
    }

    public byte[] digest() {
        byte[] byArray = this.e.digest();
        if (LogStream.level >= 5) {
            log.println("digest: ");
            Hexdump.hexdump(log, byArray, 0, byArray.length);
            log.flush();
        }
        this.void = 0;
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sign(byte[] byArray, int n2, int n3, ServerMessageBlock serverMessageBlock, ServerMessageBlock serverMessageBlock2) {
        serverMessageBlock.signSeq = this.long;
        if (serverMessageBlock2 != null) {
            serverMessageBlock2.signSeq = this.long + 1;
            serverMessageBlock2.verifyFailed = false;
        }
        try {
            this.update(this.d, 0, this.d.length);
            int n4 = n2 + 14;
            for (int i2 = 0; i2 < 8; ++i2) {
                byArray[n4 + i2] = 0;
            }
            ServerMessageBlock.writeInt4(this.long, byArray, n4);
            this.update(byArray, n2, n3);
            System.arraycopy(this.digest(), 0, byArray, n4, 8);
            if (this.c) {
                this.c = false;
                System.arraycopy("BSRSPYL ".getBytes(), 0, byArray, n4, 8);
            }
        }
        catch (Exception exception) {
            if (LogStream.level > 0) {
                exception.printStackTrace(log);
            }
        }
        finally {
            this.long += 2;
        }
    }

    boolean verify(byte[] byArray, int n2, ServerMessageBlock serverMessageBlock) {
        int n3;
        Object object;
        this.update(this.d, 0, this.d.length);
        int n4 = n2;
        this.update(byArray, n4, 14);
        n4 += 14;
        byte[] byArray2 = new byte[8];
        ServerMessageBlock.writeInt4(serverMessageBlock.signSeq, byArray2, 0);
        this.update(byArray2, 0, byArray2.length);
        n4 += 8;
        if (serverMessageBlock.command == 46) {
            object = (SmbComReadAndXResponse)serverMessageBlock;
            n3 = serverMessageBlock.length - ((SmbComReadAndXResponse)object).dataLength;
            this.update(byArray, n4, n3 - 14 - 8);
            this.update(((SmbComReadAndXResponse)object).b, ((SmbComReadAndXResponse)object).off, ((SmbComReadAndXResponse)object).dataLength);
        } else {
            this.update(byArray, n4, serverMessageBlock.length - 14 - 8);
        }
        object = this.digest();
        for (n3 = 0; n3 < 8; ++n3) {
            if (object[n3] == byArray[n2 + 14 + n3]) continue;
            if (LogStream.level >= 2) {
                log.println("signature verification failure");
                Hexdump.hexdump(log, (byte[])object, 0, 8);
                Hexdump.hexdump(log, byArray, n2 + 14, 8);
            }
            serverMessageBlock.verifyFailed = true;
            return true;
        }
        serverMessageBlock.verifyFailed = false;
        return false;
    }

    public String toString() {
        return "LM_COMPATIBILITY=" + SmbConstants.LM_COMPATIBILITY + " MacSigningKey=" + Hexdump.toHexString(this.d, 0, this.d.length);
    }
}

