/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SmbConstants;
import jcifs.smb.SmbTransport;
import jcifs.util.Hexdump;
import jcifs.util.LogStream;

class SmbComNegotiateResponse
extends ServerMessageBlock {
    int dialectIndex;
    SmbTransport.ServerData server;

    SmbComNegotiateResponse(SmbTransport.ServerData serverData) {
        this.server = serverData;
    }

    int writeParameterWordsWireFormat(byte[] byArray, int n2) {
        return 0;
    }

    int writeBytesWireFormat(byte[] byArray, int n2) {
        return 0;
    }

    int readParameterWordsWireFormat(byte[] byArray, int n2) {
        int n3 = n2;
        this.dialectIndex = SmbComNegotiateResponse.readInt2(byArray, n2);
        n2 += 2;
        if (this.dialectIndex > 10) {
            return n2 - n3;
        }
        this.server.securityMode = byArray[n2++] & 0xFF;
        this.server.security = this.server.securityMode & 1;
        this.server.encryptedPasswords = (this.server.securityMode & 2) == 2;
        this.server.signaturesEnabled = (this.server.securityMode & 4) == 4;
        this.server.signaturesRequired = (this.server.securityMode & 8) == 8;
        this.server.maxMpxCount = SmbComNegotiateResponse.readInt2(byArray, n2);
        this.server.maxNumberVcs = SmbComNegotiateResponse.readInt2(byArray, n2 += 2);
        this.server.maxBufferSize = SmbComNegotiateResponse.readInt4(byArray, n2 += 2);
        this.server.maxRawSize = SmbComNegotiateResponse.readInt4(byArray, n2 += 4);
        this.server.sessionKey = SmbComNegotiateResponse.readInt4(byArray, n2 += 4);
        this.server.capabilities = SmbComNegotiateResponse.readInt4(byArray, n2 += 4);
        this.server.serverTime = SmbComNegotiateResponse.readTime(byArray, n2 += 4);
        this.server.serverTimeZone = SmbComNegotiateResponse.readInt2(byArray, n2 += 8);
        n2 += 2;
        this.server.encryptionKeyLength = byArray[n2++] & 0xFF;
        return n2 - n3;
    }

    int readBytesWireFormat(byte[] byArray, int n2) {
        int n3 = n2;
        if ((this.server.capabilities & Integer.MIN_VALUE) == 0) {
            this.server.encryptionKey = new byte[this.server.encryptionKeyLength];
            System.arraycopy(byArray, n2, this.server.encryptionKey, 0, this.server.encryptionKeyLength);
            n2 += this.server.encryptionKeyLength;
            if (this.byteCount > this.server.encryptionKeyLength) {
                int n4;
                block10: {
                    n4 = 0;
                    try {
                        if ((this.flags2 & 0x8000) == 32768) {
                            while (byArray[n2 + n4] != 0 || byArray[n2 + n4 + 1] != 0) {
                                if ((n4 += 2) <= 256) continue;
                                throw new RuntimeException("zero termination not found");
                            }
                            this.server.oemDomainName = new String(byArray, n2, n4, "UTF-16LE");
                        } else {
                            while (byArray[n2 + n4] != 0) {
                                if (++n4 <= 256) continue;
                                throw new RuntimeException("zero termination not found");
                            }
                            this.server.oemDomainName = new String(byArray, n2, n4, SmbConstants.OEM_ENCODING);
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        if (LogStream.level <= 1) break block10;
                        unsupportedEncodingException.printStackTrace(log);
                    }
                }
                n2 += n4;
            } else {
                this.server.oemDomainName = new String();
            }
        } else {
            this.server.guid = new byte[16];
            System.arraycopy(byArray, n2, this.server.guid, 0, 16);
            this.server.oemDomainName = new String();
        }
        return n2 - n3;
    }

    public String toString() {
        return new String("SmbComNegotiateResponse[" + super.toString() + ",wordCount=" + this.wordCount + ",dialectIndex=" + this.dialectIndex + ",securityMode=0x" + Hexdump.toHexString(this.server.securityMode, 1) + ",security=" + (this.server.security == 0 ? "share" : "user") + ",encryptedPasswords=" + this.server.encryptedPasswords + ",maxMpxCount=" + this.server.maxMpxCount + ",maxNumberVcs=" + this.server.maxNumberVcs + ",maxBufferSize=" + this.server.maxBufferSize + ",maxRawSize=" + this.server.maxRawSize + ",sessionKey=0x" + Hexdump.toHexString(this.server.sessionKey, 8) + ",capabilities=0x" + Hexdump.toHexString(this.server.capabilities, 8) + ",serverTime=" + new Date(this.server.serverTime) + ",serverTimeZone=" + this.server.serverTimeZone + ",encryptionKeyLength=" + this.server.encryptionKeyLength + ",byteCount=" + this.byteCount + ",oemDomainName=" + this.server.oemDomainName + "]");
    }
}

