/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.util.Date;
import jcifs.Config;
import jcifs.smb.AndXServerMessageBlock;
import jcifs.smb.ServerMessageBlock;
import jcifs.util.Hexdump;

class SmbComOpenAndX
extends AndXServerMessageBlock {
    private static final int bc = 1;
    private static final int bf = 2;
    private static final int bg = 4;
    private static final int bd = 0;
    private static final int bp = 16;
    private static final int bj = 32;
    private static final int be = 48;
    private static final int bb = 64;
    private static final int bn = 4096;
    private static final int bh = 16384;
    private static final int bo = 16;
    private static final int bm = 0;
    private static final int bl = 1;
    private static final int bi = 2;
    private static final int bk = Config.getInt("jcifs.smb.client.OpenAndX.ReadAndX", 1);
    int flags;
    int desiredAccess;
    int searchAttributes;
    int fileAttributes;
    int creationTime;
    int openFunction;
    int allocationSize;

    SmbComOpenAndX(String string, int n2, int n3, ServerMessageBlock serverMessageBlock) {
        super(serverMessageBlock);
        this.path = string;
        this.command = (byte)45;
        this.desiredAccess = n2 & 3;
        if (this.desiredAccess == 3) {
            this.desiredAccess = 2;
        }
        this.desiredAccess |= 0x40;
        this.desiredAccess &= 0xFFFFFFFE;
        this.searchAttributes = 22;
        this.fileAttributes = 0;
        this.openFunction = (n3 & 0x40) == 64 ? ((n3 & 0x10) == 16 ? 18 : 2) : ((n3 & 0x10) == 16 ? ((n3 & 0x20) == 32 ? 16 : 17) : 1);
    }

    int getBatchLimit(byte by) {
        return by == 46 ? bk : 0;
    }

    int writeParameterWordsWireFormat(byte[] byArray, int n2) {
        int n3 = n2;
        SmbComOpenAndX.writeInt2(this.flags, byArray, n2);
        SmbComOpenAndX.writeInt2(this.desiredAccess, byArray, n2 += 2);
        SmbComOpenAndX.writeInt2(this.searchAttributes, byArray, n2 += 2);
        SmbComOpenAndX.writeInt2(this.fileAttributes, byArray, n2 += 2);
        this.creationTime = 0;
        SmbComOpenAndX.writeInt4(this.creationTime, byArray, n2 += 2);
        SmbComOpenAndX.writeInt2(this.openFunction, byArray, n2 += 4);
        SmbComOpenAndX.writeInt4(this.allocationSize, byArray, n2 += 2);
        n2 += 4;
        for (int i2 = 0; i2 < 8; ++i2) {
            byArray[n2++] = 0;
        }
        return n2 - n3;
    }

    int writeBytesWireFormat(byte[] byArray, int n2) {
        int n3 = n2;
        if (this.useUnicode) {
            byArray[n2++] = 0;
        }
        n2 += this.writeString(this.path, byArray, n2);
        return n2 - n3;
    }

    int readParameterWordsWireFormat(byte[] byArray, int n2) {
        return 0;
    }

    int readBytesWireFormat(byte[] byArray, int n2) {
        return 0;
    }

    public String toString() {
        return new String("SmbComOpenAndX[" + super.toString() + ",flags=0x" + Hexdump.toHexString(this.flags, 2) + ",desiredAccess=0x" + Hexdump.toHexString(this.desiredAccess, 4) + ",searchAttributes=0x" + Hexdump.toHexString(this.searchAttributes, 4) + ",fileAttributes=0x" + Hexdump.toHexString(this.fileAttributes, 4) + ",creationTime=" + new Date(this.creationTime) + ",openFunction=0x" + Hexdump.toHexString(this.openFunction, 2) + ",allocationSize=" + this.allocationSize + ",fileName=" + this.path + "]");
    }
}

