/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import jcifs.Config;
import jcifs.smb.AndXServerMessageBlock;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SmbConstants;
import jcifs.smb.SmbException;
import jcifs.smb.SmbSession;
import jcifs.smb.SmbTransport;

class SmbComSessionSetupAndX
extends AndXServerMessageBlock {
    private static final int a1 = Config.getInt("jcifs.smb.client.SessionSetupAndX.TreeConnectAndX", 1);
    private static final boolean aZ = Config.getBoolean("jcifs.smb.client.disablePlainTextPasswords", true);
    private byte[] aY;
    private byte[] aX;
    private byte[] aT = null;
    private int aV;
    private int aU;
    private String a0;
    private String aW;
    SmbSession session;
    Object cred;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    SmbComSessionSetupAndX(SmbSession smbSession, ServerMessageBlock serverMessageBlock, Object object) throws SmbException {
        super(serverMessageBlock);
        this.command = (byte)115;
        this.session = smbSession;
        this.cred = object;
        this.aV = smbSession.transport.sessionKey;
        this.aU = smbSession.transport.capabilities;
        if (smbSession.transport.server.security == 1) {
            if (object instanceof NtlmPasswordAuthentication) {
                NtlmPasswordAuthentication ntlmPasswordAuthentication = (NtlmPasswordAuthentication)object;
                if (ntlmPasswordAuthentication == NtlmPasswordAuthentication.ANONYMOUS) {
                    this.aY = new byte[0];
                    this.aX = new byte[0];
                    this.aU &= Integer.MAX_VALUE;
                } else if (smbSession.transport.server.encryptedPasswords) {
                    this.aY = ntlmPasswordAuthentication.getAnsiHash(smbSession.transport.server.encryptionKey);
                    this.aX = ntlmPasswordAuthentication.getUnicodeHash(smbSession.transport.server.encryptionKey);
                    if (this.aY.length == 0 && this.aX.length == 0) {
                        throw new RuntimeException("Null setup prohibited.");
                    }
                } else {
                    if (aZ) {
                        throw new RuntimeException("Plain text passwords are disabled");
                    }
                    if (this.useUnicode) {
                        String string = ntlmPasswordAuthentication.getPassword();
                        this.aY = new byte[0];
                        this.aX = new byte[(string.length() + 1) * 2];
                        this.writeString(string, this.aX, 0);
                    } else {
                        String string = ntlmPasswordAuthentication.getPassword();
                        this.aY = new byte[(string.length() + 1) * 2];
                        this.aX = new byte[0];
                        this.writeString(string, this.aY, 0);
                    }
                }
                this.a0 = ntlmPasswordAuthentication.username;
                if (this.useUnicode) {
                    this.a0 = this.a0.toUpperCase();
                }
                this.aW = ntlmPasswordAuthentication.domain.toUpperCase();
                return;
            } else {
                if (!(object instanceof byte[])) throw new SmbException("Unsupported credential type");
                this.aT = (byte[])object;
            }
            return;
        } else {
            if (smbSession.transport.server.security != 0) throw new SmbException("Unsupported");
            if (!(object instanceof NtlmPasswordAuthentication)) throw new SmbException("Unsupported credential type");
            NtlmPasswordAuthentication ntlmPasswordAuthentication = (NtlmPasswordAuthentication)object;
            this.aY = new byte[0];
            this.aX = new byte[0];
            this.a0 = ntlmPasswordAuthentication.username;
            if (this.useUnicode) {
                this.a0 = this.a0.toUpperCase();
            }
            this.aW = ntlmPasswordAuthentication.domain.toUpperCase();
        }
    }

    int getBatchLimit(byte by) {
        return by == 117 ? a1 : 0;
    }

    int writeParameterWordsWireFormat(byte[] byArray, int n2) {
        int n3 = n2;
        SmbComSessionSetupAndX.writeInt2(this.session.transport.snd_buf_size, byArray, n2);
        SmbComSessionSetupAndX.writeInt2(this.session.transport.maxMpxCount, byArray, n2 += 2);
        SmbTransport cfr_ignored_0 = this.session.transport;
        SmbComSessionSetupAndX.writeInt2(1L, byArray, n2 += 2);
        SmbComSessionSetupAndX.writeInt4(this.aV, byArray, n2 += 2);
        n2 += 4;
        if (this.aT != null) {
            SmbComSessionSetupAndX.writeInt2(this.aT.length, byArray, n2);
            n2 += 2;
        } else {
            SmbComSessionSetupAndX.writeInt2(this.aY.length, byArray, n2);
            SmbComSessionSetupAndX.writeInt2(this.aX.length, byArray, n2 += 2);
            n2 += 2;
        }
        byArray[n2++] = 0;
        byArray[n2++] = 0;
        byArray[n2++] = 0;
        byArray[n2++] = 0;
        SmbComSessionSetupAndX.writeInt4(this.aU, byArray, n2);
        return (n2 += 4) - n3;
    }

    int writeBytesWireFormat(byte[] byArray, int n2) {
        int n3 = n2;
        if (this.aT != null) {
            System.arraycopy(this.aT, 0, byArray, n2, this.aT.length);
            n2 += this.aT.length;
        } else {
            System.arraycopy(this.aY, 0, byArray, n2, this.aY.length);
            System.arraycopy(this.aX, 0, byArray, n2 += this.aY.length, this.aX.length);
            n2 += this.aX.length;
            n2 += this.writeString(this.a0, byArray, n2);
            n2 += this.writeString(this.aW, byArray, n2);
        }
        SmbTransport cfr_ignored_0 = this.session.transport;
        n2 += this.writeString(SmbConstants.NATIVE_OS, byArray, n2);
        SmbTransport cfr_ignored_1 = this.session.transport;
        n2 += this.writeString(SmbConstants.NATIVE_LANMAN, byArray, n2);
        return n2 - n3;
    }

    int readParameterWordsWireFormat(byte[] byArray, int n2) {
        return 0;
    }

    int readBytesWireFormat(byte[] byArray, int n2) {
        return 0;
    }

    public String toString() {
        SmbTransport cfr_ignored_0 = this.session.transport;
        SmbTransport cfr_ignored_1 = this.session.transport;
        SmbTransport cfr_ignored_2 = this.session.transport;
        String string = new String("SmbComSessionSetupAndX[" + super.toString() + ",snd_buf_size=" + this.session.transport.snd_buf_size + ",maxMpxCount=" + this.session.transport.maxMpxCount + ",VC_NUMBER=" + 1 + ",sessionKey=" + this.aV + ",lmHash.length=" + (this.aY == null ? 0 : this.aY.length) + ",ntHash.length=" + (this.aX == null ? 0 : this.aX.length) + ",capabilities=" + this.aU + ",accountName=" + this.a0 + ",primaryDomain=" + this.aW + ",NATIVE_OS=" + SmbConstants.NATIVE_OS + ",NATIVE_LANMAN=" + SmbConstants.NATIVE_LANMAN + "]");
        return string;
    }
}

