/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.util.Enumeration;
import jcifs.Config;
import jcifs.smb.ServerMessageBlock;
import jcifs.util.Hexdump;

abstract class SmbComTransaction
extends ServerMessageBlock
implements Enumeration {
    private static final int l = Config.getInt("jcifs.smb.client.transaction_buf_size", 65535) - 512;
    private static final int q = 61;
    private static final int t = 51;
    private static final int v = 1;
    private static final int u = 2;
    private static final int s = 2;
    private int flags = 0;
    private int fid;
    private int n = 0;
    private int r = 0;
    private boolean o = true;
    private boolean k = true;
    private int p;
    private int m;
    static final int TRANSACTION_BUF_SIZE = 65535;
    static final byte TRANS2_FIND_FIRST2 = 1;
    static final byte TRANS2_FIND_NEXT2 = 2;
    static final byte TRANS2_QUERY_FS_INFORMATION = 3;
    static final byte TRANS2_QUERY_PATH_INFORMATION = 5;
    static final byte TRANS2_GET_DFS_REFERRAL = 16;
    static final byte TRANS2_SET_FILE_INFORMATION = 8;
    static final int NET_SHARE_ENUM = 0;
    static final int NET_SERVER_ENUM2 = 104;
    static final int NET_SERVER_ENUM3 = 215;
    static final byte TRANS_PEEK_NAMED_PIPE = 35;
    static final byte TRANS_WAIT_NAMED_PIPE = 83;
    static final byte TRANS_CALL_NAMED_PIPE = 84;
    static final byte TRANS_TRANSACT_NAMED_PIPE = 38;
    protected int primarySetupOffset = 61;
    protected int secondaryParameterOffset = 51;
    protected int parameterCount;
    protected int parameterOffset;
    protected int parameterDisplacement;
    protected int dataCount;
    protected int dataOffset;
    protected int dataDisplacement;
    int totalParameterCount;
    int totalDataCount;
    int maxParameterCount = 1024;
    int maxDataCount = l;
    byte maxSetupCount;
    int timeout = 0;
    int setupCount = 1;
    byte subCommand;
    String name = "";
    int maxBufferSize;
    byte[] txn_buf;

    SmbComTransaction() {
    }

    void reset() {
        super.reset();
        this.o = true;
        this.k = true;
    }

    void reset(int n2, String string) {
        this.reset();
    }

    public boolean hasMoreElements() {
        return this.o;
    }

    public Object nextElement() {
        if (this.k) {
            this.k = false;
            this.parameterOffset = this.primarySetupOffset + this.setupCount * 2 + 2;
            if (this.command != -96) {
                if (this.command == 37 && !this.isResponse()) {
                    this.parameterOffset += this.stringWireLength(this.name, this.parameterOffset);
                }
            } else if (this.command == -96) {
                this.parameterOffset += 2;
            }
            this.n = this.parameterOffset % 2;
            this.n = this.n == 0 ? 0 : 2 - this.n;
            this.parameterOffset += this.n;
            this.m = this.totalParameterCount = this.writeParametersWireFormat(this.txn_buf, this.p);
            int n2 = this.maxBufferSize - this.parameterOffset;
            this.parameterCount = Math.min(this.totalParameterCount, n2);
            n2 -= this.parameterCount;
            this.dataOffset = this.parameterOffset + this.parameterCount;
            this.r = this.dataOffset % 2;
            this.r = this.r == 0 ? 0 : 2 - this.r;
            this.dataOffset += this.r;
            this.totalDataCount = this.writeDataWireFormat(this.txn_buf, this.m);
            this.dataCount = Math.min(this.totalDataCount, n2);
        } else {
            this.command = this.command != -96 ? (byte)38 : (byte)-95;
            this.parameterOffset = 51;
            if (this.totalParameterCount - this.parameterDisplacement > 0) {
                this.n = this.parameterOffset % 2;
                this.n = this.n == 0 ? 0 : 2 - this.n;
                this.parameterOffset += this.n;
            }
            this.parameterDisplacement += this.parameterCount;
            int n3 = this.maxBufferSize - this.parameterOffset - this.n;
            this.parameterCount = Math.min(this.totalParameterCount - this.parameterDisplacement, n3);
            n3 -= this.parameterCount;
            this.dataOffset = this.parameterOffset + this.parameterCount;
            this.r = this.dataOffset % 2;
            this.r = this.r == 0 ? 0 : 2 - this.r;
            this.dataOffset += this.r;
            this.dataDisplacement += this.dataCount;
            this.dataCount = Math.min(this.totalDataCount - this.dataDisplacement, n3 -= this.r);
        }
        if (this.parameterDisplacement + this.parameterCount >= this.totalParameterCount && this.dataDisplacement + this.dataCount >= this.totalDataCount) {
            this.o = false;
        }
        return this;
    }

    int writeParameterWordsWireFormat(byte[] byArray, int n2) {
        int n3 = n2;
        SmbComTransaction.writeInt2(this.totalParameterCount, byArray, n2);
        SmbComTransaction.writeInt2(this.totalDataCount, byArray, n2 += 2);
        n2 += 2;
        if (this.command != 38) {
            SmbComTransaction.writeInt2(this.maxParameterCount, byArray, n2);
            SmbComTransaction.writeInt2(this.maxDataCount, byArray, n2 += 2);
            n2 += 2;
            byArray[n2++] = this.maxSetupCount;
            byArray[n2++] = 0;
            SmbComTransaction.writeInt2(this.flags, byArray, n2);
            SmbComTransaction.writeInt4(this.timeout, byArray, n2 += 2);
            n2 += 4;
            byArray[n2++] = 0;
            byArray[n2++] = 0;
        }
        SmbComTransaction.writeInt2(this.parameterCount, byArray, n2);
        SmbComTransaction.writeInt2(this.parameterOffset, byArray, n2 += 2);
        n2 += 2;
        if (this.command == 38) {
            SmbComTransaction.writeInt2(this.parameterDisplacement, byArray, n2);
            n2 += 2;
        }
        SmbComTransaction.writeInt2(this.dataCount, byArray, n2);
        SmbComTransaction.writeInt2(this.dataCount == 0 ? 0 : this.dataOffset, byArray, n2 += 2);
        n2 += 2;
        if (this.command == 38) {
            SmbComTransaction.writeInt2(this.dataDisplacement, byArray, n2);
            n2 += 2;
        } else {
            byArray[n2++] = (byte)this.setupCount;
            byArray[n2++] = 0;
            n2 += this.writeSetupWireFormat(byArray, n2);
        }
        return n2 - n3;
    }

    int writeBytesWireFormat(byte[] byArray, int n2) {
        int n3 = n2;
        int n4 = this.n;
        if (this.command == 37 && !this.isResponse()) {
            n2 += this.writeString(this.name, byArray, n2);
        }
        if (this.parameterCount > 0) {
            while (n4-- > 0) {
                byArray[n2++] = 0;
            }
            System.arraycopy(this.txn_buf, this.p, byArray, n2, this.parameterCount);
            n2 += this.parameterCount;
        }
        if (this.dataCount > 0) {
            n4 = this.r;
            while (n4-- > 0) {
                byArray[n2++] = 0;
            }
            System.arraycopy(this.txn_buf, this.m, byArray, n2, this.dataCount);
            this.m += this.dataCount;
            n2 += this.dataCount;
        }
        return n2 - n3;
    }

    int readParameterWordsWireFormat(byte[] byArray, int n2) {
        return 0;
    }

    int readBytesWireFormat(byte[] byArray, int n2) {
        return 0;
    }

    abstract int writeSetupWireFormat(byte[] var1, int var2);

    abstract int writeParametersWireFormat(byte[] var1, int var2);

    abstract int writeDataWireFormat(byte[] var1, int var2);

    abstract int readSetupWireFormat(byte[] var1, int var2, int var3);

    abstract int readParametersWireFormat(byte[] var1, int var2, int var3);

    abstract int readDataWireFormat(byte[] var1, int var2, int var3);

    public String toString() {
        return new String(super.toString() + ",totalParameterCount=" + this.totalParameterCount + ",totalDataCount=" + this.totalDataCount + ",maxParameterCount=" + this.maxParameterCount + ",maxDataCount=" + this.maxDataCount + ",maxSetupCount=" + this.maxSetupCount + ",flags=0x" + Hexdump.toHexString(this.flags, 2) + ",timeout=" + this.timeout + ",parameterCount=" + this.parameterCount + ",parameterOffset=" + this.parameterOffset + ",parameterDisplacement=" + this.parameterDisplacement + ",dataCount=" + this.dataCount + ",dataOffset=" + this.dataOffset + ",dataDisplacement=" + this.dataDisplacement + ",setupCount=" + this.setupCount + ",pad=" + this.n + ",pad1=" + this.r);
    }
}

