/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.util.Enumeration;
import jcifs.smb.FileEntry;
import jcifs.smb.ServerMessageBlock;
import jcifs.util.LogStream;

abstract class SmbComTransactionResponse
extends ServerMessageBlock
implements Enumeration {
    private static final int af = 61;
    private static final int ah = 1;
    private static final int ai = 2;
    private int aj;
    private int ag;
    private boolean ad;
    private boolean ae;
    protected int totalParameterCount;
    protected int totalDataCount;
    protected int parameterCount;
    protected int parameterOffset;
    protected int parameterDisplacement;
    protected int dataOffset;
    protected int dataDisplacement;
    protected int setupCount;
    protected int bufParameterStart;
    protected int bufDataStart;
    int dataCount;
    byte subCommand;
    boolean hasMore = true;
    boolean isPrimary = true;
    byte[] txn_buf = null;
    int status;
    int numEntries;
    FileEntry[] results;

    SmbComTransactionResponse() {
    }

    void reset() {
        super.reset();
        this.bufDataStart = 0;
        this.hasMore = true;
        this.isPrimary = true;
        this.ae = false;
        this.ad = false;
    }

    public boolean hasMoreElements() {
        return this.errorCode == 0 && this.hasMore;
    }

    public Object nextElement() {
        if (this.isPrimary) {
            this.isPrimary = false;
        }
        return this;
    }

    int writeParameterWordsWireFormat(byte[] byArray, int n2) {
        return 0;
    }

    int writeBytesWireFormat(byte[] byArray, int n2) {
        return 0;
    }

    int readParameterWordsWireFormat(byte[] byArray, int n2) {
        int n3 = n2;
        this.totalParameterCount = SmbComTransactionResponse.readInt2(byArray, n2);
        if (this.bufDataStart == 0) {
            this.bufDataStart = this.totalParameterCount;
        }
        this.totalDataCount = SmbComTransactionResponse.readInt2(byArray, n2 += 2);
        this.parameterCount = SmbComTransactionResponse.readInt2(byArray, n2 += 4);
        this.parameterOffset = SmbComTransactionResponse.readInt2(byArray, n2 += 2);
        this.parameterDisplacement = SmbComTransactionResponse.readInt2(byArray, n2 += 2);
        this.dataCount = SmbComTransactionResponse.readInt2(byArray, n2 += 2);
        this.dataOffset = SmbComTransactionResponse.readInt2(byArray, n2 += 2);
        this.dataDisplacement = SmbComTransactionResponse.readInt2(byArray, n2 += 2);
        this.setupCount = byArray[n2 += 2] & 0xFF;
        n2 += 2;
        if (this.setupCount != 0) {
            if (LogStream.level > 2) {
                log.println("setupCount is not zero: " + this.setupCount);
            }
        }
        return n2 - n3;
    }

    int readBytesWireFormat(byte[] byArray, int n2) {
        this.ag = 0;
        this.aj = 0;
        if (this.parameterCount > 0) {
            this.aj = this.parameterOffset - (n2 - this.headerStart);
            System.arraycopy(byArray, n2 += this.aj, this.txn_buf, this.bufParameterStart + this.parameterDisplacement, this.parameterCount);
            n2 += this.parameterCount;
        }
        if (this.dataCount > 0) {
            this.ag = this.dataOffset - (n2 - this.headerStart);
            System.arraycopy(byArray, n2 += this.ag, this.txn_buf, this.bufDataStart + this.dataDisplacement, this.dataCount);
            n2 += this.dataCount;
        }
        if (!this.ad && this.parameterDisplacement + this.parameterCount == this.totalParameterCount) {
            this.ad = true;
        }
        if (!this.ae && this.dataDisplacement + this.dataCount == this.totalDataCount) {
            this.ae = true;
        }
        if (this.ad && this.ae) {
            this.hasMore = false;
            this.readParametersWireFormat(this.txn_buf, this.bufParameterStart, this.totalParameterCount);
            this.readDataWireFormat(this.txn_buf, this.bufDataStart, this.totalDataCount);
        }
        return this.aj + this.parameterCount + this.ag + this.dataCount;
    }

    abstract int writeSetupWireFormat(byte[] var1, int var2);

    abstract int writeParametersWireFormat(byte[] var1, int var2);

    abstract int writeDataWireFormat(byte[] var1, int var2);

    abstract int readSetupWireFormat(byte[] var1, int var2, int var3);

    abstract int readParametersWireFormat(byte[] var1, int var2, int var3);

    abstract int readDataWireFormat(byte[] var1, int var2, int var3);

    public String toString() {
        return new String(super.toString() + ",totalParameterCount=" + this.totalParameterCount + ",totalDataCount=" + this.totalDataCount + ",parameterCount=" + this.parameterCount + ",parameterOffset=" + this.parameterOffset + ",parameterDisplacement=" + this.parameterDisplacement + ",dataCount=" + this.dataCount + ",dataOffset=" + this.dataOffset + ",dataDisplacement=" + this.dataDisplacement + ",setupCount=" + this.setupCount + ",pad=" + this.aj + ",pad1=" + this.ag);
    }
}

