/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import jcifs.smb.DosError;
import jcifs.smb.NtStatus;
import jcifs.smb.WinError;
import jcifs.util.Hexdump;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SmbException
extends IOException
implements NtStatus,
DosError,
WinError {
    private int do;
    private Throwable for;

    static String getMessageByCode(int n2) {
        if (n2 == 0) {
            return "NT_STATUS_SUCCESS";
        }
        if ((n2 & 0xC0000000) == -1073741824) {
            int n3 = 1;
            int n4 = NtStatus.NT_STATUS_CODES.length - 1;
            while (n4 >= n3) {
                int n5 = (n3 + n4) / 2;
                if (n2 > NtStatus.NT_STATUS_CODES[n5]) {
                    n3 = n5 + 1;
                    continue;
                }
                if (n2 < NtStatus.NT_STATUS_CODES[n5]) {
                    n4 = n5 - 1;
                    continue;
                }
                return NtStatus.NT_STATUS_MESSAGES[n5];
            }
        } else {
            int n6 = 0;
            int n7 = DosError.DOS_ERROR_CODES.length - 1;
            while (n7 >= n6) {
                int n8 = (n6 + n7) / 2;
                if (n2 > DosError.DOS_ERROR_CODES[n8][0]) {
                    n6 = n8 + 1;
                    continue;
                }
                if (n2 < DosError.DOS_ERROR_CODES[n8][0]) {
                    n7 = n8 - 1;
                    continue;
                }
                return DosError.DOS_ERROR_MESSAGES[n8];
            }
        }
        return "0x" + Hexdump.toHexString(n2, 8);
    }

    static int getStatusByCode(int n2) {
        if ((n2 & 0xC0000000) != 0) {
            return n2;
        }
        int n3 = 0;
        int n4 = DosError.DOS_ERROR_CODES.length - 1;
        while (n4 >= n3) {
            int n5 = (n3 + n4) / 2;
            if (n2 > DosError.DOS_ERROR_CODES[n5][0]) {
                n3 = n5 + 1;
                continue;
            }
            if (n2 < DosError.DOS_ERROR_CODES[n5][0]) {
                n4 = n5 - 1;
                continue;
            }
            return DosError.DOS_ERROR_CODES[n5][1];
        }
        return -1073741823;
    }

    static String getMessageByWinerrCode(int n2) {
        int n3 = 0;
        int n4 = WinError.WINERR_CODES.length - 1;
        while (n4 >= n3) {
            int n5 = (n3 + n4) / 2;
            if (n2 > WinError.WINERR_CODES[n5]) {
                n3 = n5 + 1;
                continue;
            }
            if (n2 < WinError.WINERR_CODES[n5]) {
                n4 = n5 - 1;
                continue;
            }
            return WinError.WINERR_MESSAGES[n5];
        }
        return n2 + "";
    }

    SmbException() {
    }

    SmbException(int n2, Throwable throwable) {
        super(SmbException.getMessageByCode(n2));
        this.do = SmbException.getStatusByCode(n2);
        this.for = throwable;
    }

    SmbException(String string) {
        super(string);
        this.do = -1073741823;
    }

    SmbException(String string, Throwable throwable) {
        super(string);
        this.for = throwable;
        this.do = -1073741823;
    }

    public SmbException(int n2, boolean bl) {
        super(bl ? SmbException.getMessageByWinerrCode(n2) : SmbException.getMessageByCode(n2));
        this.do = bl ? n2 : SmbException.getStatusByCode(n2);
    }

    public int getNtStatus() {
        return this.do;
    }

    public Throwable getRootCause() {
        return this.for;
    }

    public String toString() {
        if (this.for != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            this.for.printStackTrace(printWriter);
            return super.toString() + "\n" + stringWriter;
        }
        return super.toString();
    }
}

