/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import jcifs.Config;
import jcifs.UniAddress;
import jcifs.dcerpc.DcerpcHandle;
import jcifs.dcerpc.msrpc.MsrpcDfsRootEnum;
import jcifs.dcerpc.msrpc.MsrpcShareEnum;
import jcifs.dcerpc.msrpc.MsrpcShareGetInfo;
import jcifs.netbios.NbtAddress;
import jcifs.smb.ACE;
import jcifs.smb.Dfs;
import jcifs.smb.DfsReferral;
import jcifs.smb.DosFileFilter;
import jcifs.smb.FileEntry;
import jcifs.smb.Handler;
import jcifs.smb.Info;
import jcifs.smb.NetServerEnum2;
import jcifs.smb.NetServerEnum2Response;
import jcifs.smb.NetShareEnum;
import jcifs.smb.NetShareEnumResponse;
import jcifs.smb.NtTransQuerySecurityDesc;
import jcifs.smb.NtTransQuerySecurityDescResponse;
import jcifs.smb.NtlmAuthenticator;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SID;
import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbComBlankResponse;
import jcifs.smb.SmbComClose;
import jcifs.smb.SmbComCreateDirectory;
import jcifs.smb.SmbComDelete;
import jcifs.smb.SmbComDeleteDirectory;
import jcifs.smb.SmbComFindClose2;
import jcifs.smb.SmbComNTCreateAndX;
import jcifs.smb.SmbComNTCreateAndXResponse;
import jcifs.smb.SmbComOpenAndX;
import jcifs.smb.SmbComOpenAndXResponse;
import jcifs.smb.SmbComQueryInformation;
import jcifs.smb.SmbComQueryInformationResponse;
import jcifs.smb.SmbComReadAndX;
import jcifs.smb.SmbComReadAndXResponse;
import jcifs.smb.SmbComRename;
import jcifs.smb.SmbComTransaction;
import jcifs.smb.SmbComWrite;
import jcifs.smb.SmbComWriteAndX;
import jcifs.smb.SmbComWriteAndXResponse;
import jcifs.smb.SmbComWriteResponse;
import jcifs.smb.SmbConstants;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFileFilter;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;
import jcifs.smb.SmbFilenameFilter;
import jcifs.smb.SmbNamedPipe;
import jcifs.smb.SmbSession;
import jcifs.smb.SmbTransport;
import jcifs.smb.SmbTree;
import jcifs.smb.Trans2FindFirst2;
import jcifs.smb.Trans2FindFirst2Response;
import jcifs.smb.Trans2FindNext2;
import jcifs.smb.Trans2QueryFSInformation;
import jcifs.smb.Trans2QueryFSInformationResponse;
import jcifs.smb.Trans2QueryPathInformation;
import jcifs.smb.Trans2QueryPathInformationResponse;
import jcifs.smb.Trans2SetFileInformation;
import jcifs.smb.Trans2SetFileInformationResponse;
import jcifs.util.LogStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SmbFile
extends URLConnection
implements SmbConstants {
    static final int O_RDONLY = 1;
    static final int O_WRONLY = 2;
    static final int O_RDWR = 3;
    static final int O_APPEND = 4;
    static final int O_CREAT = 16;
    static final int O_EXCL = 32;
    static final int O_TRUNC = 64;
    public static final int FILE_NO_SHARE = 0;
    public static final int FILE_SHARE_READ = 1;
    public static final int FILE_SHARE_WRITE = 2;
    public static final int FILE_SHARE_DELETE = 4;
    public static final int ATTR_READONLY = 1;
    public static final int ATTR_HIDDEN = 2;
    public static final int ATTR_SYSTEM = 4;
    public static final int ATTR_VOLUME = 8;
    public static final int ATTR_DIRECTORY = 16;
    public static final int ATTR_ARCHIVE = 32;
    static final int ATTR_COMPRESSED = 2048;
    static final int ATTR_NORMAL = 128;
    static final int ATTR_TEMPORARY = 256;
    static final int ATTR_GET_MASK = Short.MAX_VALUE;
    static final int ATTR_SET_MASK = 12455;
    static final int DEFAULT_ATTR_EXPIRATION_PERIOD = 5000;
    static final int HASH_DOT = ".".hashCode();
    static final int HASH_DOT_DOT = "..".hashCode();
    static LogStream log = LogStream.getInstance();
    static long attrExpirationPeriod;
    public static final int TYPE_FILESYSTEM = 1;
    public static final int TYPE_WORKGROUP = 2;
    public static final int TYPE_SERVER = 4;
    public static final int TYPE_SHARE = 8;
    public static final int TYPE_NAMED_PIPE = 16;
    public static final int TYPE_PRINTER = 32;
    public static final int TYPE_COMM = 64;
    private String new;
    private String byte;
    private long do;
    private long try;
    private int case;
    private long for;
    private long if;
    private long a;
    private boolean goto;
    private int else = 7;
    private SmbComBlankResponse char = null;
    private DfsReferral int = null;
    protected static Dfs dfs;
    NtlmPasswordAuthentication auth;
    SmbTree tree = null;
    String unc;
    int fid;
    int type;
    boolean opened;
    int tree_num;
    UniAddress[] addresses;
    int addressIndex;

    public SmbFile(String string) throws MalformedURLException {
        this(new URL(null, string, Handler.SMB_HANDLER));
    }

    public SmbFile(SmbFile smbFile, String string) throws MalformedURLException, UnknownHostException {
        this(smbFile.isWorkgroup0() ? new URL(null, "smb://" + string, Handler.SMB_HANDLER) : new URL(smbFile.url, string, Handler.SMB_HANDLER), smbFile.auth);
    }

    public SmbFile(String string, String string2) throws MalformedURLException {
        this(new URL(new URL(null, string, Handler.SMB_HANDLER), string2, Handler.SMB_HANDLER));
    }

    public SmbFile(String string, NtlmPasswordAuthentication ntlmPasswordAuthentication) throws MalformedURLException {
        this(new URL(null, string, Handler.SMB_HANDLER), ntlmPasswordAuthentication);
    }

    public SmbFile(String string, NtlmPasswordAuthentication ntlmPasswordAuthentication, int n2) throws MalformedURLException {
        this(new URL(null, string, Handler.SMB_HANDLER), ntlmPasswordAuthentication);
        if ((n2 & 0xFFFFFFF8) != 0) {
            throw new RuntimeException("Illegal shareAccess parameter");
        }
        this.else = n2;
    }

    public SmbFile(String string, String string2, NtlmPasswordAuthentication ntlmPasswordAuthentication) throws MalformedURLException {
        this(new URL(new URL(null, string, Handler.SMB_HANDLER), string2, Handler.SMB_HANDLER), ntlmPasswordAuthentication);
    }

    public SmbFile(String string, String string2, NtlmPasswordAuthentication ntlmPasswordAuthentication, int n2) throws MalformedURLException {
        this(new URL(new URL(null, string, Handler.SMB_HANDLER), string2, Handler.SMB_HANDLER), ntlmPasswordAuthentication);
        if ((n2 & 0xFFFFFFF8) != 0) {
            throw new RuntimeException("Illegal shareAccess parameter");
        }
        this.else = n2;
    }

    public SmbFile(SmbFile smbFile, String string, int n2) throws MalformedURLException, UnknownHostException {
        this(smbFile.isWorkgroup0() ? new URL(null, "smb://" + string, Handler.SMB_HANDLER) : new URL(smbFile.url, string, Handler.SMB_HANDLER), smbFile.auth);
        if ((n2 & 0xFFFFFFF8) != 0) {
            throw new RuntimeException("Illegal shareAccess parameter");
        }
        this.else = n2;
    }

    public SmbFile(URL uRL) {
        this(uRL, new NtlmPasswordAuthentication(uRL.getUserInfo()));
    }

    public SmbFile(URL uRL, NtlmPasswordAuthentication ntlmPasswordAuthentication) {
        super(uRL);
        this.auth = ntlmPasswordAuthentication == null ? new NtlmPasswordAuthentication(uRL.getUserInfo()) : ntlmPasswordAuthentication;
        this.getUncPath0();
    }

    SmbFile(SmbFile smbFile, String string, int n2, int n3, long l2, long l3, long l4) throws MalformedURLException, UnknownHostException {
        this(smbFile.isWorkgroup0() ? new URL(null, "smb://" + string + "/", Handler.SMB_HANDLER) : new URL(smbFile.url, string + ((n3 & 0x10) > 0 ? "/" : "")));
        int n4;
        this.auth = smbFile.auth;
        if (smbFile.byte != null) {
            this.tree = smbFile.tree;
            this.int = smbFile.int;
        }
        if (string.charAt(n4 = string.length() - 1) == '/') {
            string = string.substring(0, n4);
        }
        this.unc = smbFile.byte == null ? "\\" : (smbFile.unc.equals("\\") ? '\\' + string : smbFile.unc + '\\' + string);
        this.type = n2;
        this.case = n3;
        this.do = l2;
        this.try = l3;
        this.if = l4;
        this.goto = true;
        this.for = this.a = System.currentTimeMillis() + attrExpirationPeriod;
    }

    private SmbComBlankResponse a() {
        if (this.char == null) {
            this.char = new SmbComBlankResponse();
        }
        return this.char;
    }

    void resolveDfs(ServerMessageBlock serverMessageBlock) throws SmbException {
        this.connect0();
        DfsReferral dfsReferral = dfs.resolve(this.tree.session.transport.tconHostName, this.tree.share, this.unc, this.auth);
        if (dfsReferral != null) {
            Object object;
            String string = null;
            if (serverMessageBlock != null) {
                block1 : switch (serverMessageBlock.command) {
                    case 37: 
                    case 50: {
                        switch (((SmbComTransaction)serverMessageBlock).subCommand & 0xFF) {
                            case 16: {
                                break block1;
                            }
                        }
                        string = "A:";
                        break;
                    }
                    default: {
                        string = "A:";
                    }
                }
            }
            DfsReferral dfsReferral2 = dfsReferral;
            SmbException smbException = null;
            while (true) {
                try {
                    if (LogStream.level >= 2) {
                        log.println("DFS redirect: " + dfsReferral);
                    }
                    object = UniAddress.getByName(dfsReferral.server);
                    SmbTransport smbTransport = SmbTransport.getSmbTransport((UniAddress)object, this.url.getPort());
                    smbTransport.connect();
                    this.tree = smbTransport.getSmbSession(this.auth).getSmbTree(dfsReferral.share, string);
                    if (dfsReferral != dfsReferral2 && dfsReferral.key != null) {
                        dfsReferral.map.put(dfsReferral.key, dfsReferral);
                    }
                    smbException = null;
                }
                catch (IOException iOException) {
                    smbException = iOException instanceof SmbException ? (SmbException)iOException : new SmbException(dfsReferral.server, (Throwable)iOException);
                    if ((dfsReferral = dfsReferral.next) != dfsReferral2) continue;
                }
                break;
            }
            if (smbException != null) {
                throw smbException;
            }
            if (LogStream.level >= 3) {
                log.println(dfsReferral);
            }
            this.int = dfsReferral;
            if (dfsReferral.pathConsumed < 0) {
                dfsReferral.pathConsumed = 0;
            } else if (dfsReferral.pathConsumed > this.unc.length()) {
                dfsReferral.pathConsumed = this.unc.length();
            }
            object = this.unc.substring(dfsReferral.pathConsumed);
            if (((String)object).equals("")) {
                object = "\\";
            }
            if (!dfsReferral.path.equals("")) {
                object = "\\" + dfsReferral.path + (String)object;
            }
            this.unc = object;
            if (serverMessageBlock != null && serverMessageBlock.path != null && serverMessageBlock.path.endsWith("\\") && !((String)object).endsWith("\\")) {
                object = (String)object + "\\";
            }
            if (serverMessageBlock != null) {
                serverMessageBlock.path = object;
                serverMessageBlock.flags2 |= 0x1000;
            }
        } else {
            if (this.tree.inDomainDfs && !(serverMessageBlock instanceof NtTransQuerySecurityDesc) && !(serverMessageBlock instanceof SmbComClose) && !(serverMessageBlock instanceof SmbComFindClose2)) {
                throw new SmbException(-1073741275, false);
            }
            if (serverMessageBlock != null) {
                serverMessageBlock.flags2 &= 0xFFFFEFFF;
            }
        }
    }

    void send(ServerMessageBlock serverMessageBlock, ServerMessageBlock serverMessageBlock2) throws SmbException {
        while (true) {
            this.resolveDfs(serverMessageBlock);
            try {
                this.tree.send(serverMessageBlock, serverMessageBlock2);
            }
            catch (DfsReferral dfsReferral) {
                if (dfsReferral.resolveHashes) {
                    throw dfsReferral;
                }
                serverMessageBlock.reset();
                continue;
            }
            break;
        }
    }

    static String queryLookup(String string, String string2) {
        String string3;
        char[] cArray = string.toCharArray();
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            char c2 = cArray[i2];
            if (c2 == '&') {
                if (n2 > n3 && (string3 = new String(cArray, n3, n2 - n3)).equalsIgnoreCase(string2)) {
                    return new String(cArray, ++n2, i2 - n2);
                }
                n3 = i2 + 1;
                continue;
            }
            if (c2 != '=') continue;
            n2 = i2;
        }
        if (n2 > n3 && (string3 = new String(cArray, n3, n2 - n3)).equalsIgnoreCase(string2)) {
            return new String(cArray, ++n2, cArray.length - n2);
        }
        return null;
    }

    UniAddress getAddress() throws UnknownHostException {
        if (this.addressIndex == 0) {
            return this.getFirstAddress();
        }
        return this.addresses[this.addressIndex - 1];
    }

    UniAddress getFirstAddress() throws UnknownHostException {
        Object object;
        this.addressIndex = 0;
        String string = this.url.getHost();
        String string2 = this.url.getPath();
        String string3 = this.url.getQuery();
        if (string3 != null) {
            object = SmbFile.queryLookup(string3, "server");
            if (object != null && ((String)object).length() > 0) {
                this.addresses = new UniAddress[1];
                this.addresses[0] = UniAddress.getByName((String)object);
                return this.getNextAddress();
            }
            String string4 = SmbFile.queryLookup(string3, "address");
            if (string4 != null && string4.length() > 0) {
                byte[] byArray = InetAddress.getByName(string4).getAddress();
                this.addresses = new UniAddress[1];
                this.addresses[0] = new UniAddress(InetAddress.getByAddress(string, byArray));
                return this.getNextAddress();
            }
        }
        if (string.length() == 0) {
            try {
                object = NbtAddress.getByName("\u0001\u0002__MSBROWSE__\u0002", 1, null);
                this.addresses = new UniAddress[1];
                this.addresses[0] = UniAddress.getByName(((NbtAddress)object).getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {
                NtlmPasswordAuthentication.initDefaults();
                if (NtlmPasswordAuthentication.DEFAULT_DOMAIN.equals("?")) {
                    throw unknownHostException;
                }
                this.addresses = UniAddress.getAllByName(NtlmPasswordAuthentication.DEFAULT_DOMAIN, true);
            }
        } else {
            this.addresses = string2.length() == 0 || string2.equals("/") ? UniAddress.getAllByName(string, true) : UniAddress.getAllByName(string, false);
        }
        return this.getNextAddress();
    }

    UniAddress getNextAddress() {
        UniAddress uniAddress = null;
        if (this.addressIndex < this.addresses.length) {
            uniAddress = this.addresses[this.addressIndex++];
        }
        return uniAddress;
    }

    boolean hasNextAddress() {
        return this.addressIndex < this.addresses.length;
    }

    void connect0() throws SmbException {
        try {
            this.connect();
        }
        catch (UnknownHostException unknownHostException) {
            throw new SmbException("Failed to connect to server", (Throwable)unknownHostException);
        }
        catch (SmbException smbException) {
            throw smbException;
        }
        catch (IOException iOException) {
            throw new SmbException("Failed to connect to server", (Throwable)iOException);
        }
    }

    void doConnect() throws IOException {
        SmbTransport smbTransport;
        UniAddress uniAddress = this.getAddress();
        if (this.tree != null) {
            smbTransport = this.tree.session.transport;
        } else {
            smbTransport = SmbTransport.getSmbTransport(uniAddress, this.url.getPort());
            this.tree = smbTransport.getSmbSession(this.auth).getSmbTree(this.byte, null);
        }
        String string = this.getServerWithDfs();
        boolean bl = this.tree.inDomainDfs = dfs.resolve(string, this.tree.share, null, this.auth) != null;
        if (this.tree.inDomainDfs) {
            this.tree.connectionState = 2;
        }
        try {
            if (LogStream.level >= 3) {
                log.println("doConnect: " + uniAddress);
            }
            this.tree.treeConnect(null, null);
        }
        catch (SmbAuthException smbAuthException) {
            if (this.byte == null) {
                SmbSession smbSession = smbTransport.getSmbSession(NtlmPasswordAuthentication.NULL);
                this.tree = smbSession.getSmbTree(null, null);
                this.tree.treeConnect(null, null);
            }
            NtlmPasswordAuthentication ntlmPasswordAuthentication = NtlmAuthenticator.requestNtlmPasswordAuthentication(this.url.toString(), smbAuthException);
            if (ntlmPasswordAuthentication != null) {
                this.auth = ntlmPasswordAuthentication;
                SmbSession smbSession = smbTransport.getSmbSession(this.auth);
                this.tree = smbSession.getSmbTree(this.byte, null);
                boolean bl2 = this.tree.inDomainDfs = dfs.resolve(string, this.tree.share, null, this.auth) != null;
                if (this.tree.inDomainDfs) {
                    this.tree.connectionState = 2;
                }
                this.tree.treeConnect(null, null);
            }
            if (LogStream.level >= 1 && this.hasNextAddress()) {
                smbAuthException.printStackTrace(log);
            }
            throw smbAuthException;
        }
    }

    public void connect() throws IOException {
        if (this.isConnected()) {
            return;
        }
        this.getUncPath0();
        this.getFirstAddress();
        while (true) {
            try {
                this.doConnect();
                return;
            }
            catch (SmbException smbException) {
                if (this.getNextAddress() == null) {
                    throw smbException;
                }
                if (LogStream.level < 3) continue;
                smbException.printStackTrace(log);
                continue;
            }
            break;
        }
    }

    boolean isConnected() {
        return this.tree != null && this.tree.connectionState == 2;
    }

    int open0(int n2, int n3, int n4, int n5) throws SmbException {
        int n6;
        this.connect0();
        if (LogStream.level >= 3) {
            log.println("open0: " + this.unc);
        }
        if (this.tree.session.transport.hasCapability(16)) {
            SmbComNTCreateAndXResponse smbComNTCreateAndXResponse = new SmbComNTCreateAndXResponse();
            SmbComNTCreateAndX smbComNTCreateAndX = new SmbComNTCreateAndX(this.unc, n2, n3, this.else, n4, n5, null);
            if (this instanceof SmbNamedPipe) {
                smbComNTCreateAndX.flags0 |= 0x16;
                smbComNTCreateAndX.desiredAccess |= 0x20000;
                smbComNTCreateAndXResponse.isExtended = true;
            }
            this.send(smbComNTCreateAndX, smbComNTCreateAndXResponse);
            n6 = smbComNTCreateAndXResponse.fid;
            this.case = smbComNTCreateAndXResponse.extFileAttributes & Short.MAX_VALUE;
            this.for = System.currentTimeMillis() + attrExpirationPeriod;
            this.goto = true;
        } else {
            SmbComOpenAndXResponse smbComOpenAndXResponse = new SmbComOpenAndXResponse();
            this.send(new SmbComOpenAndX(this.unc, n3, n2, null), smbComOpenAndXResponse);
            n6 = smbComOpenAndXResponse.fid;
        }
        return n6;
    }

    void open(int n2, int n3, int n4, int n5) throws SmbException {
        if (this.isOpen()) {
            return;
        }
        this.fid = this.open0(n2, n3, n4, n5);
        this.opened = true;
        this.tree_num = this.tree.tree_num;
    }

    boolean isOpen() {
        boolean bl = this.opened && this.isConnected() && this.tree_num == this.tree.tree_num;
        return bl;
    }

    void close(int n2, long l2) throws SmbException {
        if (LogStream.level >= 3) {
            log.println("close: " + n2);
        }
        this.send(new SmbComClose(n2, l2), this.a());
    }

    void close(long l2) throws SmbException {
        if (!this.isOpen()) {
            return;
        }
        this.close(this.fid, l2);
        this.opened = false;
    }

    void close() throws SmbException {
        this.close(0L);
    }

    public Principal getPrincipal() {
        return this.auth;
    }

    public String getName() {
        this.getUncPath0();
        if (this.new.length() > 1) {
            int n2 = this.new.length() - 2;
            while (this.new.charAt(n2) != '/') {
                --n2;
            }
            return this.new.substring(n2 + 1);
        }
        if (this.byte != null) {
            return this.byte + '/';
        }
        if (this.url.getHost().length() > 0) {
            return this.url.getHost() + '/';
        }
        return "smb://";
    }

    public String getParent() {
        String string = this.url.getAuthority();
        if (string.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer("smb://");
            stringBuffer.append(string);
            this.getUncPath0();
            if (this.new.length() > 1) {
                stringBuffer.append(this.new);
            } else {
                stringBuffer.append('/');
            }
            string = stringBuffer.toString();
            int n2 = string.length() - 2;
            while (string.charAt(n2) != '/') {
                --n2;
            }
            return string.substring(0, n2 + 1);
        }
        return "smb://";
    }

    public String getPath() {
        return this.url.toString();
    }

    String getUncPath0() {
        if (this.unc == null) {
            int n2;
            char[] cArray = this.url.getPath().toCharArray();
            char[] cArray2 = new char[cArray.length];
            int n3 = cArray.length;
            int n4 = 0;
            int n5 = 0;
            block5: for (n2 = 0; n2 < n3; ++n2) {
                switch (n4) {
                    case 0: {
                        if (cArray[n2] != '/') {
                            return null;
                        }
                        cArray2[n5++] = cArray[n2];
                        n4 = 1;
                        continue block5;
                    }
                    case 1: {
                        if (cArray[n2] == '/') continue block5;
                        if (cArray[n2] == '.' && (n2 + 1 >= n3 || cArray[n2 + 1] == '/')) {
                            ++n2;
                            continue block5;
                        }
                        if (n2 + 1 < n3 && cArray[n2] == '.' && cArray[n2 + 1] == '.' && (n2 + 2 >= n3 || cArray[n2 + 2] == '/')) {
                            n2 += 2;
                            if (n5 == 1) continue block5;
                            while (--n5 > 1 && cArray2[n5 - 1] != '/') {
                            }
                            continue block5;
                        }
                        n4 = 2;
                    }
                    case 2: {
                        if (cArray[n2] == '/') {
                            n4 = 1;
                        }
                        cArray2[n5++] = cArray[n2];
                    }
                }
            }
            this.new = new String(cArray2, 0, n5);
            if (n5 > 1) {
                --n5;
                n2 = this.new.indexOf(47, 1);
                if (n2 < 0) {
                    this.byte = this.new.substring(1);
                    this.unc = "\\";
                } else if (n2 == n5) {
                    this.byte = this.new.substring(1, n2);
                    this.unc = "\\";
                } else {
                    this.byte = this.new.substring(1, n2);
                    this.unc = this.new.substring(n2, cArray2[n5] == '/' ? n5 : n5 + 1);
                    this.unc = this.unc.replace('/', '\\');
                }
            } else {
                this.byte = null;
                this.unc = "\\";
            }
        }
        return this.unc;
    }

    public String getUncPath() {
        this.getUncPath0();
        if (this.byte == null) {
            return "\\\\" + this.url.getHost();
        }
        return "\\\\" + this.url.getHost() + this.new.replace('/', '\\');
    }

    public String getCanonicalPath() {
        String string = this.url.getAuthority();
        this.getUncPath0();
        if (string.length() > 0) {
            return "smb://" + this.url.getAuthority() + this.new;
        }
        return "smb://";
    }

    public String getShare() {
        return this.byte;
    }

    String getServerWithDfs() {
        if (this.int != null) {
            return this.int.server;
        }
        return this.getServer();
    }

    public String getServer() {
        String string = this.url.getHost();
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    public int getType() throws SmbException {
        if (this.type == 0) {
            if (this.getUncPath0().length() > 1) {
                this.type = 1;
            } else if (this.byte != null) {
                this.connect0();
                this.type = this.byte.equals("IPC$") ? 16 : (this.tree.service.equals("LPT1:") ? 32 : (this.tree.service.equals("COMM") ? 64 : 8));
            } else if (this.url.getAuthority() == null || this.url.getAuthority().length() == 0) {
                this.type = 2;
            } else {
                int n2;
                UniAddress uniAddress;
                try {
                    uniAddress = this.getAddress();
                }
                catch (UnknownHostException unknownHostException) {
                    throw new SmbException(this.url.toString(), (Throwable)unknownHostException);
                }
                if (uniAddress.getAddress() instanceof NbtAddress && ((n2 = ((NbtAddress)uniAddress.getAddress()).getNameType()) == 29 || n2 == 27)) {
                    this.type = 2;
                    return this.type;
                }
                this.type = 4;
            }
        }
        return this.type;
    }

    boolean isWorkgroup0() throws UnknownHostException {
        if (this.type == 2 || this.url.getHost().length() == 0) {
            this.type = 2;
            return true;
        }
        this.getUncPath0();
        if (this.byte == null) {
            int n2;
            UniAddress uniAddress = this.getAddress();
            if (uniAddress.getAddress() instanceof NbtAddress && ((n2 = ((NbtAddress)uniAddress.getAddress()).getNameType()) == 29 || n2 == 27)) {
                this.type = 2;
                return true;
            }
            this.type = 4;
        }
        return false;
    }

    Info queryPath(String string, int n2) throws SmbException {
        this.connect0();
        if (LogStream.level >= 3) {
            log.println("queryPath: " + string);
        }
        if (this.tree.session.transport.hasCapability(16)) {
            Trans2QueryPathInformationResponse trans2QueryPathInformationResponse = new Trans2QueryPathInformationResponse(n2);
            this.send(new Trans2QueryPathInformation(string, n2), trans2QueryPathInformationResponse);
            return trans2QueryPathInformationResponse.info;
        }
        SmbComQueryInformationResponse smbComQueryInformationResponse = new SmbComQueryInformationResponse((long)(this.tree.session.transport.server.serverTimeZone * 1000) * 60L);
        this.send(new SmbComQueryInformation(string), smbComQueryInformationResponse);
        return smbComQueryInformationResponse;
    }

    public boolean exists() throws SmbException {
        if (this.for > System.currentTimeMillis()) {
            return this.goto;
        }
        this.case = 17;
        this.do = 0L;
        this.try = 0L;
        this.goto = false;
        try {
            if (this.url.getHost().length() != 0) {
                if (this.byte == null) {
                    if (this.getType() == 2) {
                        UniAddress.getByName(this.url.getHost(), true);
                    } else {
                        UniAddress.getByName(this.url.getHost()).getHostName();
                    }
                } else if (this.getUncPath0().length() == 1 || this.byte.equalsIgnoreCase("IPC$")) {
                    this.connect0();
                } else {
                    Info info = this.queryPath(this.getUncPath0(), 257);
                    this.case = info.getAttributes();
                    this.do = info.getCreateTime();
                    this.try = info.getLastWriteTime();
                }
            }
            this.goto = true;
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (SmbException smbException) {
            switch (smbException.getNtStatus()) {
                case -1073741809: 
                case -1073741773: 
                case -1073741772: 
                case -1073741766: {
                    break;
                }
                default: {
                    throw smbException;
                }
            }
        }
        this.for = System.currentTimeMillis() + attrExpirationPeriod;
        return this.goto;
    }

    public boolean canRead() throws SmbException {
        if (this.getType() == 16) {
            return true;
        }
        return this.exists();
    }

    public boolean canWrite() throws SmbException {
        if (this.getType() == 16) {
            return true;
        }
        return this.exists() && (this.case & 1) == 0;
    }

    public boolean isDirectory() throws SmbException {
        if (this.getUncPath0().length() == 1) {
            return true;
        }
        if (!this.exists()) {
            return false;
        }
        return (this.case & 0x10) == 16;
    }

    public boolean isFile() throws SmbException {
        if (this.getUncPath0().length() == 1) {
            return false;
        }
        this.exists();
        return (this.case & 0x10) == 0;
    }

    public boolean isHidden() throws SmbException {
        if (this.byte == null) {
            return false;
        }
        if (this.getUncPath0().length() == 1) {
            return this.byte.endsWith("$");
        }
        this.exists();
        return (this.case & 2) == 2;
    }

    public String getDfsPath() throws SmbException {
        this.resolveDfs(null);
        if (this.int == null) {
            return null;
        }
        String string = "smb:/" + this.int.server + "/" + this.int.share + this.unc;
        string = string.replace('\\', '/');
        if (this.isDirectory()) {
            string = string + '/';
        }
        return string;
    }

    public long createTime() throws SmbException {
        if (this.getUncPath0().length() > 1) {
            this.exists();
            return this.do;
        }
        return 0L;
    }

    public long lastModified() throws SmbException {
        if (this.getUncPath0().length() > 1) {
            this.exists();
            return this.try;
        }
        return 0L;
    }

    public String[] list() throws SmbException {
        return this.list("*", 22, null, null);
    }

    public String[] list(SmbFilenameFilter smbFilenameFilter) throws SmbException {
        return this.list("*", 22, smbFilenameFilter, null);
    }

    public SmbFile[] listFiles() throws SmbException {
        return this.listFiles("*", 22, null, null);
    }

    public SmbFile[] listFiles(String string) throws SmbException {
        return this.listFiles(string, 22, null, null);
    }

    public SmbFile[] listFiles(SmbFilenameFilter smbFilenameFilter) throws SmbException {
        return this.listFiles("*", 22, smbFilenameFilter, null);
    }

    public SmbFile[] listFiles(SmbFileFilter smbFileFilter) throws SmbException {
        return this.listFiles("*", 22, null, smbFileFilter);
    }

    String[] list(String string, int n2, SmbFilenameFilter smbFilenameFilter, SmbFileFilter smbFileFilter) throws SmbException {
        ArrayList arrayList = new ArrayList();
        this.doEnum(arrayList, false, string, n2, smbFilenameFilter, smbFileFilter);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    SmbFile[] listFiles(String string, int n2, SmbFilenameFilter smbFilenameFilter, SmbFileFilter smbFileFilter) throws SmbException {
        ArrayList arrayList = new ArrayList();
        this.doEnum(arrayList, true, string, n2, smbFilenameFilter, smbFileFilter);
        return arrayList.toArray(new SmbFile[arrayList.size()]);
    }

    void doEnum(ArrayList arrayList, boolean bl, String string, int n2, SmbFilenameFilter smbFilenameFilter, SmbFileFilter smbFileFilter) throws SmbException {
        if (smbFileFilter != null && smbFileFilter instanceof DosFileFilter) {
            DosFileFilter dosFileFilter = (DosFileFilter)smbFileFilter;
            if (dosFileFilter.wildcard != null) {
                string = dosFileFilter.wildcard;
            }
            n2 = dosFileFilter.attributes;
        }
        try {
            int n3 = this.url.getHost().length();
            if (n3 == 0 || this.getType() == 2) {
                this.doNetServerEnum(arrayList, bl, string, n2, smbFilenameFilter, smbFileFilter);
            } else if (this.byte == null) {
                this.doShareEnum(arrayList, bl, string, n2, smbFilenameFilter, smbFileFilter);
            } else {
                this.doFindFirstNext(arrayList, bl, string, n2, smbFilenameFilter, smbFileFilter);
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new SmbException(this.url.toString(), (Throwable)unknownHostException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new SmbException(this.url.toString(), (Throwable)malformedURLException);
        }
    }

    void doShareEnum(ArrayList arrayList, boolean bl, String string, int n2, SmbFilenameFilter smbFilenameFilter, SmbFileFilter smbFileFilter) throws SmbException, UnknownHostException, MalformedURLException {
        FileEntry fileEntry;
        int n3;
        FileEntry[] fileEntryArray;
        HashMap<FileEntry, FileEntry> hashMap;
        IOException iOException;
        block18: {
            String string2 = this.url.getPath();
            iOException = null;
            if (string2.lastIndexOf(47) != string2.length() - 1) {
                throw new SmbException(this.url.toString() + " directory must end with '/'");
            }
            if (this.getType() != 4) {
                throw new SmbException("The requested list operations is invalid: " + this.url.toString());
            }
            hashMap = new HashMap<FileEntry, FileEntry>();
            if (dfs.isTrustedDomain(this.getServer(), this.auth)) {
                try {
                    fileEntryArray = this.doDfsRootEnum();
                    for (n3 = 0; n3 < fileEntryArray.length; ++n3) {
                        fileEntry = fileEntryArray[n3];
                        if (hashMap.containsKey(fileEntry)) continue;
                        hashMap.put(fileEntry, fileEntry);
                    }
                }
                catch (IOException iOException2) {
                    if (LogStream.level < 4) break block18;
                    iOException2.printStackTrace(log);
                }
            }
        }
        UniAddress uniAddress = this.getFirstAddress();
        while (uniAddress != null) {
            try {
                this.doConnect();
                try {
                    fileEntryArray = this.doMsrpcShareEnum();
                }
                catch (IOException iOException3) {
                    if (LogStream.level >= 3) {
                        iOException3.printStackTrace(log);
                    }
                    fileEntryArray = this.doNetShareEnum();
                }
                for (n3 = 0; n3 < fileEntryArray.length; ++n3) {
                    fileEntry = fileEntryArray[n3];
                    if (hashMap.containsKey(fileEntry)) continue;
                    hashMap.put(fileEntry, fileEntry);
                }
                break;
            }
            catch (IOException iOException4) {
                if (LogStream.level >= 3) {
                    iOException4.printStackTrace(log);
                }
                iOException = iOException4;
                uniAddress = this.getNextAddress();
            }
        }
        if (iOException != null && hashMap.isEmpty()) {
            if (!(iOException instanceof SmbException)) {
                throw new SmbException(this.url.toString(), (Throwable)iOException);
            }
            throw (SmbException)iOException;
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            fileEntry = (FileEntry)iterator.next();
            String string3 = fileEntry.getName();
            if (smbFilenameFilter != null && !smbFilenameFilter.accept(this, string3) || string3.length() <= 0) continue;
            SmbFile smbFile = new SmbFile(this, string3, fileEntry.getType(), 17, 0L, 0L, 0L);
            if (smbFileFilter != null && !smbFileFilter.accept(smbFile)) continue;
            if (bl) {
                arrayList.add(smbFile);
                continue;
            }
            arrayList.add(string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileEntry[] doDfsRootEnum() throws IOException {
        FileEntry[] fileEntryArray;
        block6: {
            DcerpcHandle dcerpcHandle = null;
            dcerpcHandle = DcerpcHandle.getHandle("ncacn_np:" + this.getAddress().getHostAddress() + "[\\PIPE\\netdfs]", this.auth);
            try {
                MsrpcDfsRootEnum msrpcDfsRootEnum = new MsrpcDfsRootEnum(this.getServer());
                dcerpcHandle.sendrecv(msrpcDfsRootEnum);
                if (msrpcDfsRootEnum.retval != 0) {
                    throw new SmbException(msrpcDfsRootEnum.retval, true);
                }
                fileEntryArray = msrpcDfsRootEnum.getEntries();
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var6_5 = null;
                    try {
                        dcerpcHandle.close();
                    }
                    catch (IOException iOException) {
                        if (LogStream.level < 4) break block7;
                        iOException.printStackTrace(log);
                    }
                }
                throw throwable;
            }
            try {
                dcerpcHandle.close();
            }
            catch (IOException iOException) {
                if (LogStream.level < 4) break block6;
                iOException.printStackTrace(log);
            }
        }
        return fileEntryArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileEntry[] doMsrpcShareEnum() throws IOException {
        FileEntry[] fileEntryArray;
        block6: {
            MsrpcShareEnum msrpcShareEnum = new MsrpcShareEnum(this.url.getHost());
            DcerpcHandle dcerpcHandle = DcerpcHandle.getHandle("ncacn_np:" + this.getAddress().getHostAddress() + "[\\PIPE\\srvsvc]", this.auth);
            try {
                dcerpcHandle.sendrecv(msrpcShareEnum);
                if (msrpcShareEnum.retval != 0) {
                    throw new SmbException(msrpcShareEnum.retval, true);
                }
                fileEntryArray = msrpcShareEnum.getEntries();
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var5_5 = null;
                    try {
                        dcerpcHandle.close();
                    }
                    catch (IOException iOException) {
                        if (LogStream.level < 4) break block7;
                        iOException.printStackTrace(log);
                    }
                }
                throw throwable;
            }
            try {
                dcerpcHandle.close();
            }
            catch (IOException iOException) {
                if (LogStream.level < 4) break block6;
                iOException.printStackTrace(log);
            }
        }
        return fileEntryArray;
    }

    FileEntry[] doNetShareEnum() throws SmbException {
        NetShareEnum netShareEnum = new NetShareEnum();
        NetShareEnumResponse netShareEnumResponse = new NetShareEnumResponse();
        this.send(netShareEnum, netShareEnumResponse);
        if (netShareEnumResponse.status != 0) {
            throw new SmbException(netShareEnumResponse.status, true);
        }
        return netShareEnumResponse.results;
    }

    void doNetServerEnum(ArrayList arrayList, boolean bl, String string, int n2, SmbFilenameFilter smbFilenameFilter, SmbFileFilter smbFileFilter) throws SmbException, UnknownHostException, MalformedURLException {
        boolean bl2;
        NetServerEnum2Response netServerEnum2Response;
        NetServerEnum2 netServerEnum2;
        int n3;
        int n4 = n3 = this.url.getHost().length() == 0 ? 0 : this.getType();
        if (n3 == 0) {
            this.connect0();
            netServerEnum2 = new NetServerEnum2(this.tree.session.transport.server.oemDomainName, Integer.MIN_VALUE);
            netServerEnum2Response = new NetServerEnum2Response();
        } else if (n3 == 2) {
            netServerEnum2 = new NetServerEnum2(this.url.getHost(), -1);
            netServerEnum2Response = new NetServerEnum2Response();
        } else {
            throw new SmbException("The requested list operations is invalid: " + this.url.toString());
        }
        do {
            this.send(netServerEnum2, netServerEnum2Response);
            if (netServerEnum2Response.status != 0 && netServerEnum2Response.status != 234) {
                throw new SmbException(netServerEnum2Response.status, true);
            }
            bl2 = netServerEnum2Response.status == 234;
            int n5 = bl2 ? netServerEnum2Response.numEntries - 1 : netServerEnum2Response.numEntries;
            for (int i2 = 0; i2 < n5; ++i2) {
                FileEntry fileEntry = netServerEnum2Response.results[i2];
                String string2 = fileEntry.getName();
                if (smbFilenameFilter != null && !smbFilenameFilter.accept(this, string2) || string2.length() <= 0) continue;
                SmbFile smbFile = new SmbFile(this, string2, fileEntry.getType(), 17, 0L, 0L, 0L);
                if (smbFileFilter != null && !smbFileFilter.accept(smbFile)) continue;
                if (bl) {
                    arrayList.add(smbFile);
                    continue;
                }
                arrayList.add(string2);
            }
            if (this.getType() != 2) break;
            netServerEnum2.subCommand = (byte)-41;
            ((SmbComTransaction)netServerEnum2).reset(0, netServerEnum2Response.lastName);
            netServerEnum2Response.reset();
        } while (bl2);
    }

    void doFindFirstNext(ArrayList arrayList, boolean bl, String string, int n2, SmbFilenameFilter smbFilenameFilter, SmbFileFilter smbFileFilter) throws SmbException, UnknownHostException, MalformedURLException {
        block7: {
            String string2 = this.getUncPath0();
            String string3 = this.url.getPath();
            if (string3.lastIndexOf(47) != string3.length() - 1) {
                throw new SmbException(this.url.toString() + " directory must end with '/'");
            }
            SmbComTransaction smbComTransaction = new Trans2FindFirst2(string2, string, n2);
            Trans2FindFirst2Response trans2FindFirst2Response = new Trans2FindFirst2Response();
            if (LogStream.level >= 3) {
                log.println("doFindFirstNext: " + smbComTransaction.path);
            }
            this.send(smbComTransaction, trans2FindFirst2Response);
            int n3 = trans2FindFirst2Response.sid;
            smbComTransaction = new Trans2FindNext2(n3, trans2FindFirst2Response.resumeKey, trans2FindFirst2Response.lastName);
            trans2FindFirst2Response.subCommand = (byte)2;
            while (true) {
                for (int i2 = 0; i2 < trans2FindFirst2Response.numEntries; ++i2) {
                    int n4;
                    FileEntry fileEntry = trans2FindFirst2Response.results[i2];
                    String string4 = fileEntry.getName();
                    if (string4.length() < 3 && ((n4 = string4.hashCode()) == HASH_DOT || n4 == HASH_DOT_DOT) && (string4.equals(".") || string4.equals("..")) || smbFilenameFilter != null && !smbFilenameFilter.accept(this, string4) || string4.length() <= 0) continue;
                    SmbFile smbFile = new SmbFile(this, string4, 1, fileEntry.getAttributes(), fileEntry.createTime(), fileEntry.lastModified(), fileEntry.length());
                    if (smbFileFilter != null && !smbFileFilter.accept(smbFile)) continue;
                    if (bl) {
                        arrayList.add(smbFile);
                        continue;
                    }
                    arrayList.add(string4);
                }
                if (trans2FindFirst2Response.isEndOfSearch || trans2FindFirst2Response.numEntries == 0) break;
                smbComTransaction.reset(trans2FindFirst2Response.resumeKey, trans2FindFirst2Response.lastName);
                trans2FindFirst2Response.reset();
                this.send(smbComTransaction, trans2FindFirst2Response);
            }
            try {
                this.send(new SmbComFindClose2(n3), this.a());
            }
            catch (SmbException smbException) {
                if (LogStream.level < 4) break block7;
                smbException.printStackTrace(log);
            }
        }
    }

    public void renameTo(SmbFile smbFile) throws SmbException {
        if (this.getUncPath0().length() == 1 || smbFile.getUncPath0().length() == 1) {
            throw new SmbException("Invalid operation for workgroups, servers, or shares");
        }
        this.resolveDfs(null);
        smbFile.resolveDfs(null);
        if (!this.tree.equals(smbFile.tree)) {
            throw new SmbException("Invalid operation for workgroups, servers, or shares");
        }
        if (LogStream.level >= 3) {
            log.println("renameTo: " + this.unc + " -> " + smbFile.unc);
        }
        this.a = 0L;
        this.for = 0L;
        smbFile.for = 0L;
        this.send(new SmbComRename(this.unc, smbFile.unc), this.a());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyTo0(SmbFile smbFile, byte[][] byArray, int n2, WriterThread writerThread, SmbComReadAndX smbComReadAndX, SmbComReadAndXResponse smbComReadAndXResponse) throws SmbException {
        Object object;
        if (this.for < System.currentTimeMillis()) {
            this.case = 17;
            this.do = 0L;
            this.try = 0L;
            this.goto = false;
            object = this.queryPath(this.getUncPath0(), 257);
            this.case = object.getAttributes();
            this.do = object.getCreateTime();
            this.try = object.getLastWriteTime();
            this.goto = true;
            this.for = System.currentTimeMillis() + attrExpirationPeriod;
        }
        if (this.isDirectory()) {
            block28: {
                String string = smbFile.getUncPath0();
                if (string.length() > 1) {
                    try {
                        smbFile.mkdir();
                        smbFile.setPathInformation(this.case, this.do, this.try);
                    }
                    catch (SmbException smbException) {
                        if (smbException.getNtStatus() == -1073741790 || smbException.getNtStatus() == -1073741771) break block28;
                        throw smbException;
                    }
                }
            }
            object = this.listFiles("*", 22, null, null);
            try {
                for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                    SmbFile smbFile2 = new SmbFile(smbFile, ((SmbFile)object[i2]).getName(), ((SmbFile)object[i2]).type, ((SmbFile)object[i2]).case, ((SmbFile)object[i2]).do, ((SmbFile)object[i2]).try, ((SmbFile)object[i2]).if);
                    ((SmbFile)object[i2]).copyTo0(smbFile2, byArray, n2, writerThread, smbComReadAndX, smbComReadAndXResponse);
                }
            }
            catch (UnknownHostException unknownHostException) {
                throw new SmbException(this.url.toString(), (Throwable)unknownHostException);
            }
            catch (MalformedURLException malformedURLException) {
                throw new SmbException(this.url.toString(), (Throwable)malformedURLException);
            }
        }
        try {
            this.open(1, 0, 128, 0);
            try {
                smbFile.open(82, 258, this.case, 0);
            }
            catch (SmbAuthException smbAuthException) {
                if ((smbFile.case & 1) != 0) {
                    smbFile.setPathInformation(smbFile.case & 0xFFFFFFFE, 0L, 0L);
                    smbFile.open(82, 258, this.case, 0);
                }
                throw smbAuthException;
            }
            int n3 = 0;
            long l2 = 0L;
            while (true) {
                smbComReadAndX.setParam(this.fid, l2, n2);
                smbComReadAndXResponse.setParam(byArray[n3], 0);
                this.send(smbComReadAndX, smbComReadAndXResponse);
                WriterThread writerThread2 = writerThread;
                synchronized (writerThread2) {
                    if (writerThread.e != null) {
                        throw writerThread.e;
                    }
                    while (!writerThread.ready) {
                        try {
                            writerThread.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            throw new SmbException(smbFile.url.toString(), (Throwable)interruptedException);
                        }
                    }
                    if (writerThread.e != null) {
                        throw writerThread.e;
                    }
                    if (smbComReadAndXResponse.dataLength <= 0) {
                        break;
                    }
                    writerThread.write(byArray[n3], smbComReadAndXResponse.dataLength, smbFile, l2);
                }
                n3 = n3 == 1 ? 0 : 1;
                l2 += (long)smbComReadAndXResponse.dataLength;
            }
            smbFile.send(new Trans2SetFileInformation(smbFile.fid, this.case, this.do, this.try), new Trans2SetFileInformationResponse());
            smbFile.close(0L);
        }
        catch (Exception exception) {
            if (LogStream.level > 1) {
                exception.printStackTrace(log);
            }
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(SmbFile smbFile) throws SmbException {
        if (this.byte == null || smbFile.byte == null) {
            throw new SmbException("Invalid operation for workgroups or servers");
        }
        SmbComReadAndX smbComReadAndX = new SmbComReadAndX();
        SmbComReadAndXResponse smbComReadAndXResponse = new SmbComReadAndXResponse();
        this.connect0();
        smbFile.connect0();
        this.resolveDfs(null);
        try {
            if (this.getAddress().equals(smbFile.getAddress()) && this.new.regionMatches(true, 0, smbFile.new, 0, Math.min(this.new.length(), smbFile.new.length()))) {
                throw new SmbException("Source and destination paths overlap.");
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        WriterThread writerThread = new WriterThread();
        writerThread.setDaemon(true);
        writerThread.start();
        SmbTransport smbTransport = this.tree.session.transport;
        SmbTransport smbTransport2 = smbFile.tree.session.transport;
        if (smbTransport.snd_buf_size < smbTransport2.snd_buf_size) {
            smbTransport2.snd_buf_size = smbTransport.snd_buf_size;
        } else {
            smbTransport.snd_buf_size = smbTransport2.snd_buf_size;
        }
        int n2 = Math.min(smbTransport.rcv_buf_size - 70, smbTransport.snd_buf_size - 70);
        byte[][] byArray = new byte[2][n2];
        try {
            this.copyTo0(smbFile, byArray, n2, writerThread, smbComReadAndX, smbComReadAndXResponse);
        }
        finally {
            writerThread.write(null, -1, null, 0L);
        }
    }

    public void delete() throws SmbException {
        this.exists();
        this.getUncPath0();
        this.delete(this.unc);
    }

    void delete(String string) throws SmbException {
        SmbFile[] smbFileArray;
        if (this.getUncPath0().length() == 1) {
            throw new SmbException("Invalid operation for workgroups, servers, or shares");
        }
        if (System.currentTimeMillis() > this.for) {
            this.case = 17;
            this.do = 0L;
            this.try = 0L;
            this.goto = false;
            smbFileArray = this.queryPath(this.getUncPath0(), 257);
            this.case = smbFileArray.getAttributes();
            this.do = smbFileArray.getCreateTime();
            this.try = smbFileArray.getLastWriteTime();
            this.for = System.currentTimeMillis() + attrExpirationPeriod;
            this.goto = true;
        }
        if ((this.case & 1) != 0) {
            this.setReadWrite();
        }
        if (LogStream.level >= 3) {
            log.println("delete: " + string);
        }
        if ((this.case & 0x10) != 0) {
            block9: {
                try {
                    smbFileArray = this.listFiles("*", 22, null, null);
                    for (int i2 = 0; i2 < smbFileArray.length; ++i2) {
                        smbFileArray[i2].delete();
                    }
                }
                catch (SmbException smbException) {
                    if (smbException.getNtStatus() == -1073741809) break block9;
                    throw smbException;
                }
            }
            this.send(new SmbComDeleteDirectory(string), this.a());
        } else {
            this.send(new SmbComDelete(string), this.a());
        }
        this.a = 0L;
        this.for = 0L;
    }

    public long length() throws SmbException {
        if (this.a > System.currentTimeMillis()) {
            return this.if;
        }
        if (this.getType() == 8) {
            int n2 = 1;
            Trans2QueryFSInformationResponse trans2QueryFSInformationResponse = new Trans2QueryFSInformationResponse(n2);
            this.send(new Trans2QueryFSInformation(n2), trans2QueryFSInformationResponse);
            this.if = trans2QueryFSInformationResponse.info.getCapacity();
        } else if (this.getUncPath0().length() > 1 && this.type != 16) {
            Info info = this.queryPath(this.getUncPath0(), 258);
            this.if = info.getSize();
        } else {
            this.if = 0L;
        }
        this.a = System.currentTimeMillis() + attrExpirationPeriod;
        return this.if;
    }

    public long getDiskFreeSpace() throws SmbException {
        if (this.getType() == 8 || this.type == 1) {
            int n2 = 1007;
            try {
                return this.a(n2);
            }
            catch (SmbException smbException) {
                switch (smbException.getNtStatus()) {
                    case -1073741823: 
                    case -1073741821: {
                        n2 = 1;
                        return this.a(n2);
                    }
                }
                throw smbException;
            }
        }
        return 0L;
    }

    private long a(int n2) throws SmbException {
        Trans2QueryFSInformationResponse trans2QueryFSInformationResponse = new Trans2QueryFSInformationResponse(n2);
        this.send(new Trans2QueryFSInformation(n2), trans2QueryFSInformationResponse);
        if (this.type == 8) {
            this.if = trans2QueryFSInformationResponse.info.getCapacity();
            this.a = System.currentTimeMillis() + attrExpirationPeriod;
        }
        return trans2QueryFSInformationResponse.info.getFree();
    }

    public void mkdir() throws SmbException {
        String string = this.getUncPath0();
        if (string.length() == 1) {
            throw new SmbException("Invalid operation for workgroups, servers, or shares");
        }
        if (LogStream.level >= 3) {
            log.println("mkdir: " + string);
        }
        this.send(new SmbComCreateDirectory(string), this.a());
        this.a = 0L;
        this.for = 0L;
    }

    public void mkdirs() throws SmbException {
        SmbFile smbFile;
        try {
            smbFile = new SmbFile(this.getParent(), this.auth);
        }
        catch (IOException iOException) {
            return;
        }
        if (!smbFile.exists()) {
            smbFile.mkdirs();
        }
        this.mkdir();
    }

    public void createNewFile() throws SmbException {
        if (this.getUncPath0().length() == 1) {
            throw new SmbException("Invalid operation for workgroups, servers, or shares");
        }
        this.close(this.open0(51, 0, 128, 0), 0L);
    }

    void setPathInformation(int n2, long l2, long l3) throws SmbException {
        this.exists();
        int n3 = this.case & 0x10;
        int n4 = this.open0(1, 256, n3, n3 != 0 ? 1 : 64);
        this.send(new Trans2SetFileInformation(n4, n2 | n3, l2, l3), new Trans2SetFileInformationResponse());
        this.close(n4, 0L);
        this.for = 0L;
    }

    public void setCreateTime(long l2) throws SmbException {
        if (this.getUncPath0().length() == 1) {
            throw new SmbException("Invalid operation for workgroups, servers, or shares");
        }
        this.setPathInformation(0, l2, 0L);
    }

    public void setLastModified(long l2) throws SmbException {
        if (this.getUncPath0().length() == 1) {
            throw new SmbException("Invalid operation for workgroups, servers, or shares");
        }
        this.setPathInformation(0, 0L, l2);
    }

    public int getAttributes() throws SmbException {
        if (this.getUncPath0().length() == 1) {
            return 0;
        }
        this.exists();
        return this.case & Short.MAX_VALUE;
    }

    public void setAttributes(int n2) throws SmbException {
        if (this.getUncPath0().length() == 1) {
            throw new SmbException("Invalid operation for workgroups, servers, or shares");
        }
        this.setPathInformation(n2 & 0x30A7, 0L, 0L);
    }

    public void setReadOnly() throws SmbException {
        this.setAttributes(this.getAttributes() | 1);
    }

    public void setReadWrite() throws SmbException {
        this.setAttributes(this.getAttributes() & 0xFFFFFFFE);
    }

    public URL toURL() throws MalformedURLException {
        return this.url;
    }

    public int hashCode() {
        int n2;
        try {
            n2 = this.getAddress().hashCode();
        }
        catch (UnknownHostException unknownHostException) {
            n2 = this.getServer().toUpperCase().hashCode();
        }
        this.getUncPath0();
        return n2 + this.new.toUpperCase().hashCode();
    }

    protected boolean pathNamesPossiblyEqual(String string, String string2) {
        int n2 = string.lastIndexOf(47);
        int n3 = string2.lastIndexOf(47);
        int n4 = string.length() - n2;
        int n5 = string2.length() - n3;
        if (n4 > 1 && string.charAt(n2 + 1) == '.') {
            return true;
        }
        if (n5 > 1 && string2.charAt(n3 + 1) == '.') {
            return true;
        }
        return n4 == n5 && string.regionMatches(true, n2, string2, n3, n4);
    }

    public boolean equals(Object object) {
        if (object instanceof SmbFile) {
            SmbFile smbFile = (SmbFile)object;
            if (this == smbFile) {
                return true;
            }
            if (this.pathNamesPossiblyEqual(this.url.getPath(), smbFile.url.getPath())) {
                this.getUncPath0();
                smbFile.getUncPath0();
                if (this.new.equalsIgnoreCase(smbFile.new)) {
                    boolean bl;
                    try {
                        bl = this.getAddress().equals(smbFile.getAddress());
                    }
                    catch (UnknownHostException unknownHostException) {
                        bl = this.getServer().equalsIgnoreCase(smbFile.getServer());
                    }
                    return bl;
                }
            }
        }
        return false;
    }

    public String toString() {
        return this.url.toString();
    }

    public int getContentLength() {
        try {
            return (int)(this.length() & 0xFFFFFFFFL);
        }
        catch (SmbException smbException) {
            return 0;
        }
    }

    public long getDate() {
        try {
            return this.lastModified();
        }
        catch (SmbException smbException) {
            return 0L;
        }
    }

    public long getLastModified() {
        try {
            return this.lastModified();
        }
        catch (SmbException smbException) {
            return 0L;
        }
    }

    public InputStream getInputStream() throws IOException {
        return new SmbFileInputStream(this);
    }

    public OutputStream getOutputStream() throws IOException {
        return new SmbFileOutputStream(this);
    }

    private void a(ACE[] aCEArray, boolean bl) throws IOException {
        String string = this.getServerWithDfs();
        if (bl) {
            SID[] sIDArray = new SID[aCEArray.length];
            Object var6_5 = null;
            for (int i2 = 0; i2 < aCEArray.length; ++i2) {
                sIDArray[i2] = aCEArray[i2].sid;
            }
            for (int i3 = 0; i3 < sIDArray.length; i3 += 10) {
                int n2 = sIDArray.length - i3;
                if (n2 > 64) {
                    n2 = 64;
                }
                SID.resolveSids(string, this.auth, sIDArray, i3, n2);
            }
        } else {
            for (int i4 = 0; i4 < aCEArray.length; ++i4) {
                aCEArray[i4].sid.origin_server = string;
                aCEArray[i4].sid.origin_auth = this.auth;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ACE[] getSecurity(boolean bl) throws IOException {
        int n2 = this.open0(1, 131072, 0, this.isDirectory() ? 1 : 0);
        NtTransQuerySecurityDesc ntTransQuerySecurityDesc = new NtTransQuerySecurityDesc(n2, 4);
        NtTransQuerySecurityDescResponse ntTransQuerySecurityDescResponse = new NtTransQuerySecurityDescResponse();
        try {
            this.send(ntTransQuerySecurityDesc, ntTransQuerySecurityDescResponse);
        }
        finally {
            this.close(n2, 0L);
        }
        ACE[] aCEArray = ntTransQuerySecurityDescResponse.securityDescriptor.aces;
        if (aCEArray != null) {
            this.a(aCEArray, bl);
        }
        return aCEArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ACE[] getShareSecurity(boolean bl) throws IOException {
        ACE[] aCEArray;
        String string = this.url.getPath();
        this.resolveDfs(null);
        String string2 = this.getServerWithDfs();
        MsrpcShareGetInfo msrpcShareGetInfo = new MsrpcShareGetInfo(string2, this.tree.share);
        DcerpcHandle dcerpcHandle = DcerpcHandle.getHandle("ncacn_np:" + string2 + "[\\PIPE\\srvsvc]", this.auth);
        try {
            dcerpcHandle.sendrecv(msrpcShareGetInfo);
            if (msrpcShareGetInfo.retval != 0) {
                throw new SmbException(msrpcShareGetInfo.retval, true);
            }
            aCEArray = msrpcShareGetInfo.getSecurity();
            if (aCEArray != null) {
                this.a(aCEArray, bl);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            block9: {
                Object var8_8 = null;
                try {
                    dcerpcHandle.close();
                }
                catch (IOException iOException) {
                    if (LogStream.level < 1) break block9;
                    iOException.printStackTrace(log);
                }
            }
            throw throwable;
        }
        try {
            dcerpcHandle.close();
        }
        catch (IOException iOException) {
            if (LogStream.level >= 1) {
                iOException.printStackTrace(log);
            }
        }
        return aCEArray;
    }

    public ACE[] getSecurity() throws IOException {
        return this.getSecurity(false);
    }

    static {
        try {
            Class.forName("jcifs.Config");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        attrExpirationPeriod = Config.getLong("jcifs.smb.client.attrExpirationPeriod", 5000L);
        dfs = new Dfs();
    }

    class WriterThread
    extends Thread {
        byte[] b;
        int n;
        long off;
        boolean ready;
        SmbFile dest;
        SmbException e = null;
        boolean useNTSmbs;
        SmbComWriteAndX reqx;
        SmbComWrite req;
        ServerMessageBlock resp;

        WriterThread() throws SmbException {
            super("JCIFS-WriterThread");
            this.useNTSmbs = SmbFile.this.tree.session.transport.hasCapability(16);
            if (this.useNTSmbs) {
                this.reqx = new SmbComWriteAndX();
                this.resp = new SmbComWriteAndXResponse();
            } else {
                this.req = new SmbComWrite();
                this.resp = new SmbComWriteResponse();
            }
            this.ready = false;
        }

        synchronized void write(byte[] byArray, int n2, SmbFile smbFile, long l2) {
            this.b = byArray;
            this.n = n2;
            this.dest = smbFile;
            this.off = l2;
            this.ready = false;
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            WriterThread writerThread = this;
            synchronized (writerThread) {
                try {
                    while (true) {
                        this.notify();
                        this.ready = true;
                        while (this.ready) {
                            this.wait();
                        }
                        if (this.n == -1) {
                            return;
                        }
                        if (this.useNTSmbs) {
                            this.reqx.setParam(this.dest.fid, this.off, this.n, this.b, 0, this.n);
                            this.dest.send(this.reqx, this.resp);
                            continue;
                        }
                        this.req.setParam(this.dest.fid, this.off, this.n, this.b, 0, this.n);
                        this.dest.send(this.req, this.resp);
                    }
                }
                catch (SmbException smbException) {
                    this.e = smbException;
                }
                catch (Exception exception) {
                    this.e = new SmbException("WriterThread", (Throwable)exception);
                }
                this.notify();
            }
        }
    }
}

