/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import jcifs.smb.SmbComReadAndX;
import jcifs.smb.SmbComReadAndXResponse;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbNamedPipe;
import jcifs.smb.TransPeekNamedPipe;
import jcifs.smb.TransPeekNamedPipeResponse;
import jcifs.util.LogStream;
import jcifs.util.transport.TransportException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SmbFileInputStream
extends InputStream {
    private long for;
    private int do;
    private int if;
    private int a;
    private byte[] int = new byte[1];
    SmbFile file;

    public SmbFileInputStream(String string) throws SmbException, MalformedURLException, UnknownHostException {
        this(new SmbFile(string));
    }

    public SmbFileInputStream(SmbFile smbFile) throws SmbException, MalformedURLException, UnknownHostException {
        this(smbFile, 1);
    }

    SmbFileInputStream(SmbFile smbFile, int n2) throws SmbException, MalformedURLException, UnknownHostException {
        this.file = smbFile;
        this.if = n2 & 0xFFFF;
        this.a = n2 >>> 16 & 0xFFFF;
        if (smbFile.type != 16) {
            smbFile.open(n2, this.a, 128, 0);
            this.if &= 0xFFFFFFAF;
        } else {
            smbFile.connect0();
        }
        this.do = Math.min(smbFile.tree.session.transport.rcv_buf_size - 70, smbFile.tree.session.transport.server.maxBufferSize - 70);
    }

    protected IOException seToIoe(SmbException smbException) {
        IOException iOException = smbException;
        Throwable throwable = smbException.getRootCause();
        if (throwable instanceof TransportException) {
            iOException = (TransportException)throwable;
            throwable = ((TransportException)iOException).getRootCause();
        }
        if (throwable instanceof InterruptedException) {
            iOException = new InterruptedIOException(throwable.getMessage());
            iOException.initCause(throwable);
        }
        return iOException;
    }

    public void close() throws IOException {
        try {
            this.file.close();
            this.int = null;
        }
        catch (SmbException smbException) {
            throw this.seToIoe(smbException);
        }
    }

    public int read() throws IOException {
        if (this.read(this.int, 0, 1) == -1) {
            return -1;
        }
        return this.int[0] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        return this.readDirect(byArray, n2, n3);
    }

    public int readDirect(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5;
        if (n3 <= 0) {
            return 0;
        }
        long l2 = this.for;
        if (this.int == null) {
            throw new IOException("Bad file descriptor");
        }
        this.file.open(this.if, this.a, 128, 0);
        if (LogStream.level >= 4) {
            SmbFile.log.println("read: fid=" + this.file.fid + ",off=" + n2 + ",len=" + n3);
        }
        SmbComReadAndXResponse smbComReadAndXResponse = new SmbComReadAndXResponse(byArray, n2);
        if (this.file.type == 16) {
            smbComReadAndXResponse.responseTimeout = 0L;
        }
        do {
            n4 = n3 > this.do ? this.do : n3;
            if (LogStream.level >= 4) {
                SmbFile.log.println("read: len=" + n3 + ",r=" + n4 + ",fp=" + this.for);
            }
            try {
                SmbComReadAndX smbComReadAndX = new SmbComReadAndX(this.file.fid, this.for, n4, null);
                if (this.file.type == 16) {
                    smbComReadAndX.remaining = 1024;
                    smbComReadAndX.maxCount = 1024;
                    smbComReadAndX.minCount = 1024;
                }
                this.file.send(smbComReadAndX, smbComReadAndXResponse);
            }
            catch (SmbException smbException) {
                if (this.file.type == 16 && smbException.getNtStatus() == -1073741493) {
                    return -1;
                }
                throw this.seToIoe(smbException);
            }
            n5 = smbComReadAndXResponse.dataLength;
            if (n5 <= 0) {
                return (int)(this.for - l2 > 0L ? this.for - l2 : -1L);
            }
            this.for += (long)n5;
            smbComReadAndXResponse.off += n5;
        } while ((n3 -= n5) > 0 && n5 == n4);
        return (int)(this.for - l2);
    }

    public int available() throws IOException {
        if (this.file.type != 16) {
            return 0;
        }
        try {
            SmbNamedPipe smbNamedPipe = (SmbNamedPipe)this.file;
            this.file.open(32, smbNamedPipe.pipeType & 0xFF0000, 128, 0);
            TransPeekNamedPipe transPeekNamedPipe = new TransPeekNamedPipe(this.file.unc, this.file.fid);
            TransPeekNamedPipeResponse transPeekNamedPipeResponse = new TransPeekNamedPipeResponse(smbNamedPipe);
            smbNamedPipe.send(transPeekNamedPipe, transPeekNamedPipeResponse);
            if (transPeekNamedPipeResponse.status == 1 || transPeekNamedPipeResponse.status == 4) {
                this.file.opened = false;
                return 0;
            }
            return transPeekNamedPipeResponse.available;
        }
        catch (SmbException smbException) {
            throw this.seToIoe(smbException);
        }
    }

    public long skip(long l2) throws IOException {
        if (l2 > 0L) {
            this.for += l2;
            return l2;
        }
        return 0L;
    }
}

