/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbComWrite;
import jcifs.smb.SmbComWriteAndX;
import jcifs.smb.SmbComWriteAndXResponse;
import jcifs.smb.SmbComWriteResponse;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbNamedPipe;
import jcifs.smb.TransWaitNamedPipe;
import jcifs.smb.TransWaitNamedPipeResponse;
import jcifs.util.LogStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SmbFileOutputStream
extends OutputStream {
    private SmbFile int;
    private boolean do;
    private boolean for;
    private int try;
    private int new;
    private int if;
    private long case;
    private byte[] byte = new byte[1];
    private SmbComWriteAndX char;
    private SmbComWriteAndXResponse a;
    private SmbComWrite else;
    private SmbComWriteResponse goto;

    public SmbFileOutputStream(String string) throws SmbException, MalformedURLException, UnknownHostException {
        this(string, false);
    }

    public SmbFileOutputStream(SmbFile smbFile) throws SmbException, MalformedURLException, UnknownHostException {
        this(smbFile, false);
    }

    public SmbFileOutputStream(String string, boolean bl) throws SmbException, MalformedURLException, UnknownHostException {
        this(new SmbFile(string), bl);
    }

    public SmbFileOutputStream(SmbFile smbFile, boolean bl) throws SmbException, MalformedURLException, UnknownHostException {
        this(smbFile, bl, bl ? 22 : 82);
    }

    public SmbFileOutputStream(String string, int n2) throws SmbException, MalformedURLException, UnknownHostException {
        this(new SmbFile(string, "", null, n2), false);
    }

    SmbFileOutputStream(SmbFile smbFile, boolean bl, int n2) throws SmbException, MalformedURLException, UnknownHostException {
        this.int = smbFile;
        this.do = bl;
        this.try = n2;
        this.new = n2 >>> 16 & 0xFFFF;
        if (bl) {
            try {
                this.case = smbFile.length();
            }
            catch (SmbAuthException smbAuthException) {
                throw smbAuthException;
            }
            catch (SmbException smbException) {
                this.case = 0L;
            }
        }
        if (smbFile instanceof SmbNamedPipe && smbFile.unc.startsWith("\\pipe\\")) {
            smbFile.unc = smbFile.unc.substring(5);
            smbFile.send(new TransWaitNamedPipe("\\pipe" + smbFile.unc), new TransWaitNamedPipeResponse());
        }
        smbFile.open(n2, this.new | 2, 128, 0);
        this.try &= 0xFFFFFFAF;
        this.if = smbFile.tree.session.transport.snd_buf_size - 70;
        this.for = smbFile.tree.session.transport.hasCapability(16);
        if (this.for) {
            this.char = new SmbComWriteAndX();
            this.a = new SmbComWriteAndXResponse();
        } else {
            this.else = new SmbComWrite();
            this.goto = new SmbComWriteResponse();
        }
    }

    public void close() throws IOException {
        this.int.close();
        this.byte = null;
    }

    public void write(int n2) throws IOException {
        this.byte[0] = (byte)n2;
        this.write(this.byte, 0, 1);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public boolean isOpen() {
        return this.int.isOpen();
    }

    void ensureOpen() throws IOException {
        if (!this.int.isOpen()) {
            this.int.open(this.try, this.new | 2, 128, 0);
            if (this.do) {
                this.case = this.int.length();
            }
        }
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (!this.int.isOpen() && this.int instanceof SmbNamedPipe) {
            this.int.send(new TransWaitNamedPipe("\\pipe" + this.int.unc), new TransWaitNamedPipeResponse());
        }
        this.writeDirect(byArray, n2, n3, 0);
    }

    public void writeDirect(byte[] byArray, int n2, int n3, int n4) throws IOException {
        if (n3 <= 0) {
            return;
        }
        if (this.byte == null) {
            throw new IOException("Bad file descriptor");
        }
        this.ensureOpen();
        if (LogStream.level >= 4) {
            SmbFile.log.println("write: fid=" + this.int.fid + ",off=" + n2 + ",len=" + n3);
        }
        do {
            int n5;
            int n6 = n5 = n3 > this.if ? this.if : n3;
            if (this.for) {
                this.char.setParam(this.int.fid, this.case, n3 - n5, byArray, n2, n5);
                if ((n4 & 1) != 0) {
                    this.char.setParam(this.int.fid, this.case, n3, byArray, n2, n5);
                    this.char.writeMode = 8;
                } else {
                    this.char.writeMode = 0;
                }
                this.int.send(this.char, this.a);
                this.case += this.a.count;
                n3 = (int)((long)n3 - this.a.count);
                n2 = (int)((long)n2 + this.a.count);
                continue;
            }
            this.else.setParam(this.int.fid, this.case, n3 - n5, byArray, n2, n5);
            this.case += this.goto.count;
            n3 = (int)((long)n3 - this.goto.count);
            n2 = (int)((long)n2 + this.goto.count);
            this.int.send(this.else, this.goto);
        } while (n3 > 0);
    }
}

