/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import jcifs.Config;
import jcifs.UniAddress;
import jcifs.netbios.NbtAddress;
import jcifs.smb.NtlmChallenge;
import jcifs.smb.NtlmContext;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SigningDigest;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbComLogoffAndX;
import jcifs.smb.SmbComSessionSetupAndX;
import jcifs.smb.SmbComSessionSetupAndXResponse;
import jcifs.smb.SmbComTreeConnectAndX;
import jcifs.smb.SmbConstants;
import jcifs.smb.SmbException;
import jcifs.smb.SmbTransport;
import jcifs.smb.SmbTree;
import jcifs.smb.Trans2FindFirst2;
import jcifs.smb.Trans2FindFirst2Response;
import jcifs.util.LogStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class SmbSession {
    private static final String byte = Config.getProperty("jcifs.smb.client.logonShare", null);
    private static final int case = Config.getInt("jcifs.netbios.lookupRespLimit", 3);
    private static final String a = Config.getProperty("jcifs.smb.client.domain", null);
    private static final String do = Config.getProperty("jcifs.smb.client.username", null);
    private static final int int = Config.getInt("jcifs.netbios.cachePolicy", 600) * 60;
    static NbtAddress[] dc_list = null;
    static long dc_list_expiration;
    static int dc_list_counter;
    int connectionState;
    int uid;
    Vector trees;
    private UniAddress if;
    private int for;
    private int try;
    private InetAddress new;
    SmbTransport transport = null;
    NtlmPasswordAuthentication auth;
    long expiration;
    String netbiosName = null;

    private static NtlmChallenge a(NbtAddress nbtAddress) throws SmbException {
        UniAddress uniAddress = new UniAddress(nbtAddress);
        SmbTransport smbTransport = SmbTransport.getSmbTransport(uniAddress, 0);
        if (do == null) {
            smbTransport.connect();
            if (LogStream.level >= 3) {
                SmbTransport.log.println("Default credentials (jcifs.smb.client.username/password) not specified. SMB signing may not work propertly.  Skipping DC interrogation.");
            }
        } else {
            SmbSession smbSession = smbTransport.getSmbSession(NtlmPasswordAuthentication.DEFAULT);
            smbSession.getSmbTree(byte, null).treeConnect(null, null);
        }
        return new NtlmChallenge(smbTransport.server.encryptionKey, uniAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NtlmChallenge getChallengeForDomain() throws SmbException, UnknownHostException {
        if (a == null) {
            throw new SmbException("A domain was not specified");
        }
        String string = a;
        synchronized (string) {
            long l2 = System.currentTimeMillis();
            int n2 = 1;
            do {
                if (dc_list_expiration < l2) {
                    NbtAddress[] nbtAddressArray = NbtAddress.getAllByName(a, 28, null, null);
                    dc_list_expiration = l2 + (long)int * 1000L;
                    if (nbtAddressArray != null && nbtAddressArray.length > 0) {
                        dc_list = nbtAddressArray;
                    } else {
                        dc_list_expiration = l2 + 900000L;
                        if (LogStream.level >= 2) {
                            SmbTransport.log.println("Failed to retrieve DC list from WINS");
                        }
                    }
                }
                int n3 = Math.min(dc_list.length, case);
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4;
                    if (dc_list[n4 = dc_list_counter++ % n3] == null) continue;
                    try {
                        return SmbSession.a(dc_list[n4]);
                    }
                    catch (SmbException smbException) {
                        if (LogStream.level >= 2) {
                            SmbTransport.log.println("Failed validate DC: " + dc_list[n4]);
                            if (LogStream.level > 2) {
                                smbException.printStackTrace(SmbTransport.log);
                            }
                        }
                        SmbSession.dc_list[n4] = null;
                    }
                }
                dc_list_expiration = 0L;
            } while (n2-- > 0);
            dc_list_expiration = l2 + 900000L;
        }
        throw new UnknownHostException("Failed to negotiate with a suitable domain controller for " + a);
    }

    public static byte[] getChallenge(UniAddress uniAddress) throws SmbException, UnknownHostException {
        return SmbSession.getChallenge(uniAddress, 0);
    }

    public static byte[] getChallenge(UniAddress uniAddress, int n2) throws SmbException, UnknownHostException {
        SmbTransport smbTransport = SmbTransport.getSmbTransport(uniAddress, n2);
        smbTransport.connect();
        return smbTransport.server.encryptionKey;
    }

    public static void logon(UniAddress uniAddress, NtlmPasswordAuthentication ntlmPasswordAuthentication) throws SmbException {
        SmbSession.logon(uniAddress, 0, ntlmPasswordAuthentication);
    }

    public static void logon(UniAddress uniAddress, int n2, NtlmPasswordAuthentication ntlmPasswordAuthentication) throws SmbException {
        SmbTree smbTree = SmbTransport.getSmbTransport(uniAddress, n2).getSmbSession(ntlmPasswordAuthentication).getSmbTree(byte, null);
        if (byte == null) {
            smbTree.treeConnect(null, null);
        } else {
            Trans2FindFirst2 trans2FindFirst2 = new Trans2FindFirst2("\\", "*", 16);
            Trans2FindFirst2Response trans2FindFirst2Response = new Trans2FindFirst2Response();
            smbTree.send(trans2FindFirst2, trans2FindFirst2Response);
        }
    }

    SmbSession(UniAddress uniAddress, int n2, InetAddress inetAddress, int n3, NtlmPasswordAuthentication ntlmPasswordAuthentication) {
        this.if = uniAddress;
        this.for = n2;
        this.new = inetAddress;
        this.try = n3;
        this.auth = ntlmPasswordAuthentication;
        this.trees = new Vector();
        this.connectionState = 0;
    }

    synchronized SmbTree getSmbTree(String string, String string2) {
        SmbTree smbTree;
        if (string == null) {
            string = "IPC$";
        }
        Enumeration enumeration = this.trees.elements();
        while (enumeration.hasMoreElements()) {
            smbTree = (SmbTree)enumeration.nextElement();
            if (!smbTree.matches(string, string2)) continue;
            return smbTree;
        }
        smbTree = new SmbTree(this, string, string2);
        this.trees.addElement(smbTree);
        return smbTree;
    }

    boolean matches(NtlmPasswordAuthentication ntlmPasswordAuthentication) {
        return this.auth == ntlmPasswordAuthentication || this.auth.equals(ntlmPasswordAuthentication);
    }

    synchronized SmbTransport transport() {
        if (this.transport == null) {
            this.transport = SmbTransport.getSmbTransport(this.if, this.for, this.new, this.try, null);
        }
        return this.transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(ServerMessageBlock serverMessageBlock, ServerMessageBlock serverMessageBlock2) throws SmbException {
        SmbTransport smbTransport = this.transport();
        synchronized (smbTransport) {
            if (serverMessageBlock2 != null) {
                serverMessageBlock2.received = false;
            }
            this.expiration = System.currentTimeMillis() + (long)SmbConstants.SO_TIMEOUT;
            this.sessionSetup(serverMessageBlock, serverMessageBlock2);
            if (serverMessageBlock2 != null && serverMessageBlock2.received) {
                return;
            }
            if (serverMessageBlock instanceof SmbComTreeConnectAndX) {
                SmbComTreeConnectAndX smbComTreeConnectAndX = (SmbComTreeConnectAndX)serverMessageBlock;
                if (this.netbiosName != null && smbComTreeConnectAndX.path.endsWith("\\IPC$")) {
                    smbComTreeConnectAndX.path = "\\\\" + this.netbiosName + "\\IPC$";
                }
            }
            serverMessageBlock.uid = this.uid;
            serverMessageBlock.auth = this.auth;
            try {
                this.transport.send(serverMessageBlock, serverMessageBlock2);
            }
            catch (SmbException smbException) {
                if (serverMessageBlock instanceof SmbComTreeConnectAndX) {
                    this.logoff(true);
                }
                serverMessageBlock.digest = null;
                throw smbException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sessionSetup(ServerMessageBlock serverMessageBlock, ServerMessageBlock serverMessageBlock2) throws SmbException {
        SmbTransport smbTransport = this.transport();
        synchronized (smbTransport) {
            NtlmContext ntlmContext = null;
            SmbException smbException = null;
            byte[] byArray = new byte[]{};
            int n2 = 10;
            while (this.connectionState != 0) {
                if (this.connectionState == 2 || this.connectionState == 3) {
                    return;
                }
                try {
                    this.transport.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new SmbException(interruptedException.getMessage(), (Throwable)interruptedException);
                }
            }
            this.connectionState = 1;
            try {
                this.transport.connect();
                if (LogStream.level >= 4) {
                    SmbTransport.log.println("sessionSetup: accountName=" + this.auth.username + ",primaryDomain=" + this.auth.domain);
                }
                this.uid = 0;
                block27: do {
                    switch (n2) {
                        case 10: {
                            if (this.auth != NtlmPasswordAuthentication.ANONYMOUS && this.transport.hasCapability(Integer.MIN_VALUE)) {
                                n2 = 20;
                                break;
                            }
                            SmbComSessionSetupAndX smbComSessionSetupAndX = new SmbComSessionSetupAndX(this, serverMessageBlock, this.auth);
                            SmbComSessionSetupAndXResponse smbComSessionSetupAndXResponse = new SmbComSessionSetupAndXResponse(serverMessageBlock2);
                            if (this.transport.isSignatureSetupRequired(this.auth)) {
                                if (this.auth.hashesExternal && NtlmPasswordAuthentication.DEFAULT_PASSWORD != "") {
                                    this.transport.getSmbSession(NtlmPasswordAuthentication.DEFAULT).getSmbTree(byte, null).treeConnect(null, null);
                                } else {
                                    byte[] byArray2 = this.auth.getSigningKey(this.transport.server.encryptionKey);
                                    smbComSessionSetupAndX.digest = new SigningDigest(byArray2, false);
                                }
                            }
                            smbComSessionSetupAndX.auth = this.auth;
                            try {
                                this.transport.send(smbComSessionSetupAndX, smbComSessionSetupAndXResponse);
                            }
                            catch (SmbAuthException smbAuthException) {
                                throw smbAuthException;
                            }
                            catch (SmbException smbException2) {
                                smbException = smbException2;
                            }
                            if (smbComSessionSetupAndXResponse.isLoggedInAsGuest && !"GUEST".equalsIgnoreCase(this.auth.username) && this.transport.server.security != 0) {
                                throw new SmbAuthException(-1073741715);
                            }
                            if (smbException != null) {
                                throw smbException;
                            }
                            this.uid = smbComSessionSetupAndXResponse.uid;
                            if (smbComSessionSetupAndX.digest != null) {
                                this.transport.digest = smbComSessionSetupAndX.digest;
                            }
                            this.connectionState = 2;
                            n2 = 0;
                            break;
                        }
                        case 20: {
                            byte[] byArray3;
                            if (ntlmContext == null) {
                                boolean bl = (this.transport.flags2 & 4) != 0;
                                ntlmContext = new NtlmContext(this.auth, bl);
                            }
                            if (LogStream.level >= 4) {
                                SmbTransport.log.println(ntlmContext);
                            }
                            if (ntlmContext.isEstablished()) {
                                this.netbiosName = ntlmContext.getNetbiosName();
                                this.connectionState = 2;
                                n2 = 0;
                                break;
                            }
                            try {
                                byArray = ntlmContext.initSecContext(byArray, 0, byArray.length);
                            }
                            catch (SmbException smbException3) {
                                try {
                                    this.transport.disconnect(true);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                this.uid = 0;
                                throw smbException3;
                            }
                            if (byArray == null) continue block27;
                            SmbComSessionSetupAndX smbComSessionSetupAndX = new SmbComSessionSetupAndX(this, null, byArray);
                            SmbComSessionSetupAndXResponse smbComSessionSetupAndXResponse = new SmbComSessionSetupAndXResponse(null);
                            if (this.transport.isSignatureSetupRequired(this.auth) && (byArray3 = ntlmContext.getSigningKey()) != null) {
                                smbComSessionSetupAndX.digest = new SigningDigest(byArray3, true);
                            }
                            smbComSessionSetupAndX.uid = this.uid;
                            this.uid = 0;
                            try {
                                this.transport.send(smbComSessionSetupAndX, smbComSessionSetupAndXResponse);
                            }
                            catch (SmbAuthException smbAuthException) {
                                throw smbAuthException;
                            }
                            catch (SmbException smbException4) {
                                smbException = smbException4;
                                try {
                                    this.transport.disconnect(true);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (smbComSessionSetupAndXResponse.isLoggedInAsGuest && !"GUEST".equalsIgnoreCase(this.auth.username)) {
                                throw new SmbAuthException(-1073741715);
                            }
                            if (smbException != null) {
                                throw smbException;
                            }
                            this.uid = smbComSessionSetupAndXResponse.uid;
                            if (smbComSessionSetupAndX.digest != null) {
                                this.transport.digest = smbComSessionSetupAndX.digest;
                            }
                            byArray = smbComSessionSetupAndXResponse.blob;
                            break;
                        }
                        default: {
                            throw new SmbException("Unexpected session setup state: " + n2);
                        }
                    }
                } while (n2 != 0);
            }
            catch (SmbException smbException5) {
                this.logoff(true);
                this.connectionState = 0;
                throw smbException5;
            }
            finally {
                this.transport.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logoff(boolean bl) {
        SmbTransport smbTransport = this.transport();
        synchronized (smbTransport) {
            if (this.connectionState != 2) {
                return;
            }
            this.connectionState = 3;
            this.netbiosName = null;
            Object object = this.trees.elements();
            while (object.hasMoreElements()) {
                SmbTree smbTree = (SmbTree)object.nextElement();
                smbTree.treeDisconnect(bl);
            }
            if (!bl && this.transport.server.security != 0) {
                object = new SmbComLogoffAndX(null);
                ((SmbComLogoffAndX)object).uid = this.uid;
                try {
                    this.transport.send((ServerMessageBlock)object, null);
                }
                catch (SmbException smbException) {
                    // empty catch block
                }
                this.uid = 0;
            }
            this.connectionState = 0;
            this.transport.notifyAll();
        }
    }

    public String toString() {
        return "SmbSession[accountName=" + this.auth.username + ",primaryDomain=" + this.auth.domain + ",uid=" + this.uid + ",connectionState=" + this.connectionState + "]";
    }
}

