/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import jcifs.UniAddress;
import jcifs.netbios.Name;
import jcifs.netbios.NbtAddress;
import jcifs.netbios.NbtException;
import jcifs.netbios.SessionRequestPacket;
import jcifs.smb.AndXServerMessageBlock;
import jcifs.smb.BufferCache;
import jcifs.smb.Dfs;
import jcifs.smb.DfsReferral;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SigningDigest;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbComBlankResponse;
import jcifs.smb.SmbComNegotiate;
import jcifs.smb.SmbComNegotiateResponse;
import jcifs.smb.SmbComReadAndXResponse;
import jcifs.smb.SmbComTransaction;
import jcifs.smb.SmbComTransactionResponse;
import jcifs.smb.SmbConstants;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbSession;
import jcifs.smb.SmbTree;
import jcifs.smb.Trans2GetDfsReferral;
import jcifs.smb.Trans2GetDfsReferralResponse;
import jcifs.util.Encdec;
import jcifs.util.Hexdump;
import jcifs.util.LogStream;
import jcifs.util.transport.Request;
import jcifs.util.transport.Response;
import jcifs.util.transport.Transport;
import jcifs.util.transport.TransportException;

public class SmbTransport
extends Transport
implements SmbConstants {
    static final byte[] BUF = new byte[65535];
    static final SmbComNegotiate NEGOTIATE_REQUEST = new SmbComNegotiate();
    static LogStream log = LogStream.getInstance();
    static HashMap dfsRoots = null;
    InetAddress localAddr;
    int localPort;
    UniAddress address;
    Socket socket;
    int port;
    int mid;
    OutputStream out;
    InputStream in;
    byte[] sbuf = new byte[512];
    SmbComBlankResponse key = new SmbComBlankResponse();
    long sessionExpiration = System.currentTimeMillis() + (long)SmbConstants.SO_TIMEOUT;
    LinkedList referrals = new LinkedList();
    SigningDigest digest = null;
    LinkedList sessions = new LinkedList();
    ServerData server = new ServerData();
    int flags2 = SmbConstants.FLAGS2;
    int maxMpxCount = SmbConstants.MAX_MPX_COUNT;
    int snd_buf_size = SmbConstants.SND_BUF_SIZE;
    int rcv_buf_size = SmbConstants.RCV_BUF_SIZE;
    int capabilities = SmbConstants.CAPABILITIES;
    int sessionKey = 0;
    boolean useUnicode = SmbConstants.USE_UNICODE;
    String tconHostName = null;

    static synchronized SmbTransport getSmbTransport(UniAddress uniAddress, int n2) {
        return SmbTransport.getSmbTransport(uniAddress, n2, SmbConstants.LADDR, SmbConstants.LPORT, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized SmbTransport getSmbTransport(UniAddress uniAddress, int n2, InetAddress inetAddress, int n3, String string) {
        SmbTransport smbTransport;
        LinkedList linkedList = SmbConstants.CONNECTIONS;
        synchronized (linkedList) {
            if (SmbConstants.SSN_LIMIT != 1) {
                ListIterator listIterator = SmbConstants.CONNECTIONS.listIterator();
                while (listIterator.hasNext()) {
                    smbTransport = (SmbTransport)listIterator.next();
                    if (!smbTransport.matches(uniAddress, n2, inetAddress, n3, string) || SmbConstants.SSN_LIMIT != 0 && smbTransport.sessions.size() >= SmbConstants.SSN_LIMIT) continue;
                    return smbTransport;
                }
            }
            smbTransport = new SmbTransport(uniAddress, n2, inetAddress, n3);
            SmbConstants.CONNECTIONS.add(0, smbTransport);
        }
        return smbTransport;
    }

    SmbTransport(UniAddress uniAddress, int n2, InetAddress inetAddress, int n3) {
        this.address = uniAddress;
        this.port = n2;
        this.localAddr = inetAddress;
        this.localPort = n3;
    }

    synchronized SmbSession getSmbSession() {
        return this.getSmbSession(new NtlmPasswordAuthentication(null, null, null));
    }

    synchronized SmbSession getSmbSession(NtlmPasswordAuthentication ntlmPasswordAuthentication) {
        long l2;
        SmbSession smbSession;
        ListIterator listIterator = this.sessions.listIterator();
        while (listIterator.hasNext()) {
            smbSession = (SmbSession)listIterator.next();
            if (!smbSession.matches(ntlmPasswordAuthentication)) continue;
            smbSession.auth = ntlmPasswordAuthentication;
            return smbSession;
        }
        if (SmbConstants.SO_TIMEOUT > 0 && this.sessionExpiration < (l2 = System.currentTimeMillis())) {
            this.sessionExpiration = l2 + (long)SmbConstants.SO_TIMEOUT;
            listIterator = this.sessions.listIterator();
            while (listIterator.hasNext()) {
                smbSession = (SmbSession)listIterator.next();
                if (smbSession.expiration >= l2) continue;
                smbSession.logoff(false);
            }
        }
        smbSession = new SmbSession(this.address, this.port, this.localAddr, this.localPort, ntlmPasswordAuthentication);
        smbSession.transport = this;
        this.sessions.add(smbSession);
        return smbSession;
    }

    boolean matches(UniAddress uniAddress, int n2, InetAddress inetAddress, int n3, String string) {
        if (string == null) {
            string = uniAddress.getHostName();
        }
        return (this.tconHostName == null || string.equalsIgnoreCase(this.tconHostName)) && uniAddress.equals(this.address) && (n2 == 0 || n2 == this.port || n2 == 445 && this.port == 139) && (inetAddress == this.localAddr || inetAddress != null && inetAddress.equals(this.localAddr)) && n3 == this.localPort;
    }

    boolean hasCapability(int n2) throws SmbException {
        try {
            this.connect(SmbConstants.RESPONSE_TIMEOUT);
        }
        catch (IOException iOException) {
            throw new SmbException(iOException.getMessage(), (Throwable)iOException);
        }
        return (this.capabilities & n2) == n2;
    }

    boolean isSignatureSetupRequired(NtlmPasswordAuthentication ntlmPasswordAuthentication) {
        return (this.flags2 & 4) != 0 && this.digest == null && ntlmPasswordAuthentication != NtlmPasswordAuthentication.NULL && !NtlmPasswordAuthentication.NULL.equals(ntlmPasswordAuthentication);
    }

    void ssn139() throws IOException {
        Name name = new Name(this.address.firstCalledName(), 32, null);
        do {
            this.socket = this.localAddr == null ? new Socket(this.address.getHostAddress(), 139) : new Socket(this.address.getHostAddress(), 139, this.localAddr, this.localPort);
            this.socket.setSoTimeout(SmbConstants.SO_TIMEOUT);
            this.out = this.socket.getOutputStream();
            this.in = this.socket.getInputStream();
            SessionRequestPacket sessionRequestPacket = new SessionRequestPacket(name, NbtAddress.getLocalName());
            this.out.write(this.sbuf, 0, sessionRequestPacket.writeWireFormat(this.sbuf, 0));
            if (SmbTransport.readn(this.in, this.sbuf, 0, 4) < 4) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new SmbException("EOF during NetBIOS session request");
            }
            block1 : switch (this.sbuf[0] & 0xFF) {
                case 130: {
                    if (LogStream.level >= 4) {
                        log.println("session established ok with " + this.address);
                    }
                    return;
                }
                case 131: {
                    int n2 = this.in.read() & 0xFF;
                    switch (n2) {
                        case 128: 
                        case 130: {
                            this.socket.close();
                            break block1;
                        }
                    }
                    this.disconnect(true);
                    throw new NbtException(2, n2);
                }
                case -1: {
                    this.disconnect(true);
                    throw new NbtException(2, -1);
                }
                default: {
                    this.disconnect(true);
                    throw new NbtException(2, 0);
                }
            }
        } while ((name.name = this.address.nextCalledName()) != null);
        throw new IOException("Failed to establish session with " + this.address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(int n2, ServerMessageBlock serverMessageBlock) throws IOException {
        byte[] byArray = this.sbuf;
        synchronized (this.sbuf) {
            if (n2 == 139) {
                this.ssn139();
            } else {
                if (n2 == 0) {
                    n2 = 445;
                }
                this.socket = this.localAddr == null ? new Socket(this.address.getHostAddress(), n2) : new Socket(this.address.getHostAddress(), n2, this.localAddr, this.localPort);
                this.socket.setSoTimeout(SmbConstants.SO_TIMEOUT);
                this.out = this.socket.getOutputStream();
                this.in = this.socket.getInputStream();
            }
            if (++this.mid == 32000) {
                this.mid = 1;
            }
            SmbTransport.NEGOTIATE_REQUEST.mid = this.mid;
            int n3 = NEGOTIATE_REQUEST.encode(this.sbuf, 4);
            Encdec.enc_uint32be(n3 & 0xFFFF, this.sbuf, 0);
            if (LogStream.level >= 4) {
                log.println(NEGOTIATE_REQUEST);
                if (LogStream.level >= 6) {
                    Hexdump.hexdump(log, this.sbuf, 4, n3);
                }
            }
            this.out.write(this.sbuf, 0, 4 + n3);
            this.out.flush();
            if (this.peekKey() == null) {
                throw new IOException("transport closed in negotiate");
            }
            int n4 = Encdec.dec_uint16be(this.sbuf, 2) & 0xFFFF;
            if (n4 < 33 || 4 + n4 > this.sbuf.length) {
                throw new IOException("Invalid payload size: " + n4);
            }
            SmbTransport.readn(this.in, this.sbuf, 36, n4 - 32);
            serverMessageBlock.decode(this.sbuf, 4);
            if (LogStream.level >= 4) {
                log.println(serverMessageBlock);
                if (LogStream.level >= 6) {
                    Hexdump.hexdump(log, this.sbuf, 4, n3);
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void connect() throws SmbException {
        try {
            super.connect(SmbConstants.RESPONSE_TIMEOUT);
        }
        catch (TransportException transportException) {
            throw new SmbException("Failed to connect: " + this.address, (Throwable)transportException);
        }
    }

    protected void doConnect() throws IOException {
        SmbComNegotiateResponse smbComNegotiateResponse = new SmbComNegotiateResponse(this.server);
        try {
            this.a(this.port, smbComNegotiateResponse);
        }
        catch (ConnectException connectException) {
            this.port = this.port == 0 || this.port == 445 ? 139 : 445;
            this.a(this.port, smbComNegotiateResponse);
        }
        catch (NoRouteToHostException noRouteToHostException) {
            this.port = this.port == 0 || this.port == 445 ? 139 : 445;
            this.a(this.port, smbComNegotiateResponse);
        }
        if (smbComNegotiateResponse.dialectIndex > 10) {
            throw new SmbException("This client does not support the negotiated dialect.");
        }
        if ((this.server.capabilities & Integer.MIN_VALUE) != Integer.MIN_VALUE && this.server.encryptionKeyLength != 8 && SmbConstants.LM_COMPATIBILITY == 0) {
            throw new SmbException("Unexpected encryption key length: " + this.server.encryptionKeyLength);
        }
        this.tconHostName = this.address.getHostName();
        this.flags2 = this.server.signaturesRequired || this.server.signaturesEnabled && SmbConstants.SIGNPREF ? (this.flags2 |= 4) : (this.flags2 &= 0xFFFB);
        this.maxMpxCount = Math.min(this.maxMpxCount, this.server.maxMpxCount);
        if (this.maxMpxCount < 1) {
            this.maxMpxCount = 1;
        }
        this.snd_buf_size = Math.min(this.snd_buf_size, this.server.maxBufferSize);
        this.capabilities &= this.server.capabilities;
        if ((this.server.capabilities & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            this.capabilities |= Integer.MIN_VALUE;
        }
        if ((this.capabilities & 4) == 0) {
            if (SmbConstants.FORCE_UNICODE) {
                this.capabilities |= 4;
            } else {
                this.useUnicode = false;
                this.flags2 &= Short.MAX_VALUE;
            }
        }
    }

    protected void doDisconnect(boolean bl) throws IOException {
        ListIterator listIterator = this.sessions.listIterator();
        while (listIterator.hasNext()) {
            SmbSession smbSession = (SmbSession)listIterator.next();
            smbSession.logoff(bl);
        }
        this.socket.shutdownOutput();
        this.out.close();
        this.in.close();
        this.socket.close();
        this.digest = null;
    }

    protected void makeKey(Request request) throws IOException {
        if (++this.mid == 32000) {
            this.mid = 1;
        }
        ((ServerMessageBlock)request).mid = this.mid;
    }

    protected Request peekKey() throws IOException {
        int n2;
        do {
            if ((n2 = SmbTransport.readn(this.in, this.sbuf, 0, 4)) >= 4) continue;
            return null;
        } while (this.sbuf[0] == -123);
        n2 = SmbTransport.readn(this.in, this.sbuf, 4, 32);
        if (n2 < 32) {
            return null;
        }
        if (LogStream.level >= 4) {
            log.println("New data read: " + this);
            Hexdump.hexdump(log, this.sbuf, 4, 32);
        }
        while (this.sbuf[0] != 0 || this.sbuf[1] != 0 || this.sbuf[4] != -1 || this.sbuf[5] != 83 || this.sbuf[6] != 77 || this.sbuf[7] != 66) {
            int n3;
            for (n3 = 0; n3 < 35; ++n3) {
                this.sbuf[n3] = this.sbuf[n3 + 1];
            }
            n3 = this.in.read();
            if (n3 == -1) {
                return null;
            }
            this.sbuf[35] = (byte)n3;
        }
        this.key.mid = Encdec.dec_uint16le(this.sbuf, 34) & 0xFFFF;
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSend(Request request) throws IOException {
        byte[] byArray = BUF;
        synchronized (BUF) {
            ServerMessageBlock serverMessageBlock = (ServerMessageBlock)request;
            int n2 = serverMessageBlock.encode(BUF, 4);
            Encdec.enc_uint32be(n2 & 0xFFFF, BUF, 0);
            if (LogStream.level >= 4) {
                do {
                    log.println(serverMessageBlock);
                } while (serverMessageBlock instanceof AndXServerMessageBlock && (serverMessageBlock = ((AndXServerMessageBlock)serverMessageBlock).andx) != null);
                if (LogStream.level >= 6) {
                    Hexdump.hexdump(log, BUF, 4, n2);
                }
            }
            this.out.write(BUF, 0, 4 + n2);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void doSend0(Request request) throws IOException {
        try {
            this.doSend(request);
        }
        catch (IOException iOException) {
            if (LogStream.level > 2) {
                iOException.printStackTrace(log);
            }
            try {
                this.disconnect(true);
            }
            catch (IOException iOException2) {
                iOException2.printStackTrace(log);
            }
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRecv(Response response) throws IOException {
        ServerMessageBlock serverMessageBlock = (ServerMessageBlock)response;
        serverMessageBlock.useUnicode = this.useUnicode;
        serverMessageBlock.extendedSecurity = (this.capabilities & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        byte[] byArray = BUF;
        synchronized (BUF) {
            System.arraycopy(this.sbuf, 0, BUF, 0, 36);
            int n2 = Encdec.dec_uint16be(BUF, 2) & 0xFFFF;
            if (n2 < 33 || 4 + n2 > this.rcv_buf_size) {
                throw new IOException("Invalid payload size: " + n2);
            }
            int n3 = Encdec.dec_uint32le(BUF, 9) & 0xFFFFFFFF;
            if (serverMessageBlock.command == 46 && (n3 == 0 || n3 == -2147483643)) {
                SmbComReadAndXResponse smbComReadAndXResponse = (SmbComReadAndXResponse)serverMessageBlock;
                int n4 = 32;
                SmbTransport.readn(this.in, BUF, 4 + n4, 27);
                serverMessageBlock.decode(BUF, 4);
                int n5 = smbComReadAndXResponse.dataOffset - (n4 += 27);
                if (smbComReadAndXResponse.byteCount > 0 && n5 > 0 && n5 < 4) {
                    SmbTransport.readn(this.in, BUF, 4 + n4, n5);
                }
                if (smbComReadAndXResponse.dataLength > 0) {
                    SmbTransport.readn(this.in, smbComReadAndXResponse.b, smbComReadAndXResponse.off, smbComReadAndXResponse.dataLength);
                }
            } else {
                SmbTransport.readn(this.in, BUF, 36, n2 - 32);
                serverMessageBlock.decode(BUF, 4);
                if (serverMessageBlock instanceof SmbComTransactionResponse) {
                    ((SmbComTransactionResponse)serverMessageBlock).nextElement();
                }
            }
            if (this.digest != null && serverMessageBlock.errorCode == 0) {
                this.digest.verify(BUF, 4, serverMessageBlock);
            }
            if (LogStream.level >= 4) {
                log.println(response);
                if (LogStream.level >= 6) {
                    Hexdump.hexdump(log, BUF, 4, n2);
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    protected void doSkip() throws IOException {
        int n2 = Encdec.dec_uint16be(this.sbuf, 2) & 0xFFFF;
        if (n2 < 33 || 4 + n2 > this.rcv_buf_size) {
            this.in.skip(this.in.available());
        } else {
            this.in.skip(n2 - 32);
        }
    }

    void checkStatus(ServerMessageBlock serverMessageBlock, ServerMessageBlock serverMessageBlock2) throws SmbException {
        serverMessageBlock2.errorCode = SmbException.getStatusByCode(serverMessageBlock2.errorCode);
        switch (serverMessageBlock2.errorCode) {
            case 0: {
                break;
            }
            case -1073741790: 
            case -1073741718: 
            case -1073741715: 
            case -1073741714: 
            case -1073741713: 
            case -1073741712: 
            case -1073741711: 
            case -1073741710: 
            case -1073741428: 
            case -1073741260: {
                throw new SmbAuthException(serverMessageBlock2.errorCode);
            }
            case -1073741225: {
                if (serverMessageBlock.auth == null) {
                    throw new SmbException(serverMessageBlock2.errorCode, null);
                }
                DfsReferral dfsReferral = this.getDfsReferrals(serverMessageBlock.auth, serverMessageBlock.path, 1);
                if (dfsReferral == null) {
                    throw new SmbException(serverMessageBlock2.errorCode, null);
                }
                SmbFile.dfs.insert(serverMessageBlock.path, dfsReferral);
                throw dfsReferral;
            }
            case -2147483643: {
                break;
            }
            case -1073741802: {
                break;
            }
            default: {
                throw new SmbException(serverMessageBlock2.errorCode, null);
            }
        }
        if (serverMessageBlock2.verifyFailed) {
            throw new SmbException("Signature verification failed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(ServerMessageBlock serverMessageBlock, ServerMessageBlock serverMessageBlock2) throws SmbException {
        block24: {
            this.connect();
            serverMessageBlock.flags2 |= this.flags2;
            serverMessageBlock.useUnicode = this.useUnicode;
            serverMessageBlock.response = serverMessageBlock2;
            if (serverMessageBlock.digest == null) {
                serverMessageBlock.digest = this.digest;
            }
            try {
                if (serverMessageBlock2 == null) {
                    this.doSend0(serverMessageBlock);
                    return;
                }
                if (serverMessageBlock instanceof SmbComTransaction) {
                    serverMessageBlock2.command = serverMessageBlock.command;
                    SmbComTransaction smbComTransaction = (SmbComTransaction)serverMessageBlock;
                    SmbComTransactionResponse smbComTransactionResponse = (SmbComTransactionResponse)serverMessageBlock2;
                    smbComTransaction.maxBufferSize = this.snd_buf_size;
                    smbComTransactionResponse.reset();
                    try {
                        SmbConstants smbConstants;
                        BufferCache.getBuffers(smbComTransaction, smbComTransactionResponse);
                        smbComTransaction.nextElement();
                        if (smbComTransaction.hasMoreElements()) {
                            smbConstants = new SmbComBlankResponse();
                            super.sendrecv(smbComTransaction, (Response)((Object)smbConstants), SmbConstants.RESPONSE_TIMEOUT);
                            if (smbConstants.errorCode != 0) {
                                this.checkStatus(smbComTransaction, (ServerMessageBlock)smbConstants);
                            }
                            smbComTransaction.nextElement();
                        } else {
                            this.makeKey(smbComTransaction);
                        }
                        smbConstants = this;
                        synchronized (smbConstants) {
                            serverMessageBlock2.received = false;
                            smbComTransactionResponse.isReceived = false;
                            try {
                                this.response_map.put(smbComTransaction, smbComTransactionResponse);
                                do {
                                    this.doSend0(smbComTransaction);
                                } while (smbComTransaction.hasMoreElements() && smbComTransaction.nextElement() != null);
                                long l2 = SmbConstants.RESPONSE_TIMEOUT;
                                smbComTransactionResponse.expiration = System.currentTimeMillis() + l2;
                                while (smbComTransactionResponse.hasMoreElements()) {
                                    this.wait(l2);
                                    l2 = smbComTransactionResponse.expiration - System.currentTimeMillis();
                                    if (l2 > 0L) continue;
                                    throw new TransportException(this + " timedout waiting for response to " + smbComTransaction);
                                }
                                if (serverMessageBlock2.errorCode != 0) {
                                    this.checkStatus(smbComTransaction, smbComTransactionResponse);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                throw new TransportException(interruptedException);
                            }
                            finally {
                                this.response_map.remove(smbComTransaction);
                            }
                            break block24;
                        }
                    }
                    finally {
                        BufferCache.releaseBuffer(smbComTransaction.txn_buf);
                        BufferCache.releaseBuffer(smbComTransactionResponse.txn_buf);
                    }
                }
                serverMessageBlock2.command = serverMessageBlock.command;
                super.sendrecv(serverMessageBlock, serverMessageBlock2, SmbConstants.RESPONSE_TIMEOUT);
            }
            catch (SmbException smbException) {
                throw smbException;
            }
            catch (IOException iOException) {
                throw new SmbException(iOException.getMessage(), (Throwable)iOException);
            }
        }
        this.checkStatus(serverMessageBlock, serverMessageBlock2);
    }

    public String toString() {
        return super.toString() + "[" + this.address + ":" + this.port + "]";
    }

    void dfsPathSplit(String string, String[] stringArray) {
        int n2 = 0;
        int n3 = stringArray.length - 1;
        int n4 = 0;
        int n5 = 0;
        int n6 = string.length();
        do {
            if (n2 == n3) {
                stringArray[n3] = string.substring(n5);
                return;
            }
            if (n4 != n6 && string.charAt(n4) != '\\') continue;
            stringArray[n2++] = string.substring(n5, n4);
            n5 = n4 + 1;
        } while (n4++ < n6);
        while (n2 < stringArray.length) {
            stringArray[n2++] = "";
        }
    }

    DfsReferral getDfsReferrals(NtlmPasswordAuthentication ntlmPasswordAuthentication, String string, int n2) throws SmbException {
        SmbTree smbTree = this.getSmbSession(ntlmPasswordAuthentication).getSmbTree("IPC$", null);
        Trans2GetDfsReferralResponse trans2GetDfsReferralResponse = new Trans2GetDfsReferralResponse();
        smbTree.send(new Trans2GetDfsReferral(string), trans2GetDfsReferralResponse);
        if (trans2GetDfsReferralResponse.numReferrals == 0) {
            return null;
        }
        if (n2 == 0 || trans2GetDfsReferralResponse.numReferrals < n2) {
            n2 = trans2GetDfsReferralResponse.numReferrals;
        }
        DfsReferral dfsReferral = new DfsReferral();
        String[] stringArray = new String[4];
        long l2 = System.currentTimeMillis() + Dfs.TTL * 1000L;
        int n3 = 0;
        while (true) {
            dfsReferral.resolveHashes = ntlmPasswordAuthentication.hashesExternal;
            dfsReferral.ttl = trans2GetDfsReferralResponse.referrals[n3].ttl;
            dfsReferral.expiration = l2;
            if (string.equals("")) {
                dfsReferral.server = trans2GetDfsReferralResponse.referrals[n3].path.substring(1).toLowerCase();
            } else {
                this.dfsPathSplit(trans2GetDfsReferralResponse.referrals[n3].node, stringArray);
                dfsReferral.server = stringArray[1];
                dfsReferral.share = stringArray[2];
                dfsReferral.path = stringArray[3];
            }
            dfsReferral.pathConsumed = trans2GetDfsReferralResponse.pathConsumed;
            if (++n3 == n2) break;
            dfsReferral.append(new DfsReferral());
            dfsReferral = dfsReferral.next;
        }
        return dfsReferral.next;
    }

    DfsReferral[] __getDfsReferrals(NtlmPasswordAuthentication ntlmPasswordAuthentication, String string, int n2) throws SmbException {
        SmbTree smbTree = this.getSmbSession(ntlmPasswordAuthentication).getSmbTree("IPC$", null);
        Trans2GetDfsReferralResponse trans2GetDfsReferralResponse = new Trans2GetDfsReferralResponse();
        smbTree.send(new Trans2GetDfsReferral(string), trans2GetDfsReferralResponse);
        if (n2 == 0 || trans2GetDfsReferralResponse.numReferrals < n2) {
            n2 = trans2GetDfsReferralResponse.numReferrals;
        }
        DfsReferral[] dfsReferralArray = new DfsReferral[n2];
        String[] stringArray = new String[4];
        long l2 = System.currentTimeMillis() + Dfs.TTL * 1000L;
        for (int i2 = 0; i2 < dfsReferralArray.length; ++i2) {
            DfsReferral dfsReferral = new DfsReferral();
            dfsReferral.resolveHashes = ntlmPasswordAuthentication.hashesExternal;
            dfsReferral.ttl = trans2GetDfsReferralResponse.referrals[i2].ttl;
            dfsReferral.expiration = l2;
            if (string.equals("")) {
                dfsReferral.server = trans2GetDfsReferralResponse.referrals[i2].path.substring(1).toLowerCase();
            } else {
                this.dfsPathSplit(trans2GetDfsReferralResponse.referrals[i2].node, stringArray);
                dfsReferral.server = stringArray[1];
                dfsReferral.share = stringArray[2];
                dfsReferral.path = stringArray[3];
            }
            dfsReferral.pathConsumed = trans2GetDfsReferralResponse.pathConsumed;
            dfsReferralArray[i2] = dfsReferral;
        }
        return dfsReferralArray;
    }

    class ServerData {
        byte flags;
        int flags2;
        int maxMpxCount;
        int maxBufferSize;
        int sessionKey;
        int capabilities;
        String oemDomainName;
        int securityMode;
        int security;
        boolean encryptedPasswords;
        boolean signaturesEnabled;
        boolean signaturesRequired;
        int maxNumberVcs;
        int maxRawSize;
        long serverTime;
        int serverTimeZone;
        int encryptionKeyLength;
        byte[] encryptionKey;
        byte[] guid;

        ServerData() {
        }
    }
}

