/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SmbComTransaction;
import jcifs.smb.SmbComTreeConnectAndX;
import jcifs.smb.SmbComTreeConnectAndXResponse;
import jcifs.smb.SmbComTreeDisconnect;
import jcifs.smb.SmbException;
import jcifs.smb.SmbSession;
import jcifs.smb.SmbTransport;
import jcifs.util.LogStream;

class SmbTree {
    private static int a;
    int connectionState;
    int tid;
    String share;
    String service = "?????";
    String service0;
    SmbSession session;
    boolean inDfs;
    boolean inDomainDfs;
    int tree_num;

    SmbTree(SmbSession smbSession, String string, String string2) {
        this.session = smbSession;
        this.share = string.toUpperCase();
        if (string2 != null && !string2.startsWith("??")) {
            this.service = string2;
        }
        this.service0 = this.service;
        this.connectionState = 0;
    }

    boolean matches(String string, String string2) {
        return this.share.equalsIgnoreCase(string) && (string2 == null || string2.startsWith("??") || this.service.equalsIgnoreCase(string2));
    }

    public boolean equals(Object object) {
        if (object instanceof SmbTree) {
            SmbTree smbTree = (SmbTree)object;
            return this.matches(smbTree.share, smbTree.service);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(ServerMessageBlock serverMessageBlock, ServerMessageBlock serverMessageBlock2) throws SmbException {
        SmbTransport smbTransport = this.session.transport();
        synchronized (smbTransport) {
            if (serverMessageBlock2 != null) {
                serverMessageBlock2.received = false;
            }
            this.treeConnect(serverMessageBlock, serverMessageBlock2);
            if (serverMessageBlock == null || serverMessageBlock2 != null && serverMessageBlock2.received) {
                return;
            }
            if (!this.service.equals("A:")) {
                block3 : switch (serverMessageBlock.command) {
                    case -94: 
                    case 4: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 113: {
                        break;
                    }
                    case 37: 
                    case 50: {
                        switch (((SmbComTransaction)serverMessageBlock).subCommand & 0xFF) {
                            case 0: 
                            case 16: 
                            case 35: 
                            case 38: 
                            case 83: 
                            case 84: 
                            case 104: 
                            case 215: {
                                break block3;
                            }
                        }
                        throw new SmbException("Invalid operation for " + this.service + " service");
                    }
                    default: {
                        throw new SmbException("Invalid operation for " + this.service + " service" + serverMessageBlock);
                    }
                }
            }
            serverMessageBlock.tid = this.tid;
            if (this.inDfs && !this.service.equals("IPC") && serverMessageBlock.path != null && serverMessageBlock.path.length() > 0) {
                serverMessageBlock.flags2 = 4096;
                serverMessageBlock.path = '\\' + this.session.transport().tconHostName + '\\' + this.share + serverMessageBlock.path;
            }
            try {
                this.session.send(serverMessageBlock, serverMessageBlock2);
            }
            catch (SmbException smbException) {
                if (smbException.getNtStatus() == -1073741623) {
                    this.treeDisconnect(true);
                }
                throw smbException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void treeConnect(ServerMessageBlock serverMessageBlock, ServerMessageBlock serverMessageBlock2) throws SmbException {
        SmbTransport smbTransport = this.session.transport();
        synchronized (smbTransport) {
            while (this.connectionState != 0) {
                if (this.connectionState == 2 || this.connectionState == 3) {
                    return;
                }
                try {
                    this.session.transport.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new SmbException(interruptedException.getMessage(), (Throwable)interruptedException);
                }
            }
            this.connectionState = 1;
            try {
                this.session.transport.connect();
                String string = "\\\\" + this.session.transport.tconHostName + '\\' + this.share;
                this.service = this.service0;
                SmbTransport cfr_ignored_0 = this.session.transport;
                if (LogStream.level >= 4) {
                    SmbTransport cfr_ignored_1 = this.session.transport;
                    SmbTransport.log.println("treeConnect: unc=" + string + ",service=" + this.service);
                }
                SmbComTreeConnectAndXResponse smbComTreeConnectAndXResponse = new SmbComTreeConnectAndXResponse(serverMessageBlock2);
                SmbComTreeConnectAndX smbComTreeConnectAndX = new SmbComTreeConnectAndX(this.session, string, this.service, serverMessageBlock);
                this.session.send(smbComTreeConnectAndX, smbComTreeConnectAndXResponse);
                this.tid = smbComTreeConnectAndXResponse.tid;
                this.service = smbComTreeConnectAndXResponse.service;
                this.inDfs = smbComTreeConnectAndXResponse.shareIsInDfs;
                this.tree_num = a++;
                this.connectionState = 2;
            }
            catch (SmbException smbException) {
                this.treeDisconnect(true);
                this.connectionState = 0;
                throw smbException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void treeDisconnect(boolean bl) {
        SmbTransport smbTransport = this.session.transport();
        synchronized (smbTransport) {
            block7: {
                if (this.connectionState != 2) {
                    return;
                }
                this.connectionState = 3;
                if (!bl && this.tid != 0) {
                    try {
                        this.send(new SmbComTreeDisconnect(), null);
                    }
                    catch (SmbException smbException) {
                        SmbTransport cfr_ignored_0 = this.session.transport;
                        if (LogStream.level <= 1) break block7;
                        SmbTransport cfr_ignored_1 = this.session.transport;
                        smbException.printStackTrace(SmbTransport.log);
                    }
                }
            }
            this.inDfs = false;
            this.inDomainDfs = false;
            this.connectionState = 0;
            this.session.transport.notifyAll();
        }
    }

    public String toString() {
        return "SmbTree[share=" + this.share + ",service=" + this.service + ",tid=" + this.tid + ",inDfs=" + this.inDfs + ",inDomainDfs=" + this.inDomainDfs + ",connectionState=" + this.connectionState + "]";
    }
}

