/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import jcifs.smb.FileEntry;
import jcifs.smb.SmbComTransactionResponse;
import jcifs.smb.SmbConstants;
import jcifs.util.LogStream;

class Trans2FindFirst2Response
extends SmbComTransactionResponse {
    static final int SMB_INFO_STANDARD = 1;
    static final int SMB_INFO_QUERY_EA_SIZE = 2;
    static final int SMB_INFO_QUERY_EAS_FROM_LIST = 3;
    static final int SMB_FIND_FILE_DIRECTORY_INFO = 257;
    static final int SMB_FIND_FILE_FULL_DIRECTORY_INFO = 258;
    static final int SMB_FILE_NAMES_INFO = 259;
    static final int SMB_FILE_BOTH_DIRECTORY_INFO = 260;
    int sid;
    boolean isEndOfSearch;
    int eaErrorOffset;
    int lastNameOffset;
    int lastNameBufferIndex;
    String lastName;
    int resumeKey;

    Trans2FindFirst2Response() {
        this.command = (byte)50;
        this.subCommand = 1;
    }

    String readString(byte[] byArray, int n2, int n3) {
        String string;
        block5: {
            string = null;
            try {
                if (this.useUnicode) {
                    string = new String(byArray, n2, n3, "UTF-16LE");
                } else {
                    if (n3 > 0 && byArray[n2 + n3 - 1] == 0) {
                        --n3;
                    }
                    string = new String(byArray, n2, n3, SmbConstants.OEM_ENCODING);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (LogStream.level <= 1) break block5;
                unsupportedEncodingException.printStackTrace(log);
            }
        }
        return string;
    }

    int writeSetupWireFormat(byte[] byArray, int n2) {
        return 0;
    }

    int writeParametersWireFormat(byte[] byArray, int n2) {
        return 0;
    }

    int writeDataWireFormat(byte[] byArray, int n2) {
        return 0;
    }

    int readSetupWireFormat(byte[] byArray, int n2, int n3) {
        return 0;
    }

    int readParametersWireFormat(byte[] byArray, int n2, int n3) {
        int n4 = n2;
        if (this.subCommand == 1) {
            this.sid = Trans2FindFirst2Response.readInt2(byArray, n2);
            n2 += 2;
        }
        this.numEntries = Trans2FindFirst2Response.readInt2(byArray, n2);
        this.isEndOfSearch = (byArray[n2 += 2] & 1) == 1;
        this.eaErrorOffset = Trans2FindFirst2Response.readInt2(byArray, n2 += 2);
        this.lastNameOffset = Trans2FindFirst2Response.readInt2(byArray, n2 += 2);
        return (n2 += 2) - n4;
    }

    int readDataWireFormat(byte[] byArray, int n2, int n3) {
        int n4 = n2;
        this.lastNameBufferIndex = n2 + this.lastNameOffset;
        this.results = new SmbFindFileBothDirectoryInfo[this.numEntries];
        for (int i2 = 0; i2 < this.numEntries; ++i2) {
            SmbFindFileBothDirectoryInfo smbFindFileBothDirectoryInfo = new SmbFindFileBothDirectoryInfo();
            this.results[i2] = smbFindFileBothDirectoryInfo;
            smbFindFileBothDirectoryInfo.nextEntryOffset = Trans2FindFirst2Response.readInt4(byArray, n2);
            smbFindFileBothDirectoryInfo.fileIndex = Trans2FindFirst2Response.readInt4(byArray, n2 + 4);
            smbFindFileBothDirectoryInfo.creationTime = Trans2FindFirst2Response.readTime(byArray, n2 + 8);
            smbFindFileBothDirectoryInfo.lastWriteTime = Trans2FindFirst2Response.readTime(byArray, n2 + 24);
            smbFindFileBothDirectoryInfo.endOfFile = Trans2FindFirst2Response.readInt8(byArray, n2 + 40);
            smbFindFileBothDirectoryInfo.extFileAttributes = Trans2FindFirst2Response.readInt4(byArray, n2 + 56);
            smbFindFileBothDirectoryInfo.fileNameLength = Trans2FindFirst2Response.readInt4(byArray, n2 + 60);
            smbFindFileBothDirectoryInfo.filename = this.readString(byArray, n2 + 94, smbFindFileBothDirectoryInfo.fileNameLength);
            if (this.lastNameBufferIndex >= n2 && (smbFindFileBothDirectoryInfo.nextEntryOffset == 0 || this.lastNameBufferIndex < n2 + smbFindFileBothDirectoryInfo.nextEntryOffset)) {
                this.lastName = smbFindFileBothDirectoryInfo.filename;
                this.resumeKey = smbFindFileBothDirectoryInfo.fileIndex;
            }
            n2 += smbFindFileBothDirectoryInfo.nextEntryOffset;
        }
        return this.dataCount;
    }

    public String toString() {
        String string = this.subCommand == 1 ? "Trans2FindFirst2Response[" : "Trans2FindNext2Response[";
        return new String(string + super.toString() + ",sid=" + this.sid + ",searchCount=" + this.numEntries + ",isEndOfSearch=" + this.isEndOfSearch + ",eaErrorOffset=" + this.eaErrorOffset + ",lastNameOffset=" + this.lastNameOffset + ",lastName=" + this.lastName + "]");
    }

    class SmbFindFileBothDirectoryInfo
    implements FileEntry {
        int nextEntryOffset;
        int fileIndex;
        long creationTime;
        long lastAccessTime;
        long lastWriteTime;
        long changeTime;
        long endOfFile;
        long allocationSize;
        int extFileAttributes;
        int fileNameLength;
        int eaSize;
        int shortNameLength;
        String shortName;
        String filename;

        SmbFindFileBothDirectoryInfo() {
        }

        public String getName() {
            return this.filename;
        }

        public int getType() {
            return 1;
        }

        public int getAttributes() {
            return this.extFileAttributes;
        }

        public long createTime() {
            return this.creationTime;
        }

        public long lastModified() {
            return this.lastWriteTime;
        }

        public long length() {
            return this.endOfFile;
        }

        public String toString() {
            return new String("SmbFindFileBothDirectoryInfo[nextEntryOffset=" + this.nextEntryOffset + ",fileIndex=" + this.fileIndex + ",creationTime=" + new Date(this.creationTime) + ",lastAccessTime=" + new Date(this.lastAccessTime) + ",lastWriteTime=" + new Date(this.lastWriteTime) + ",changeTime=" + new Date(this.changeTime) + ",endOfFile=" + this.endOfFile + ",allocationSize=" + this.allocationSize + ",extFileAttributes=" + this.extFileAttributes + ",fileNameLength=" + this.fileNameLength + ",eaSize=" + this.eaSize + ",shortNameLength=" + this.shortNameLength + ",shortName=" + this.shortName + ",filename=" + this.filename + "]");
        }
    }
}

