/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import jcifs.smb.AllocInfo;
import jcifs.smb.SmbComTransactionResponse;

class Trans2QueryFSInformationResponse
extends SmbComTransactionResponse {
    static final int SMB_INFO_ALLOCATION = 1;
    static final int SMB_QUERY_FS_SIZE_INFO = 259;
    static final int SMB_FS_FULL_SIZE_INFORMATION = 1007;
    private int an;
    AllocInfo info;

    Trans2QueryFSInformationResponse(int n2) {
        this.an = n2;
        this.command = (byte)50;
        this.subCommand = (byte)3;
    }

    int writeSetupWireFormat(byte[] byArray, int n2) {
        return 0;
    }

    int writeParametersWireFormat(byte[] byArray, int n2) {
        return 0;
    }

    int writeDataWireFormat(byte[] byArray, int n2) {
        return 0;
    }

    int readSetupWireFormat(byte[] byArray, int n2, int n3) {
        return 0;
    }

    int readParametersWireFormat(byte[] byArray, int n2, int n3) {
        return 0;
    }

    int readDataWireFormat(byte[] byArray, int n2, int n3) {
        switch (this.an) {
            case 1: {
                return this.readSmbInfoAllocationWireFormat(byArray, n2);
            }
            case 259: {
                return this.readSmbQueryFSSizeInfoWireFormat(byArray, n2);
            }
            case 1007: {
                return this.readFsFullSizeInformationWireFormat(byArray, n2);
            }
        }
        return 0;
    }

    int readSmbInfoAllocationWireFormat(byte[] byArray, int n2) {
        int n3 = n2;
        SmbInfoAllocation smbInfoAllocation = new SmbInfoAllocation();
        smbInfoAllocation.sectPerAlloc = Trans2QueryFSInformationResponse.readInt4(byArray, n2 += 4);
        smbInfoAllocation.alloc = Trans2QueryFSInformationResponse.readInt4(byArray, n2 += 4);
        smbInfoAllocation.free = Trans2QueryFSInformationResponse.readInt4(byArray, n2 += 4);
        smbInfoAllocation.bytesPerSect = Trans2QueryFSInformationResponse.readInt2(byArray, n2 += 4);
        this.info = smbInfoAllocation;
        return (n2 += 4) - n3;
    }

    int readSmbQueryFSSizeInfoWireFormat(byte[] byArray, int n2) {
        int n3 = n2;
        SmbInfoAllocation smbInfoAllocation = new SmbInfoAllocation();
        smbInfoAllocation.alloc = Trans2QueryFSInformationResponse.readInt8(byArray, n2);
        smbInfoAllocation.free = Trans2QueryFSInformationResponse.readInt8(byArray, n2 += 8);
        smbInfoAllocation.sectPerAlloc = Trans2QueryFSInformationResponse.readInt4(byArray, n2 += 8);
        smbInfoAllocation.bytesPerSect = Trans2QueryFSInformationResponse.readInt4(byArray, n2 += 4);
        this.info = smbInfoAllocation;
        return (n2 += 4) - n3;
    }

    int readFsFullSizeInformationWireFormat(byte[] byArray, int n2) {
        int n3 = n2;
        SmbInfoAllocation smbInfoAllocation = new SmbInfoAllocation();
        smbInfoAllocation.alloc = Trans2QueryFSInformationResponse.readInt8(byArray, n2);
        smbInfoAllocation.free = Trans2QueryFSInformationResponse.readInt8(byArray, n2 += 8);
        n2 += 8;
        smbInfoAllocation.sectPerAlloc = Trans2QueryFSInformationResponse.readInt4(byArray, n2 += 8);
        smbInfoAllocation.bytesPerSect = Trans2QueryFSInformationResponse.readInt4(byArray, n2 += 4);
        this.info = smbInfoAllocation;
        return (n2 += 4) - n3;
    }

    public String toString() {
        return new String("Trans2QueryFSInformationResponse[" + super.toString() + "]");
    }

    class SmbInfoAllocation
    implements AllocInfo {
        long alloc;
        long free;
        int sectPerAlloc;
        int bytesPerSect;

        SmbInfoAllocation() {
        }

        public long getCapacity() {
            return this.alloc * (long)this.sectPerAlloc * (long)this.bytesPerSect;
        }

        public long getFree() {
            return this.free * (long)this.sectPerAlloc * (long)this.bytesPerSect;
        }

        public String toString() {
            return new String("SmbInfoAllocation[alloc=" + this.alloc + ",free=" + this.free + ",sectPerAlloc=" + this.sectPerAlloc + ",bytesPerSect=" + this.bytesPerSect + "]");
        }
    }
}

