/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.util.Date;
import jcifs.smb.Info;
import jcifs.smb.SmbComTransactionResponse;
import jcifs.util.Hexdump;

class Trans2QueryPathInformationResponse
extends SmbComTransactionResponse {
    static final int SMB_QUERY_FILE_BASIC_INFO = 257;
    static final int SMB_QUERY_FILE_STANDARD_INFO = 258;
    private int ar;
    Info info;

    Trans2QueryPathInformationResponse(int n2) {
        this.ar = n2;
        this.subCommand = (byte)5;
    }

    int writeSetupWireFormat(byte[] byArray, int n2) {
        return 0;
    }

    int writeParametersWireFormat(byte[] byArray, int n2) {
        return 0;
    }

    int writeDataWireFormat(byte[] byArray, int n2) {
        return 0;
    }

    int readSetupWireFormat(byte[] byArray, int n2, int n3) {
        return 0;
    }

    int readParametersWireFormat(byte[] byArray, int n2, int n3) {
        return 2;
    }

    int readDataWireFormat(byte[] byArray, int n2, int n3) {
        switch (this.ar) {
            case 257: {
                return this.readSmbQueryFileBasicInfoWireFormat(byArray, n2);
            }
            case 258: {
                return this.readSmbQueryFileStandardInfoWireFormat(byArray, n2);
            }
        }
        return 0;
    }

    int readSmbQueryFileStandardInfoWireFormat(byte[] byArray, int n2) {
        int n3 = n2;
        SmbQueryFileStandardInfo smbQueryFileStandardInfo = new SmbQueryFileStandardInfo();
        smbQueryFileStandardInfo.allocationSize = Trans2QueryPathInformationResponse.readInt8(byArray, n2);
        smbQueryFileStandardInfo.endOfFile = Trans2QueryPathInformationResponse.readInt8(byArray, n2 += 8);
        smbQueryFileStandardInfo.numberOfLinks = Trans2QueryPathInformationResponse.readInt4(byArray, n2 += 8);
        n2 += 4;
        smbQueryFileStandardInfo.deletePending = (byArray[n2++] & 0xFF) > 0;
        smbQueryFileStandardInfo.directory = (byArray[n2++] & 0xFF) > 0;
        this.info = smbQueryFileStandardInfo;
        return n2 - n3;
    }

    int readSmbQueryFileBasicInfoWireFormat(byte[] byArray, int n2) {
        int n3 = n2;
        SmbQueryFileBasicInfo smbQueryFileBasicInfo = new SmbQueryFileBasicInfo();
        smbQueryFileBasicInfo.createTime = Trans2QueryPathInformationResponse.readTime(byArray, n2);
        smbQueryFileBasicInfo.lastAccessTime = Trans2QueryPathInformationResponse.readTime(byArray, n2 += 8);
        smbQueryFileBasicInfo.lastWriteTime = Trans2QueryPathInformationResponse.readTime(byArray, n2 += 8);
        smbQueryFileBasicInfo.changeTime = Trans2QueryPathInformationResponse.readTime(byArray, n2 += 8);
        smbQueryFileBasicInfo.attributes = Trans2QueryPathInformationResponse.readInt2(byArray, n2 += 8);
        this.info = smbQueryFileBasicInfo;
        return (n2 += 2) - n3;
    }

    public String toString() {
        return new String("Trans2QueryPathInformationResponse[" + super.toString() + "]");
    }

    class SmbQueryFileStandardInfo
    implements Info {
        long allocationSize;
        long endOfFile;
        int numberOfLinks;
        boolean deletePending;
        boolean directory;

        SmbQueryFileStandardInfo() {
        }

        public int getAttributes() {
            return 0;
        }

        public long getCreateTime() {
            return 0L;
        }

        public long getLastWriteTime() {
            return 0L;
        }

        public long getSize() {
            return this.endOfFile;
        }

        public String toString() {
            return new String("SmbQueryInfoStandard[allocationSize=" + this.allocationSize + ",endOfFile=" + this.endOfFile + ",numberOfLinks=" + this.numberOfLinks + ",deletePending=" + this.deletePending + ",directory=" + this.directory + "]");
        }
    }

    class SmbQueryFileBasicInfo
    implements Info {
        long createTime;
        long lastAccessTime;
        long lastWriteTime;
        long changeTime;
        int attributes;

        SmbQueryFileBasicInfo() {
        }

        public int getAttributes() {
            return this.attributes;
        }

        public long getCreateTime() {
            return this.createTime;
        }

        public long getLastWriteTime() {
            return this.lastWriteTime;
        }

        public long getSize() {
            return 0L;
        }

        public String toString() {
            return new String("SmbQueryFileBasicInfo[createTime=" + new Date(this.createTime) + ",lastAccessTime=" + new Date(this.lastAccessTime) + ",lastWriteTime=" + new Date(this.lastWriteTime) + ",changeTime=" + new Date(this.changeTime) + ",attributes=0x" + Hexdump.toHexString(this.attributes, 4) + "]");
        }
    }
}

